<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class availability_reservation_extra
{
  private $_data = array();

  public function get_id()
  {
    if( isset($this->_data['id']) )
      return $this->_data['id'];
  }


  public function set_id($id)
  {
    if( is_int($id) )
      {
	$this->_data['id'] = (int)$id;
      }
  }


  public function get_resv_id()
  {
    if( isset($this->_data['resv_id']) )
      return $this->_data['resv_id'];
  }


  public function set_resv_id($resv_id)
  {
    $this->_data['resv_id'] = (int)$resv_id;
  }


  public function set_source($src)
  {
    $this->_data['source'] = trim($src);
  }


  public function get_source()
  {
    if( isset($this->_data['source']) )
      return $this->_data['source'];
  }


  public function set_desc($desc)
  {
    $this->_data['desc'] = trim($desc);
  }


  public function get_desc()
  {
    if( isset($this->_data['desc']) )
      return $this->_data['desc'];
  }


  public function set_sku($sku)
  {
    $this->_data['sku'] = trim($sku);
  }


  public function get_sku()
  {
    if( isset($this->_data['sku']) )
      return $this->_data['sku'];
  }


  public function set_itemid($itemid)
  {
    $this->_data['itemid'] = (int)$itemid;
  }


  public function get_itemid()
  {
    if( isset($this->_data['itemid']) )
      return $this->_data['itemid'];
  }


  public function set_qty($qty)
  {
    $this->_data['qty'] = (int)$qty;
  }


  public function get_qty()
  {
    if( isset($this->_data['qty']) )
      return $this->_data['qty'];
  }


  public function set_itemamt($itemamt)
  {
    $this->_data['itemamt'] = (float)$itemamt;
  }


  public function get_itemamt()
  {
    if( isset($this->_data['itemamt']) )
      return $this->_data['itemamt'];
  }


  public function get_data()
  {
    if( isset($this->_data['data']) && count($this->_data['data']) )
      return serialize($this->_data['data']);
  }


  public function set_data_value($key,$value)
  {
    if( !is_string($key) )
      {
	if( !isset($this->_data['data']) ) $this->_data['data'] = array();
	$this->_data['data'][$key] = $value;
      }
  }


  public function get_data_value($key)
  {
    if( isset($this->_data['data']) && isset($this->_data['data'][$key]) )
      {
	return $this->_data['data'][$key];
      }
  }


  public function is_valid()
  {
    if( isset($this->_data['source']) && isset($this->_data['itemid']) &&
	isset($this->_data['qty']) && isset($this->_data['itemamt']) )
      {
	return TRUE;
      }
    return FALSE;
  }


  public function from_array($data)
  {
    $this->_data = $data;
  }

  
  public function to_array()
  {
    return $this->_data;
  }


  public function save()
  {
    if( $this->get_id() <= 0 )
      {
	return reservation_extra_ops::insert($this);
      }
    else
      {
	return reservation_extra_ops::update($this);
      }
  }
}

#
# EOF
#
?>