<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class availability_reservation 
{
  private $_id;
  private $_customer_id;
  private $_price;
  private $_status;
  private $_admin_notes;
  private $_create_date;
  private $_modified_date;
  private $_parts;
  private $_notes;
  private $_actor;
  private $_extra;


  public function __construct()
  {
    $this->_parts = array();
    $this->_notes = array();
    $this->_extra = array();
  }


  public function get_id()
  {
    return $this->_id;
  }


  public function set_id($id)
  {
    $this->_id = $id;
  }


  public function get_customer_id()
  {
    return $this->_customer_id;
  }


  public function set_customer_id($customer_id)
  {
    $this->_customer_id = $customer_id;
  }


  public function get_base_price()
  {
    return $this->_price;
  }

  public function get_price()
  {
    $price = $this->get_base_price();
    return $price;
  }


  public function set_price($price)
  {
    $this->_price = $price;
  }


  public function get_status()
  {
    return $this->_status;
  }


  public function set_status($status)
  {
    $this->_status = $status;
  }


  public function get_admin_notes()
  {
    return $this->_admin_notes;
  }


  public function set_admin_notes($admin_notes)
  {
    $this->_admin_notes = $admin_notes;
  }


  public function get_create_date()
  {
    return $this->_create_date;
  }


  public function set_create_date($create_date)
  {
    $this->_create_date = $create_date;
  }


  public function get_modified_date()
  {
    return $this->_modified_date;
  }


  public function set_modified_date($modified_date)
  {
    $this->_modified_date = $modified_date;
  }


  public function count_parts()
  {
    return count($this->_parts);
  }


  public function &get_part_by_idx($idx)
  {
    if( $idx >= 0 && $idx < count($this->_parts) )
      {
	return $this->_parts[$idx];
      }
  }


  public function &get_part_by_id($part_id)
  {
    for( $i = 0; $i < count($this->_parts); $i++ )
      {
	if( $this->_parts[$i]->get_id() == $part_id )
	  {
	    return $this->_parts[$part_id];
	  }
      }
  }


  public function add_part($part)
  {
    $this->_parts[] = $part;
  }


  public function remove_part_by_id($part_id)
  {
    $tmp = array();
    for( $i = 0; $i < count($this->_parts); $i++ )
      {
	if( $this->_parts[$i]->get_id() == $part_id )
	  {
	    continue;
	  }
	$tmp[] = $this->_parts[$i];
      }
    $this->_parts = $tmp;
  }


  public function remove_part_by_idx($idx)
  {
    if( $idx >= 0 && $idx < count($this->_parts) )
      {
	$tmp = array();
	for( $i = 0; $i < count($this->_parts); $i++ )
	  {
	    if( $i == $idx ) continue;
	    $tmp[] = $this->_parts[$i];
	  }
	$this->_parts = $tmp;
      }
  }


  public function remove_all_parts()
  {
    $this->_parts = array();
  }


  public function count_notes()
  {
    return count($this->_notes);
  }


  public function &get_note_by_idx($idx)
  {
    if( $idx >= 0 && $idx < count($this->_notes) )
      {
	return $this->_notes[$idx];
      }
  }


  public function &get_note_by_id($note_id)
  {
    for( $i = 0; $i < count($this->_notes); $i++ )
      {
	if( $this->_notes[$i]->get_id() == $note_id )
	  {
	    return $this->_notes[$note_id];
	  }
      }
  }


  public function add_note(&$note)
  {
    $this->_notes[] = $note;
  }


  public function add_extra(availability_reservation_extra $extra)
  {
    $this->_extra[] = $extra;
  }


  public function count_extra()
  {
    return count($this->_extra);
  }

  
  public function get_extra_by_idx($idx)
  {
    if( $idx < 0 || $idx >= $this->count_extra() ) return;
    return $this->_extra[$idx];
  }

  public function set_actor($actor)
  {
    $this->_actor = $actor;
  }


  public function get_actor()
  {
    if( is_null($this->_actor) )
      {
	// don't know the actor
	// assume the currently logged in admin.
	$uid = get_userid(false);
	if( $uid )
	  {
	    $userops = cmsms()->GetUserOperations();
	    $user = $userops->LoadUserById($uid);
	    $this->_actor = $user->username;
	  }
      }
    return $this->_actor;
  }

  public function save()
  {
    if( $this->_id <= 0 )
      {
	return reservation_ops::insert($this);
      }
    else
      {
	return reservation_ops::update($this);
      }
  }


  public function from_array($data)
  {
    $this->_id = $data['id'];
    $this->_customer_id = $data['customer_id'];
    $this->_price = $data['price'];
    $this->_status = $data['status'];
    $this->_admin_notes = $data['admin_notes'];
    $this->_create_date = $data['create_date'];
    $this->_modified_date = $data['modified_date'];
  }


  public function to_array()
  {
    $data = array();
    $data['id'] = $this->_id;
    $data['customer_id'] = $this->_customer_id;
    $data['price'] = $this->_price;
    $data['status'] = $this->_status;
    $data['admin_notes'] = $this->_admin_notes;
    $data['create_date'] = $this->_create_date;
    $data['modified_date'] = $this->_modified_date;

    $data['parts'] = array();
    for( $i = 0; $i < $this->count_parts(); $i++ )
      {
	$part = $this->get_part_by_idx($i);
	$data['parts'][] = $part->to_array();
      }

    $data['notes'] = array();
    for( $i = 0; $i < $this->count_notes(); $i++ )
      {
	$note = $this->get_note_by_idx($i);
	$data['notes'][] = $note->to_array();
      }

    $data['extra'] = array();
    for( $i = 0; $i < $this->count_extra(); $i++ )
      {
	$extra = $this->get_extra_by_idx($i);
	$data['extra'][] = $extra->to_array();
      }
    return $data;
  }
} // end of class

#
# EOF
#
?>
