<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

function availability_GetAttributesForRsrc(&$mod,$rsrc_id)
{
  $db =& $mod->GetDb();
  $query = 'SELECT * FROM '.AVAILABILITY_TABLE_CATS.' A
            LEFT JOIN '.AVAILABILITY_TABLE_RSRC_CATS.' B
            ON A.id = B.category_id 
            WHERE B.rsrc_id = ?
            ORDER BY A.id';
  $res = $db->GetArray($query,array($rsrc_id));
  return $res;
}


function availability_GetFieldsForRsrc(&$mod,$rsrc_id)
{
  global $gCms;
  $config = $gCms->GetConfig();
  $db =& $mod->GetDb();
  $query = 'SELECT fd.id,fd.name,fd.prompt,fd.type,fd.item_order,
                   fv.value 
            FROM '.AVAILABILITY_TABLE_FIELDDEFS.' fd
            LEFT JOIN '.AVAILABILITY_TABLE_FIELDVALS.' fv
            ON fd.id = fv.fielddef_id 
            WHERE fv.rsrc_id = ?
              AND fd.public = 1
            ORDER BY fd.item_order';
  $res = $db->GetArray($query,array($rsrc_id));

  if( is_array( $res ) )
    {
      $path = cms_join_path($config['uploads_path'],$mod->GetName());
      for( $i = 0; $i < count($res); $i++ )
	{
	  if( $res[$i]['type'] == 'image' )
	    {
	      $fn = cms_join_path($path,'resources_'.$rsrc_id,'thumb_'.$res[$i]['value']);
	      if( file_exists( $fn ) )
		{
		  $res[$i]['thumbnail'] = 'thumb_'.$res[$i]['value'];
		}
	    }
	}
    }
  return $res; 
}

function availability_GetAttributeIDs(&$mod,$data)
{
  if( !is_array($str) )
    {
      // it's not an array, so assume it's a comma separated
      // list of category names
      $data = explode(',',$data);
    }

  $query = 'SELECT id FROM '.AVAILABILITY_TABLE_CATS.'
             WHERE name IN ('.implode(',',$data).')';
  $res = false;
  $tmp = $db->GetArray($query);
  if( is_array( $tmp ) )
    {

      $res = cge_array::extract_field($tmp,'id');
    }
  return $res;
}


function availability_SearchResult(&$mod,$returnid,$articleid,$attr)
{
  $result = array();
  if( $attr == 'resource' )
    {
      $db =& $mod->GetDb();
      $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS.'
                 WHERE id = ? AND active = 1';
      $row = $db->GetRow($query,array($articleid));
      if( $row )
	{
	  $result[0] = $mod->GetFriendlyName();
	  $result[1] = $row['name'];
	  $pretty_url = $mod->GetResourceType()."/$returnid/$articleid/".munge_string_to_url($row['name']);
	  $result[2] = $mod->CreateURL($id,'detail',$returnid,
				       array('rsrcid'=>$articleid),false,$pretty_url);
	}
    }
  return $result;
}

#
# EOF
#
?>