<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

function availability_GetTypesDropdown(&$mod,$id,$name,$selected = '',
                                       $addtext = '',$selectone = false)
{
   $items = array();
   if( $selectone )
     {
	$items[$mod->Lang('select_one')] = '';
     }
   $items[$mod->Lang('textbox')] = 'textbox';
   $items[$mod->Lang('checkbox')] = 'checkbox';
   $items[$mod->Lang('textarea')] = 'textarea';
   $items[$mod->Lang('dropdown')] = 'dropdown';
   $items[$mod->Lang('imagetext')] = 'image';
   $items[$mod->Lang('file')] = 'file';

   return $mod->CreateInputDropdown($id, $name, $items, -1, $selected,
   				  $addtext);
}


function availability_GetResourceType(&$mod,$plural = false)
{
    $str = $mod->GetPreference('resource_type','resource');
    if( $plural )
      {
	$str .= 's';
      }
    $tr = $mod->Lang(strtolower($str));
    if( strstr($tr,'Add Me') !== FALSE )
      {
	// couldn't find a translation for this
	// so skip it and use it without
	// TODO: put a notice into the log?
	$tr = ucwords($str);
      }
    return $tr;
}


function availability_HandleFileUpload(&$mod,$id,$name,$record_id,&$value,
				       &$result)
{
    global $gCms;
    $config = $gCms->GetConfig();
    $destdir = cms_join_path($config['uploads_path'],$mod->GetName(),'resources_'.$record_id);
    cge_dir::mkdirr( $destdir );
    if( !is_dir($destdir) )
      {
	$result = 'error_mkdir';
	return false;
      }

    $handler = new cg_fileupload($id,$destdir);
    $handler->set_accepted_filetypes($mod->GetPreference('image_types'));
    $res = $handler->handle_upload($name);
    if( !$res && $handler->get_error() != CGFILEUPLOAD_NOFILE )
      {
	$err = $handler->get_error();
	$result = sprintf("%s %s: %s",$mod->Lang('field'),$def->name,
			  $mod->GetUploadErrorMessage($err));
	return false;
      }
    else if( !$res )
      {
	return false;
      }

    $value = $res;
    return true;
}

function availability_HandleImageUpload(&$mod,$id,$name,$record_id,
					&$value,&$result)
{
    global $gCms;
    $config = $gCms->GetConfig();
    $destdir = cms_join_path($config['uploads_path'],$mod->GetName(),'resources_'.$record_id);
    cge_dir::mkdirr( $destdir );
    if( !is_dir($destdir) )
      {
	$result = $mod->Lang('error_mkdir').': '.$destdir;
	return false;
      }

    $handler = new cg_fileupload($id,$destdir);
    $handler->set_accepted_filetypes($mod->GetPreference('image_types'));
    $res = $handler->handle_upload($name,'');
    $err = $handler->get_error();
    if( !$res && $err != CGFILEUPLOAD_NOFILE )
      {
	$result = sprintf("%s %s: %s",$mod->Lang('error_upload'),$name,
			  $mod->GetUploadErrorMessage($err));
	return false;
      }
    else if( !$res )
      {
	return false;
      }

    $value = $res;

    if( $mod->GetPreference('auto_thumbnail') )
      {
	$srcname = cms_join_path($destdir,$value);
	$destname = cms_join_path($destdir,'thumb_'.$value);
	$mod->TransformImage($srcname,$destname);
      }
    return true;
}

function availability_HandleImageDelete(&$mod,$id,$record_id,$value)
{
    global $gCms;
    $config = $gCms->GetConfig();
    $destdir = cms_join_path($config['uploads_path'],$mod->GetName(),'resources_'.$record_id);
    if( !is_dir($destdir) )
      {
	return true;
      }

    $fn = cms_join_path($destdir,$value);
    if( file_exists($fn) ) 
      {
	@unlink($fn);
	if( file_exists($fn) ) return false;
      }

    $fn = cms_join_path($destdir,'thumb_'.$value);
    if( file_exists($fn) ) 
      {
	@unlink($fn);
	if( file_exists($fn) ) return false;
      }

    return true;
}


function availability_HandleFileDelete(&$mod,$id,$record_id,$value)
{
    global $gCms;
    $config = $gCms->GetConfig();
    $destdir = cms_join_path($config['uploads_path'],$mod->GetName(),'resources_'.$record_id);
    if( !is_dir($destdir) )
      {
	return true;
      }

    $fn = cms_join_path($destdir,$value);
    if( file_exists($fn) ) 
      {
	@unlink($fn);
	if( file_exists($fn) ) return false;
      }

    return true;
}

function availability_loadEventTypes(&$mod)
{
    $db =& $mod->GetDb();
    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_EVENT_TYPES.'
               ORDER by iorder';
    $res = $db->GetArray($query);
    
    if( $res ) 
      {
	$mod->cached_event_types = array();
	foreach( $res as $one )
	  {
	    $mod->cached_event_types[$one['id']] = $one;
	  }
      }
}

function availability_GetEventTypeFromID(&$mod,$event_id)
{
    if( !is_array($mod->cached_event_types) )
      {
	$mod->_loadEventTypes();
      }

    if( !isset($mod->cached_event_types[$event_id]) )
      {
	return false;
      }
    return $mod->cached_event_types[$event_id]['name'];
}

function availability_GetEventTypeDropdownList(&$mod,$any = false)
{
    if( !is_array($mod->cached_event_types) )
      {
	$mod->_loadEventTypes();
      }

    $res = array();
    if( $any )
      {
	$res[$mod->Lang('any')] = -1;
      }
    if( count($mod->cached_event_types) )
      {
	foreach( $mod->cached_event_types as $key => $val )
	  {
	    $res[$val['name']] = $val['id'];
	  }
      }
    return $res;
}


function availability_GetUserDetails(&$mod,$uid)
{
  $feu =& $mod->GetModuleInstance('FrontEndUsers');
  if( !is_object($feu) ) return false;
  
  $gid = (int)$mod->GetPreference('customer_group');
  if( $gid == -1 ) return false;
  
  $tmp = $feu->GetUserInfo($uid);
  if( $tmp[0] === FALSE ) return false;
  $oneuser = $tmp[1];
  $oneuser['props'] = $feu->GetUserProperties($uid);
  
  $result = array();
  $result['username'] = $oneuser['username'];
  $result['email'] = $feu->GetEmail($uid);
  
  global $gCms;
  $smarty =& $gCms->GetSmarty();
  $smarty->assign('username',$oneuser['username']);
  $smarty->assign('_email_address_',$result['email']);
  $smarty->assign('userid',$oneuser['id']);
  if( isset($oneuser['props']) )
    {
      foreach( $oneuser['props'] as $oneprop )
	{
	  $smarty->assign($oneprop['title'],$oneprop['data']);
	}
    }
  $str = $mod->ProcessTemplateFromData(
	 $mod->GetPreference('customer_display_template','{$username}'));
  $result['display'] = $str;
  return $result;
}

function availability_GetUserDropdownList(&$mod)
{
  $result = false;
  
  $feu =& $mod->GetModuleInstance('FrontEndUsers');
  if( !is_object($feu) ) return false;
  
  $gid = (int)$mod->GetPreference('customer_group');
  if( $gid == -1 ) return false;
  
  global $gCms;
  $smarty =& $gCms->GetSmarty();
  $users = $feu->GetFullUsersInGroup($gid);
  $result = array();
  if( $users !== FALSE )
    {
      foreach( $users as $oneuser )
	{
	  $smarty->assign('username',$oneuser['username']);
	  $smarty->assign('_email_address_',$feu->GetEmail($oneuser['id']));
	  $smarty->assign('userid',$oneuser['id']);
	  if( isset($oneuser['props']) )
	    {
	      foreach( $oneuser['props'] as $oneprop )
		{
		  if( isset($oneprop['data']) && isset($oneprop['title']) )
		    $smarty->assign($oneprop['title'],$oneprop['data']);
		}
	    }
	  $str = $mod->ProcessTemplateFromData(
	    $mod->GetPreference('customer_display_template','{$username}'));
	  $result[trim($str)] = $oneuser['id'];
	  ksort($result);
	}
    }
  return $result;
}

function availability_SearchReIndex(&$mod,&$searchmodule)
{
  $db =& $mod->GetDb();
  
  $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS.'
             WHERE active = 1
             ORDER BY base_price DESC';
  $dbr = $db->Execute($query);
  while( $dbr && $row = $dbr->FetchRow() )
    {
      $flds = $mod->GetFieldsForRsrc($row['id']);
      $str = $row['name'].' '.$row['description'];
      for( $i = 0; $i < count($flds); $i++ )
	{
	  if( $flds[$i]['type'] == 'textbox' || $flds[$i]['type'] == 'textarea' )
	    {
	      $str .= ' '.$flds[$i]['value'];
	    }
	}
      $searchmodule->AddWords($mod->GetName(), $row['id'], 'resource', $str );
    }
}

#
# EOF
#
?>