<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

// Setup
$pagelimit = $this->GetPreference('rsrcs_pagelimit',25);
$category = $this->GetPreference('rsrcs_category',-1);
$active = $this->GetPreference('rsrcs_active',-1);
$curpage = 1;

if( isset($params['curpage']) )
  {
    $curpage = (int)$params['curpage'];
  }

if( isset($params['btnfilterrsrcs']) )
  {
    $pagelimit = (int)$params['input_pagelimit'];
    $this->SetPreference('rsrcs_pagelimit',$pagelimit);
    $curpage = 1;

    $category = (int)$params['input_category'];
    $this->SetPreference('rsrcs_category',$category);

    $active = (int)$params['input_active'];
    $this->SetPreference('rsrcs_active',$active);
  }

// some math
$startelement = ($curpage-1)*$pagelimit;

// TODO: FORM FOR SELECTING TYPE
// TODO: PAGINATION

//
// Build the Form
//
$query = 'SELECT * FROM '.AVAILABILITY_TABLE_CATS;
$tmp = $db->GetArray($query);
$cats = array($this->Lang('any') => -1);
foreach( $tmp as $onecat )
{
  $cats[$onecat['name']] = $onecat['id'];
}

$smarty->assign('formstart',
		$this->CGCreateFormStart($id,'defaultadmin',$returnid,
					 array('cg_activetab'=>'resources')));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('input_category',$this->CreateInputDropdown($id,'input_category',$cats,-1,$category));
$tmp = array($this->Lang('all')=>1000000,'5'=>5,'10'=>10,'25'=>25,'50'=>50,'100'=>100);
$smarty->assign('input_pagelimit',$this->CreateInputDropdown($id,'input_pagelimit',$tmp,-1,$pagelimit));
$tmp = array($this->Lang('any')=>-1,$this->Lang('yes')=>1,$this->Lang('no')=>0);
$smarty->assign('input_active',$this->CreateInputDropdown($id,'input_active',$tmp,-1,$active));
$smarty->assign('btnfilter',$this->CreateInputSubmit($id,'btnfilterrsrcs',$this->Lang('apply')));

//
// Build the data for the display
//

// Build the querie(s)
$can_reorder = 1;
$subselects = '';
$qparms = array();
$where = array();
$joins = array();
$query1 = 'SELECT R.*'.$subselects.' FROM '.AVAILABILITY_TABLE_RSRCS.' R';
$query2 = 'SELECT count(id) FROM '.AVAILABILITY_TABLE_RSRCS.' R';
if( $category != -1 )
  {
    $can_reorder = 0;
    $joins[] = AVAILABILITY_TABLE_RSRC_CATS.' RC ON R.id = RC.rsrc_id';
    $where[] = 'RC.category_id = ?';
    $qparms[] = $category;
  }
if( $active != -1 )
  {
    $can_reorder = 0;
    $where[] = 'R.active = ?';
    $qparms[] = $active;
  }

// Assemble the queries
if( count($joins) )
  {
    $query1 .= ' LEFT JOIN '.implode(' LEFT JOIN ',$joins);
    $query2 .= ' LEFT JOIN '.implode(' LEFT JOIN ',$joins);
  }
if( count($where) )
  {
    $query1 .= ' WHERE ' . implode(' AND ',$where);
    $query2 .= ' WHERE ' . implode(' AND ',$where);
  }
$query1 .= ' ORDER BY sorting ASC';

// Get the count
$numrecords = $db->GetOne($query2,$qparms);
$npages = (int)((int)$numrecords / $pagelimit);
if( ((int)$numrecords % $pagelimit) )
  {
    $npages++;
  }
if( $npages > 1 )
  {
    $can_reorder = 0;
  }

$smarty->assign('prevpage',$curpage-1);
$smarty->assign('curpage',$curpage);
$smarty->assign('nextpage',$curpage+1);
$smarty->assign('pagecount',$npages);
$smarty->assign('can_reorder',$can_reorder);

// The data for the table
$dbr = $db->SelectLimit($query1,$pagelimit,$startelement,$qparms);

$resources = array();
$query_future = 'SELECT COUNT(DISTINCT resv_id) FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.' WHERE rsrc_id = ? AND (start_date > NOW() OR end_date > NOW())';
$query_past = 'SELECT COUNT(DISTINCT resv_id) FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.' WHERE rsrc_id = ? AND (start_date < NOW() OR end_date < NOW())';
while( $dbr && $row = $dbr->FetchRow() )
  {
    $row['past_resvns'] = $db->GetOne($query_past,array($row['id']));
    $row['future_resvns'] = $db->GetOne($query_future,array($row['id']));
    $resources[] = $row;
  }
if( is_array($resources) && count($resources) )
  {
    $smarty->assign('resources',$resources);
  }

echo $this->ProcessTemplate('admin_resources_tab.tpl');

#
# EOF
#
?>