<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// Permissions
//
if( !$this->CanViewReservations() ) return;

//
// Initialization
//
$days_in_month = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
$this_day = (int)(strftime("%d",time()));
$this_month = (int)(strftime("%m",time()));
$this_year = intval(strftime("%Y",time()));
$store_date = false;
$sel_rsrcs = array();
$the_month = $this_month;
$the_year = $this_year;

if( isset($_SESSION['availability']) && is_array($_SESSION['availability']) )
{
  if( isset($_SESSION['availability']['resvn_tab']) &&
      is_array($_SESSION['availability']['resvn_tab']) )
    {
      $the_month = $_SESSION['availability']['resvn_tab']['month'];
      $the_year = $_SESSION['availability']['resvn_tab']['year'];
    }
}

//
// Handle Input Params
//
if( isset($params['resvn_year']) )
  {
    $the_year = (int)$params['resvn_year'];
    $store_date = true;
  }
if( isset($params['resvn_month']) )
  {
    $store_date = true;
    $the_month = (int)$params['resvn_month'];
    if( $the_month <= 0 )
      {
	$the_month = 12;
	$the_year--;
      }
    else if( $the_month > 12 )
      {
	$the_month = 1;
	$the_year++;
      }
  }

if( isset($params['resvn_filter']) )
{
  if( isset($params['resvn_rsrcs']) )
    {
      $sel_rsrcs = $params['resvn_rsrcs'];
    }
  if( isset($params['resvn_month_Year']) )
    {
      $store_date = true;
      $the_year = (int)$params['resvn_month_Year'];
    }
  if( isset($params['resvn_month_Month']) )
    {
      $store_date = true;
      $the_month = (int)$params['resvn_month_Month'];
      if( $the_month <= 0 )
	{
	  $the_month = 12;
	  $the_year--;
	}
      else if( $the_month > 12 )
	{
	  $the_month = 1;
	  $the_year++;
	}
    }
}


if( isset($params['resvn_reset']) )
{
  $sel_rsrcs = array();
  $the_month = $this_month;
  $the_year = $this_year;
  if( isset($params['resvn_month_Year']) )
    {
      $the_year = (int)$params['resvn_month_Year'];
    }
  if( isset($params['resvn_month_Month']) )
    {
      $the_month = (int)$params['resvn_month_Month'];
    }
  $store_date = true;
}


if( $store_date )
  {
    // store the date for later use.
    if( !isset($_SESSION['availability']) )
      {
	$_SESSION['availability'] = array();
      }
    if( !isset($_SESSION['availability']['resvn_tab']) )
      {
	$_SESSION['availability']['resvn_tab'] = array();
      }
    $_SESSION['availability']['resvn_tab']['month'] = $the_month;
    $_SESSION['availability']['resvn_tab']['year'] = $the_year;
  }


//
// Calculate metadata
//
if( is_leapyear($the_year) )
{
  $days_in_month[1] = 29;
}
$su_date = mktime(0,0,0,$the_month,1,$the_year);
$eu_date = mktime(23,59,50,$the_month,$days_in_month[$the_month-1],$the_year);
$sdb_date = $db->DbTimeStamp($su_date);
$edb_date = $db->DbTimeStamp($eu_date);

//
// Gather Data
//

$query = "SELECT DISTINCT A.* FROM ".AVAILABILITY_TABLE_RESERVATIONS." A
            LEFT JOIN ".AVAILABILITY_TABLE_RESERVATION_PARTS." B
              ON A.id = B.resv_id
           WHERE ((B.start_date BETWEEN $sdb_date AND $edb_date)
                  OR (B.end_date BETWEEN $sdb_date AND $edb_date))";
if( count($sel_rsrcs) )
{
  $query .= ' AND B.rsrc_id IN ('.implode(',',$sel_rsrcs).')';
}
$query .= " GROUP BY A.id ORDER BY end_date ASC";
$reservations = $db->GetArray($query);
$reservation_ids = cge_array::extract_field($reservations,'id');
$dbr = $db->Execute($query);

$stats = '';
{
  $q3 = 'SELECT resv_id, COUNT(rsrc_id) AS COUNT, MIN(start_date) AS start_date, MAX(end_date) AS end_date
           FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
          WHERE resv_id IN ('.implode(',',$reservation_ids).')
          GROUP BY resv_id';
  $tmp = $db->GetArray($q3);
  if( $tmp )
    {
      $stats = cge_array::to_hash($tmp,'resv_id');
    }
}

for( $res = 0; $res < count($reservation_ids); $res++ )
  {
    $row =& $reservations[$res];

    $q2 = 'SELECT DISTINCT A.id,A.name FROM '.AVAILABILITY_TABLE_RSRCS.' A, '.AVAILABILITY_TABLE_RESERVATION_PARTS.' B
            WHERE A.id = B.rsrc_id AND B.resv_id = ? ORDER BY A.name';
    $rsrcs = $db->GetArray($q2,array($row['id']));
    if( count($rsrcs) == 1)
      {
	$row['rsrcs'] = $rsrcs[0]['name'];
      }
    else
      {
	$tmp = array();
	foreach($rsrcs as $one)
	  {
	    $tmp[] = $one['name'];
	  }
	$row['rsrcs'] = implode(', ',$tmp);
      }

    if( $stats )
      {
	$row['start_date'] = $ts_start = $db->UnixTimeStamp($stats[$row['id']]['start_date']);
	$row['end_date'] = $ts_end = $db->UnixTimeStamp($stats[$row['id']]['end_date']);
	if( $ts_end < time() )
	  {
	    $row['addn_status'] = 'expired';
	  }
	else if( $ts_start > time() )
	  {
	    $row['addn_status'] = 'future';
	  }
	else 
	  {
	    $row['addn_status'] = 'in_progress';
	  }
      }

    $tmp = $this->GetUserDetails($row['customer_id']);
    $row['userdetails'] = $tmp;
  }
if( is_array($reservations) && count($reservations) )
  {
    $smarty->assign('reservations',$reservations);
    $smarty->assign('stats',$stats);
  }

//
// Build the form
//
$smarty->assign('formstart',
		$this->CGCreateFormStart($id,'defaultadmin',$returnid,
					 array('cg_activetab'=>'reservations')));
$smarty->assign('formend',$this->CreateFormEnd());

{
  $query = 'SELECT id,name FROM '.AVAILABILITY_TABLE_RSRCS;
  $tmp = $db->Getarray($query);
  if( is_array($tmp) && count($tmp) )
    {
      $opts = array();
      foreach( $tmp as $one )
        {
          $opts[$one['name']] = $one['id'];
        }
      $smarty->assign('input_rsrcs',
                      $this->CreateInputSelectList($id,'resvn_rsrcs[]',$opts,
                                                  $sel_rsrcs));
    }  
}
$smarty->assign('btnfilter',$this->CreateInputSubmit($id,'resvn_filter',$this->Lang('apply')));
$smarty->assign('btnreset',$this->CreateInputSubmit($id,'resvn_reset',$this->Lang('reset')));
$smarty->assign('resv_date',$su_date);
$smarty->assign('prevmonth_link',
		$this->CreateLink($id,'defaultadmin','',
				  $this->Lang('prev'),
				  array('cg_activetab'=>'reservations',
					'resvn_month'=>$the_month-1,
					'resvn_year'=>$the_year)));
$smarty->assign('nextmonth_link',
		$this->CreateLink($id,'defaultadmin','',
				  $this->Lang('next'),
				  array('cg_activetab'=>'reservations',
					'resvn_month'=>$the_month+1,
					'resvn_year'=>$the_year)));

//
// Output
//
echo $this->ProcessTemplate('admin_reservations_tab.tpl');

#
# EOF
#
?>