<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

// Create the form
$contentops =& $gCms->GetContentOperations();
{
  $yesno = array();
  $yesno[0] = $this->Lang('no');
  $yesno[1] = $this->Lang('yes');
  $smarty->assign('list_yesno',$yesno);
}

{
  $intervals = array();
  $intervals['hourly'] = $this->Lang('hourly');
  $intervals['half_day'] = $this->Lang('half_day');
  $intervals['daily'] = $this->Lang('daily');
  $smarty->assign('intervals',$intervals);

  // applies only to hourly interval
  $granularity = array();
  $granularity['quarter_hour'] = $this->Lang('quarter_hour');
  $granularity['half_hour'] = $this->Lang('half_hour');
  $granularity['hour'] = $this->Lang('one_hour');
  $smarty->assign('granularity',$granularity);

  $smarty->assign('starttime1',$this->GetPreference('starttime_1'));
  $smarty->assign('endtime1',$this->GetPreference('endtime_1'));
  $smarty->assign('starttime2',$this->GetPreference('starttime_2'));
  $smarty->assign('endtime2',$this->GetPreference('endtime_2'));
}
$smarty->assign('dflt_interval',$this->GetPreference('dflt_interval','daily'));
$smarty->assign('dflt_granularity',$this->GetPreference('dflt_granularity','half_hour'));

$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_update_preferences'));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));

$smarty->assign('input_resource_type',
		$this->CreateInputText($id,'resource_type',
				       $this->GetPreference('resource_type','resource'),50,50));
$smarty->assign('input_currency_symbol',
		$this->CreateInputText($id,'currency_symbol',
				       $this->GetPreference('currency_symbol','$'),2,2));

$smarty->assign('checkin_time',strtotime($this->GetPreference('checkin_time','14:00')));
$smarty->assign('checkout_time',strtotime($this->GetPreference('checkout_time','11:00')));
$smarty->assign('error_no_prices',$this->GetPreference('error_no_prices',1));

$smarty->assign('input_allowed_image_types',
		$this->CreateInputText($id,'image_types',
				       $this->GetPreference('image_types'),50,255));
$smarty->assign('input_auto_thumbnail',
		$this->CreateInputYesNoDropdown($id,'auto_thumbnail',$this->GetPreference('auto_thumbnail')));
$smarty->assign('input_allowed_file_types',
		$this->CreateInputText($id,'file_types',
				       $this->GetPreference('file_types'),50,255));
$smarty->assign('input_calendar_resvn_foreground',
                $this->CreateColorDropdown($id,'resvn_foreground',$this->GetPreference('resvn_foreground')));
$smarty->assign('input_calendar_resvn_background',
                $this->CreateColorDropdown($id,'resvn_background',$this->GetPreference('resvn_background')));
$smarty->assign('input_calendar_conflict_foreground',
                $this->CreateColorDropdown($id,'conflict_foreground',$this->GetPreference('conflict_foreground')));
$smarty->assign('input_calendar_conflict_background',
                $this->CreateColorDropdown($id,'conflict_background',$this->GetPreference('conflict_background')));
$smarty->assign('input_calendar_pending_foreground',
                $this->CreateColorDropdown($id,'pending_foreground',$this->GetPreference('pending_foreground')));
$smarty->assign('input_calendar_pending_background',
                $this->CreateColorDropdown($id,'pending_background',$this->GetPreference('pending_background')));
$smarty->assign('input_calendar_partial_foreground',
                $this->CreateColorDropdown($id,'partial_foreground',$this->GetPreference('partial_foreground')));
$smarty->assign('input_calendar_partial_background',
                $this->CreateColorDropdown($id,'partial_background',$this->GetPreference('partial_background')));


$config = $gCms->GetConfig();
$opts = array();
$str = basename($config['uploads_path']);
$opts[$str] = $config['uploads_path'];
{
  $tmp = cge_dir::dir_list($config['uploads_path']);
  foreach( $tmp as $one )
  {
    $opts[$str.'/'.$one] = $config['uploads_path'].'/'.$one;
  }
}
$smarty->assign('input_attachment_dir',
    $this->CreateInputDropdown($id,'attachment_dir',$opts,-1,
       $this->GetPreference('attachment_dir')));

$feu =& $this->GetModuleInstance('FrontEndUsers');
if( is_object($feu) )
  {
    $groups = $feu->GetGroupList();
    $groups = array_merge(array($this->Lang('none')=>-1),$groups); 
    $smarty->assign('input_customer_group',
		    $this->CreateInputDropdown($id,'customer_group',$groups,
					       -1,
					       $this->GetPreference('customer_group')));
    $smarty->assign('input_customer_display_template',
		    $this->CreateInputText($id,'customer_display_template',
					   $this->GetPreference('customer_display_template','{$username}'),
					   50,100));

    $smarty->assign('input_page_redirect_notloggedin',
        $contentops->CreateHierarchyDropdown('',
 	  $this->GetPreference('page_redirect_notloggedin',-1),
          $id.'page_redirect_notloggedin'));
							 
  }

$smarty->assign('input_reservation_confirm_page',
		$contentops->CreateHierarchyDropdown('',
 	        $this->GetPreference('reservation_confirm_page',-1),
 	        $id.'reservation_confirm_page'));
		
$smarty->assign('input_reservation_confirm_msg',
		$this->CreateInputYesNoDropdown($id,'reservation_confirm_msg',$this->GetPreference('reservation_confirm_msg',1)));

$smarty->assign('input_reservation_confirm_email_flag',
		$this->CreateInputYesNoDropdown($id,'reservation_confirm_email_flag',
						$this->GetPreference('reservation_confirm_email_flag',1)));
$userlist = array();
$userops =& $gCms->GetUserOperations();
$groupops =& $gCms->GetGroupOperations();
$allgroups = $groupops->LoadGroups();
foreach( $allgroups as $onegroup )
{
  if( !$onegroup->active ) continue;
  $userlist[$this->Lang('group').': '.$onegroup->name] = $onegroup->id * -1;
}
$allusers = $userops->LoadUsers();
foreach( $allusers as $oneuser )
{
  if( !$oneuser->active ) continue;
  if( !$oneuser->adminaccess ) continue;
  if( check_permission($oneuser->id,AVAILABILITY_PERM_RESERVATIONS) ||
      check_permission($oneuser->id,AVAILABILITY_PERM_VIEWRESV) ||
      check_permission($oneuser->id,AVAILABILITY_PERM_CONTACTCUSTOMER) )
    {
      $str = '';
      if( !empty($oneuser->lastname) && !empty($oneuser->firstname) )
	{
	  $str = sprintf("%s, %s (%s)",$oneuser->lastname, $oneuser->firstname, $oneuser->username);
	}
      else if( !empty($oneuser->email) )
	{
	  $str = sprintf("%s (%s)",$oneuser->email,$oneuser->username);
	}
      else
	{
	  $str = $oneuser->username;
	}
      $userlist[$str] = $oneuser->id;
    }
}
$smarty->assign('input_reservation_confirm_email_cc',
		$this->CreateInputSelectList($id,'reservation_confirm_email_cc[]',$userlist,
					     explode(',',$this->GetPreference('reservation_confirm_email_cc')),
					     5));

$smarty->assign('input_reservation_confirm_email_subject',
		$this->CreateInputText($id,'reservation_confirm_email_subject',
				       $this->GetPreference('reservation_confirm_email_subject',
							    $this->Lang('dflt_reservation_confirm_email_subject')),80,255));

$smarty->assign('input_reservation_confirm_email_attachment',
		$this->CreateFileDropdown($id,'reservation_confirm_email_attachment',
					  $this->GetPreference('reservation_confirm_email_attachment'),
					  $this->GetPreference('attachment_dir'),'',1));

$smarty->assign('input_reservation_default_page',
		$contentops->CreateHierarchyDropdown('',
		    $this->GetPreference('reservation_default_page',-1),
		    $id.'reservation_default_page'));

$smarty->assign('input_reservation_require_deposit',
		$this->CreateInputYesNoDropdown($id,'reservation_require_deposit',
						$this->GetPreference('reservation_require_deposit',0)));
$smarty->assign('input_reservation_deposit_percent',
		$this->CreateInputText($id,'reservation_deposit_percent',
				       $this->GetPreference('reservation_deposit_percent'),6,6));
$smarty->assign('input_reservation_deposit_minimum',
		$this->CreateInputText($id,'reservation_deposit_minimum',
				       $this->GetPreference('reservation_deposit_minimum'),6,6));
$smarty->assign('input_reservation_deposit_summary',
		$this->CreateInputText($id,'reservation_deposit_summary',
				       $this->GetPreference('reservation_deposit_summary'),80,255));
$smarty->assign('input_reservation_sku_prefix',
		$this->CreateInputText($id,'reservation_sku_prefix',
				       $this->GetPreference('reservation_sku_prefix'),3,3));

$smarty->assign('default_capacity',$this->GetPreference('default_capacity',50));

{
  $tmp = date('Y');
  $data = array('-1'=>$this->Lang('current_year'));
  for( $i = $tmp; $i > $tmp - 20; $i-- )
    {
      $data[$i] = $i;
    }
  $smarty->assign('admin_yearlist',$data);
}
$smarty->assign('admin_startyear',$this->GetPreference('admin_startyear',$tmp));

//
// output the form
//
echo $this->ProcessTemplate('admin_preferences_tab.tpl');

#
# EOF
#
?>