<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

// TODO: FORM FOR SELECTING TYPE
// TODO: FORM FOR SELECTING DATES
// TODO: PAGINATION

//
// Setup
//
$pagelimit = $this->GetPreference('events_pagelimit',25);
$bookable = $this->GetPreference('events_bookable',-1);
$event_type = $this->GetPreference('events_type',-1);
$use_dates = $this->GetPreference('events_use_dates',false);
$startdate = $this->GetPreference('events_startdate',time());
$enddate = $this->GetPreference('events_enddate',time());
$curpage_ev = 1;

if( isset($params['curpage_ev']) )
  {
    $curpage_ev = (int)$params['curpage_ev'];
  }

if( isset($params['btnfilterevents']) )
  {
    $pagelimit = (int)$params['input_pagelimit'];
    $this->SetPreference('events_pagelimit',$pagelimit);

    $bookable = (int)$params['input_bookable'];
    $this->SetPreference('events_bookable',$bookable);

    $event_type = (int)$params['input_type'];
    $this->SetPreference('events_type',$event_type);

    $use_dates = (int)$params['input_use_dates'];
    $this->SetPreference('events_use_dates',$use_dates);

    $startdate = mktime(0,0,0,
			(int)$params['input_startdate_Month'],
			(int)$params['input_startdate_Day'],
			(int)$params['input_startdate_Year']);
    $this->SetPreference('events_startdate',$startdate);

    $enddate = mktime(0,0,0,
			(int)$params['input_enddate_Month'],
			(int)$params['input_enddate_Day'],
			(int)$params['input_enddate_Year']);
    $this->SetPreference('events_enddate',$enddate);

    $curpage_ev = 1;
  }

// some math
$startelement = ($curpage_ev-1)*$pagelimit;

//
// Build the form
//
$this->SetCurrentTab('events');
$smarty->assign('formstart',
		$this->CGCreateFormStart($id,'defaultadmin',
					 $returnid,
					 array('cg_activetab'=>'events')));
$smarty->assign('formend',$this->CreateFormEnd());
$tmp = array($this->Lang('all')=>1000000,'5'=>5,'10'=>10,'25'=>25,'50'=>50,'100'=>100);
$smarty->assign('input_pagelimit',$this->CreateInputDropdown($id,'input_pagelimit',$tmp,-1,$pagelimit));
$tmp = array($this->Lang('any')=>-1,$this->Lang('yes')=>1,$this->Lang('no')=>0);
$smarty->assign('input_bookable',$this->CreateInputDropdown($id,'input_bookable',$tmp,-1,$bookable));
$types = $this->GetEventTypeDropdownList(true);
$smarty->assign('input_type',$this->CreateInputDropdown($id,'input_type',$types,-1,$event_type));
$smarty->assign('input_use_dates',$this->CreateInputYesNoDropdown($id,'input_use_dates',$use_dates));
$smarty->assign('btnfilter',$this->CreateInputSubmit($id,'btnfilterevents',$this->Lang('apply')));
$smarty->assign('input_startdate',$startdate);
$smarty->assign('input_enddate',$enddate);

//
// The data for display
//

// build the queries
$qparms = array();
$where = array();
$joins = array();
$query1 = 'SELECT * FROM '.AVAILABILITY_TABLE_EVENTS.' EV';
$query2 = 'SELECT count(id) FROM '.AVAILABILITY_TABLE_EVENTS.' EV';
if( $bookable != -1 )
  {
    $where[] = 'EV.bookable = ?';
    $qparms[] = $bookable;
  }
if( $event_type != -1 )
  {
    $where[] = 'EV.event_type_id = ?';
    $qparms[] = $event_type;
  }
if( $use_dates )
  {
    $db_startdate = $db->DbTimeStamp($startdate);
    $db_enddate = $db->DbTimeStamp($enddate);
    $where[] = "EV.start_date >= $db_startdate";
    $where[] = "EV.end_date <= $db_enddate";
  }
// Assemble the queries
if( count($joins) )
  {
    $query1 .= ' LEFT JOIN '.implode(' LEFT JOIN ',$joins);
    $query2 .= ' LEFT JOIN '.implode(' LEFT JOIN ',$joins);
  }
if( count($where) )
  {
    $query1 .= ' WHERE ' . implode(' AND ',$where);
    $query2 .= ' WHERE ' . implode(' AND ',$where);
  }


// Get the data
$dbr = $db->SelectLimit($query1,$pagelimit,$startelement,$qparms);
//echo 'DEBUG: query = '.$db->sql.'<br/>';
$events = array();
while( $dbr && $row = $dbr->FetchRow() )
  {
    $events[] = $row;
  }
if( is_array($events) && count($events) )
  {
    $smarty->assign('events',$events);
  }


// Get the count
$numrecords = $db->GetOne($query2,$qparms);
$npages = (int)((int)$numrecords / $pagelimit);
if( ((int)$numrecords % $pagelimit) )
  {
    $npages++;
  }

$smarty->assign('prevpage',$curpage_ev-1);
$smarty->assign('curpage_ev',$curpage_ev);
$smarty->assign('nextpage',$curpage_ev+1);
$smarty->assign('pagecount',$npages);

//
// Output
//
echo $this->ProcessTemplate('admin_events_tab.tpl');

#
# EOF
#
?>