<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// functions
//
function is_leapyear($year)
{
  $f = 0;
  if( $year % 4 == 0 ) $f = 1;
  if( $year % 100 == 0 ) $f == 0;
  if( $year % 400 == 0 ) $f = 1;
  return $f;
}

function get_array_pos($haystack,$needle)
{
  for( $i = 0; $i < count($haystack); $i++ )
    {
      if( $haystack[$i] == $needle ) return $i;
    }
  return FALSE;
}

//
// Check Permissions
//

//
// Initialize
//
$sel_etypes = array();
$sel_resources = array();
$sel_categories = array();
$days_in_month = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
$this_day = (int)(strftime("%d",time()));
$this_month = (int)(strftime("%m",time()));
$this_year = intval(strftime("%Y",time()));
$the_month = $this_month;
$the_day = $this_day;
$the_year = $this_year;
$vacantobj = new StdClass();
$vacantobj->status = 'vacant';
$vacantobj->fg = '#000'; // todo
$vacantobj->bg = #fff'; // todo
$vacantobj->label = $this->Lang('vacant');
$pendingobj = new StdClass();
$pendingobj->status = 'pending';
$pendingobj->fg = $this->GetPreference('pending_foreground');
$pendingobj->bg = $this->GetPreference('pending_background');
$pendingobj->label = $this->Lang('pending');

$reservedobj = new StdClass();
$reservedobj->status = 'reserved';
$reservedobj->fg = $this->GetPreference('resvn_foreground');
$reservedobj->bg = $this->GetPreference('resvn_background');
$reservedobj->label = $this->Lang('reserved');

$partialobj = new StdClass();
$partialobj->status = 'partial';
$partialobj->fg = $this->GetPreference('partial_foreground');
$partialobj->bg = $this->GetPreference('partial_background');
$partialobj->label = $this->Lang('partially_reserved');

$conflictobj = new StdClass();
$conflictobj->status = 'conflict';
$conflictobj->fg = $this->GetPreference('conflict_foreground');
$conflictobj->bg = $this->GetPreference('conflict_background');

$statistics = array();
$statistics['vacant'] = 0;
$statistics['total'] = 0;
$statistics['closed'] = 0;
$statistics['reserved'] = 0;
$statistics['pending'] = 0;
$statistics['event'] = 0;
$statistics['conflict'] = 0;
$statistics['partial'] = 0;
$statistics['numparts'] = 0;
$statistics['in_cart'] = 0;

$legend = array();
$legend[$this->Lang('vacant')] = $vacantobj;
$legend[$this->Lang('reserved')] = $reservedobj;
$legend[$this->Lang('pending')] = $pendingobj;
$legend[$this->Lang('partially_reserved')] = $partialobj;
$legend[$this->Lang('conflict')] = $conflictobj;

//
// Handle filter form submission
//
if( isset($params['cal_year']) )
{
  $the_year = (int)$params['cal_year'];
}
if( isset($params['cal_month']) )
{
  $the_month = (int)$params['cal_month'];
  if( $the_month <= 0 )
    {
      $the_month = 12;
      $the_year--;
    }
  else if( $the_month > 12 )
    {
      $the_month = 1;
      $the_year++;
    }
}

if( isset($params['calendar_filter']) )
{
  if( isset($params['calendar_dateYear']) )
    {
      $the_year = (int)$params['calendar_dateYear'];
    }
  if( isset($params['calendar_dateMonth']) )
    {
      $the_month = (int)$params['calendar_dateMonth'];
    }
  if( isset($params['filter_rsrcs']) )
    {
      $sel_resources = $params['filter_rsrcs'];
    }
  if( isset($params['filter_cats']) )
    {
      $sel_categories = $params['filter_cats'];
    }
  if( isset($params['filter_etypes']) )
    {
      $sel_etypes = $params['filter_etypes'];
    }
}
else if( isset($params['calendar_reset']) )
{
  $sel_resources = array();
  $sel_categories = array();
  $sel_etypes = array();
  $the_month = $this_month;
  $the_year = $this_year;
}
if( is_leapyear($the_year) )
{
  $days_in_month[1] = 29;
}
$dispdate = mktime(0,0,0,$the_month,1,$the_year);
$month_start_u = mktime(0,0,0,$the_month,1,$the_year);
$month_end_u = mktime(23,59,0,$the_month,$days_in_month[$the_month-1],$the_year);
$month_start_day = $db->DbTimeStamp($month_start_u);
$month_end_day = $db->DbTimeStamp($month_end_u);


//
// Build a grid from selected data
// Grid is resources across the top
// Days along the bottom.
// The 0 values is the column and row header
// 
//
$query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE active = 1';
if( count($sel_categories) )
{
  $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS.' A
              LEFT JOIN '.AVAILABILITY_TABLE_RSRC_CATS.' B
                ON A.id = B.rsrc_id
             WHERE active = 1
               AND B.category_id IN ('.implode(',',$sel_categories).')';
}
else if( count($sel_resources) )
{
  $query .= ' AND id IN ('.implode(',',$sel_resources).')';
}
$query .= ' ORDER BY sorting ASC';
$rsrcs = '';
$rsrcs_index = '';
{
  $tmp = $db->GetArray($query);
  // calculate the number of slots for each resource
  for( $i = 0; $i < count($tmp); $i++ )
    {
      $tmp2 =& $tmp[$i];
      switch($tmp2['res_interval'])
	{
	case 'daily':
	  $tmp2['ext_numslots'] = 1;
	  break;
	case 'half_day':
	  $tmp2['ext_numslots'] = 2;
	  break;
	case 'hourly':
	  $nslots = (int)((strtotime($tmp2['endtime1']) - strtotime($tmp2['starttime1'])) / 3600);
	  $nslots += (int)((strtotime($tmp2['endtime2']) - strtotime($tmp2['starttime2'])) / 3600);
	  $tmp2['ext_numslots'] = $nslots;
	  break;
	}
    }
  $rsrcs = cge_array::to_hash($tmp,'id');
  $rsrcs_index = array_keys($rsrcs);
}


$grid = array_fill(0,$days_in_month[$the_month-1],array_fill(0,count($rsrcs)+1,'&nbsp;'));

//
// fill the grid labels
// top row
$grid[0][0] = $dispdate;
for( $r = 0; $r < count($rsrcs_index); $r++ )
{
  $rid = $rsrcs_index[$r];
  if($this->CheckPermission(AVAILABILITY_PERM_RESOURCES) )
    {
      $grid[0][$r+1] = $this->CreateLink($id,'admin_edit_rsrc','',$rsrcs[$rid]['name'],
					 array('rsrcid'=>$rsrcs[$rid]['id']));
    }
  else
    {
      $grid[0][$r+1] = $rsrcs[$rid]['name'];
    }
}
// columns
for( $d = 1; $d <= $days_in_month[$the_month-1]; $d++ )
{
  if( $this->CheckPermission(AVAILABILITY_PERM_VIEWRESV) ||
      $this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS))
    {
      $grid[$d][0] = $this->CreateLink($id,'admin_view_day','',$d,
				       array('day'=>$d,'month'=>$the_month,'year'=>$the_year));
    }
  else
    {
      $grid[$d][0] = $d;
    }
}

//
// Fill the grid values with vacancies
//
for( $r = 0; $r < count($rsrcs); $r++ )
{
  for( $d = 1; $d <= $days_in_month[$the_month-1]; $d++ )
  {
    $grid[$d][$r+1] = $vacantobj;
  }
}

//
// Fill the appriate grid values with event information
//
$eventtypes = array();
{
  $query = 'SELECT * FROM '.AVAILABILITY_TABLE_EVENT_TYPES;
  $tmp = $db->GetArray($query);
  $eventtypes = cge_array::to_hash($tmp,'id');
}

$events = '';
{
  $query = 'SELECT A.* FROM '.AVAILABILITY_TABLE_EVENTS." A
             LEFT JOIN ".AVAILABILITY_TABLE_EVENT_TYPES." B
             ON A.event_type_id = B.id
             WHERE    (A.start_date BETWEEN $month_start_day AND $month_end_day)
                   OR (A.end_date BETWEEN $month_start_day AND $month_end_day)
                   OR (A.start_date <= $month_start_day AND A.end_date >= $month_end_day)";
  if( count($sel_etypes) )
    {
      $query .= ' AND A.event_type_id IN ('.implode(',',$sel_etypes).')';
    }
  $query .= " ORDER BY A.bookable DESC, B.iorder ASC";
  $events = $db->GetArray($query);
  $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRC_EVENTS.'
     WHERE event_id = ?';
  for( $i = 0; $i < count($events); $i++ )
    {
      $tmp = $db->GetArray($query,array($events[$i]['id']));
      if( $tmp )
	{
	  $events[$i]['rsrcs'] = $tmp;
	}
    }
}

if( is_array($events) && count($events) )
{
  foreach( $events as $one )
    {
      $resv_start_u = $db->UnixTimeStamp($one['start_date']);
      $resv_end_u = $db->UnixTimeStamp($one['end_date']);
      $rstart_u = max($resv_start_u,$month_start_u);
      $rend_u = min($resv_end_u,$month_end_u);

      $sday = intval(strftime("%d",$rstart_u));
      $eday = intval(strftime("%d",$rend_u));

      $etype =& $eventtypes[$one['event_type_id']];
      
      $obj = new StdClass();
      $obj->fg = $etype['color'];
      $obj->bg = $etype['background'];
      if( $one['bookable'] )
	{
	  $obj->status = 'event';
	}
      else
	{
	  $obj->status = 'closed';
	}
      $legend[$one['name']] = $obj;
      $obj->label = $one['name'];
      if( $this->CheckPermission(AVAILABILITY_PERM_EVENTS) )
	{
	  $obj->url   = $this->CreateURL($id,'admin_edit_event','',
					 array('eventid'=>$one['id']));
	}
      if( isset($one['rsrcs']) && count($one['rsrcs']) )
	{
	  for( $d = $sday; $d <= $eday; $d++ )
	    {
	      for( $r = 0; $r < count($one['rsrcs']); $r++ )
		{
		  $tmprid = $one['rsrcs'][$r]['rsrc_id'];
		  $idx = get_array_pos($rsrcs_index,$tmprid);
		  if( isset($rsrcs_index[$idx]) )
		    {
		      $grid[$d][$idx+1] = $obj;
		    }
		}
	    }
	} 
    }
}
unset($events);


//
// Fill the grid values with reservation information
//

$resvn = '';
{
  $query = 'SELECT DISTINCT resv_id FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS."
             WHERE (start_date BETWEEN $month_start_day AND $month_end_day) 
                OR (end_date BETWEEN $month_start_day AND $month_end_day)
             ORDER BY resv_id ASC";
  $tmp = $db->GetArray($query);
  $rids = cge_array::extract_field($tmp,'resv_id');

  if( $rids )
    {
      $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATIONS.'
             WHERE id IN ('.implode(',',$rids).')';
      $tmp = $db->GetArray($query);
      $resvn = cge_array::to_hash($tmp,'id');
      
      $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
             WHERE resv_id IN ('.implode(',',$rids).')
             ORDER BY resv_id,start_date ASC';
      $tmp = $db->GetArray($query);
      for( $i = 0; $i < count($tmp); $i++ )
	{
	  $part =& $tmp[$i];
	  $trid = $part['resv_id'];
	  if( !isset($resvn[$trid]['parts']) )
	    {
	      $resvn[$trid]['parts'] = array();
	    }
	  $resvn[$trid]['parts'][] = $part;
	}
    }
}

if( is_array($resvn) && count($resvn) )
{
  for( $res = 0; $res < count($resvn); $res++ )
    {
      $oneres =& $resvn[$res];

      // don't display cancelled reservations
      if( $oneres['status'] == 'cancelled' ) continue;

      for( $pnum = 0; $pnum < count($oneres['parts']); $pnum++ )
	{
	  $onepart =& $oneres['parts'][$pnum];
	  $the_resource =& $rsrcs[$onepart['rsrc_id']];
	  $ridx = get_array_pos($rsrcs_index,$onepart['rsrc_id'])+1; 

	  $resv_start_u = $db->UnixTimeStamp($onepart['start_date']);
	  $resv_end_u = $db->UnixTimeStamp($onepart['end_date']);
	  $rstart_u = max($resv_start_u,$month_start_u);
	  $rend_u = min($resv_end_u,$month_end_u);
	  $sday = intval(strftime("%d",$rstart_u));
	  $eday = intval(strftime("%d",$rend_u));
	  if( $eday == $days_in_month[$the_month-1] && $resv_end_u > $month_end_u )
	    {
	      // hack
	      $eday++;
	    }

	  if( $the_resource['res_interval'] != 'daily' )
	    {
	      $d = $sday;

	      if( isset($grid[$d][$ridx]) && 
		  is_object($grid[$d][$ridx]) &&
		  ($grid[$d][$ridx]->status == 'vacant' || $grid[$d][$ridx]->status == 'partial'))
		{
		  $obj = new stdClass;
		  if( !isset($obj->numparts) )
		    {
		      $obj->numparts = 1;
		    }
		  else
		    {
		      $obj->numparts++;
		    }
		  $obj->status = 'partial';
		  $obj->url = $this->CreateURL($id,'admin_view_day','',
					       array('resvnid'=>$oneres['id'],
						     'rsrcid'=>$ridx));
		  $obj->label = $this->Lang('partially_reserved_lbl',$obj->numparts,$the_resource['ext_numslots']);
		  $obj->fg = $this->GetPreference('partial_foreground');
		  $obj->bg = $this->GetPreference('partial_background');

		  $grid[$d][$ridx] = $obj;
		}
	      else
		{
		  // conflict of some type
		  $grid[$d][$ridx]->status = 'conflict';
		  $grid[$d][$ridx]->label = $this->Lang('conflict');
		  $grid[$d][$ridx]->title = $this->Lang('title_conflict2');
		  $grid[$d][$ridx]->fg = $this->GetPreference('conflict_foreground');
		  $grid[$d][$ridx]->bg = $this->GetPreference('conflict_background');
		}

	      // handle hourly or half day parts.
	      continue;
	    }

	  // handle full day reservation parts
	  $obj = new StdClass();
	  $obj->resv = $oneres['id'];
	  $obj->status = $oneres['status'];
	  switch( $oneres['status'] )
	    {
	    case AVAILABILITY_STATUS_PENDING:
	      $obj->fg = $this->GetPreference('pending_foreground');
	      $obj->bg = $this->GetPreference('pending_background');
	      $obj->status = 'pending';
	      break;
	    case AVAILABILITY_STATUS_CONFIRMED:
	      $obj->fg = $this->GetPreference('resvn_foreground');
	      $obj->bg = $this->GetPreference('resvn_background');
	      $obj->status = 'reserved';
	      break;
	    case AVAILABILITY_STATUS_CANCELLED:
	    case AVAILABILITY_STATUS_INCART:
	      break;
	    }
	  $obj->label = $this->Lang('reservation_num',$oneres['id']);
	  if( $this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS) )
	    {
	      $obj->url = $this->CreateURL($id,'admin_edit_resvn','',
					   array('resvnid'=>$oneres['id']));
	    }
	  else if( $this->CheckPermission(AVAILABILITY_PERM_VIEWRESV) )
	    {
	      $obj->url = $this->CreateLink($id,'admin_view_resvn','',
					    array('resvnid'=>$oneres['id']));
	    }
      
	  for( $d = $sday; $d < $eday; $d++ )
	    {
	      if( isset($grid[$d][$ridx]) && 
		  is_object($grid[$d][$ridx]) &&
		  (isset($grid[$d][$ridx]->resv) && ($grid[$d][$ridx]->resv != $oneres['id'])) &&
		  ($grid[$d][$ridx]->status == 'pending' || $grid[$d][$ridx]->status == 'reserved' ||
		   $grid[$d][$ridx]->status == 'closed') )
		{
		  // oops, already a reservation for this day
		  // now we gotta think about something...
		  $grid[$d][$ridx]->status = 'conflict';
		  $grid[$d][$ridx]->label = $this->Lang('conflict');
		  $grid[$d][$ridx]->title = $this->Lang('title_conflict',$grid[$d][$ridx]->resv,$oneres['id']);
		  $grid[$d][$ridx]->fg = $this->GetPreference('conflict_foreground');
		  $grid[$d][$ridx]->bg = $this->GetPreference('conflict_background');
		}
	      else
		{
		  $grid[$d][$ridx] = $obj;
		}
	    } // for each day of the reservation.
	} // for each part
    } // for each reservation
}
unset($resvn);

//
// Gather Statistics
//
for( $d = 1; $d < count($grid); $d++ )
{
  for( $r = 1; $r < count($grid[0]); $r++ )
    {
      $rid = $rsrcs_index[$r-1];
      $num = $rsrcs[$rid]['ext_numslots'];

      if( is_object($grid[$d][$r]) )
	{
	  $s = $grid[$d][$r]->status;
	  $statistics[$s]++;
	  if( $s == 'partial' )
	    {
	      $statistics['numparts']+=$grid[$d][$r]->numparts;
	    }
	  $statistics['total'] += $num;
	}
    }
}

// 
// Display the form
//
$smarty->assign('formstart',
		$this->CGCreateFormStart($id,'defaultadmin',
					 $returnid,
					 array('cg_activetab'=>'calendar')));
$smarty->assign('formend',$this->CreateFormEnd());
{
  $query = 'SELECT id,name FROM '.AVAILABILITY_TABLE_RSRCS.' ORDER BY name';
  $tmp = $db->GetArray($query);
  if( $tmp )
    {
      $opts = array();
      foreach( $tmp as $one )
	{
	  $opts[$one['name']] = $one['id'];
	}
      $addtext = 'id="filter_rsrcs" onChange="clearCategories()"';
      $smarty->assign('filter_resources',
		      $this->CreateInputSelectList($id,'filter_rsrcs[]',
						   $opts,$sel_resources,
						   3,$addtext));
    }
}

{
  $query = 'SELECT * FROM '.AVAILABILITY_TABLE_CATS;
  $tmp = $db->GetArray($query);
  if( $tmp )
    {
      $opts = array();
      foreach( $tmp as $one )
	{
	  $opts[$one['name']] = $one['id'];
	}
      $addtext = 'id="filter_cats" onChange="clearResources()"';
      $smarty->assign('filter_categories',
		      $this->CreateInputSelectList($id,'filter_cats[]',
						   $opts,$sel_categories,
						   3, $addtext));
    }
}
$smarty->assign('filter_submit',
		$this->CreateInputSubmit($id,'calendar_filter',$this->Lang('apply')));
$smarty->assign('filter_reset',
		$this->CreateInputSubmit($id,'calendar_reset',$this->Lang('reset')));

{
  $opts = array();
  foreach( $eventtypes as $key => $value )
    {
      $opts[$value['name']] = $key;
    }
  $smarty->assign('filter_etypes',
		  $this->CreateInputSelectList($id,'filter_etypes[]',
					       $opts,$sel_etypes));
}
$smarty->assign('prevmonth_link',
		$this->CreateLink($id,'defaultadmin','',
				  $this->Lang('prev'),
				  array('cg_activetab'=>'calendar',
					'cal_month'=>$the_month-1,
					'cal_year'=>$the_year)));
$smarty->assign('nextmonth_link',
		$this->CreateLink($id,'defaultadmin','',
				  $this->Lang('next'),
				  array('cg_activetab'=>'calendar',
					'cal_month'=>$the_month+1,
					'cal_year'=>$the_year)));
$smarty->assign('statistics',$statistics);
$smarty->assign('legend',$legend);
$smarty->assign('grid',$grid);
$smarty->assign('dispdate',$dispdate);
if( $this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS) )
  {
    $smarty->assign('graph_icon_url',
		    '../modules/'.$this->GetName().'/icons/chart_bar.png');
    $smarty->assign('graphing_url',
		    $this->CreateURL($id,'admin_graphing',$returnid));
  }

echo $this->ProcessTemplate('admin_calendar_tab.tpl');
#
# EOF
#
?>