<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

if( !isset($params['order_id']) ) return;

// get the order.
$order = cg_ecomm_order::get_order_contents($params['order_id']);
if( !is_array($order) ) return;
$status = $order['status'];

// see if there are any reservations in this order.
$reservations = array();
if( is_array($order) && isset($order['shipping']) )
  {
    for( $i = 0; $i < count($order['shipping']); $i++ )
      {
	$dest =& $order['shipping'][$i];
	if( isset($dest['items']) )
	  {
	    for( $j = 0; $j < count($dest['items']); $j++ )
	      {
		$item =& $dest['items'][$j];

		if( $item['source'] == $this->GetName() )
		  {
		    $reservations[] = $item;
		  }
	      }
	  }
      }
  }
if( !count($reservations) )
  {
    return;
  }

// we have reservations...
$emailtemplate = $this->GetPreference(AVAILABILITY_PREF_DFLTRESVNCONFIRMEMAIL_TEMPLATE);
switch( $status )
  {
  case 'cancelled':
    for( $i = 0; $i < count($reservations); $i++ )
      {
	$obj = reservation_ops::load_by_id($reservation[$i]['item_id']);
	if( is_object($obj) )
	  {
	    $obj->set_status(AVAILABILITY_STATUS_CANCELLED);
	    $obj->save();
	  }

	$tmp = '';
	$res = $this->SendReservationDetailsEmail($reservation[$i]['item_id'],$emailtemplate,1,$tmp);
      }
    break;

  case 'incomplete':
  case 'completed':
  case 'invoiced':
  case 'hold':    
  case 'paid':
  case 'balancedue':
  case 'confirmed':
    for( $i = 0; $i < count($reservations); $i++ )
      {
	$obj = reservation_ops::load_by_id($reservations[$i]['item_id']);
	if( is_object($obj) )
	  {
	    $obj->set_status(AVAILABILITY_STATUS_CONFIRMED);
	    $obj->save();
	  }

	$tmp = '';
	$res = $this->SendReservationDetailsEmail($reservation[$i]['item_id'],$emailtemplate,1,$tmp);
      }
    break;
  }


#
# EOF
#
?>
