<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;


// 
// Initialization
//
if( !isset($params['resv_id']) )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_missing_parameter'));
    return;
  }
$resv_id = (int)$params['resv_id'];
$feu = $this->GetModuleInstance('FrontEndUsers');
if( !$feu ) return; // could not find feu
$custid = $feu->LoggedInId();
if( $custid <= 0 ) 
  {
    $page = $this->GetPreference('page_redirect_notloggedin',-1);
    if( $page != -1 )
      {
	$this->RedirectContent($page);
      }
    else
      {
	// gotta display a message
	// and exit
	echo $this->DisplayErrorMessage($this->Lang('error_notloggedin_feu'));
	return;
      }
  }
$thetemplate = 'sendemail_'.$this->GetPreference(AVAILABILITY_PREF_DFLTSENDEMAIL_TEMPLATE);
$emailtemplate = 'custemail_'.$this->GetPreference(AVAILABILITY_PREF_DFLTCUSTEMAIL_TEMPLATE);
$subject = '';
$body = '';
$ccmyself = '';
$status = '';
$message = '';

//
// Parameters
//
if( isset($params['sendemailtemplate']) )
  {
    $thetemplate = 'sendemail_'.trim($params['sendemailtemplate']);
  }
if( isset($params['emailtemplate']) )
  {
    $emailtemplate = 'custemail_'.trim($params['emailtemplate']);
  }
if( isset($params['avail_body']) )
  {
    $body = trim($params['avail_body']);
  }
if( isset($params['avail_subject']) )
  {
    $subject = trim($params['avail_subject']);
  }
if( isset($params['avail_ccmyself']) )
  {
    $ccmyself = (int)$params['avail_ccmyself'];
  }

//
// Setup
//


//
// Process form data
//
if( isset($params['avail_submit']) )
  {
    //
    // data validation
    //
    if( empty($subject) )
      {
	$status = 'error';
	$message = $this->Lang('error_missing_parameter');
      }
    else if( empty($body) )
      {
	$status = 'error';
	$message = $this->Lang('error_missing_parameter');
      }

    if( empty($status) )
      {
	$smarty->assign('resv_id',$resv_id);
	$smarty->assign('subject',$subject);
	$smarty->assign('body',$body);
	$msgsubject = sprintf($this->Lang('subject_email_for_reservation',$resv_id));
	$msgbody = $this->ProcessTemplateFromDatabase($emailtemplate);
	if( empty($msgbody) )
	  {
	    echo $this->DisplayErrorMessage($this->Lang('error_internalconfig'));
	    return;
	  }
	
	// Send the email (text only)
	$ccusers = $this->GetAdminCCList();
	$myemail = $feu->GetEmail($custid);
	if( empty($myemail) )
	  {
	    echo $this->DisplayErrorMessage($this->Lang('error_no_customer_email'));
	    return;
	  }
	if( empty($ccusers) )
	  {
	    // if the ccusers list is empty, there's nobody
	    // to send the email to.
	    $status = 'error';
	    $message = $this->Lang('error_noemailaddress');
	  }
	else
	  {
	    $mailer =& $this->GetModuleInstance('CMSMailer');
	    $mailer->reset();
	    $mailer->IsHTML(true);
	    $mailer->SetSubject($msgsubject);
	    $mailer->SetBody($msgbody);
	    $mailer->AddReplyTo($myemail);
	    if( $ccmyself )
	      {
		// send the customer a copy of this email
		$mailer->AddCC($myemail);
	      }
	    foreach($ccusers as $one)
	      {
		$mailer->AddAddress($one);
	      }
	  }

	// add it to the database
	$now = $db->DbTimeStamp(time());
	$query = 'INSERT INTO '.AVAILABILITY_TABLE_RESERVATION_NOTES."
                   (resv_id,subject,text,create_date)
                  VALUES (?,?,?,$now)";
	$db->Execute($query,array($resv_id,$subject,$body));
	
	// display a warm fuzzy message
	$status = 'success';
	$message = $this->Lang('info_email_sent');
      }
  }


//
// Setup Smarty
//
if( empty($status) || $status != 'success' )
  {
    $smarty->assign('formstart',
		    $this->CGCreateFormStart($id,'sendemail',$returnid,$params));
    $smarty->assign('formend',$this->CreateFormEnd());
  }
$smarty->assign('resv_id',$resv_id);
$smarty->assign('body',$body);
$smarty->assign('subject',$subject);
$smarty->assign('ccmyself',$ccmyself);
$smarty->assign('status',$status);
$smarty->assign('message',$message);

//
// Display the form
//
echo $this->ProcessTemplateFromDatabase($thetemplate);

#
# EOF
#
?>