<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

////////////////////////
//  Search Form View  //
////////////////////////

//
// Parameters:
// searchtemplate=blah
// summarytemplate=blah
// detailtemplate=blah
// summarypage=alias
// detailpage=alias
// startdate
// enddate
// inline
// 

//
// Initialization
//
$thetemplate = 'advsearchform_'.$this->GetPreference(AVAILABILITY_PREF_DFLTADVSEARCHFORM_TEMPLATE);
$summaryparams = array();
$summarypage = $returnid;
$inline=0;
$startdate = time();
$enddate = strtotime('+1 month',$startdate);
$searchparms = array();

//
// Handle Input Parameters
//
if( isset($params['searchtemplate']) )
  {
    $thetemplate = 'advsearchform_'.trim($params['searchtemplate']);
    unset($params['searchtemplate']);
  }
if( isset($params['inline']) )
  {
    $inline = (int)$params['inline'];
    unset($params['inline']);
  }
if( isset($params['summarypage']) )
  {
    $inline = 0;
    $summarypage = $this->resolve_alias_or_id($params['summarypage']);
    unset($params['summarypage']);
  }
if( isset($params['startdate']) )
  {
    $startdate = strtotime(trim($params['startdate']));
    $enddate = strtotime('+1 month',$startdate);
    unset($params['startdate']);
  }
if( isset($params['enddate']) )
  {
    $enddate = strtotime(trim($params['enddate']));
    unset($params['enddate']);
  }

if( isset($params['avail_submit']) )
  {
    //
    // Submit has been pressed
    //

    // 
    // Gather form parameters
    //
    if( isset($params['avail_startdate_Month']) )
      {
	$startdate = mktime(0,0,0,
			    (int)$params['avail_startdate_Month'],
			    (int)$params['avail_startdate_Day'],
			    (int)$params['avail_startdate_Year']);
	$enddate = strtotime('+1 month',$startdate);
      }

    if( isset($params['avail_enddate_Month']) )
      {
	$enddate = mktime(0,0,0,
			    (int)$params['avail_enddate_Month'],
			    (int)$params['avail_enddate_Day'],
			    (int)$params['avail_enddate_Year']);
      }
    $searchparms['startdate'] = $startdate;
    $searchparms['enddate'] = $enddate;

    //
    // Do the search
    //
    $res = $this->DoAdvancedSearch($searchparms);
    if( $res )
      {
	$params['avail_specify'] = implode(',',$res);

	// display the output
	echo $this->DoAction('default',$id,$params,$summarypage);
      }
    return;
  }

//
// Give everything to smarty
//
$smarty->assign('formstart',$this->CGCreateFormStart($id,'search',$summarypage,$params,$inline));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('startdate',$startdate);
$smarty->assign('enddate',$enddate);

//
// Process Template
//
echo $this->ProcessTemplateFromDatabase($thetemplate);

#
# EOF
#
?>