<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

///////////////////////////
//  View My Reservations //
///////////////////////////

//
// Initialization
//
$feu = $this->GetModuleInstance('FrontEndUsers');
if( !$feu ) return; // could not find feu
$custid = $feu->LoggedInId();
if( $custid <= 0 ) 
  {
    $page = $this->GetPreference('page_redirect_notloggedin',-1);
    if( $page != -1 )
      {
	$this->RedirectContent($page);
      }
    else
      {
	// gotta display a message
	// and exit
	echo $this->DisplayErrorMessage($this->Lang('error_notloggedin_feu'));
	return;
      }
  }
$thetemplate = 'myresv_'.$this->GetPreference(AVAILABILITY_PREF_DFLTMYRESV_TEMPLATE);
$sortby = 'start_date';
$sortorder = 'ASC';
$detailpage = $this->GetPreference('reservation_default_page',-1);
if( $detailpage == -1 )
  {
    $detailpage = $returnid;
  }
$showall = 0;

//
// Parameters
//
if( isset($params['myresvtemplate']) )
  {
    $thetemplate = 'myresv_'.trim($params['myresvtemplate']);
  }
if( isset($params['sortby']) )
  {
    switch($params['sortby'])
      {
      case 'start_date':
      case 'end_date':
      case 'price':
      case 'num_people':
      case 'create_date':
      case 'modified_date':
	$sortby = $params['sortby'];
      }
  }
if( isset($params['sortorder']) )
  {
    $tmp = strtoupper($params['sortorder']);
    switch($tmp)
      {
      case 'ASC':
      case 'DESC':
	$sortorder = $tmp;
      }
  }
if( isset($params['detailpage']) )
  {
    $manager =& $gCms->GetHierarchyManager();
    $node =& $manager->sureGetNodeByAlias($params['detailpage']);
    if (isset($node))
      {
	$content =& $node->GetContent();	
	if (isset($content))
	  {
	    $detailpage = $content->Id();
	  }
      }
    else
      {
	$node =& $manager->sureGetNodeById($params['detailpage']);
	if (isset($node))
	  {
	    $detailpage = $params['detailpage'];
	  }
      }
  }
if( isset($params['showall']) )
  {
    $showall = 1;
  }

//
// Setup
//


//
// Gather the data
//
$where = array();
$qparms = array();
$query = 'SELECT A.id FROM '.AVAILABILITY_TABLE_RESERVATIONS.' A
            LEFT JOIN '.AVAILABILITY_TABLE_RESERVATION_PARTS.' B
              ON A.id = B.resv_id';
$where[] = 'A.customer_id = ?';
$qparms[] = $custid;
$now = $db->DbTimeStamp(time());
if( $showall == 0 )
  {
    $where[] = "B.start_date > $now";
  }
if( count($where) )
  {
    $query .= " WHERE ".implode(" AND ",$where);
  }
$query .= " ORDER BY $sortby $sortorder";
$resvn_ids = $db->GetCol($query,array($custid));

$config = $gCms->GetConfig();
$url = $config['root_url'].'/modules/'.$this->GetName().'/icons';
$resvns = array();
$now = time();
foreach( $resvn_ids as $one_id )
{
  $resvn = reservation_ops::load_by_id($one_id);
  $resvns[] = reservation_ops::to_array($resvn);
}
for( $i = 0; $i < count($resvns); $i++ )
  {
    $params['resv_id'] = $resvns[$i]['id'];
    $pretty_url = $this->GetResourceType()."/viewresvn/$detailpage/{$resvns[$i]['id']}";
    $start_ut = $db->UnixTimeStamp($resvns[$i]['start_date']);
    if( $start_ut > time() )
      {
	$resvns[$i]['edit_url'] = $this->CreateURL($id,'addresvn',$detailpage,
						   $params,false,$pretty_url);
	$resvns[$i]['email_url'] = $this->CreateURL($id,'sendemail',$detailpage,
						    $params);

	$resvns[$i]['email_icon'] = $this->DisplayImage("$url/email.png",$this->Lang('send_email'));
	$resvns[$i]['edit_icon'] = $this->DisplayImage("$url/calendar_edit.png",$this->Lang('edit'));
      }
  }

//
// Give it to smarty
//
if( count($resvns) )
  {
    $smarty->assign('reservations',$resvns);
  }

//
// Display the Template
//
echo $this->ProcessTemplateFromDatabase($thetemplate);


#
# EOF
#
?>