<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

$data = json_decode($_POST['data'], true);

$res = array();
$res['result'] = 'success';
$res['message'] = '';

// check input paramas
if( !isset($data['rsrc_id']) || !isset($data['start_date']) )
  {
    $res['result'] = 'error';
    $res['message'] = $this->Lang('error_insufficient_params');
  }
else
  {
    $start_date = '';
    $end_date = '';
    {
      $stmp = new cge_date($data['start_date']);
      $stmp->set_seconds(0);
      $start_date = $stmp->to_timestamp();

      if( isset($data['end_date']) )
	{
	  $etmp = new cge_date($data['end_date']);
	  $etmp->set_seconds(0);
	  $end_date = $etmp->to_timestamp();
	}
    }

    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE id = ?';
    $row = $db->GetRow($query,array($data['rsrc_id']));
    if( $row )
      {
	// check for capacity problems....
	if( !$row['allow_overcapacity'] && 
 	    $row['capacity'] > 0 &&
	    ($data['num_people'] > $row['capacity']) )
	  {
	    $res['result'] = 'error';
	    $res['message'] = $this->Lang('error_over_capacity',$row['capacity'],$data['num_people']);
	  }

	if( $res['result'] == 'success' )
	  {
	    // adjust the end time based on the interval
	    switch($row['res_interval'])
	      {
	      case 'daily':
		{
		  list($start_date,$end_date) = $this->AdjustReservationPartInterval2($row,$start_date,$end_date);
		  
		  // basic checks
		  if( $start_date >= $end_date )
		    {
		      // invalid date values
		      $res['result'] = 'error';
		      $res['message'] = $this->Lang('error_invalid_dates');
		    }
		  $res['start_date'] = $start_date;
		  $res['end_date'] = $end_date;
		}
		break;
		
	      case 'hourly':
		{
		  list($start_date,$end_date) = $this->AdjustReservationPartInterval2($row,$start_date,$end_date);
		  $start1_ts = cge_date_utils::ts_set_time_from_str($start_date,$row['starttime1']);
		  $end1_ts = cge_date_utils::ts_set_time_from_str($start_date,$row['endtime1']);
		  $start2_ts = cge_date_utils::ts_set_time_from_str($start_date,$row['starttime2']);
		  $end2_ts = cge_date_utils::ts_set_time_from_str($start_date,$row['endtime2']);
		  
		  // basic checks
		  if( ($start_date < $start1_ts) ||
		      ($start_date >= $end1_ts && $start_date < $start2_ts) ||
		      ($start_date > $end2_ts) ||
		      ($end_date > $end1_ts && $end_date < $start2_ts ) ||
		      ($end_date < $start_date) ||
		      ($end_date > $end2_ts) )
		    {
		      // invalid date values
		      $res['result'] = 'error';
		      $res['message'] = $this->Lang('error_invalid_dates');
		    }
		  else
		    {
		      // check to make sure we're starting on the proper interval.
		      $offset = 0;
		      switch($row['granularity'])
			{
			case 'quarter_hour':
			  $offset = 15;
			  break;
			case 'half_hour':
			  $offset = 30;
			  break;
			case 'hour':
			  $offset = 60;
			  break;
			}
		      
		      $tmp = $start1_ts;
		      if( $start_date >= $start2_ts )
			{
			  $tmp = $start2_ts;
			}
		      $rem = ($start_date - $tmp) % ($offset*60);
		      if( $rem > 0 )
			{
			  // invalid date values
			  $res['result'] = 'error';
			  $res['message'] = $this->Lang('error_invalid_dates');
			}
		    }
		  
		  $res['start_date'] = $start_date;
		  $res['end_date'] = $end_date;
		}
		break;
		
	      case 'half_day':
		if( !isset($data['meridian']) )
		  {
		    $res['result'] = 'error';
		    $res['message'] = $this->Lang('error_insufficient_params');
		  }
		else
		  {
		    list($start_date,$end_date) = $this->AdjustReservationPartInterval2($row,$start_date,$end_date,$data['meridian']);
		    $res['start_date'] = $start_date;
		    $res['end_date'] = $end_date;
		  }
		break;
	      }
	  }


	if( $res['result'] == 'success' && $this->GetPreference('admin_startyear',-1) == -1 )
	  {
	    $now = time();
	    if( ($end_date <= $now) || ($start_date < $now && $end_date > $now) )
	      {
		$res['result'] = 'started';
		$res['message'] = $this->Lang('error_timeperiod_started');
	      }
	  }
	

	if( $res['result'] == 'success' )
	  {
	    // now really check for conflicts
	    $reservation = array();
	    $part = array();
	    $part['rsrc_id'] = $data['rsrc_id'];
	    $part['start_date'] = $start_date;
	    $part['end_date'] = $end_date;
	    $part['num_people'] = max(1,$data['num_people']);
	    $reservation['parts'] = array($part);
	    
	    // 1.  Check for conflicts
	    $err = $this->CheckReservationConflicts($reservation);
	    if( $err )
	      {
		$res['result'] = 'conflict';
		$res['message'] = $this->Lang('error_reservation_conflict');
	      }
	  }
	
	if( $res['result'] == 'success' )
	  {
	    $res['result'] = 'available';
	    $parts = '';
	    $res['price'] = $this->CalculateReservationPrice($reservation,$parts);
	    if( !count($parts) || $res['price'] === FALSE )
	      {
		$res['result'] = 'error';
		$res['message'] = $this->Lang('error_calculate_price');
	      }
	  }
      }
  }

if( isset($res['start_date']) )
  {
    $res['start_date'] = strftime('%m/%d/%Y %H:%M',$res['start_date']);
  }
if( isset($res['end_date']) )
  {
    $res['end_date'] = strftime('%m/%d/%Y %H:%M',$res['end_date']);
  }

// post processing
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT" ); 
header("Last-Modified: " . gmdate( "D, d M Y H:i:s" ) . "GMT" ); 
header("Cache-Control: no-cache, must-revalidate" ); 
header("Pragma: no-cache" );
header("Content-Type: text/xml; charset=utf-8");
print json_encode($res);
exit;

#
# EOF
#
?>
