<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !isset($params['rsrcid']) ) return;

/////////////////////////////
//  Resource Detail View   //
/////////////////////////////

//
// Setup
//
$config = $gCms->GetConfig();

//
// Parameters
// detailtemplate - the detail template
// rsrcid = the resource id
//
$rsrcid = (int)$params['rsrcid'];
$thetemplate = 'detail_'.$this->GetPreference(AVAILABILITY_PREF_DFLTDETAIL_TEMPLATE);
if( isset($params['detailtemplate']) )
  {
    $thetemplate = 'detail_'.trim($params['detailtemplate']);
  }

//
// Get the data
//

// the resource
$query = 'SELECT id,name,description,base_price 
            FROM '.AVAILABILITY_TABLE_RSRCS.' 
           WHERE active = 1 AND id = ?';
$rsrc = $db->GetRow($query,array($rsrcid));
if( $rsrc )
  {
    $tmp = $this->GetFieldsForRsrc($rsrcid);
    if( $tmp )
      {
	$tmp2 = cge_array::to_hash($tmp,'name');
	$rsrc['fields'] = $tmp2;
      }
    $tmp = $this->GetAttributesForRsrc($rsrcid);
    if( $tmp )
      {
	$rsrc['attribs'] = $tmp;
      }
    $desturl = $config['uploads_url'].'/'.$this->GetName().'/resources_'.$rsrcid;
    
    // prices
    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRC_PRICES.' 
           WHERE rsrc_id = ?';
    $prices = $db->GetRow($query,array($rsrcid));
    if( $prices )
      {
	$rsrc['prices'] = $prices;
      }

    //
    // Give it to smarty
    //
    $smarty->assign('rsrc',$rsrc);
    $smarty->assign('file_location',$desturl);
  }

// We're done
echo $this->ProcessTemplateFromDatabase($thetemplate);
#
# EOF
#
?>