<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

// The top nav bar
if( $this->CheckPermission('Modify Templates') ||
    $this->CheckPermission(AVAILABILITY_PERM_EVENTS) ||
    $this->CheckPermission('Modify Site Preferences') ||
    ($this->HaveResources() && $this->CanEditReservations()) )
  {
    echo '<div class="pageoverflow" style="text-align: right; width: 80%;">';
    if( $this->CheckPermission(AVAILABILITY_PERM_EVENTS) ||
	$this->CheckPermission('Modify Site Preferences') )
      {
	echo $this->CreateImageLink($id,'admin_settings',$returnid,
				    $this->Lang('lbl_settings'),
				    'icons/topfiles/preferences.gif',array(),'','',false);
      }
    if( $this->CheckPermission('Modify Templates') )
      {
	echo $this->CreateImageLink($id,'admin_templates',$returnid,
				    $this->Lang('lbl_templates'),
				    'icons/topfiles/template.gif',array(),'','',false);
      }
    if( $this->HaveResources() && $this->CanEditReservations() )
      {
	echo $this->CreateImageLink($id,'admin_edit_resvn',$returnid,
				    $this->Lang('add_reservation'),
				    'icons/system/newobject.gif',array(),'','',false);
      }
    echo '</div><br/>';
  }

echo $this->StartTabHeaders();
if( $this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS) ||
    $this->CheckPermission(AVAILABILITY_PERM_VIEWRESV))
  {
    echo $this->SetTabHeader('calendar',
           $this->Lang('lbl_calendar').'&nbsp;'.
			     $this->DisplayImage('calendar.png'));
    echo $this->SetTabHeader('reservations',
	   $this->Lang('lbl_reservations').'&nbsp;'.
			     $this->DisplayImage('clock.png'));
  }
if( $this->CheckPermission(AVAILABILITY_PERM_RESOURCES) )
  {
    echo $this->SetTabHeader('resources',
	  $this->GetResourceType(true).'&nbsp;'.$this->DisplayImage('package.png'));
  }
if( $this->CheckPermission(AVAILABILITY_PERM_EVENTS) )
  {
    echo $this->SetTabHeader('events',
	  $this->Lang('lbl_events').'&nbsp;'.$this->DisplayImage('flag_green.png'));
  }
echo $this->EndTabHeaders();

// The content of the tabs
echo $this->StartTabContent();
if( $this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS) ||
    $this->CheckPermission(AVAILABILITY_PERM_VIEWRESV))
  {
    echo $this->StartTab('calendar',$params);
    include(dirname(__FILE__).'/function.admin_calendar_tab.php');
    echo $this->EndTab();

    echo $this->StartTab('reservations',$params);
    include(dirname(__FILE__).'/function.admin_reservations_tab.php');
    echo $this->EndTab();
  }
if( $this->CheckPermission(AVAILABILITY_PERM_RESOURCES) )
  {
    echo $this->StartTab('resources',$params);
    include(dirname(__FILE__).'/function.admin_resources_tab.php');
    echo $this->EndTab();
  }
if( $this->CheckPermission(AVAILABILITY_PERM_EVENTS) )
  {
    echo $this->StartTab('events',$params);
    include(dirname(__FILE__).'/function.admin_events_tab.php');
    echo $this->EndTab();
  }
echo $this->EndTabContent();

#
# EOF
#
?>