<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//////////////////////////////
//  Resource Summary View   //
//////////////////////////////

//
// Parameters:
// category=csv list of category names
// pagelimit=number of rooms on a page
// sortby=name,price
// sortorder=desc,asc
// pagenum
// showall=1
// summarytemplate=blah
//

//
// Initialization
//
$attribute='';
$data_attributes = '';
$pagelimit=25;
$sortby='sorting';
$sortorder='ASC';
$sortfield = '';
$startelement = 0;
$pagenum=1;
$showall=0;
$thetemplate = 'summary_'.$this->GetPreference(AVAILABILITY_PREF_DFLTSUMMARY_TEMPLATE);
$detailparams = array();
$specify = '';

//
// Handle Input Parameters
//
$error = '';
if( isset($params['avail_specify']) )
  {
    $specify = trim($params['avail_specify']);
  }
if( isset($params['attribute']) )
{
  $attribute = trim($params['attribute']);
  // can be a comma separated list
  // gotta get back the ID's.
  $data_attributes = $this->GetAttributeIDs($attribute);
}
if( isset($params['pagelimit']) )
{
  $pagelimit = (int)$params['pagelimit'];
  $pagelimit = max(1,$pagelimit);
  $pagelimit = min(1000,$pagelimit);
}
if( isset($params['showall']) )
{
  $showall = 1;
}
if( isset($params['pagenum']) )
{
  $pagenum = (int)$params['pagenum'];
  $pagenum = max(1,$pagenum);
  $startelement = ($pagenum-1) * $pagelimit;
}
if( isset($params['sortby']) )
{
  $tmp = trim(strtolower($params['sortby']));
  switch( $tmp )
    {
    case 'name':
    case 'price':
    case 'sorting':
      $sortby = $tmp;
      break;

    default:
      if( startswith($tmp,'f:') )
	{
	  $tmp2 = substr($tmp,2);
	  $sql = 'SELECT id FROM '.AVAILABILITY_TABLE_FIELDDEFS.'
                   WHERE name = ?';
	  $sortfield = $db->GetOne($sql,array($tmp2));
	  $sortby = 'fv.value';
	}
      else
	{
	  $error = $this->Lang('error_invalid_value');
	}
      break;
    }
}

if( isset($params['sortorder']) )
{
  switch( strtoupper($params['sortorder']) )
    {
    case 'ASC':
    case 'DESC':
      $sortorder = strtoupper($params['sortorder']);
      break;
    default:
      $error = $this->Lang('error_invalid_value');
    }
}
$detailpage = $returnid;
if( isset($params['detailpage']) )
  {
    $manager =& $gCms->GetHierarchyManager();
    $node =& $manager->sureGetNodeByAlias($params['detailpage']);
    if (isset($node))
      {
	$content =& $node->GetContent();	
	if (isset($content))
	  {
	    $detailpage = $content->Id();
	  }
      }
    else
      {
	$node =& $manager->sureGetNodeById($params['detailpage']);
	if (isset($node))
	  {
	    $detailpage = $params['detailpage'];
	  }
      }
  }
if( isset($params['detailtemplate']) )
  {
    $detailparams['detailtemplate'] = $params['detailtemplate'];
  }
if( isset($params['summarytemplate']) )
  {
    $thetemplate = 'summary_'.trim($params['summarytemplate']);
  }

//
// Build the queries
//
$where = array();
$joins = array();
$qparms = array();
$queryc = 'SELECT count(rs.id) AS count FROM '.AVAILABILITY_TABLE_RSRCS.' rs';
$query1 = 'SELECT rs.* FROM '.AVAILABILITY_TABLE_RSRCS.' rs';
if( !empty($specify) )
  {
    $where[] = 'rs.id IN ('.$specify.')';
  }
if( !empty($sortfield) )
  {
    $joins[] = 'LEFT JOIN '.AVAILABILITY_TABLE_FIELDVALS.' fv
                  ON fv.rsrc_id = rs.id';
    $where[] = 'fv.fielddef_id = ?';
    $qparms[] = $sortfield;
  }
if( is_array($data_attributes) && count($data_attributes) )
{
  $joins[] = 'LEFT JOIN '.AVAILABILITY_TABLE_RSRCS_CATS.' rc
                ON rs.id = rc.rsrc_id';
  $where[] = 'rc.category_id IN ('.implode(',',$data_attributes).')';
}

// Final assembly
if( count($joins) )
{
  foreach( $joins as $one )
    {
      $queryc .= ' '.$one;
      $query1 .= ' '.$one;
    }
}
if( count($where) )
{
  $queryc .= ' WHERE '.implode(' AND ',$where);
  $query1 .= ' WHERE '.implode(' AND ',$where);
}
$query1 .= " ORDER BY $sortby $sortorder";


//
// Get The Count of records
//
$totalcount = $db->GetOne($queryc,$qparms);

//
// Setup Pagination
//
$pagecount = (int)($totalcount / $pagelimit);
if( ($totalcount % $pagelimit) > 0 )
  {
    $pagecount++;
  }


//
// And get the data
//
$dbr = $db->SelectLimit($query1,$pagelimit,$startelement,$qparms);
if( $dbr )
  {
    $data = array();
    while( $dbr && $row = $dbr->FetchRow() )
      {
	// Get the row
	$row['file_location'] = $config['uploads_url'].'/'.$this->GetName().'/resources_'.$row['id'];
	$row['attribs'] = $this->GetAttributesForRsrc($row['id']);
	$row['attribs_byname'] = cge_array::to_hash($row['attribs'],'name');
	{
	  $tmp = $this->GetFieldsForRsrc($row['id']);
	  $row['fields'] = cge_array::to_hash($tmp,'name');
	}
	$row['fields_byname'] = cge_array::to_hash($row['fields'],'name');
	$row['detail_url'] = $this->GetResourceDetailURL($id,$detailpage,$row['id'],$row['name'],$detailparams);

	$data[] = $row;
      }

    if( count($data) )
      {
	$smarty->assign('rsrcs',$data);
      }
  }


//
// Pagination Links and Data
//
$smarty->assign('pagecount',$pagecount);
$smarty->assign('pagenum',$pagenum);
if( $pagenum > 1 )
  {
    $params['pagenum'] = 1;
    $smarty->assign('firstpage_url',
		    $this->CreateURL($id,'default',$returnid,$params));
    $params['pagenum'] = $pagenum - 1;
    $smarty->assign('prevpage_url',
		    $this->CreateURL($id,'default',$returnid,$params));
  }
if( $pagenum < $pagecount )
  {
    $params['pagenum'] = $pagecount;
    $smarty->assign('lastpage_url',
		    $this->CreateURL($id,'default',$returnid,$params));
    $params['pagenum'] = $pagenum+1;
    $smarty->assign('nextpage_url',
		    $this->CreateURL($id,'default',$returnid,$params));
  }


//
// Process Template
//
echo $this->ProcessTemplateFromDatabase($thetemplate);

#
# EOF
#
?>
