<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

if( !isset($params['year']) || !isset($params['month']) || !isset($params['day']) )
  {
    return;
  }

///////////////
//  Day View //
///////////////

//
// Setup
//
$config = $gCms->GetConfig();
$rsrcid = -1;
$checkin_time = $this->GetPreference('checkin_time','14:00');
list($hours,$minutes) = explode(':',$checkin_time,2);
$minutes += 15;
$the_resource = '';

//
// Parameters
// day = the day
// month = the month
// year = the year
// rsrcid (optional) = the resource id
// daytemplate (optional) = the day view template to use
//
$thetemplate = 'day_'.$this->GetPreference(AVAILABILITY_PREF_DFLTDAY_TEMPLATE);
if( isset($params['daytemplate']) )
  {
    $thetemplate = 'day_'.trim($params['daytemplate']);
  }
$year = (int)$params['year'];
$month = (int)$params['month'];
$day = (int)$params['day'];
if( isset($params['rsrcid']) )
  {
    $rsrcid = (int)$params['rsrcid'];
  }


//
// Calculations
//
$dbdate_ut = mktime($hours,$minutes,0,$month,$day,$year);
$dbdate = $db->DbTimeStamp($dbdate_ut);


//
// Get the data
//
if( $rsrcid > 0 )
  {
    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE active = 1 AND id = ?';
    $rsrc = $db->GetRow($query,array($rsrcid));

    if( !is_array( $rsrc ) )
      {
	return;
      }

    {
      $tmp = $this->GetFieldsForRsrc($rsrcid);
      if( $tmp )
	{
	  $tmp2 = cge_array::to_hash($tmp,'name');
	  $rsrc['fields'] = $tmp2;
	}
      $tmp = $this->GetAttributesForRsrc($rsrcid);
      if( $tmp )
	{
	  $rsrc['attribs'] = $tmp;
	}
      $rsrc['file_location'] = $config['uploads_url'].'/'.$this->GetName().'/resources_'.$rsrcid;
      
      $the_resource = $rsrc;
    }
  }


$qparms = array();
$query = 'SELECT E.*,ET.* FROM '.AVAILABILITY_TABLE_EVENTS.' E
            LEFT JOIN '.AVAILABILITY_TABLE_EVENT_TYPES.' ET
              ON E.event_type_id = ET.id';
if( $rsrcid > 0 )
  {
    $query .= ' LEFT JOIN '.AVAILABILITY_TABLE_RSRC_EVENTS.' RE
                 ON E.id = RE.event_id';
  }
$query .= " WHERE (E.start_date < $dbdate AND E.end_date > $dbdate)
              AND E.bookable = 1";
if( $rsrcid > 0 )
  {
    $query .= ' AND RE.rsrc_id = ?';
    $qparms[] = $rsrcid;
  }
$data = $db->GetArray($query,$qparms);
if( count($data) )
  {
    $smarty->assign('events',$data);
  }


//SELECT RS.* FROM cms_module_availability_rsrcs RS WHERE RS.id IN (SELECT DISTINCT RP.rsrc_id FROM cms_module_availability_reservations R LEFT JOIN cms_module_availability_reservation_parts RP ON R.id = RP.resv_id WHERE (R.start_date < '2009-04-08 14:15:00' AND R.end_date > '2009-04-08 14:15:00'));


// Get the list of free resources for this day
$qparms = array();
$query = 'SELECT RS.* FROM '.AVAILABILITY_TABLE_RSRCS.' RS 
           WHERE RS.active = 1
             AND RS.id NOT IN (SELECT DISTINCT RP.rsrc_id FROM '.AVAILABILITY_TABLE_RESERVATIONS.' R
                                 LEFT JOIN '.AVAILABILITY_TABLE_RESERVATION_PARTS." RP
                                   ON R.id = RP.resv_id 
                                WHERE R.status = 'confirmed'
                                  AND (R.start_date < $dbdate AND R.end_date > $dbdate))";
$data = $db->GetArray($query,$qparms);
if( count($data) )
  {
    // thse resources are not booked
    for( $i = 0; $i < count($data); $i++ )
      {
	$rsrc =& $data[$i];
	$the_rsrcid = $rsrc['id'];

	$tmp = $this->GetFieldsForRsrc($the_rsrcid);
	if( $tmp )
	  {
	    $tmp2 = cge_array::to_hash($tmp,'name');
	    $rsrc['fields'] = $tmp2;
	  }
	$tmp = $this->GetAttributesForRsrc($the_rsrcid);
	if( $tmp )
	  {
	    $rsrc['attribs'] = $tmp;
	  }
	$rsrc['file_location'] = $config['uploads_url'].'/'.$this->GetName().'/resources_'.$the_rsrcid;
      }

    $data = cge_array::to_hash($data,'id');
    $smarty->assign('resources',$data);
  }

# a) get the events in effect for this date
# a.1) for this resource?
# if rsrcid is empty
#   get the free rooms
# else
#   get the status of this room

//
// Give the data to smarty
//
$smarty->assign('the_date',$dbdate_ut);
if( $rsrcid > 0 )
  {
    $smarty->assign('the_resource',$the_resource);
    $smarty->assign('rsrcid',$rsrcid);
  }

//
// Process the template
//
echo $this->ProcessTemplateFromDatabase($thetemplate);

#
# EOF
#
?>