<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

/////////////////////////////////
//  Confirm Reservation Report //
/////////////////////////////////

//
// Initialization
//
if( !isset($params['resv_id']) )
  {
    // missing parameter
    return;
  }
$resv_id = (int)$params['resv_id'];
$feu = $this->GetModuleInstance('FrontEndUsers');
if( !$feu ) return; // could not find feu
$custid = $feu->LoggedInId();
if( $custid <= 0 ) 
  {
    $page = $this->GetPreference('page_redirect_notloggedin',-1);
    if( $page != -1 )
      {
	$this->RedirectContent($page);
      }
    else
      {
	// gotta display a message
	// and exit
	echo $this->DisplayErrorMessage($this->Lang('error_notloggedin_feu'));
	return;
      }
  }
$thetemplate = 'resvncfm_'.$this->GetPreference(AVAILABILITY_PREF_DFLTRESVNCONFIRM_TEMPLATE);
if( isset($params['confirmtemplate']) )
  {
    $thetemplate = 'resvncfm_'.trim($params['confirmtemplate']);
  }


//
// Setup
//

//
// Get Data
//
$reservation = reservation_ops::load_by_id($resv_id);
$array_data = reservation_ops::to_array($reservation);
$userobj =& $this->GetUserObject($custid);
if( $reservation->get_customer_id() != $custid )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_permission'));
    return;
  }
$query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS;
$tmp = $db->GetArray($query);
$array_data['resources'] = cge_array::to_hash($tmp,'id');

//
// Give data to smarty
//
$smarty->assign('userinfo',$userobj);
$smarty->assign('resvn_obj',$reservation);
$smarty->assign('reservation',$array_data);

//
// Display the template
//
echo $this->ProcessTemplateFromDatabase($thetemplate);

#
# EOF
#
?>