<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

///////////////////////////////////
//  Availability Calendar View   //
///////////////////////////////////

//
// functions
//
function is_leapyear($year)
{
  $f = 0;
  if( $year % 4 == 0 ) $f = 1;
  if( $year % 100 == 0 ) $f == 0;
  if( $year % 400 == 0 ) $f = 1;
  return $f;
}

function get_array_pos($haystack,$needle)
{
  for( $i = 0; $i < count($haystack); $i++ )
    {
      if( $haystack[$i] == $needle ) return $i;
    }
  return FALSE;
}


//
// Initialization
//
$sortby = 'sorting';
$sortorder=  'ASC';
$sortfield = '';
$thetemplate = 'calendar_'.$this->GetPreference(AVAILABILITY_PREF_DFLTCALENDAR_TEMPLATE);
$category='';
$resources='';
$sel_etypes = array();
$sel_resources = array();
$sel_categories = array();
$days_in_month = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
$this_day = (int)(strftime("%d",time()));
$this_month = (int)(strftime("%m",time()));
$this_year = intval(strftime("%Y",time()));
$the_month = $this_month;
$the_day = $this_day;
$the_year = $this_year;
$vacantobj = new StdClass();
$vacantobj->status = 'vacant';
$vacantobj->fg = '#000'; // todo
$vacantobj->bg = #fff'; // todo
$vacantobj->label = $this->Lang('vacant');
$reservedobj = new StdClass();
$reservedobj->status = 'reserved';
$reservedobj->fg = $this->GetPreference('resvn_foreground');
$reservedobj->bg = $this->GetPreference('resvn_background');
$reservedobj->label = $this->Lang('reserved');
$legend = array();
$legend[$this->Lang('vacant')] = $vacantobj;
$legend[$this->Lang('reserved')] = $reservedobj;
$grid = '';
$detailparams = array();

//
// Parameters
// category         = csv list of category names
// resources        = csv list of resources
// month            = month to display
// year             = year to display
// detailpage       = page for detail views
// calendartemplate = name of category templateo
//
$detailpage = $returnid;
if( isset($params['detailpage']) )
  {
    $manager =& $gCms->GetHierarchyManager();
    $node =& $manager->sureGetNodeByAlias($params['detailpage']);
    if (isset($node))
      {
	$content =& $node->GetContent();	
	if (isset($content))
	  {
	    $detailpage = $content->Id();
	  }
      }
    else
      {
	$node =& $manager->sureGetNodeById($params['detailpage']);
	if (isset($node))
	  {
	    $detailpage = $params['detailpage'];
	  }
      }
  }
if( isset($params['detailtemplate']) )
  {
    $detailparams['detailtemplate'] = $params['detailtemplate'];
  }
if( isset($params['calendartemplate']) )
  {
    $thetemplate = 'calendar_'.trim($params['calendartemplate']);
  }
if( isset($params['category']) )
  {
    $category=trim($params['category']);
  }
else if( isset($params['resources']) )
  {
    $resources=trim($params['resources']);
  }
if( isset($params['year']) )
  {
    $the_year = (int)$params['year'];
  }
if( isset($params['month']) )
  {
    $the_month = (int)$params['month'];
    if( $the_month <= 0 )
      {
	$the_month = 12;
	$the_year--;
      }
    else if ($the_month > 12)
      {
	$the_month = 1;
	$the_year++;
      }
  }
if( isset($params['sortby']) )
  {
    $tmp = trim(strtolower($params['sortby']));
    switch( $tmp )
      {
      case 'name':
      case 'price':
      case 'sorting':
	$sortby = $tmp;
	break;

      default:
        $tmp2 = substr($tmp,2);
	$sql = 'SELECT id FROM '.AVAILABILITY_TABLE_FIELDDEFS.'
                   WHERE name = ?';
	$sortfield = $db->GetOne($sql,array($tmp2));
	if( $sortfield )
	  {
	    $sortby = 'fv.value';
	  }
      }
  }

//
// Setup
//
if( is_leapyear($the_year) )
  {
    $days_in_month[1]++;
  }
$dispdate = mktime(0,0,0,$the_month,1,$the_year);
$month_start_u = mktime(0,0,0,$the_month,1,$the_year);
$month_end_u = mktime(23,59,0,$the_month,$days_in_month[$the_month-1],$the_year);
$month_start_day = $db->DbTimeStamp($month_start_u);
$month_end_day = $db->DbTimeStamp($month_end_u);
if( !empty($category) )
  {
    $query = 'SELECT id FROM '.AVAILABILITY_TABLE_CATS.'
             WHERE name IN (';
    $query .= explode(',',$category).')';
    $tmp = $db->GetArray($query);
    $sel_categories = cge_array::extract_field($tmp,'id');
  }
if( !empty($resources) )
  {
    $sel_resources = explode(',',$resources);
  }


//
// Build a grid from selected data
// Grid is resources across the top
// Days along the bottom.
// The 0 values is the column and row header
// 
//
$where = array();
$joins = array();
$parms = array();
$query = 'SELECT r.id,r.name,r.res_interval,r.starttime1,r.endtime1,r.starttime2,r.endtime2 
            FROM '.AVAILABILITY_TABLE_RSRCS.' r';
$where[] = 'r.active = 1';
if( $sortfield != '' )
  {
    $joins[] = AVAILABILITY_TABLE_FIELDVALS." fv ON fv.rsrc_id = r.id AND fv.fielddef_id = ?";;
    $parms[] = $sortfield;
  }
if( count($sel_categories) )
  {
    $joins[] = AVAIABILITY_TABLE_RSRC_CATS.' rc ON r.id = rc.rsrc_id';
    $where[] = 'B.category_id IN ('.implode(',',$sel_categories).')';
  }
else if( count($sel_resources) )
  {
    $where[] = 'r.id IN ('.implode(',',$sel_resources).')';
  }

// assemble the query
if( count($joins) )
  {
    $query .= ' LEFT JOIN '.implode(' LEFT JOIN ',$joins);
  }
if( count($where) )
  {
    $query .= ' WHERE '.implode(' AND ',$where);
  }
$query .= " ORDER BY $sortby $sortorder";

$rsrcs = '';
$rsrcs_index = '';
{
  $tmp = $db->GetArray($query,$parms);
  if( $tmp ) 
    {
      // calculate the number of slots for each resource
      for( $i = 0; $i < count($tmp); $i++ )
	{
	  $tmp2 =& $tmp[$i];
	  switch($tmp2['res_interval'])
	    {
	    case 'daily':
	      $tmp2['ext_numslots'] = 1;
	      break;
	    case 'half_day':
	      $tmp2['ext_numslots'] = 2;
	      break;
	    case 'hourly':
	      $nslots = (int)((strtotime($tmp2['endtime1']) - strtotime($tmp2['starttime1'])) / 3600);
	      $nslots += (int)((strtotime($tmp2['endtime2']) - strtotime($tmp2['starttime2'])) / 3600);
	      $tmp2['ext_numslots'] = $nslots;
	      break;
	    }
	}
      $rsrcs = cge_array::to_hash($tmp,'id');
      $rsrcs_index = array_keys($rsrcs);
    }
}

if( is_array($rsrcs) && count($rsrcs) )
  {
    $grid = array_fill(0,$days_in_month[$the_month-1],array_fill(0,count($rsrcs)+1,'&nbsp;'));

    //
    // fill the grid labels
    // top row
    $grid[0][0] = $dispdate;
    for( $r = 0; $r < count($rsrcs); $r++ )
      {
	$rid = $rsrcs_index[$r];
	$obj = new StdClass();
	$obj->url = $this->GetResourceDetailURL($id,$detailpage,
						$rsrcs[$rid]['id'],
						$rsrcs[$rid]['name'],$detailparams);
	$obj->label = $rsrcs[$rid]['name'];
	$obj->id = $rsrcs[$rid]['id'];
	$grid[0][$r+1] = $obj;
      }
    // columns
    for( $d = 1; $d <= $days_in_month[$the_month-1]; $d++ )
      {
	// todo, possible day view link here.
	$obj = new StdClass();
	$obj->url = $this->GetDayViewURL($id,$detailpage,$the_month,$d,$the_year);
	$obj->time = mktime(0,0,0,$the_month,$d,$the_year);
	$obj->label = $d;
	$grid[$d][0] = $obj;
      }
    
    //
    // Fill the grid values with vacancies
    //
    $statistics['total'] =  (count($grid)-1)*(count($grid[0])-1);
    for( $r = 0; $r < count($rsrcs); $r++ )
      {
	$rid = $rsrcs_index[$r];
	for( $d = 1; $d <= $days_in_month[$the_month-1]; $d++ )
	  {
	    $obj = clone $vacantobj;
	    $obj->url = $this->GetReservationURL($id,$returnid,$rsrcs[$rid]['id'],$the_month,$d,$the_year);
	    $grid[$d][$r+1] = $obj;
	  }
      }
    
    //
    // Fill the appriate grid values with event information
    //
    $eventtypes = array();
    {
      $query = 'SELECT * FROM '.AVAILABILITY_TABLE_EVENT_TYPES;
      $tmp = $db->GetArray($query);
      $eventtypes = cge_array::to_hash( $tmp, 'id' );
    }
    $events = '';
    {
      $query = 'SELECT A.* FROM '.AVAILABILITY_TABLE_EVENTS." A
             LEFT JOIN ".AVAILABILITY_TABLE_EVENT_TYPES." B
             ON A.event_type_id = B.id
             WHERE    (A.start_date BETWEEN $month_start_day AND $month_end_day)
                   OR (A.end_date BETWEEN $month_start_day AND $month_end_day)
                   OR (A.start_date <= $month_start_day AND A.end_date >= $month_end_day)";
      if( count($sel_etypes) )
	{
	  $query .= ' AND A.event_type_id IN ('.implode(',',$sel_etypes).')';
	}
      $query .= " ORDER BY A.bookable DESC, B.iorder ASC";
      $events = $db->GetArray($query);
      $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRC_EVENTS.'
                 WHERE event_id = ?';
      for( $i = 0; $i < count($events); $i++ )
	{
	  $tmp = $db->GetArray($query,array($events[$i]['id']));
	  if( $tmp )
	    {
	      $events[$i]['rsrcs'] = $tmp;
	    }
	}
    }
    if( is_array($events) && count($events) )
      {
	foreach( $events as $one )
	  {
	    $resv_start_u = $db->UnixTimeStamp($one['start_date']);
	    $resv_end_u = $db->UnixTimeStamp($one['end_date']);
	    $rstart_u = max($resv_start_u,$month_start_u);
	    $rend_u = min($resv_end_u,$month_end_u);
	    
	    $sday = intval(strftime("%d",$rstart_u));
	    $eday = intval(strftime("%d",$rend_u));
	    
	    $etype =& $eventtypes[$one['event_type_id']];
	    
	    $obj = new StdClass();
	    $obj->fg = $etype['color'];
	    $obj->bg = $etype['background'];
	    if( $one['bookable'] )
	      {
		$obj->status = 'event';
	      }
	    else
	      {
		$obj->status = 'closed';
	      }
	    $legend[$one['name']] = $obj;

	    // todo, possible link to view event.
	    $obj->label = $one['name'];
	    if( isset($one['rsrcs']) && count($one['rsrcs']) )
	      {
		for( $d = $sday; $d <= $eday; $d++ )
		  {
		    for( $r = 0; $r < count($one['rsrcs']); $r++ )
		      {
			$tmp_rid = $one['rsrcs'][$r]['rsrc_id'];
			$tmp_idx = get_array_pos($rsrcs_index,$tmp_rid);
			if( isset($rsrcs_index[$tmp_idx]) )
			  {
			    $grid[$d][$tmp_idx+1] = $obj;
			  }
		      }
		  }
	      } 
	  }
      }
    unset($events);


    //
    // Fill the grid values with reservation information
    //
    
    $resvn = '';
    {
      $query = 'SELECT DISTINCT resv_id FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS."
                 WHERE (start_date BETWEEN $month_start_day AND $month_end_day) 
                    OR (end_date BETWEEN $month_start_day AND $month_end_day)
                 ORDER BY resv_id ASC";
      $tmp = $db->GetArray($query);
      $rids = cge_array::extract_field($tmp,'resv_id');

      if( $rids )
	{
	  $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATIONS.'
                     WHERE id IN ('.implode(',',$rids).')';
	  $tmp = $db->GetArray($query);
	  $resvn = cge_array::to_hash($tmp,'id');

          $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
                     WHERE resv_id IN ('.implode(',',$rids).')
                     ORDER BY resv_id,start_date ASC';
	  $tmp = $db->GetArray($query);

	  for( $i = 0; $i < count($tmp); $i++ )
	    {
	      $part =& $tmp[$i];
	      $trid = $part['resv_id'];
	      if( !isset($resvn[$trid]['parts']) )
		{
		  $resvn[$trid]['parts'] = array();
		}
	      $resvn[$trid]['parts'][] = $part;
	    }
	}
    }

    if( is_array($resvn) && count($resvn) )
      {
	for( $res = 0; $res < count($resvn); $res++ )
	  {
	    $oneres =& $resvn[$res];

	    // don't display cancelled reservations
	    if( $oneres['status'] == 'cancelled' ) continue;

	    for( $pnum = 0; $pnum < count($oneres['parts']); $pnum++ )
	      {
		$onepart =& $oneres['parts'][$pnum];
		if( !isset($rsrcs[$onepart['rsrc_id']]) ) continue;
		$the_resource =& $rsrcs[$onepart['rsrc_id']];
		$ridx = get_array_pos($rsrcs_index,$onepart['rsrc_id'])+1; 

		$resv_start_u = $db->UnixTimeStamp($onepart['start_date']);
		$resv_end_u = $db->UnixTimeStamp($onepart['end_date']);
		$rstart_u = max($resv_start_u,$month_start_u);
		$rend_u = min($resv_end_u,$month_end_u);
	    
		$sday = intval(strftime("%d",$rstart_u));
		$eday = intval(strftime("%d",$rend_u));
		if( $eday == $days_in_month[$the_month-1] && $resv_end_u > $month_end_u )
		  {
		    // hack
		    $eday++;
		  }

		if( $the_resource['res_interval'] != 'daily' )
		  {
		    $d = $sday;

		    if( isset($grid[$d][$ridx]) && 
			is_object($grid[$d][$ridx]) &&
			($grid[$d][$ridx]->status == 'vacant' || $grid[$d][$ridx]->status == 'partial'))
		      {
			$obj =& $grid[$d][$ridx];
			if( !isset($obj->numparts) )
			  {
			    $obj->numparts = 1;
			  }
			else
			  {
			    $obj->numparts++;
			  }
			$obj->status = 'partial';
// 			$obj->url = $this->GetDayViewURL($id,$detailpage,$the_month,$d,$the_year,
// 							 array('rsrcid'=>$oneres['id']));
			$obj->label = $this->Lang('partially_reserved_lbl',$obj->numparts,$the_resource['ext_numslots']);
			$obj->fg ='black'; // todo
			$obj->bg = 'cyan'; // todo

			$grid[$d][$ridx] = $obj;
		      }
		    else
		      {
			// conflict of some type
			$grid[$d][$ridx]->status = 'conflict';
			$grid[$d][$ridx]->label = $this->Lang('conflict');
			$grid[$d][$ridx]->title = $this->Lang('title_conflict2');
			$grid[$d][$ridx]->fg = $this->GetPreference('conflict_foreground');
			$grid[$d][$ridx]->bg = $this->GetPreference('conflict_background');
		      }

		    // handle hourly or half day parts.
		    continue;
		  }

		// handle full day reservation parts.
		$obj = new StdClass();
		$obj->resv = $oneres['id'];
		$obj->fg = $this->GetPreference('resvn_foreground');
		$obj->bg = $this->GetPreference('resvn_background');
		$obj->status = 'reserved';
		$obj->label = $this->Lang('reserved');
	    
		for( $d = $sday; $d < $eday; $d++ )
		  {
		    if( isset($grid[$d][$ridx]) && 
			is_object($grid[$d][$ridx]) &&
			(isset($grid[$d][$ridx]->resv) && ($grid[$d][$ridx]->resv != $oneres['id'])) &&
			($grid[$d][$ridx]->status == 'pending' || $grid[$d][$ridx]->status == 'reserved' ||
			 $grid[$d][$ridx]->status == 'closed') )
		      {
			// oops, already a reservation for this day
			// now we gotta think about something...
			$grid[$d][$ridx]->status = 'conflict';
			$grid[$d][$ridx]->label = $this->Lang('conflict');
			$grid[$d][$ridx]->title = $this->Lang('title_conflict',$grid[$d][$ridx]->resv,$oneres['id']);
			$grid[$d][$ridx]->fg = $this->GetPreference('conflict_foreground');
			$grid[$d][$ridx]->bg = $this->GetPreference('conflict_background');
		      }
		    else
		      {
			$grid[$d][$ridx] = $obj;
		      }
		  } // for each day of the reservatio
	      } // for each part
	  } // for each reservation
      } // if there are reservations.
    unset($resvn);
  } // if there are resources


//
// Give data to smarty
//
if( is_array($grid) )
  {
    $smarty->assign('grid',$grid);
    $smarty->assign('legend',$legend);
  }
$smarty->assign('the_month',$the_month-1);
$smarty->assign('the_year',$the_year);
$smarty->assign('dispdate',$dispdate);

$parms = $params;
$parms['month'] = $the_month - 1;
$parms['year'] = $the_year;
$smarty->assign('prevmonth_url',
		$this->CreateURL($id,'calendar',$returnid,$parms));
$parms['month'] = $the_month + 1;
$parms['year'] = $the_year;
$smarty->assign('nextmonth_url',
		$this->CreateURL($id,'calendar',$returnid,$parms));

// 
// Display the page
//
echo $this->ProcessTemplateFromDatabase($thetemplate);

#
# EOF
#
?>