<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') )
  {
    die('permission denied');
  }

$starttime_1 = mktime($params['starttime1_Hour'],$params['starttime1_Minute'],0);
$endtime_1 = mktime($params['endtime1_Hour'],$params['endtime1_Minute'],0);
$starttime_2 = mktime($params['starttime2_Hour'],$params['starttime2_Minute'],0);
$endtime_2 = mktime($params['endtime2_Hour'],$params['endtime2_Minute'],0);
if( ($starttime_1 >= $starttime_2) || ($endtime_1 >= $endtime_2) ||
    ($starttime_1 >= $endtime_1) || ($startime_2 >= $endtime_2) )
  {
    $this->SetError($this->Lang('error_invalid_time_settings'));
    $this->RedirectToTab($id,'preferences','','admin_settings');
  }

$starttime_1 = sprintf('%02d:%02d',$params['starttime1_Hour'],$params['starttime1_Minute']);
$endtime_1 = sprintf('%02d:%02d',$params['endtime1_Hour'],$params['endtime1_Minute']);
$starttime_2 = sprintf('%02d:%02d',$params['starttime2_Hour'],$params['starttime2_Minute']);
$endtime_2 = sprintf('%02d:%02d',$params['endtime2_Hour'],$params['endtime2_Minute']);
$this->SetPreference('starttime_1',$starttime_1);
$this->SetPreference('endtime_1',$endtime_1);
$this->SetPreference('starttime_2',$starttime_2);
$this->SetPreference('endtime_2',$endtime_2);

$this->SetPreference('resource_type',trim($params['resource_type']));
$this->SetPreference('currency_symbol',trim($params['currency_symbol']));
$this->SetPreference('dflt_interval',trim($params['dflt_interval']));
$this->SetPreference('dflt_granularity',trim($params['dflt_granularity']));
$checkin_time = sprintf("%02d:%02d",$params['checkin_Hour'],$params['checkin_Minute']);
$this->SetPreference('checkin_time',$checkin_time);
$checkout_time = sprintf("%02d:%02d",$params['checkout_Hour'],$params['checkout_Minute']);
$this->SetPreference('checkout_time',$checkout_time);
$this->SetPreference('error_no_prices',(int)$params['error_no_prices']);

$this->SetPreference('image_types',trim($params['image_types']));
$this->SetPreference('auto_thumbnail',trim($params['auto_thumbnail']));
$this->SetPreference('file_types',trim($params['file_types']));
$this->SetPreference('customer_group',(int)$params['customer_group']);
$this->SetPreference('customer_display_template',trim($params['customer_display_template']));
$this->SetPreference('resvn_foreground',$params['resvn_foreground']);
$this->SetPreference('resvn_background',$params['resvn_background']);
$this->SetPreference('partial_foreground',$params['partial_foreground']);
$this->SetPreference('partial_background',$params['partial_background']);
$this->SetPreference('conflict_foreground',$params['conflict_foreground']);
$this->SetPreference('conflict_background',$params['conflict_background']);
$this->SetPreference('pending_foreground',$params['pending_foreground']);
$this->SetPreference('pending_background',$params['pending_background']);
$this->SetPreference('attachment_dir',$params['attachment_dir']);
$this->SetPreference('page_redirect_notloggedin',
		     $params['page_redirect_notloggedin']);
$this->SetPreference('reservation_confirm_page',
		     (int)$params['reservation_confirm_page']);
$this->SetPreference('reservation_confirm_msg',
		     (int)$params['reservation_confirm_msg']);
$this->SetPreference('reservation_confirm_email_flag',
		     $params['reservation_confirm_email_flag']);
$this->SetPreference('reservation_confirm_email_cc',
		     implode(',',$params['reservation_confirm_email_cc']));
$this->SetPreference('reservation_confirm_email_subject',
		     trim($params['reservation_confirm_email_subject']));
$this->SetPreference('reservation_confirm_email_attachment',
		     trim($params['reservation_confirm_email_attachment']));
$this->SetPreference('reservation_default_page',(int)$params['reservation_default_page']);

$this->SetPreference('reservation_require_deposit',(int)$params['reservation_require_deposit']);
$this->SetPreference('reservation_deposit_minimum',floatval($params['reservation_deposit_minimum']));
$this->SetPreference('reservation_deposit_percent',floatval($params['reservation_deposit_percent']));
$this->SetPreference('reservation_deposit_summary',trim($params['reservation_deposit_summary']));
$this->SetPreference('reservation_sku_prefix',trim($params['reservation_sku_prefix']));

$default_capacity = 50;
if( isset($params['default_capacity']) )
  $default_capacity = (int)$params['default_capacity'];
if( $default_capacity <= 0 )
  $default_capacity = 50;
$this->SetPreference('default_capacity',$default_capacity);
$this->SetPreference('admin_startyear',(int)$params['admin_startyear']);

$this->RedirectToTab($id,'preferences','','admin_settings');

#
# EOF
#
?>