<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

// The Settings panel
if( !$this->CheckPermission('Modify Site Preferences') &&
    !$this->CheckPermission(AVAILABILITY_PERM_EVENTS))
  {
    die('permission denied');
  }


echo '<div class="pageoverflow" style="text-align: right; width: 80%;">'.
$this->CreateImageLink($id,'defaultadmin',$returnid,
		       $this->Lang('lbl_back'),'icons/system/back.gif',array(),'','',false).'</div><br/>';
    
echo $this->StartTabHeaders();
if( $this->CheckPermission(AVAILABILITY_PERM_EVENTS) )
{
  echo $this->SetTabHeader('event_types',$this->Lang('lbl_event_types'));
}
if( $this->CheckPermission('Modify Site Preferences') )
{
  echo $this->SetTabHeader('categories',$this->GetResourceType().' '.$this->Lang('lbl_categories'));
  echo $this->SetTabHeader('custom_fields',$this->Lang('lbl_custom_fields'));
  echo $this->SetTabHeader('preferences',$this->Lang('lbl_preferences'));
}
echo $this->EndTabHeaders();

echo $this->StartTabContent();
if( $this->CheckPermission(AVAILABILITY_PERM_EVENTS) )
{
  echo $this->StartTab('event_types');
  include(dirname(__FILE__).'/function.admin_event_types_tab.php');
  echo $this->EndTab();
}
if( $this->CheckPermission('Modify Site Preferences') )
{
  echo $this->StartTab('categories');
  include(dirname(__FILE__).'/function.admin_categories_tab.php');
  echo $this->EndTab();

  echo $this->StartTab('custom_fields');
  include(dirname(__FILE__).'/function.admin_custom_fields_tab.php');
  echo $this->EndTab();

  echo $this->StartTab('preferences');
  include(dirname(__FILE__).'/function.admin_preferences_tab.php');
  echo $this->EndTab();
}

echo $this->EndTabContent();

#
# EOF
#
?>