<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(AVAILABILITY_PERM_RESOURCES) ) exit();
$this->SetCurrentTab('resources');

if( !isset($params['rsrcid']) ) 
  {
    die('error 1');
    $this->SetError($this->Lang('error_invalid_value'));
    $this->RedirectToTab($id);
  }
$rsrcid = (int)$params['rsrcid'];
if( !isset($params['dir']) ) 
  {
    die('error 2');
    $this->SetError($this->Lang('error_invalid_value'));
    $this->RedirectToTab($id);
  }
$dir = trim(strtolower($params['dir']));
if( $dir != 'up' && $dir != 'down' )
  {
    die('error 3');
    $this->SetError($this->Lang('error_invalid_value'));
    $this->RedirectToTab($id);
  }

$query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE id = ?';
$rsrc = $db->GetRow($query,array($rsrcid));
if( !is_array($rsrc) )
  {
    die('error 4');
    $this->SetError($this->Lang('error_invalid_value'));
    $this->RedirectToTab($id);
  }
$query = 'SELECT count(id) FROM '.AVAILABILITY_TABLE_RSRCS;
$total_rsrc = $db->Execute($query);

switch($dir)
  {
  case 'up':
    if( $rsrc['sorting'] < 2 )
      {
	$this->SetError($this->Lang('error_invalid_value'));
	$this->RedirectToTab($id);
      }
    $query = 'UPDATE '.AVAILABILITY_TABLE_RSRCS.' SET sorting=sorting+1 WHERE sorting=?';
    $dbr = $db->Execute($query,array($rsrc['sorting']-1));
    $query = 'UPDATE '.AVAILABILITY_TABLE_RSRCS.' SET sorting=sorting-1 WHERE id = ?';
    $dbr = $db->Execute($query,array($rsrcid));
    break;

  case 'down':
    if( $rsrc['sorting'] >= $total_rsrc )
      {
	$this->SetError($this->Lang('error_invalid_value'));
	$this->RedirectToTab($id);
      }
    $query = 'UPDATE '.AVAILABILITY_TABLE_RSRCS.' SET sorting=sorting-1 WHERE sorting=?';
    $db->Execute($query,array($rsrc['sorting']+1));
    $query = 'UPDATE '.AVAILABILITY_TABLE_RSRCS.' SET sorting=sorting+1 WHERE id = ?';
    $db->Execute($query,array($rsrcid));
    break;
  }

$this->RedirectToTab($id);
#
# EOF
#
?>