<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
$this->SetCurrentTab('reservations');

//
// Permissions check
//
if( !$this->CanContactCustomers() )
  {
    die('permission denied');
  }
if( !isset($params['resvnid']) )
  {
    echo $this->ShowErrors($this->Lang('error_missingparameter'));
    return;
  }

//
// Initialization
//
$resv_id = intval($params['resvnid']);


//
// Gather Data
//
$query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATIONS.'
           WHERE id = ?';
$resvn = $db->GetRow($query,array($resv_id));
if( !$resvn )
{
  echo $this->ShowErrors($this->Lang('error_notfound'));
  return;
}
{
  $query = 'SELECT rsrc_id FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
           WHERE resv_id = ?';
  $tmp = $db->GetArray($query,array($resv_id));
  $tmp2 = cge_array::extract_field($tmp,'rsrc_id');
  $query = 'SELECT name FROM '.AVAILABILITY_TABLE_RSRCS.'
             WHERE id IN ('.implode(',',$tmp2).')';
  $tmp3 = $db->GetArray($query);
  $resvn['rsrcs'] = cge_array::extract_field($tmp3,'name');
}
$userinfo = $this->GetUserDetails($resvn['customer_id']);


//
// Handle form data
//
if( isset($params['cancel']) )
{
  $this->RedirectToTab($id);
}
else if( isset($params['submit']) )
{
  //
  // Validate Data
  //
  $error = '';
  $subject = '';
  $template = '';
  $attachment = '';
  $body = '';
  if( isset($params['input_subject']) )
    {
      $subject = trim($params['input_subject']);
    }
  if( isset($params['input_body']) )
    {
      $body = trim($params['input_body']);
    }
  if( isset($params['input_template']) )
    {
      $template = trim($params['input_template']);
    }
  if( isset($params['input_file']) )
    {
      if( is_array($params['input_file']) )
	{
	  $attachment = implode('^^^',$params['input_file']);
	}
      else
	{
	  $attachment = trim($params['input_file']);
	}
    }
  if( empty($subject) || empty($body) )
    {
      $error = $this->Lang('error_missing_parameter');
    }
  else
    {
      // 
      // Build the Email
      //
      $smarty->assign('subject',$subject);
      $smarty->assign('body',$body);
      $message_body = $this->ProcessTemplateFromDatabase($template);

      // 
      // Send It
      //
      $cmsmailer =& $this->GetModuleInstance('CMSMailer');
      $cmsmailer->AddAddress($userinfo['email'],$userinfo['display']);
      $cmsmailer->IsHTML(true);
      $cmsmailer->SetSubject($subject);
      $cmsmailer->SetBody($message_body);
      if( !empty($attachment) )
	{
	  $files = explode('^^^',$attachment);
	  foreach($files as $file)
	    {
	      $fn = $this->GetPreference('attachment_dir').'/'.$file;
	      $cmsmailer->AddAttachment( $fn, $file );
	    }
	}
      $cmsmailer->Send();

      // 
      // Add it to the Notes
      //
      $now = $db->DbTimeStamp(time());
      $query = 'INSERT INTO '.AVAILABILITY_TABLE_RESERVATION_NOTES."
                  (resv_id, subject, text, create_date)
                VALUES (?,?,?,$now)";
      $dbr = $db->Execute($query,array($resv_id,$subject,$message_body));
      if( !$dbr ) 
        {
	  die($db->sql.'<br/>'.$db->ErrorMsg());
	}

      // Done
      $this->RedirectToTab($id);
    }

}


//
// Display Output
//
$query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATION_NOTES.'
           WHERE resv_id = ? ORDER BY create_date DESC';
$notes = $db->GetArray($query,array($resv_id));
if( is_array($notes) && count($notes) )
{
  $smarty->assign('notes',$notes);
}
$smarty->assign('resvn',$resvn);
$smarty->assign('userinfo',$userinfo);
$smarty->assign('resv_id',$resv_id);
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_mail_resvn',$returnid,$params,
                                                     false,'post','multipart/form-data'));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('input_body',$this->CreateTextArea(true,$id,'','input_body'));
$smarty->assign('input_file',$this->CreateFileDropdown($id,'input_file','',$this->GetPreference('attachment_dir'),'',1,true,5));
$smarty->assign('input_template',$this->CreateTemplateDropdown($id,'input_template','custemail_'));
echo $this->ProcessTemplate('admin_mail_resvn.tpl');


#
# EOF
#
?>