<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS) )
  {
    die('permission denied');
  }

//
// functions
//
function is_leapyear($year)
{
  $f = 0;
  if( $year % 4 == 0 ) $f = 1;
  if( $year % 100 == 0 ) $f == 0;
  if( $year % 400 == 0 ) $f = 1;
  return $f;
}


// 
// Initialization
//
$years = array();
$years[] = date('Y',time());
$years[] = -1;
$years[] = -1;
$days_in_month = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
$monthnames = explode('/',$this->Lang('monthlist_brief'));

//
// Process parameters
//
if( isset($params['year1']) )
  {
    $years[0] = (int)$params['year1'];
  }
if( isset($params['year2']) )
  {
    $years[1] = (int)$params['year2'];
  }
if( isset($params['year3']) )
  {
    $years[2] = (int)$params['year3'];
  }

//
// Setup
//
if( $years[1] == $years[0] ) $years[1] = -1;
if( $years[2] == $years[0] ) $years[2] = -1;
if( $years[2] == $years[1] ) $years[2] = -1;
$this->InitializeCharting();
$dataset = new pData;
// $dataset->AddPoint($data[0],$years[0]);
// $dataset->AddPoint($data[1],$years[1]);
// $dataset->AddPoint($data[2],$years[2]);


//
// Get Data
//
$query = 'SELECT start_date FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
           ORDER BY start_date ASC';
$tmp = $db->GetOne($query);
$first_year = date('Y',$db->UnixTimeStamp($tmp));

$query = 'SELECT start_date FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
           ORDER BY start_date DESC LIMIT 1';
$tmp = $db->GetOne($query);
$last_year = date('Y',$db->UnixTimeStamp($tmp));

$query = 'SELECT COUNT(id) FROM '.AVAILABILITY_TABLE_RSRCS;
$num_resources = $db->GetOne($query);

$data = array();
$query = 'SELECT COUNT(rsrc_id) AS count 
            FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
           WHERE (start_date BETWEEN %s AND %s) 
 	      OR (end_date BETWEEN %s AND %s)';
foreach( $years as $curyear )
{
  if( $curyear == -1 ) continue;

  $yeardata = array();
  for( $month = 1; $month <= 12; $month++ )
    {
      $numdays = $days_in_month[$month-1];
      if( $month == 2 && is_leapyear($curyear) ) $numdays++;

      $ut_start = mktime(0,0,0,$month,1,$curyear);
      $ut_end   = mktime(23,59,0,$month,$numdays,$curyear);
      $db_start = $db->DbTimeStamp($ut_start);
      $db_end = $db->DbTimeStamp($ut_end);
      $tmp = $db->GetOne(sprintf($query,$db_start,$db_end,$db_start,$db_end));
      if( $tmp > 0 )
	{
	  $val = $tmp / ($num_resources * $numdays) * 100;
	  $dataset->AddPoint($val,$curyear,$monthnames[$month-1]);
	}
      $yeardata[$month] = $tmp;
    }
  $data[] = $yeardata;
  $dataset->SetSerieName($curyear,$curyear);
}

$dataset->AddAllSeries();
$dataset->SetAbsciseLabelSerie();
$dataset->SetXAxisName('Month');
$dataset->SetYAxisName('% Reservations');
$dataset->SetYAxisUnit('%');

$chart = new pChart(700,250);
$dir = dirname(dirname(__FILE__)).'/CGExtensions/fonts';
$chart->setFontProperties("$dir/tahoma.ttf",8);
$chart->setGraphArea(50,30,585,200);
$chart->drawFilledRoundedRectangle(7,7,693,243,5,240,240,240);
$chart->drawRoundedRectangle(5,5,695,225,5,230,230,230);
$chart->drawGraphArea(255,255,255,TRUE);
$chart->drawScale($dataset->GetData(),$dataset->GetDataDescription(),SCALE_START0,150,150,150,TRUE,0,2,TRUE);
$chart->drawGrid(4,TRUE,230,230,230,50);
$chart->drawTreshold(0,143,55,72,TRUE,TRUE);
$chart->drawLegend(600,30,$dataset->GetDataDescription(),255,255,255);
$chart->drawTitle(50,22,"Reservation History",50,50,50,585);

$chart->drawLineGraph($dataset->GetData(),$dataset->GetDataDescription());
$chart->drawPlotGraph($dataset->GetData(),$dataset->GetDataDescription(),3,2,255,255,255);

$chart->Render('../tmp/graph.png');

$smarty->assign('formstart',
		$this->CreateFormStart($id,'admin_graphing',$returnid));
$smarty->assign('formend',
		$this->CreateFormEnd());
$yearlist = array();
$yearlist[-1] = $this->Lang('none');
for( $y = $first_year; $y <= $last_year; $y++ )
  {
    $yearlist[$y] = $y;
  }
$smarty->assign('years',$yearlist);
$smarty->assign('values',$years);
$smarty->assign('graph','../tmp/graph.png');
echo $this->ProcessTemplate('admin_graphing.tpl');
#
# EOF
#
?>