<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(AVAILABILITY_PERM_RESOURCES) ) exit();

// Setup
$row = array('name'=>'','active'=>1,'description'=>'','base_price'=>'','admin_notes'=>'', 'capacity'=>'',
	     'res_interval'=>$this->GetPreference('dflt_interval'),
	     'granularity'=>$this->GetPreference('dflt_granularity'),
	     'starttime1'=>$this->GetPreference('starttime_1'),
	     'endtime1'=>$this->GetPreference('endtime_1'),
	     'starttime2'=>$this->GetPreference('starttime_2'),
	     'endtime2'=>$this->GetPreference('endtime_2'),
	     'checkintime'=>$this->GetPreference('checkin_time'),
	     'checkouttime'=>$this->GetPreference('checkout_time'),
	     'allow_overcapacity'=>1,
	     'sorting'=>''
	     );
$adjusts = array('sunday'=>'','monday'=>'','tuesday'=>'','wednesday'=>'','thursday'=>'',
		 'friday'=>'','saturday'=>'', 'weekly'=>'','overcap'=>'',
		 'discount_days'=>'','discount_adjust'=>'','discount_type'=>AVAILABILITY_DISCOUNT_NONE);
$this->SetCurrentTab('resources');

if( isset($params['rsrcid']) )
  {
    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE id = ?';
    $row = $db->GetRow( $query, array( (int)$params['rsrcid']) );

    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRC_PRICES.' where rsrc_id = ?';
    $adjusts = $db->GetRow($query, array( (int)$params['rsrcid']) );
  }

if( isset($params['cancel']) )
  {
    $this->RedirectToTab($id);
  }
else if( isset($params['submit']) )
  {
    // Data collection
    if( isset($params['input_name']) )
      {
	$row['name'] = trim($params['input_name']);
      }
    if( isset($params['input_active']) )
      {
	$row['active'] = (int)$params['input_active'];
      }
    if( isset($params['input_description']) )
      {
	$row['description'] = trim($params['input_description']);
      }
    if( isset($params['input_base_price']) )
      {
	$row['base_price'] = floatval($params['input_base_price']);
      }
    if( isset($params['input_admin_notes']) )
      {
	$row['admin_notes'] = trim($params['input_admin_notes']);
      }
    if( isset($params['input_capacity']) )
      {
	$row['capacity'] = (int)$params['input_capacity'];
      }
    if( isset($params['input_allow_overcapacity']) )
      {
	$row['allow_overcapacity'] = (int)$params['input_allow_overcapacity'];
      }

    // scheduling
    $row['res_interval'] = trim($params['res_interval']);
    $row['granularity'] = trim($params['granularity']);
    $row['starttime1'] = sprintf('%02d:%02d',$params['starttime1_Hour'],$params['starttime1_Minute']);
    $row['endtime1'] = sprintf('%02d:%02d',$params['endtime1_Hour'],$params['endtime1_Minute']);
    $row['starttime2'] = sprintf('%02d:%02d',$params['starttime2_Hour'],$params['starttime2_Minute']);
    $row['endtime2'] = sprintf('%02d:%02d',$params['endtime2_Hour'],$params['endtime2_Minute']);
    $row['checkintime'] = sprintf('%02d:%02d',$params['checkin_Hour'],$params['checkin_Minute']);
    $row['checkouttime'] = sprintf('%02d:%02d',$params['checkout_Hour'],$params['checkout_Minute']);

     // adjustments
    //$adjusts['rsrc_id'] = int($params['rsrcid']);
    if( isset($params['sunday_adjust']) )
      {
	$adjusts['sunday'] = trim($params['sunday_adjust']);
      }
    if( isset($params['monday_adjust']) )
      {
	$adjusts['monday'] = trim($params['monday_adjust']);
      }
    if( isset($params['tuesday_adjust']) )
      {
	$adjusts['tuesday'] = trim($params['tuesday_adjust']);
      }
    if( isset($params['wednesday_adjust']) )
      {
	$adjusts['wednesday'] = trim($params['wednesday_adjust']);
      }
    if( isset($params['thursday_adjust']) )
      {
	$adjusts['thursday'] = trim($params['thursday_adjust']);
      }
    if( isset($params['friday_adjust']) )
      {
	$adjusts['friday'] = trim($params['friday_adjust']);
      }
    if( isset($params['saturday_adjust']) )
      {
	$adjusts['saturday'] = trim($params['saturday_adjust']);
      }
    if( isset($params['weekly_amount']) )
      {
	$adjusts['weekly'] = trim($params['weekly_amount']);
      }
    if( isset($params['overcap_amount']) )
      {
	$adjusts['overcap'] = trim($params['overcap_amount']);
      }
    if( isset($params['discount_type']) )
      {
	$adjusts['discount_type'] = (int)($params['discount_type']);
      }
    if( isset($params['discount_days']) )
      {
	$adjusts['discount_days'] = (int)($params['discount_days']);
      }
    if( isset($params['discount_adjust']) )
      {
	$adjusts['discount_adjust'] = trim($params['discount_adjust']);
      }

    // Data validation
    $errors = array();
    if( empty($row['name']) )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }
    if( $row['base_price'] < 0.0 || $row['base_price'] > 1000000.0 )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }
    if( $adjusts['weekly'] < 0.0 || $adjusts['weekly'] > 1000000.0 )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }
    if( $adjusts['overcap'] < 0.0 || $adjusts['overcap'] > 1000000.0 )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }
    if( $adjusts['discount_days'] < 0 )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }

    // Database work
    if( count($errors) )
      {
	echo $this->ShowErrors($errors);
      }
    else
      {
	$dbr = true;
	if( !isset($params['rsrcid']) )
	  {
	    $query = 'SELECT MAX(sorting) FROM '.AVAILABILITY_TABLE_RSRCS;
	    $new_sorting = $db->GetOne($query);
	    $row['sorting'] = $new_sorting+1;

	    // it's an insert
	    $query = 'INSERT INTO '.AVAILABILITY_TABLE_RSRCS.' 
                        (name, active, description, base_price, admin_notes, capacity,
                         res_interval, granularity, starttime1, endtime1, starttime2, endtime2,
                         checkintime, checkouttime, allow_overcapacity, sorting )
                       VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
	    $dbr = $db->Execute($query,
				array($row['name'],$row['active'],$row['description'],$row['base_price'],
				      $row['admin_notes'],$row['capacity'],
				      $row['res_interval'],$row['granularity'],
				      $row['starttime1'],$row['endtime1'],
				      $row['starttime2'],$row['endtime2'],
				      $row['checkintime'],$row['checkouttime'],
				      $row['allow_overcapacity'],$row['sorting']));
	    if( !$dbr ) 
	      {
		die($db->sql.'<br/>'.$db->ErrorMsg().'<br/>');
	      }
	    $params['rsrcid'] = $db->Insert_ID();

	    if( $dbr )
	      {
		$query = 'INSERT INTO '.AVAILABILITY_TABLE_RSRC_PRICES.'
                      (rsrc_id, sunday, monday, tuesday, wednesday, thursday, friday, saturday, weekly, overcap, discount_days, 
                       discount_adjust, discount_type)
                      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)';
		$dbr = $db->Execute($query,
				    array($params['rsrcid'], $adjusts['sunday'], $adjusts['monday'], $adjusts['tuesday'],
					  $adjusts['wednesday'], $adjusts['thursday'], $adjusts['friday'], $adjusts['saturday'],
					  $adjusts['weekly'], $adjusts['overcap'],
					  $adjusts['discount_days'], $adjusts['discount_adjust'], $adjusts['discount_type']));
		if( !$dbr ) 
		  {
		    die($db->sql.'<br/>'.$db->ErrorMsg().'<br/>');
		  }

	      }
	  }
	else
	  {
	    // it's an update
	    $query = 'UPDATE '.AVAILABILITY_TABLE_RSRCS.' 
                         SET name = ?, active = ?, description = ?, 
                             base_price = ?, admin_notes = ?, capacity = ?,
                             res_interval = ?, granularity = ?,
                             starttime1 = ?, endtime1 = ?,
                             starttime2 = ?, endtime2 = ?,
                             checkintime = ?, checkouttime = ?,
                             allow_overcapacity = ?
                       WHERE id = ?';
	    $dbr = $db->Execute($query,
				array($row['name'],$row['active'],
				      $row['description'],$row['base_price'],
				      $row['admin_notes'],
				      $row['capacity'],
				      $row['res_interval'], $row['granularity'],
				      $row['starttime1'], $row['endtime1'],
				      $row['starttime2'], $row['endtime2'],
				      $row['checkintime'], $row['checkouttime'],
                                      $row['allow_overcapacity'],
				      (int)$params['rsrcid']));

	    if( $dbr )
	      {
		$query = 'UPDATE '.AVAILABILITY_TABLE_RSRC_PRICES.' 
                          SET sunday = ?, monday = ?, tuesday = ?, wednesday = ?, thursday = ?, 
                              friday = ?, saturday = ?, weekly = ?, overcap = ?,
                              discount_days = ?, discount_adjust = ?, discount_type = ?
                          WHERE rsrc_id = ?';
		$dbr = $db->Execute($query,
				    array($adjusts['sunday'], $adjusts['monday'], $adjusts['tuesday'],
					  $adjusts['wednesday'], $adjusts['thursday'], $adjusts['friday'], 
					  $adjusts['saturday'], $adjusts['weekly'], $adjusts['overcap'],
					  $adjusts['discount_days'],$adjusts['discount_adjust'],
					  $adjusts['discount_type'],
					  (int)$params['rsrcid']) );
	      }
	  }

	if( !$dbr )
	  {
	    echo $db->sql.'<br/>ERROR: '.$db->ErrorMsg().'<br/>';
	    die();
	  }


	//
	// Handle categories
	//
	
	// delete any existing categories for this resource
	$query = 'DELETE FROM '.AVAILABILITY_TABLE_RSRC_CATS.' WHERE rsrc_id = ?';
	$db->Execute($query, array((int)$params['rsrcid']));

	//
	// Handle custom fields
	//
	$query = 'INSERT INTO '.AVAILABILITY_TABLE_RSRC_CATS.' (rsrc_id,category_id)
                   VALUES (?,?)';
	foreach( $params as $key => $value )
	  {
	    if( !preg_match('/cat_/', $key ) )
	      {
		continue;
	      }
	    $catid = (int)substr($key,4);
	    $db->Execute($query,array((int)$params['rsrcid'],$catid));
	  }


	// delete any existing fields for this resource
	$query = 'DELETE FROM '.AVAILABILITY_TABLE_FIELDVALS.' WHERE rsrc_id = ?';
	$db->Execute($query, array((int)$params['rsrcid']));

	// handle parameters
	foreach( $params as $key => $value )
	  {
	    if( !preg_match('/fld_/', $key ) )
	      {
		continue;
	      }
	    $value = trim($value);

	    // adjust the key to get the field name
	    $fldname = substr($key,4);
	    if( !isset($params['info_'.$fldname]) )
	      {
		// todo, trigger error
		continue;
	      }
	    list($fldtype,$fldid) = explode(',',trim($params['info_'.$fldname]));
	    $pass = true;
	    switch( $fldtype )
	      {
	      case 'image':
		{
		  $res = true;
		  if( isset( $params['del_'.$fldname] ) )
		    {
		      $res = $this->HandleImageDelete($id,(int)$params['rsrcid'],$value);
		    }

		  if( !$res )
		    {
		      $pass = false;
		      $errors[] = $this->Lang('error_filedelete');
		    }
		  else
		    {
		      $t_value = '';
		      $t_result = '';
		      $res = $this->HandleImageUpload($id,$key,(int)$params['rsrcid'],
						      $t_value,$t_result);
		      if( !$res && !empty($result))
			{
			  $pass = false;
			  $errors[] = $t_result;
			}
		      if( $res && !empty($t_value) )
			{
			  $value = $t_value;
			}
		    }
		}
		break;

	      case 'file':
		{
		  $res = true;
		  if( isset( $params['del_'.$fldname] ) )
		    {
		      $res = $this->HandleFileDelete($id,(int)$params['rsrcid'],$value);
		    }

		  if( !$res )
		    {
		      $pass = false;
		      $errors[] = $this->Lang('error_filedelete');
		    }
		  else
		    {
		      $t_value = '';
		      $t_result = '';
		      $res = $this->HandleFileUpload($id,$key,(int)$params['rsrcid'],
						     $value,$result);
		      if( !$res && !empty($result))
			{
			  $pass = false;
			  $errors[] = $result;
			}
		      if( $res && !empty($t_value) )
			{
			  $value = $t_value;
			}
		    }
		}
		break;
	      }

	    // save the value
	    if( $pass && !empty($value))
	      {
		$query = 'INSERT INTO '.AVAILABILITY_TABLE_FIELDVALS.' (rsrc_id, fielddef_id, value)
                       VALUES (?,?,?)';
		$dbr = $db->Execute( $query, array( (int)$params['rsrcid'],$fldid,$value) );
	      }		
	  }

	// add search data
	if( !count($errors) && $row['active'])
	  {
	    $search =& $this->GetModuleInstance('Search');
	    if( is_object($search) )
	      {
		$str = $row['name'].' '.$row['description'];
		foreach( $params as $key => $value )
		  {
		    if( !preg_match('/fld_/', $key ) )
		      {
			continue;
		      }
		    list($fldtype,$fldid) = explode(',',trim($params['info_'.$fldname]));
		    $value = trim($value);
		    if( $fldtype == 'textbox' || $fldtype == 'textarea' )
		      {
			$str .= ' '.$value;
		      }
		  }
		$search->AddWords($this->GetName(),(int)$params['rsrcid'],'resource',$str);
	      }
	  }

	// display  errors or redirect
	if( count($errors) )
	  {
	    echo $this->ShowErrors($errors);
	  }
	else
	  {
	    $this->RedirectToTab($id);
	  }

      } // else

  } // submit

//
// Create the form
//
{
  $discount_types = array();
  $discount_types[AVAILABILITY_DISCOUNT_NONE] = $this->Lang('none');
  $discount_types[AVAILABILITY_DISCOUNT_FREEBLOCK] = $this->Lang('discount_freeblock');
  $discount_types[AVAILABILITY_DISCOUNT_ALLADJUST] = $this->Lang('discount_alladjust');
  $discount_types[AVAILABILITY_DISCOUNT_ADJUSTDAYS] = $this->Lang('discount_adjustdays');
  $smarty->assign('discount_types',$discount_types);;
}

{
  $intervals = array();
  $intervals['hourly'] = $this->Lang('hourly');
  $intervals['half_day'] = $this->Lang('half_day');
  $intervals['daily'] = $this->Lang('daily');
  $smarty->assign('intervals',$intervals);

  // applies only to hourly interval
  $granularity = array();
  $granularity['quarter_hour'] = $this->Lang('quarter_hour');
  $granularity['half_hour'] = $this->Lang('half_hour');
  $granularity['hour'] = $this->Lang('one_hour');
  $smarty->assign('granularity',$granularity);
}

{
  $capacities = array();
  $capacities[-1] = $this->Lang('not_applicable');
  $default_capacity = $this->GetPreference('default_capacity',50);
  for( $i = 1; $i <= $default_capacity; $i++ )
    {
      $capacities[$i] = $i;
    }
  $smarty->assign('list_capacities',$capacities);
}


$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_edit_rsrc',$returnid,$params,false,'post','multipart/form-data'));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));
$smarty->assign('cancel',$this->CreateInputSubmit($id,'cancel',$this->Lang('cancel')));

$smarty->assign('rsrc',$row);
$smarty->assign('input_name',$this->CreateInputText($id,'input_name',$row['name'],80,255));
$smarty->assign('input_description',$this->CreateTextArea(true,$id,$row['description'],'input_description'));
$smarty->assign('input_base_price',$this->CreateInputText($id,'input_base_price',$row['base_price'],10,10));
$smarty->assign('input_admin_notes',$this->CreateTextArea(true,$id,$row['admin_notes'],'input_admin_notes'));
$smarty->assign('input_active',$this->CreateInputYesNoDropdown($id,'input_active',$row['active']));
$smarty->assign('input_allow_overcapacity',$this->CreateInputYesNoDropdown($id,'input_allow_overcapacity',$row['allow_overcapacity']));

// Add custom weekday prices
$smarty->assign('adjusts',$adjusts);
$smarty->assign('sunday_adjust',$this->CreateInputText($id,'sunday_adjust',$adjusts['sunday'],10,30));
$smarty->assign('monday_adjust',$this->CreateInputText($id,'monday_adjust',$adjusts['monday'],10,30));
$smarty->assign('tuesday_adjust',$this->CreateInputText($id,'tuesday_adjust',$adjusts['tuesday'],10,30));
$smarty->assign('wednesday_adjust',$this->CreateInputText($id,'wednesday_adjust',$adjusts['wednesday'],10,30));
$smarty->assign('thursday_adjust',$this->CreateInputText($id,'thursday_adjust',$adjusts['thursday'],10,30));
$smarty->assign('friday_adjust',$this->CreateInputText($id,'friday_adjust',$adjusts['friday'],10,30));
$smarty->assign('saturday_adjust',$this->CreateInputText($id,'saturday_adjust',$adjusts['saturday'],10,30));

// Add Categories to the form
$query = 'SELECT * FROM '.AVAILABILITY_TABLE_CATS;
$catdefs = $db->GetArray($query);
if( isset($params['rsrcid']) )
  {
    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRC_CATS.' WHERE rsrc_id = ?';
    $catvals = $db->GetArray($query,array((int)$params['rsrcid']));
    if( $catvals )
      {
	$tmp = cge_array::merge_by_keys($catdefs,$catvals,'id','category_id');
	$catdefs = $tmp;
      }
  }
$categories = array();
foreach( $catdefs as $onecat )
{
  $onecat['field'] = $this->CreateInputCheckbox($id,'cat_'.$onecat['id'],1,
						(isset($onecat['rsrc_id']))?1:0);
  $categories[] = $onecat;
}
if( count($categories) )
  {
    $smarty->assign('categories',$categories);
  }

// Add custom fields to the form
$query = 'SELECT * FROM '.AVAILABILITY_TABLE_FIELDDEFS;
$fielddefs = $db->GetArray($query);
if( isset($params['rsrcid']) )
  {
    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_FIELDVALS.' WHERE rsrc_id = ?';
    $fieldvals = $db->GetArray($query,array((int)$params['rsrcid']));
    if( $fieldvals )
      {
	$tmp = cge_array::merge_by_keys($fielddefs,$fieldvals,'id','fielddef_id');
	$fielddefs = $tmp;
      }
  }

$fields = array();
foreach( $fielddefs as $onefield )
{
  if( !isset($onefield['value']) ) $onefield['value'] = '';

  $onefield['hidden'] = $this->CreateInputHidden($id,'info_'.$onefield['name'],
						 $onefield['type'].','.$onefield['id']); 
  switch( $onefield['type'] )
    {
    case 'textbox':
      $size = min(50,$onefield['max_length']);
      $onefield['field'] = $this->CreateInputText($id,'fld_'.$onefield['name'],
						  $onefield['value'],$size,$onefield['max_length']);
      break;

    case 'textarea':
      $onefield['field'] = $this->CreateTextArea(true,$id,$onefield['value'],'fld_'.$onefield['name']);
      break;

    case 'checkbox':
      // todo, add hidden field first with the value
      $onefield['field'] = $this->CreateInputCheckbox($id,'fld_'.$onefield['name'],1,$onefield['value']);
      break;

    case 'dropdown':
      {
	$tmp = explode("\n",$onefield['options']);
	$tmp2 = array();
	foreach( $tmp as $one )
	  {
	    $one = trim($one);
	    $tmp2[$one] = $one;
	  }
	$onefield['field'] = $this->CreateInputDropdown($id,'fld_'.$onefield['name'],
							$tmp2,-1,$onefield['value']);
      }
      break;

    case 'image':
      if( !empty($onefield['value']) ) 
	{
	  $onefield['display_value'] = $onefield['value'];
	  $onefield['delete_field'] = $this->CreateInputCheckbox($id,'del_'.$onefield['name'],1,0);
	}
      $onefield['field'] = $this->CreateInputHidden($id,'fld_'.$onefield['name'],
						    $onefield['value']).$this->CreateFileUploadInput($id,'fld_'.$onefield['name'],'',30);
      break;

    case 'file':
      if( !empty($onefield['value']) ) $onefield['display_value'] = $onefield['value'];
      $onefield['field'] = $this->CreateInputHidden($id,'fld_'.$onefield['name'],
						    $onefield['value']).$this->CreateFileUploadInput($id,'fld_'.$onefield['name'],'',30);
      break;
    }
  $fields[] = $onefield;
}
if( count($fields) )
  {
    $smarty->assign('fields',$fields);
  }


// Echo it out
echo $this->ProcessTemplate('admin_edit_rsrc.tpl');

#
# EOF
#
?>