<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS) )
  {
    die('permission denied');
  }

//
// check_parts_overlap
//
function check_parts_overlap($parts)
{
  $data = array();

  for( $p = 0; $p < count($parts); $p++ )
    {
      $part =& $parts['i'];
      if( !isset($data['rsrc_id']) )
	{
	  $data['rsrc_id'] = array();
	}
      else
	{
	  // hmmm, two (or more) books for the same resource in one reservation?
	  for( $k = 0; $k < count($data['rsrc_id']); $k++ )
	    {
	      $tmp =& $data['rsrc_id'][$k];
	      if( ($part['start_date'] >= $tmp['start_date']) && $part['start_date'] <= $tmp['end_date'] )
		return FALSE;
	      if( ($part['end_date'] >= $tmp['start_date']) && $part['end_date'] <= $tmp['end_date'] )
		return TRUE;
	    }
	}
      $data['rsrc_id'][] = $part;
    }

  return TRUE;
}

//
// initialzation
//
$resv_id = '';
$this->SetCurrentTab('reservations');
$resvn_obj = '';
$reservation = array('id'=>-1,
                     'customer_id'=>-1,
		     'admin_notes'=>'',
		     'status'=>AVAILABILITY_STATUS_PENDING,
		     'parts'=>array(),
		     'price'=>'',
		     'create_date'=>time(),
		     'modified_date'=>time());
$checkin_time = $this->GetPreference('checkin_time');
$checkout_time = $this->GetPreference('checkout_time');
$change_note = '';
$my_uid = get_userid();
$my_username = '';
{
  $userops = $gCms->GetUserOperations();
  $tmp = $userops->LoadUserById($my_uid);
  if( $tmp )
    {
      $my_username = $tmp->username;
    }
}
$user_action = '';

//
// Setup
//
if( isset($params['cancel']) )
  {
    $this->RedirectToTab($id);
  }

if( isset($params['resvnid']) )
{
  $resv_id = (int)$params['resvnid'];
  // Load the reservation
  $resvn_obj = reservation_ops::load_by_id($resv_id);
  $reservation = $resvn_obj->to_array();
//   $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATIONS.' 
//              WHERE id = ?';
//   $reservation = $db->GetRow($query,array($resv_id));

//   $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
//              WHERE resv_id = ?';
//   $reservation['parts'] = $db->GetArray($query,array($resv_id));

//   $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATION_EXTRA.'
//              WHERE resv_id = ?';
//   $reservation['extra'] = $db->GetArray($query,array($resv_id));
}
if( isset($params['uid']) )
{
  $reservation['customer_id'] = (int)$params['uid'];
}


if( isset($params['submit']) && $params['submit'] == $this->Lang('submit'))
  {
    $did_set_price = 0;

    // Data collection
    if( isset($params['input_status']) )
      {
	$reservation['status'] = trim($params['input_status']);
	unset($params['input_status']);
      }
    if( isset($params['input_customer_id']) )
      {
	$reservation['customer_id'] = (int)$params['input_customer_id'];
	unset($params['input_customer_id']);
      }
    if( isset($params['input_admin_notes']) )
      {
	$reservation['admin_notes'] = trim($params['input_admin_notes']);
	unset($params['input_admin_notes']);
      }
    if( isset($params['input_price']) && !empty($params['input_price']) &&
	$reservation['price'] != (float)$params['input_price'])
      {
	$did_set_price = 1;
	$reservation['price'] = floatval($params['input_price']);
	unset($params['input_price']);
      }
    if( isset($params['change_note']) && !empty($params['change_note']) )
      {
	$change_note = trim($params['change_note']);
      }

    $reservation['parts'] = array();

    // get the reservation parts out of params
    for( $i = 1; $i < 1000; $i++ )
      {
	if( isset($params['part_selrsrc_'.$i]) && ($params['part_selrsrc_'.$i] > 0) )
	  {
	    $partidx = $i;
	    $rid = $params['part_selrsrc_'.$i];
            $start_ut = $params['part_startdate_'.$i];
	    $end_ut = '';
	    $meridian = '';
	    if( isset($params['part_startdate_'.$i.'meridian']) )
	      {
		$meridian = $params['part_startdate_'.$i.'meridian'];
	      }
            if( $params['part_enddate_'.$i] )
	      {
		$end_ut = $params['part_enddate_'.$i];
	      }
	    $part = $this->AdjustReservationPartInterval($rid,$start_ut,$end_ut,$meridian);
	    $part['resv_id']    = $reservation['id']; // incase it's already set
	    $part['rsrc_id']    = $rid;
	    $part['num_people'] = $params['part_numpeople_'.$i];
	    $part['price']      = $params['part_price_'.$i];
	    $reservation['parts'][] = $part;
	  }
	else
	  {
	    break;
	  }
      }

    if( isset($reservation['extra']) && is_array($reservation['extra']) )
      {
	// handle trimming the 'extra' array to the data and only keep the ids that are supplied in the form.
	$prefix = 'resvn_extra_';
	$keep_ids = array();
	foreach( $params as $key => $value )
	  {
	    if( startswith($key,$prefix) )
	      {
		$extra_id = (int)substr($key,strlen($prefix));
		$keep_ids[] = $extra_id;
	      }
	  }

	if( !count($keep_ids) )
	  {
	    $reservation['extra'] = array();
	  }
	else
	  {
	    $new_extra = array();
	    for( $i = 0; $i < count($reservation['extra']); $i++ )
	      {
		if( !in_array($reservation['extra'][$i]['id'], $keep_ids) )
		  {
		    $new_extra[] = $reservation['extra'][$i];
		  }
	      }
	    $reservation['extra'] = $new_extra;
	  }
      }

    
    if( !$did_set_price )
      {
	// haven't set the price yet
	// grab it from all the parts.
	$price = 0;
	for( $n = 0; $n < count($reservation['parts']); $n++ )
	  {
	    $price += $reservation['parts'][$n]['price'];
	  }
	for( $n = 0; $n < count($reservation['extra']); $n++ )
	  {
	    $extra = $reservation['extra'][$n];
	    $price += $extra['qty'] * $extra['itemamt'];
	  }
	$reservation['price'] = $price;
	$did_set_price = 1;
      }

    // data validation
    $errors = array();
    if( $reservation['status'] == -1 )
      {
	$errors[] = $this->Lang('error_select_status');
      }
    if( $reservation['customer_id'] < 1 )
      {
	$errors[] = $this->Lang('error_no_customer_selected');
      }
    if( (empty($reservation['price']) || $reservation['price'] < 0.0 || $reservation['price'] > 1000000.0) &&
	$this->GetPreference('error_no_prices',1) )
      {
	$errors[] = $this->Lang('error_invalid_price');
      }
    if( !count($reservation['parts']) )
      {
	$errors[] = $this->Lang('error_no_resources_selected');
      }
    else
      {
	// check for conflicts and overlaps amongst these reservation parts
	if( check_parts_overlap($reservation['parts']) )
	  {
	    $errors[] = $this->Lang('error_event_conflict');
	  }
      }

    
    if( !count($errors) )
      {
	// check against the database for reervation conflicts.
        if( !isset($params['resvnid']) )
          {
            // This is an insert
	    $conflict = $this->CheckReservationConflicts($reservation);
	    if( $conflict )
	      {
	        // yep, there's a conflict
	        $errors[] = $this->Lang('error_event_conflict');
	      }
          }
        else
          {
	    // This is an update
	    $reservation['id'] = $resv_id;
	    $conflict = $this->CheckReservationConflicts($reservation);
	    if( $conflict )
	      {
	        // yep, there's a conflict
	        $errors[] = $this->Lang('error_event_conflict');
	      }
          }
      }

    // data storage
    if( !count($errors) )
      {
	// everything is good
	// add it to the database
	$parts = '';
        $dbr = '';
	$this->CalculateReservationParts($reservation);	
	$now = $db->DbTimeStamp(time());
	$did_insert = FALSE;

        if( $resv_id )
          {
	    $user_action = 'change';

            // an update
            $query = 'UPDATE '.AVAILABILITY_TABLE_RESERVATIONS."
                         SET customer_id = ?, 
                             price = ?, admin_notes = ?, status = ?,
                             modified_date = $now
                       WHERE id = ?";
            $dbr = $db->Execute($query,array($reservation['customer_id'],$reservation['price'],
					     $reservation['admin_notes'],$reservation['status'],$resv_id));

            $query = 'DELETE FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.' 
                       WHERE resv_id = ?';
            $db->Execute($query,array($resv_id));

	    $tmp = array();
	    if( is_array($reservation['extra']) )
	      {
		foreach( $reservation['extra'] as $one_extra )
		  {
		    $tmp[] = (int)$one_extra['id'];
		  }
	      }
	    $query = 'DELETE FROM '.AVAILABILITY_TABLE_RESERVATION_EXTRA.'
                       WHERE resv_id = ?';
	    if( count($tmp) )
	      {
		$query .= ' AND id NOT IN ('.implode(',',$tmp).')';
              }
	    $dbr = $db->Execute($query,array($resv_id));
          }
        else
          {
	    $user_action = 'create';

   	    $query = 'INSERT INTO '.AVAILABILITY_TABLE_RESERVATIONS."
                      (customer_id, price, 
                       admin_notes, status, create_date, modified_date)
                      VALUES (?,?,?,?,$now,$now)";
 	    $dbr = $db->Execute($query,array($reservation['customer_id'],$reservation['price'],
					     $reservation['admin_notes'],$reservation['status']));
 	    $resv_id = $db->Insert_ID();
	    $did_insert = TRUE;
	  }

	if( !$dbr )
	  {
	    echo $db->ErrorMsg()." - ".$db->sql.'<br/>';
	    die();
	  }
	else
	  {
	    $reservation['id'] = $resv_id;
	    
	    $tquery = 'INSERT INTO '.AVAILABILITY_TABLE_RESERVATION_PARTS."
                       (start_date,end_date,resv_id, rsrc_id, num_people, price ) 
                      VALUES (%s,%s,?,?,?,?)";
	    for( $i = 0; $i < count($reservation['parts']); $i++ )
	      {
		$part =& $reservation['parts'][$i];
		$start_date = $db->DbTimeStamp($part['start_date']);
		$end_date = $db->DbTimeStamp($part['end_date']);

		$query = sprintf($tquery,$start_date,$end_date);
		$dbr = $db->Execute($query,array($resv_id,$part['rsrc_id'],$part['num_people'],$part['price']));
		if( !$dbr )
		  {
		    // debug
		    echo $db->ErrorMsg()." - ".$db->sql.'<br/>';
		    die(); // debug
		  }
	      }

	    // insert a history record.
	    $query = 'INSERT INTO '.AVAILABILITY_TABLE_RESERVATION_HIST."
                       (resv_id,who,action,changed,note)
                      VALUES (?,?,?,NOW(),?)";
	    $db->Execute($query,array($resv_id,$my_username,$user_action,$change_note));

	    if( $this->GetPreference('reservation_confirm_email_flag',1) &&
		isset($params['input_sendmessage']) &&
		$params['input_sendmessage'] == 1)
	      {
		$tmp = '';
		$emailtemplate = $this->GetPreference(AVAILABILITY_PREF_DFLTRESVNCONFIRMEMAIL_TEMPLATE);
		$res = $this->SendReservationDetailsemail($resv_id,$emailtemplate,1,$tmp);
	      }

	    // audit something
	    if( $did_insert )
	      {
		$this->Audit($resv_id,$this->GetName(),
			     'New Reservation Created for customer '.$reservation['customer_id']);
	      }
	    else
	      {
		$this->Audit($resv_id,$this->GetName(),
			     'Reservation Created for customer '.$reservation['customer_id']);
	      }

	    // and done.
            $this->RedirectToTab($id);
	  }
      }
    else
      {
	echo $this->ShowErrors($errors);
      }
  }



//
// Build the form
//
for( $p = 0; $p < count($reservation['parts']); $p++ )
  {
    $part =& $reservation['parts'][$p];
    $rsrc = availability_utils::get_resource($part['rsrc_id']);
    if( $rsrc )
      {
	$c = '';
	switch( $rsrc['res_interval'] )
	  {
	  case 'hourly':
	    $c = ',h';
	    break;
	  case 'half_day':
	    $c = ',p';
	    break;
	  case 'daily':
	    $c = ',d';
	    break;
	  }
        $part['ext_part_type'] = $rsrc['res_interval'];
	$part['ext_rsrcid'] = $part['rsrc_id'].$c;
	$part['ext_summary'] = $this->GetResourceSummary($rsrc);
      }
  }

$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_edit_resvn',
						     $returnid,$params));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));
$smarty->assign('cancel',$this->CreateInputSubmit($id,'cancel',$this->Lang('cancel')));
$feu =& $this->GetModuleInstance('FrontEndUsers');
if( is_object($feu) )
  {
    $gid = (int)$this->GetPreference('customer_group');
    if( $gid == -1 )
      {
	echo $this->ShowErrors($this->Lang('error_no_users_found'));
      }
    else
      {
	$addtext = 'id="input_customer_id" onchange="on_change_customer();" ';
        $smarty->assign('memberof',$gid);
        $userlist = $this->GetUserDropdownList();
        $smarty->assign('input_customer_id',
		    $this->CreateInputDropdown($id,'input_customer_id',$userlist,
					       -1,$reservation['customer_id'],$addtext));
      }
  }

$statuses = array();
$statuses[-1] = $this->Lang('select_one');
$statuses[AVAILABILITY_STATUS_PENDING] = $this->Lang(AVAILABILITY_STATUS_PENDING);
$statuses[AVAILABILITY_STATUS_CANCELLED] = $this->Lang(AVAILABILITY_STATUS_CANCELLED);
$statuses[AVAILABILITY_STATUS_CONFIRMED] = $this->Lang(AVAILABILITY_STATUS_CONFIRMED);
$smarty->assign('statuses',$statuses);

$contentops =& $gCms->GetContentOperations();
$smarty->assign('default_content_id',$contentops->GetDefaultContent());

$smarty->assign('data',$reservation);
$smarty->assign('input_admin_notes',$this->CreateTextArea(true,$id,$reservation['admin_notes'],'input_admin_notes'));

$query = 'SELECT id,name,res_interval FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE active = 1';
$tmp = $db->GetArray($query);
$rsrcs = array();
$rsrcs_rev = array();
$rsrcs_rev['-1,-1'] =  $this->Lang('select_one');
$intervals = array();
$intervals['hourly'] = 'h';
$intervals['half_day'] = 'p';
$intervals['daily'] = 'd';
foreach( $tmp as $one )
{
  $rsrcs_rev[$one['id'].','.$intervals[$one['res_interval']]] = $one['name'].' ('.$this->Lang($one['res_interval']).')';
}
$smarty->assign('rsrc_list',$rsrcs_rev);

$tmp = array();
$tmp['am'] = $this->Lang('AM');
$tmp['pm'] = $this->Lang('PM');
$smarty->assign('meridians',$tmp);

$tmp = array();
$default_capacity = $this->GetPreference('default_capacity',50);
for( $i = 1; $i < $default_capacity; $i++ )
  {
    $tmp[$i] = $i;
  }
$smarty->assign('people_list',$tmp);
$tmp = get_preference(get_userid(),'date_format_string',get_site_preference('defaultdateformat','%b %e, %Y'));
$smarty->assign('date_format',$tmp);
if( $this->GetPreference('reservation_confirm_email_flag',1) )
  {
    $smarty->assign('input_sendmessage',
		$this->CreateInputYesNoDropdown($id,'input_sendmessage',1));
  }

$admin_startyear = $this->GetPreference('admin_startyear',-1);
if( $admin_startyear < 1900 )
  {
    $admin_startyear = date('Y');
  }
$smarty->assign('admin_startyear',$admin_startyear);

$query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATION_HIST.'
           WHERE resv_id = ? ORDER BY changed DESC';
$history = $db->GetArray($query,array($resv_id));
if( $history )
  {
    $smarty->assign('reservation_history',$history);
  }

echo $this->ProcessTemplate('admin_edit_resvn.tpl');
#
# EOF
#
?>
