<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(AVAILABILITY_PERM_EVENTS) ) die('permission denied');

//
// Setup
//
$this->SetCurrentTab('events');
$row = array('name'=>'','description'=>'','event_type_id'=>-1,
	     'start_date'=>time(),'end_date'=>strtotime("+1 week"),'bookable'=>1,
	     'price_adjust'=>'','admin_notes'=>'');
$sel_resources = array();

if( isset($params['eventid']) )
  {
    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_EVENTS.'
               WHERE id = ?';
    $row = $db->GetRow($query,array((int)$params['eventid']));

    $query = 'SELECT rsrc_id FROM '.AVAILABILITY_TABLE_RSRC_EVENTS.'
               WHERE event_id = ?';
    $tmp = $db->GetArray($query,array((int)$params['eventid']));
    foreach( $tmp as $one )
      {
	$sel_resources[] = $one['rsrc_id'];
      }
  }

//
// Handle form actions
if( isset($params['cancel']) )
  {
    $this->RedirectToTab($id);
  }
else if( isset($params['submit']) )
  {
    // Data collection
    if( isset($params['input_name']) )
      {
	$row['name'] = trim($params['input_name']);
      }
    if( isset($params['input_description']) )
      {
	$row['description'] = trim($params['input_description']);
      }
    if( isset($params['input_event_type']) )
      {
	$row['event_type_id'] = (int)($params['input_event_type']);
      }
    if( isset($params['input_startdate_Month']) )
      {
	$row['start_date'] = 
	  mktime(0,0,0,
		 (int)$params['input_startdate_Month'],
		 (int)$params['input_startdate_Day'],
		 (int)$params['input_startdate_Year']);
      }
    if( isset($params['input_enddate_Month']) )
      {
	$row['end_date'] = 
	  mktime(23,59,59,
		 (int)$params['input_enddate_Month'],
		 (int)$params['input_enddate_Day'],
		 (int)$params['input_enddate_Year']);
      }
    if( isset($params['input_bookable']) )
      {
	$row['bookable'] = (int)($params['input_bookable']);
      }
    if( isset($params['input_price_adjust']) )
      {
	$row['price_adjust'] = trim($params['input_price_adjust']);
      }
    if( isset($params['input_admin_notes']) )
      {
	$row['admin_notes'] = trim($params['input_admin_notes']);
      }
    if( isset($params['input_resources']) )
      {
	$sel_resources = $params['input_resources'];
      }

    // Data validation
    $errors = array();
    if( empty($row['name']) )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }
    if( !count($sel_resources) )
      {
	$errors[] = $this->Lang('error_must_select',$this->GetResourceType(1));
      }
    if( $row['start_date'] > $row['end_date'] )
      {
	$errors[] = $this->Lang('error_invalid_dates');
      }

    if( count($errors) )
      {
	echo $this->ShowErrors($errors);
      }
    else
      {
	// Database interaction
	$dbr = true;
	$start_date = $db->DbTimeStamp($row['start_date']);
	$end_date = $db->DbTimeStamp($row['end_date']);
	if( !isset($params['eventid']) )
	  {
	    // An insert
	    $query = 'INSERT INTO '.AVAILABILITY_TABLE_EVENTS."
                      (name,description,event_type_id,start_date,end_date,
                       bookable, price_adjust, admin_notes)
                     VALUES (?,?,?,$start_date,$end_date,?,?,?)";
	    $dbr = $db->Execute($query,array($row['name'],
					     $row['description'],
					     $row['event_type_id'],
					     $row['bookable'],
					     $row['price_adjust'],
					     $row['admin_notes']));
	    if( !$dbr )
	      {
		echo $db->sql.'<br/>ERROR: '.$db->ErrorMsg(); die();
	      }
	    if( $dbr )
	      {
		$params['eventid'] = $db->Insert_ID();
		
		// Add the items to the resource events table
		$query = 'INSERT INTO '.AVAILABILITY_TABLE_RSRC_EVENTS.'
                           (event_id,rsrc_id) VALUES (?,?)';
		foreach( $sel_resources as $sel )
		  {
		    $db->Execute($query,array((int)$params['eventid'],
					      $sel));
		  }
	      }
	  }
	else
	  {
	    // An update
	    $query = 'UPDATE '.AVAILABILITY_TABLE_EVENTS."
                      SET name = ?, description = ?, event_type_id = ?,
                          start_date = $start_date, end_date = $end_date,
                          bookable = ?, price_adjust = ?,
                          admin_notes = ?
                      WHERE id = ?";
	    $dbr = $db->Execute($query,array($row['name'],
					     $row['description'],
					     $row['event_type_id'],
					     $row['bookable'],
					     $row['price_adjust'],
					     $row['admin_notes'],
					     (int)$params['eventid']));

	    $query = 'DELETE FROM '.AVAILABILITY_TABLE_RSRC_EVENTS.'
                       WHERE event_id = ?';
	    $db->Execute($query,array((int)$params['eventid']));

	    if( $dbr )
	      {
		// Add the items to the resource events table
		$query = 'INSERT INTO '.AVAILABILITY_TABLE_RSRC_EVENTS.'
                           (event_id,rsrc_id) VALUES (?,?)';
		foreach( $sel_resources as $sel )
		  {
		    $db->Execute($query,array((int)$params['eventid'],
					      $sel));
		  }
	      }
	  } // update

	$this->RedirectToTab($id);
      } // database

  } // submit


//
// Create the form
//
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_edit_event',$returnid,$params,false,'post','multipart/form-data'));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));
$smarty->assign('cancel',$this->CreateInputSubmit($id,'cancel',$this->Lang('cancel')));
$smarty->assign('input_name',$this->CreateInputText($id,'input_name',$row['name'],80,255));
$smarty->assign('input_description',$this->CreateTextArea(true,$id,$row['description'],'input_description'));
$smarty->assign('input_startdate',$row['start_date']);
$smarty->assign('input_enddate',$row['end_date']);
$query = 'SELECT id,name FROM '.AVAILABILITY_TABLE_EVENT_TYPES.' ORDER BY iorder';
$types = $this->GetEventTypeDropdownList();
$smarty->assign('input_event_type',$this->CreateInputDropdown($id,'input_event_type',$types,-1,$row['event_type_id']));
$smarty->assign('input_bookable',$this->CreateInputYesNoDropdown($id,'input_bookable',$row['bookable']));
$smarty->assign('input_price_adjust',$this->CreateInputText($id,'input_price_adjust',$row['price_adjust']));
$smarty->assign('input_admin_notes',$this->CreateTextArea(true,$id,$row['admin_notes'],'input_admin_notes'));
$query = 'SELECT id,name FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE active = 1';
$tmp = $db->GetArray($query);
$rsrcs = array();
foreach( $tmp as $one )
{
  $rsrcs[$one['name']] = $one['id'];
}
$smarty->assign('input_resources',$this->CreateInputSelectList($id,'input_resources[]',$rsrcs,$sel_resources,10));

// Process template
echo $this->ProcessTemplate('admin_edit_event.tpl');

#
# EOF
#
?>