<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') )
  {
    die('permission denied');
  }

// setup
$row = array('name'=>'','prompt'=>'','type'=>'textbox','max_length'=>50,
	     'public'=>1,'options'=>'');

// Get the row from the database
if( isset($params['fldid']) )
  {
    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_FIELDDEFS.' WHERE id = ?';
    $row = $db->GetRow($query,array((int)$params['fldid']));
  }

// Get fields from params
if( isset($params['input_name']) )
  {
    $row['name'] = str_replace('-','_',munge_string_to_url(trim($params['input_name']),true));
  }
if( isset($params['input_prompt']) )
  {
    $row['prompt'] = trim($params['input_prompt']);
  }
if( isset($params['input_type']) )
  {
    $row['type'] = trim($params['input_type']);
  }
if( isset($params['input_maxlength']) )
  {
    $row['max_length'] = (int)$params['input_maxlength'];
  }
if( isset($params['input_public']) )
  {
    $row['public'] = (int)$params['input_public'];
  }
if( isset($params['input_options']) )
  {
    $row['options'] = trim($params['input_options']);
  }

if( isset($params['cancel']) )
  {
    $this->RedirectToTab($id,'custom_fields','','admin_settings');
  }
else if( isset($params['submit']) )
  {
    // error checking
    $errors = array();
    if( empty($row['name']) )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }
    if( empty($row['prompt']) )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }
    if( $row['type'] == 'dropdown' && empty($row['options']) )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }
    if( $row['type'] == 'textbox' && ($row['max_length'] > 2555 || $row['max_length'] < 0 ) )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }

    if( count($errors) )
      {
	echo $this->ShowErrors($errors);
      }
    else
      {
	$dbr = true;
	if( !isset($params['fldid']) )
	  {
	    // it's an insert
	    $query = 'INSERT INTO '.AVAILABILITY_TABLE_FIELDDEFS.'
                        (name,prompt,type,max_length,options,public)
                      VALUES (?,?,?,?,?,?)';
	    $dbr = $db->Execute( $query, array( $row['name'],
						$row['prompt'],
						$row['type'],
						$row['max_length'],
						$row['options'],
						$row['public']) );
	  }
	else
	  {
	    // it's an update
	    $query = 'UPDATE '.AVAILABILITY_TABLE_FIELDDEFS.'
                         SET name = ?, prompt = ?, type = ?,
                             max_length = ?, options = ?, public = ?
                       WHERE id = ?';
	    $dbr = $db->Execute( $query, array( $row['name'],
						$row['prompt'],
						$row['type'],
						$row['max_length'],
						$row['options'],
						$row['public'],
						(int)$params['fldid']) );
	  }

	if( !$dbr )
	  {
	    echo $db->sql.'<br/>ERROR: '.$db->ErrorMsg().'<br/>';
	    die();
	  }

	$this->RedirectToTab($id,'custom_fields','','admin_settings');
      }
  }

// Build the form
$smarty->assign('formstart',
		$this->CGCreateFormStart($id,'admin_edit_custom_field',$returnid,$params));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
$smarty->assign('input_name',$this->CreateInputText($id,'input_name',$row['name'],30,255));
$smarty->assign('input_prompt',$this->CreateInputText($id,'input_prompt',$row['prompt'],50,255));
$smarty->assign('input_public',$this->CreateInputYesNoDropdown($id,'input_public',$row['public']));
$addtext = "onchange='this.form.submit();'";
$smarty->assign('input_type',$this->GetTypesDropdown($id,'input_type',$row['type'],$addtext,true));

if( $row['type'] == 'textbox' )
  {
    $smarty->assign('input_maxlength',$this->CreateInputText($id,'input_maxlength',$row['max_length'],5,5));
  }
else if( $row['type'] == 'dropdown' )
  {
    $smarty->assign('input_options',
		    $this->CreateTextArea(false,$id,$row['options'],'input_options'));
  }

echo $this->ProcessTemplate('admin_edit_custom_field.tpl');
#
# EOF
#
?>