<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') )
  {
    die('permission denied');
  }

// Setup
$this->SetCurrentTab('categories');
$row = array('name'=>'');

if( isset($params['catid']) )
  {
    // catid sent, try to get the values
    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_CATS.' WHERE id = ?';
    $row = $db->GetRow( $query, array( (int)$params['catid'] ) );
  }

if( isset($params['cancel']) )
  {
    $this->RedirectToTab($id,'categories','','admin_settings');
  }
else if( isset($params['submit']) )
  {
    if( isset($params['input_name']) )
      {
	$row['name'] = trim($params['input_name']);
      }

    // error checking
    $errors = array();
    if( empty($row['name']) )
      {
	$errors[] = $this->Lang('error_invalid_value');
      }

    // handle errors, or process
    if( count($errors) )
      {
	echo $this->ShowErrors($errors);
      }
    else
      {
	$dbr = true;
	if( !isset($params['catid']) )
	  {
	    // it's an insert
	    $query = 'INSERT INTO '.AVAILABILITY_TABLE_CATS.'
                        (name) VALUES (?)';
	    $dbr = $db->Execute( $query, array( $row['name'] ));
	  }
	else
	  {
	    $query = 'UPDATE '.AVAILABILITY_TABLE_CATS.'
                         SET name = ? WHERE id = ?';
	    $dbr = $db->Execute( $query, array( $row['name'], $params['catid']));
	  }

	if( !$dbr )
	  {
	    echo $db->sql.'<br/>ERROR: '.$db->ErrorMsg().'<br/>';
	    die();
	  }

	$this->RedirectToTab($id,'categories','','admin_settings');
      }
  }


// Create the form
$smarty->assign('formstart',
		$this->CGCreateFormStart($id,'admin_edit_category',
					 $returnid,$params));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));
$smarty->assign('cancel',$this->CreateInputSubmit($id,'cancel',$this->Lang('cancel')));
$smarty->assign('input_name',$this->CreateInputText($id,'input_name',$row['name'],80,255));

echo $this->ProcessTemplate('admin_edit_category.tpl');
#
# EOF
#
?>