<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(AVAILABILITY_PERM_RESOURCES) ) exit();

$this->SetCurrentTab('resources');
if( !isset($params['rsrcid']) ) 
  {
    $this->SetError($this->Lang('error_invalid_value'));
    $this->RedirectToTab($id);
  }
$rsrc_id = (int)$params['rsrcid'];

$query = 'SELECT resv_id FROM '.AVAILABILITY_TABLE_RESERVATIONS.' WHERE rsrc_id = ? LIMIT 1';
$tmp = $db->GetOne($query,$rsrc_id);
if( $tmp )
  {
    $this->SetError($this->Lang('error_cannot_delete_resource'));
    $this->RedirectToTab($id);
  }

// Get this resources info
$query = 'SELECT * FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE id = ?';
$rsrc = $db->GetRow($query,array($rsrc_id));
if( !is_array($rsrc) )
  {
    $this->SetError($this->Lang('error_cannot_delete_resource'));
    $this->RedirectToTab($id);
  }

// Delete all the resource's categories
$query = 'DELETE FROM '.AVAILABILITY_TABLE_RSRC_CATS.' WHERE rsrc_id = ?';
$db->Execute($query,array($rsrc_id));

// Delete all the resource's fields
$query = 'DELETE FROM '.AVAILABILITY_TABLE_FIELDVALS.' WHERE rsrc_id = ?';
$db->Execute($query,array($rsrc_id));

// all the custom weekday prices
$query = 'DELETE FROM '.AVAILABILITY_TABLE_RSRC_PRICES.' WHERE rsrc_id = ?';
$db->Execute($query,array($rsrc_id));

// any reservation details
//$query = 'DELETE FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.' WHERE rsrc_id = ?';
//$query = $db->Execute($query,array($rsrc_id));

// Delete the resource itself
$query = 'DELETE FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE id = ?';
$db->Execute($query,array($rsrc_id));

// And updatie the sorting.
$query = 'UPDATE '.AVAILABILITY_TABLE_RSRCS.' SET sorting=sorting-1 WHERE sorting > ?';
$db->Execute($query,array($rsrc['sorting']));

// Update search
$search =& $this->GetModuleInstance('Search');
if( $search != FALSE )
  {
    $search->DeleteWords($this->GetName(), $rsrc_id, 'resource' );
  }

$this->RedirectToTab($id);

#
# EOF
#
?>