<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

///////////////////////////
//  Add Reservation Form //
///////////////////////////

//
// functions
//

//
// Initialization
//
$feu = $this->GetModuleInstance('FrontEndUsers');
if( !$feu ) return; // could not find feu
$cust_id = $feu->LoggedInId();
$the_date = new cge_date();
$the_date->set_day($the_date->day()+1);
$the_year = '';
$the_month = '';
$the_day = '';
$resv_id = '';
$rsrc_id = '';
$resv_obj = '';
$thetemplate = 'resvn_'.$this->GetPreference(AVAILABILITY_PREF_DFLTRESVN_TEMPLATE);
$emailtemplate = $this->GetPreference(AVAILABILITY_PREF_DFLTRESVNCONFIRMEMAIL_TEMPLATE);


//
// Parameters
//

// get data from parameters
if( isset($params['resvntemplate']) )
  {
    $thetemplate = 'resvn_'.trim($params['resvntemplate']);
  }
if( isset($params['emailtemplate']) )
  {
    $thetemplate = trim($params['emailtemplate']);
  }

$session_obj = new cge_session('availability');
$the_year  = $session_obj->get('sel_year');
$the_month = $session_obj->get('sel_month');
$the_day   = $session_obj->get('sel_day');
$rsrc_id   = $session_obj->get('sel_rsrc');
$session_obj->clear();

if( isset($params['year']) )
  {
    $the_year = (int)$params['year'];
  }
if( isset($params['month']) )
  {
    $the_month = (int)$params['month'];
  }
if( isset($params['day']) )
  {
    $the_day = (int)$params['day'];
  }
if( $the_day && $the_month && $the_year )
  {
    $the_date = cge_date_utils::date_at($the_month,$the_day,$the_year);
  }
if( isset($params['rsrcid']) )
  {
    $rsrc_id = (int)$params['rsrcid'];
  }
if( isset($params['resv_id']) )
  {
    $resv_id = (int)$params['resv_id'];
  }
if( $cust_id <= 0 ) 
  {
    // redirect the user to a certain page if not logged in.
    $page = $this->GetPreference('page_redirect_notloggedin',-1);
    if( $page != -1 )
      {
	$session_obj->put('sel_url',cge_url::current_url());
	$session_obj->put('sel_day',$the_day);
	$session_obj->put('sel_month',$the_month);
	$session_obj->put('sel_year',$the_year);
	$session_obj->put('sel_rsrc',$rsrc_id);
	$this->RedirectContent($page);
      }
    else
      {
	// gotta display a message
	// and exit
	echo $this->DisplayErrorMessage($this->Lang('error_notloggedin_feu'));
	return;
      }
  }


//
// Setup
//
if( $resv_id )
  {
    // we're editing a reservation
    $resv_obj = reservation_ops::load_by_id($resv_id);
  }
else
  {
    $resv_obj = new availability_reservation();
    $resv_obj->set_customer_id($cust_id);
    $resv_obj->set_actor($feu->GetUsername($cust_id));
    $resv_obj->set_status(AVAILABILITY_STATUS_PENDING);
    if( $rsrc_id )
      {
	$part = new availability_reservation_part();
	$part->set_rsrc_id($rsrc_id);
	$part->set_start_date($the_date->to_dbformat());
	$the_end_date = clone $the_date;
	$the_end_date->set_day($the_date->day()+1);
	$part->set_end_date($the_end_date->to_dbformat());
	$resv_obj->add_part($part);
      }
  }


//
// Data validation
//

//
// Handle form submission
//
if( isset($params['avail_submit']) )
{
  $deposit_amount = 0.0;
  if( isset($params['avail_deposit_amount']) )
    {
      $deposit_amount = (float)$params['avail_deposit_amount'];
    }

  // rebuild the reservation from params..
  $resv_obj->remove_all_parts();
  $prefix = 'avail_part_';
  $total_price = 0;
  for( $pn = 1; $pn < 1000; $pn++ )
  {
    if( !isset($params[$prefix.'selrsrc_'.$pn]) )
      {
	break;
      }

    // have a valid part.
    $the_part = new availability_reservation_part();
    $the_part->set_rsrc_id($params[$prefix.'selrsrc_'.$pn]);
    $the_part->set_start_date(cge_date_utils::ts_to_dbformat($params[$prefix.'startdate_'.$pn]));
    $the_part->set_end_date(cge_date_utils::ts_to_dbformat($params[$prefix.'enddate_'.$pn]));
    $the_part->set_num_people($params[$prefix.'numpeople_'.$pn]);
    $the_part->set_price($params[$prefix.'price_'.$pn]);
    $total_price += $params[$prefix.'price_'.$pn];
    $resv_obj->add_part($the_part);
  }


  if( isset($params['avail_extra_itemid']) )
    {
      $$itemid_list = '';
      $quantity_list = '';

      if( !is_array($params['avail_extra_itemid']) )
	{
	  $itemid_list = array(trim($params['avail_extra_itemid']));
	}
      else
	{
	  $itemid_list = $params['avail_extra_itemid'];
	}
      if( isset($params['avail_extra_quantity']) && !is_array($params['avail_extra_quantity']) )
	{
	  $quantity_list = array((int)$params['avail_extra_quantity']);
	}
      else
	{
	  $quantity_list = $params['avail_extra_quantity'];
	}

      try
	{
	  for( $i = 0; $i < count($itemid_list); $i++ )
	    {
	      $paramkey = $itemid_list[$i];
	      $source = 'Products';
	      $product_id = '';
	      if( is_int($paramkey) )
		{
		  $product_id = (int)$paramkey;
		}
	      else
		{
		  list($source,$product_id) = explode(';;',$paramkey,2);
		  $product_id = (int)$product_id;
		}
	      
	      // get the product info... may throw exception.
	      $product = cg_ecomm::get_product_info($source,$product_id);

	      // get quantity info
	      $quantity = 1;
	      if( $quantity_list && isset($quantity_list[$paramkey]) )
		{
		  $quantity = (int)$quantity_list[$paramkey];
		}

	      // build the cart item... just so we can get a summary.
	      $cartitem = new cg_ecomm_cartitem($product->get_sku(),$product_id,$quantity);
	      $cartitem->set_type($product->get_type());
	      $cartitem->set_product_id($product_id);
	      $cartitem->set_unit_weight($product->get_weight());
	      $cartitem->set_base_price($product->get_price());
	      if( $tmp = $product->get_subscription() )
		$cartitem->set_subscription($product->get_subscription());

	      // see if we have attribute information for this thing.
	      $attribs = array();
	      $prefix = 'avail_extra_attrib_'.$paramkey.'x';
	      foreach( $params as $key => $value )
		{
		  if( !startswith($key,$prefix) ) continue;
		  $attr_id = (int)substr($key,strlen($prefix));
		  $attr = $product->get_attr_by_id($attr_id);
		  if( !$attr )
		    throw new Exception("Attribute $attr_id does not exist for product $product_id in source module $source");

		  $option = $attr->get_option_by_id($value);

		  //now have the product,and an attribute id.
		  $ob = new StdClass;
		  $ob->attribset = $attr->id;
		  $ob->attrname = $attr->get_name();
		  $ob->name = $option->get_text();
		  $ob->adjustment = $option->get_adjustment();
		  $ob->sku = $option->get_sku();
		  $attribs[] = $ob;
		}
	      $cartitem->set_attributes($attribs);

	      // now get summary description for this item.
	      $summary = cg_ecomm_cart::calculate_cartitem_summary($product,$attribs,$cartitem);
	      if( !$summary )
		{
		  throw new Exception("Could not get summary for product $product_id in source module $source");
		}

	      // update the total cost of this reservation with the stuff the user added on.
	      $total_price += $cartitem->get_unit_price() * $quantity;

	      // now build the 'extra' record for the reservation and attach this item to the reservation.
	      $ob = new availability_reservation_extra();
	      $ob->set_source($source);
	      $ob->set_itemid($product_id);
	      $ob->set_desc($summary);
	      $ob->set_qty($quantity);
	      $ob->set_itemamt((float)$cartitem->get_unit_price());
	      $ob->set_sku($cartitem->get_sku());
	      $resv_obj->add_extra($ob);
	    }
	}
      catch( Exception $e )
	{
	  echo $this->DisplayErrorMessage($e->GetMessage());
	  return;
	}
    }

  if( isset($params['avail_order_notes']) )
    {
      $note = trim($params['avail_order_notes']);
      if( $note )
	{
	  $the_note = new availability_reservation_note();
	  $the_note->set_text($params['avail_order_notes']);
	  $the_note->set_subject('Original Order Notes');
	  $resv_obj->add_note($the_note);
	}
    }

  // set the total price.
  $resv_obj->set_price($total_price);

  $min_deposit = (float)reservation_utils::calc_min_deposit_by_price($total_price);
  if( $deposit_amount < $min_deposit )
    {
      $status = $this->Lang('error_insufficient_deposit');
    }

  if( empty($status) )
    {
      // save it
      $resv_obj->save();
      $this->Audit('',$this->GetName(),
		   sprintf('Customer %d Created reservation %d',$cust_id,$resv_obj->get_id()));
    }

  // add it to the cart ?
  if( empty($status) && $this->GetPreference('reservation_require_deposit') )
    {
      $cart = cg_ecomm::get_cart_module();
      if( $cart )
	{
	  if( $deposit_amount > 0 )
	    {
	      $resv_obj->set_status(AVAILABILITY_STATUS_INCART);
	      $resv_obj->save();

	      $item = new cg_ecomm_cartitem('',$resv_obj->get_id(),1,$this->GetName());
	      $item->set_base_price($deposit_amount);
	      $smarty->assign('resvn_obj',$resv_obj);
	      $smarty->assign('deposit_amount',$deposit_amount);
	      $tpl = '{sitename} reservation {$resvn_obj->get_id()}';
	      $tpl2 = $this->GetPreference('reservation_deposit_summary','');
	      if( !empty($tpl2) )
		{
		  $tpl = $tpl2;
		}
	      $prefix = $this->GetPreference('reservation_sku_prefix');
	      if( $prefix )
		{
		  $item->set_sku($prefix.sprintf('%05d',$resv_obj->get_id()));
		}
	      $item->set_summary($this->ProcessTemplateFromData($tpl));
	      $item->set_item_total($total_price);
	      $item->set_type(cg_ecomm_cartitem::TYPE_SERVICE);
	      $cart->AddCartItem($item);
	    }
	}
    }

  if( empty($status) && $this->GetPreference('reservation_confirm_email_flag',1) )
    {
      // send the details email
      $tmp = '';
      $res = $this->SendReservationDetailsEmail($resv_obj->get_id(),$emailtemplate,1,$tmp);
    }
  
  if( empty($status) )
    {
      // redirect to the next action.
      $page = $this->GetPreference('reservation_confirm_page',-1);
      $showmsg = $this->GetPreference('reservation_confirm_msg',1);

      if( $page == -1 ) $page = $returnid;
      if( $showmsg )
	{
	  $params['resv_id'] = $resv_obj->get_id();
	  $this->RedirectForFrontend($id,$page,'confirm_resvn',
				     $params);
	}
      else
	{
	  $this->RedirectContent($page);
	}
    }
}

//
// Give data to smarty
//
if( !empty($status) )
  {
    $smarty->assign('status','error');
    $smarty->assign('message',$status);
  }
$reservation = reservation_ops::to_array($resv_obj);
for( $p = 0; $p < count($reservation['parts']); $p++ )
  {
    $part =& $reservation['parts'][$p];
    $rsrc = availability_utils::get_resource($part['rsrc_id']);
    if( $rsrc )
      {
	$c = '';
	switch( $rsrc['res_interval'] )
	  {
	  case 'hourly':
	    $c = ',h';
	    break;
	  case 'half_day':
	    $c = ',p';
	    break;
	  case 'daily':
	    $c = ',d';
	    break;
	  }
        $part['ext_part_type'] = $rsrc['res_interval'];
	$part['ext_rsrcid'] = $part['rsrc_id'].$c;
	$part['ext_summary'] = availability_utils::get_resource($rsrc);
      }
  }

$smarty->assign('reservation',$reservation);

$the_rsrc = $rsrc_id;
$the_type = '';
$query = 'SELECT id,name,res_interval FROM '.AVAILABILITY_TABLE_RSRCS.' WHERE active = 1';
$tmp = $db->GetArray($query);
$rsrcs = array();
$rsrcs_rev = array();
$rsrcs_rev['-1,-1'] =  $this->Lang('select_one');
$intervals = array();
$intervals['hourly'] = 'h';
$intervals['half_day'] = 'p';
$intervals['daily'] = 'd';
foreach( $tmp as $one )
{
  if( $one['id'] == $rsrc_id )
    { 
      $the_rsrc = $rsrc_id.','.$intervals[$one['res_interval']];
      $the_type = $intervals[$one['res_interval']];
    }
  $rsrcs_rev[$one['id'].','.$intervals[$one['res_interval']]] = $one['name'].' ('.$this->Lang($one['res_interval']).')';
}
$smarty->assign('rsrc_list',$rsrcs_rev);

$smarty->assign('customerid',$cust_id);
$smarty->assign('reservation_require_deposit',$this->GetPreference('reservation_require_deposit',0));
$tmp = array();
$tmp['am'] = $this->Lang('AM');
$tmp['pm'] = $this->Lang('PM');
$smarty->assign('meridians',$tmp);
if( $cust_id > 0 )
  {
    $smarty->assign('formstart',
		    $this->CGCreateFormStart($id,'addresvn',$returnid));
    $smarty->assign('formend',$this->CreateFormEnd());
    if( $resv_id > 0 )
      {
	$smarty->assign('resv_id',$resv_id);
      }
    $smarty->assign('reservation',$reservation);

    // create a list of numbers for the 'number of people' list.
    $tmp = array();
    $default_capacity = $this->GetPreference('default_capacity',50);
    for( $i = 1; $i < $default_capacity; $i++ )
      {
	$tmp[$i] = $i;
      }
    $smarty->assign('people_list',$tmp);
    $smarty->assign('numbers',$tmp);
    $smarty->assign('sel_rsrc',$the_rsrc);
    $smarty->assign('init_start_date',$the_date->to_dbformat());
    $the_end_date = clone $the_date;
    $the_end_date->set_day($the_date->day()+1);
    $smarty->assign('init_end_date',$the_end_date->to_dbformat());
    $smarty->assign('init_rsrc_type',$the_type);
  }

$tmp = get_site_preference('defaultdateformat');
if( !$tmp ) $tmp = '%b %e, %Y';
$smarty->assign('date_format',$tmp);

//
// Display the template
//
echo $this->ProcessTemplateFromDatabase($thetemplate);






#
# EOF
#
?>
