<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

///////////////////////////////////////////////////////////////////////////
// This module is derived from CGExtensions 
$cgextensions = cms_join_path($gCms->config['root_path'],'modules',
			      'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
  echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
  return;
}
require_once($cgextensions);
///////////////////////////////////////////////////////////////////////////

require_once(dirname(__FILE__).'/defines.php');

class Availability extends CGExtensions
{
  public $cached_event_types;
  public $cached_resources;
  protected $adminfuncs_loaded;
  protected $fefuncs_loaded;
  protected $commonfuncs_loaded;
  protected $searchfuncs_loaded;

  /*---------------------------------------------------------
   Constructor()
   ---------------------------------------------------------*/
  function __construct()
  {
    $this->AddImageDir('icons');
    parent::__construct();
    $this->cached_resources = NULL;
    $this->cached_event_types = NULL;
    $this->adminfuncs_loaded = false;
    $this->fefuncs_loaded = false;
    $this->commonfuncs_loaded = false;
    $this->searchfuncs_loaded = false;
  }


  /*---------------------------------------------------------
   AllowAutoInstall()
   ---------------------------------------------------------*/
  function AllowAutoInstall() {
    return FALSE;
  }


  /*---------------------------------------------------------
   AllowAutoUpgrade()
   ---------------------------------------------------------*/
  function AllowAutoUpgrade() {
    return FALSE;
  }


  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  function GetName()
  {
    return 'Availability';
  }


  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  function GetFriendlyName()
  {
    return $this->Lang('reservation_manager');
  }

	
  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  function GetVersion()
  {
    return '1.8.1';
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  function GetAuthor()
  {
    return 'calguy1000';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  function GetAuthorEmail()
  {
    return 'calguy1000@cmsmadesimple.org';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  function GetChangeLog()
  {
    $txt = @file_get_contents(dirname(__FILE__).'/changelog.inc');
    return $txt;
  }
  
  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  function IsPluginModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'content';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('module_description');
  }


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Templates') ||
      $this->CheckPermission('Modify Site Preferences') ||
      $this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS) ||
      $this->CheckPermission(AVAILABILITY_PERM_VIEWRESV) ||
      $this->CheckPermission(AVAILABILITY_PERM_EVENTS) ||
      $this->CheckPermission(AVAILABILITY_PERM_RESOURCES);
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array('CGExtensions'=>'1.25.2',
		 'CGEcommerceBase'=>'1.3.1',
		 'CGSimpleSmarty'=>'1.4',
		 'FrontEndUsers'=>'1.12.5',
		 'JQueryTools'=>'1.0.10');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.9.2";
  }
	
	
  /*---------------------------------------------------------
   GetHeaderHTML()
   ---------------------------------------------------------*/
  function GetHeaderHTML()
  {
    $txt = <<<EOT
<style type="text/css">
.avail_cell a {
  text-decoration: none;
}
.avail_cell a:hover {
  text-decoration: none;
}
.resvn_change_notes {
  height: 3em;
}
#reservation_history {
  color: #000;
  background-color: yellow;
  width:  400px;
  height: 400px;
}
.history_item {
  border-bottom: 1px solid #999;
  margin-bottom: 1em;
}
.history_item_name {
  width: 48%;
  float: left;
}
.history_item_when {
  width: 48%;
  float: left;
}
.history_item_clear {
  clear: both;
  margin-bottom: 0.5em;
}
</style>
EOT;

    $obj =& $this->GetModuleInstance('JQueryTools');
    if( is_object($obj) )
      {
$tmpl = <<<EOT
{JQueryTools action='incjs' exclude='form'}
{JQueryTools action='ready'}
EOT;
        $txt .= $this->ProcessTemplateFromData($tmpl);
      }

    $fmt = '<script type="text/javascript" src="%s"></script>'."\n";
    
    global $gCms;
    $config = $gCms->GetConfig();
    $url = $config['root_url'].'/modules/Availability/lib/php_js.js';
    $txt .= sprintf($fmt,$url);

    return $txt;
  }	

  /*---------------------------------------------------------
  /*---------------------------------------------------------
   SetParameters()
   ---------------------------------------------------------*/
  function SetParameters()
  {
    $this->RestrictUnknownParams();
    $this->RegisterModulePlugin();

    $this->RegisterRoute('/'.$this->GetResourceType().'\/(?P<returnid>[0-9]+)\/(?P<rsrcid>[0-9]+)$/',
			 array('action'=>'detail'));
    $this->RegisterRoute('/'.$this->GetResourceType().'\/(?P<returnid>[0-9]+)\/(?P<rsrcid>[0-9]+)\/(?P<junk>.*?)$/',
			 array('action'=>'detail'));
    $this->RegisterRoute('/'.$this->GetResourceType().'\/reservation\/(?P<returnid>[0-9]+)$/',
			 array('action'=>'addresvn'));
    $this->RegisterRoute('/'.$this->GetResourceType().'\/viewresvn\/(?P<returnid>[0-9]+)\/(?P<resv_id>[0-9]+)$/',
			 array('action'=>'addresvn'));
    $this->RegisterRoute('/'.$this->GetResourcetype().'\/day\/(?P<returnid>[0-9]+)\/(?P<year>[0-9]+)-(?P<month>[0-9]+)-(?P<day>[0-9]+)$/',
			 array('action'=>'dayview'));
    $this->RegisterRoute('/'.$this->GetResourcetype().'\/day\/(?P<returnid>[0-9]+)\/(?P<rsrcid>[0-9]+)\/(?P<year>[0-9]+)-(?P<month>[0-9]+)-(?P<day>[0-9]+)$/',
			 array('action'=>'dayview'));
    $this->RegisterRoute('/'.$this->GetResourcetype().'\/reserve\/(?P<returnid>[0-9]+)\/(?P<rsrcid>[0-9]+)\/(?P<year>[0-9]+)-(?P<month>[0-9]+)-(?P<day>[0-9]+)$/',
			 array('action'=>'addresvn'));

    $this->CreateParameter('action','default',$this->Lang('help_action'));
    $this->SetParameterType('daytemplate',CLEAN_STRING);
    $this->CreateParameter('daytemplate','',$this->Lang('help_daytemplate'));
    $this->SetParameterType('detailpage',CLEAN_STRING);
    $this->CreateParameter('detailpage','',$this->Lang('help_detailpage'));
    $this->SetParameterType('detailtemplate',CLEAN_STRING);
    $this->CreateParameter('detailtemplate','',$this->Lang('help_detailtemplate'));
    $this->SetParameterType('summarytemplate',CLEAN_STRING);
    $this->CreateParameter('summarytemplate','',$this->Lang('help_summarytemplate'));
    $this->SetParameterType('calendartemplate',CLEAN_STRING);
    $this->CreateParameter('calendartemplate','',$this->Lang('help_calendartemplate'));
    $this->SetParameterType('resvntemplate',CLEAN_STRING);
    $this->CreateParameter('resvntemplate','',$this->Lang('help_resvntemplate'));
    $this->SetParameterType('emailtemplate',CLEAN_STRING);
    $this->CreateParameter('emailtemplate','',$this->Lang('help_emailtemplate'));
    $this->SetParameterType('confirmtemplate',CLEAN_STRING);
    $this->CreateParameter('confirmtemplate','',$this->Lang('help_confirmtemplate'));
    $this->SetParameterType('myresvtemplate',CLEAN_STRING);
    $this->CreateParameter('myresvtemplate','',$this->Lang('help_myresvtemplate'));
    $this->SetParameterType('sendemailtemplate',CLEAN_STRING);
    $this->CreateParameter('sendemailtemplate','',$this->Lang('help_sendemailtemplate'));

    $this->SetParameterType('pagelimit',CLEAN_INT);
    $this->CreateParameter('pagelimit','100000',$this->Lang('help_pagelimit'));
    $this->SetParameterType('showall',CLEAN_INT);
    $this->CreateParameter('showall','0',$this->Lang('help_showall'));
    $this->SetParameterType('sortby',CLEAN_STRING);
    $this->CreateParameter('sortby','',$this->Lang('help_sortby'));
    $this->SetParameterType('sortorder',CLEAN_STRING);
    $this->CreateParameter('sortorder','',$this->Lang('help_sortorder'));
    $this->SetParameterType('rsrcid',CLEAN_INT);
    $this->CreateParameter('rsrcid','',$this->Lang('help_rsrcid'));
    $this->SetParameterType('resv_id',CLEAN_INT);
    $this->CreateParameter('resv_id','',$this->Lang('help_resv_id'));

    $this->SetParameterType('category',CLEAN_STRING);
    $this->CreateParameter('category','',$this->Lang('help_category'));
    $this->SetParameterType('resources',CLEAN_STRING);
    $this->CreateParameter('resources','',$this->Lang('help_resources'));
    $this->SetParameterType('month',CLEAN_INT);
    $this->CreateParameter('month','',$this->Lang('help_month'));
    $this->SetParameterType('year',CLEAN_INT);
    $this->CreateParameter('year','',$this->Lang('help_year'));
    $this->SetParameterType('day',CLEAN_INT);
    $this->CreateParameter('day','',$this->Lang('help_day'));

    $this->SetParameterType('searchtemplate',CLEAN_STRING);
    $this->CreateParameter('searchtemplate','',$this->Lang('help_searchtemplate'));
    $this->SetParameterType('inline',CLEAN_INT);
    $this->CreateParameter('inline',0,$this->Lang('help_inline'));
    $this->SetParameterType('summarypage',CLEAN_STRING);
    $this->CreateParameter('summarypage','',$this->Lang('help_summarypage'));
//     $this->SetParameterType('startdate',CLEAN_STRING);
//     $this->CreateParameter('startdate','',$this->Lang('help_startdate'));
//     $this->SetParameterType('enddate',CLEAN_STRING);
//     $this->CreateParameter('enddate','',$this->Lang('help_enddate'));


    $this->SetParameterType('pagenum',CLEAN_INT);
    $this->SetParameterType('junk',CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP.'/avail_.*/',CLEAN_NONE);
  }


  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  function UninstallPreMessage()
  {
    return $this->Lang('ask_really_uninstall');
  }	


  /*---------------------------------------------------------
   HandlesEvents()
   ---------------------------------------------------------*/
  function HandlesEvents()
  {
    return TRUE;
  }	


  /*---------------------------------------------------------
   LazyLoadAdmin()
   ---------------------------------------------------------*/
  function LazyLoadAdmin()
    {
      if( $this->adminfuncs_loaded == false )
	{
	  require_once(dirname(__FILE__).'/functions.admin_tools.php');
	  $this->adminfuncs_loaded = true;
	}
    }


  /*---------------------------------------------------------
   LazyLoadFrontend()
   ---------------------------------------------------------*/
  function LazyLoadFrontend()
    {
      if( $this->fefuncs_loaded == false )
	{
	  require_once(dirname(__FILE__).'/functions.frontend_tools.php');
	  $this->fefuncs_loaded = true;
	}
    }


  /*---------------------------------------------------------
   LazyLoadCommon()
   ---------------------------------------------------------*/
  function LazyLoadCommon()
    {
      if( $this->commonfuncs_loaded == false )
	{
	  require_once(dirname(__FILE__).'/functions.common_tools.php');
	  $this->commonfuncs_loaded = true;
	}
    }


  /*---------------------------------------------------------
   LazyLoadSearch()
   ---------------------------------------------------------*/
  function LazyLoadSearch()
    {
      if( $this->searchfuncs_loaded == false )
	{
	  require_once(dirname(__FILE__).'/functions.search_tools.php');
	  $this->searchfuncs_loaded = true;
	}
    }



  /*---------------------------------------------------------
   GetTypesDropdown()
   ---------------------------------------------------------*/
  function GetTypesDropdown( $id, $name, $selected = '', $addtext = '', $selectone = false )
  {
    $this->LazyLoadAdmin();
    return availability_GetTypesDropdown($this,$id,$name,$selected,
					 $addtext,$selectone);
  }


  /*---------------------------------------------------------
   GetResourcetype()
   ---------------------------------------------------------*/
  function GetResourceType($plural = false)
  {
    $this->LazyLoadAdmin();
    return availability_GetResourceType($this,$plural);
  }


  /*---------------------------------------------------------
   HandleImageUpload()
   ---------------------------------------------------------*/
  function HandleFileUpload($id,$name,$record_id,&$value,&$result)
  {
    $this->LazyLoadAdmin();
    return availability_HandleFileUpload($this,$id,$name,$record_id,
					 $value,$result);
  }


  /*---------------------------------------------------------
   HandleImageUpload()
   ---------------------------------------------------------*/
  function HandleImageUpload($id,$name,$record_id,&$value,&$result)
  {
    $this->LazyLoadAdmin();
    return availability_HandleImageUpload($this,$id,$name,$record_id,
					  $value,$result);
  }


  /*---------------------------------------------------------
   HandleFileDelete()
   ---------------------------------------------------------*/
  function HandleImageDelete($id,$record_id,$value)
  {
    $this->LazyLoadAdmin();
    return availability_HandleImageDelete($this,$id,$record_id,$value);
  }


  /*---------------------------------------------------------
   HandleFileDelete()
   ---------------------------------------------------------*/
  function HandleFileDelete($id,$record_id,$value)
  {
    $this->LazyLoadAdmin();
    return availability_HandleFileDelete($this,$id,$record_id,$value);
  }


  /*---------------------------------------------------------
   _loadEventTypes()
   ---------------------------------------------------------*/
  function _loadEventTypes()
  {
    $this->LazyLoadAdmin();
    return availability_LoadEventTypes($this);
  }


  /*---------------------------------------------------------
   GetEventTypeFromID()
   ---------------------------------------------------------*/
  function GetEventTypeFromID($event_id)
  {
    $this->LazyLoadAdmin();
    return availability_GetEventTypeFromID($this,$event_id);
  }


  /*---------------------------------------------------------
   GetEventTypeDropdownList()
   ---------------------------------------------------------*/
  function GetEventTypeDropdownList($any = false)
  {
    $this->LazyLoadAdmin();
    return availability_GetEventTypeDropdownList($this,$any);
  }


  /*---------------------------------------------------------
   HaveResources()
   ---------------------------------------------------------*/
  function HaveResources()
  {
    $db =& $this->GetDb();
    $query = 'SELECT id FROM '.AVAILABILITY_TABLE_RSRCS.' LIMIT 1';
    $tmp = $db->GetOne($query);
    if( $tmp ) return true;
    return false;
  }


  /*---------------------------------------------------------
   HasEventTypes()
   ---------------------------------------------------------*/
  function HaveEventTypes()
  {
    $db =& $this->GetDb();
    $query = 'SELECT id FROM '.AVAILABILITY_TABLE_EVENT_TYPES.' LIMIT 1';
    $tmp = $db->GetOne($query);
    if( $tmp ) return true;
    return false;
  }


  /*---------------------------------------------------------
   CanContactCustomers();
   ---------------------------------------------------------*/
  function CanContactCustomers()
  {
    return $this->CheckPermission(AVAILABILITY_PERM_CONTACTCUSTOMER) ||
      $this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS);
  }


  /*---------------------------------------------------------
   CanViewReservations();
   ---------------------------------------------------------*/
  function CanViewReservations()
  {
    return $this->CheckPermission(AVAILABILITY_PERM_VIEWRESV) ||
      $this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS);
  }


  /*---------------------------------------------------------
   CanEditReservations();
   ---------------------------------------------------------*/
  function CanEditReservations()
  {
    return $this->CheckPermission(AVAILABILITY_PERM_RESERVATIONS);
  }


  /*---------------------------------------------------------
   GetUserDetails($uid)
   * Get the email address, and full name
   * for the user, and place them into an array
   * NOTE: This function should be removed.
   ---------------------------------------------------------*/
  function GetUserDetails($uid)
  {
    $this->LazyLoadAdmin();
    return availability_GetUserDetails($this,$uid);
  }


  /*---------------------------------------------------------
   GetUserObject($custid)
   ---------------------------------------------------------*/
  function &GetUserObject($custid)
  {
    $this->LazyLoadCommon();
    return availability_GetUserObject($this,$custid);
  }


  /*---------------------------------------------------------
   GetUserDropdownList()
   ---------------------------------------------------------*/
  function GetUserDropdownList()
  {
    $this->LazyLoadAdmin();
    return availability_GetUserDropdownList($this);
  }


  /*---------------------------------------------------------
   AdjustPrice($price,$adjustment)
   ---------------------------------------------------------*/
  function AdjustPrice($price,$adjustment)
  {
    $this->LazyLoadCommon();
    return availability_AdjustPrice($this,$price,$adjustment);
  }


  /*---------------------------------------------------------
   CalculateReservationParts($reservation,$resources,&$parts)
   ---------------------------------------------------------*/
  function CalculateReservationParts(&$reservation)
  {
    $this->LazyLoadCommon();
    return availability_CalculateReservationParts($this,$reservation);
  }


  /*---------------------------------------------------------
   CalculateReservationPrice()
   ---------------------------------------------------------*/
  function CalculateReservationPrice(&$reservation)
  {
    $this->LazyLoadCommon();
    return availability_CalculateReservationPrice($this,$reservation);
  }


  /*---------------------------------------------------------
   CheckReservationConflicts()
   ---------------------------------------------------------*/
  function CheckReservationConflicts($reservation)
  {
    $this->LazyLoadCommon();
    return availability_CheckReservationConflicts($this,$reservation);
  }


  /*---------------------------------------------------------
   AdjustReservationPartInterval($rsrc_id,$start_time,$end_time,$meridian)
   ---------------------------------------------------------*/
  function  AdjustReservationPartInterval2(&$rsrc,$start_time,$end_time,$meridian = '')
  {
    $this->LazyLoadCommon();
    return availability_AdjustReservationPartInterval2($this,$rsrc,$start_time,$end_time,$meridian);
  }


  /*---------------------------------------------------------
   AdjustReservationPartInterval($rsrc_id,$start_time,$end_time,$meridian)
   ---------------------------------------------------------*/
  function  AdjustReservationPartInterval($rsrc_id,$start_time,$end_time,$meridian)
  {
    $this->LazyLoadCommon();
    return availability_AdjustReservationPartInterval($this,$rsrc_id,$start_time,$end_time,$meridian);
  }

  function merge_date($exp_date,$newtime)
  {
    $tmp = $exp_date;
    list($h1,$m1) = explode(':',$newtime);
    $tmp['hour'] = $h1;
    $tmp['minutes'] = $m1;
    return $tmp;
  }


  /*---------------------------------------------------------
   GetAttributesForRsrc
   ---------------------------------------------------------*/
  function GetAttributesForRsrc($rsrc_id)
    {
      $this->LazyLoadFrontend();
      return availability_GetAttributesForRsrc($this,$rsrc_id);
    }


  /*---------------------------------------------------------
   GetFieldsForRsrc
   ---------------------------------------------------------*/
  function GetFieldsForRsrc($rsrc_id)
    {
      $this->LazyLoadFrontend();
      return availability_GetFieldsForRsrc($this,$rsrc_id);
    }


  /*---------------------------------------------------------
   GetAttributeIDs
   ---------------------------------------------------------*/
  function GetAttributeIDs($data)
    {
      $this->LazyLoadFrontend();
      return availability_GetAttributeIDs($this,$data);
    }



  /*---------------------------------------------------------
   GetReservationURL()
   ---------------------------------------------------------*/
  function GetReservationURL($id,$pageid,$rsrcid,$month,$day,$year,$title='',$params=array(),$link = false)
  {
    $prettyurl = $this->GetResourceType().sprintf("/reserve/%d/%d/%04d-%02d-%02d",$pageid,$rsrcid,$year,$month,$day);
    $params['rsrcid'] = $rsrcid;
    $params['day'] = $day;
    $params['month'] = $month;
    $params['year'] = $year;
    $txt = '';
    if( $link === false || empty($title))
      {
	$txt = $this->CreateURL($id,'addresvn',$pageid,$params,false,$prettyurl);
      }
    else
      {
	$txt = $this->CreateURL($id,'addresvn',$pageid,$title,$params,'',false,false,'',false,$prettyurl);
      }
    return $txt;
  }


  /*---------------------------------------------------------
   GetDayViewURL()
   ---------------------------------------------------------*/
  function GetDayViewURL($id,$pageid,$month,$day,$year,$title='',$params=array(),$link = false)
  {
    $prettyurl = '';
    if( isset($params['rsrcid']) )
      {
	$prettyurl = $this->GetResourceType().sprintf("/day/%d/%d/%04d-%02d-%02d",$pageid,$params['rsrcid'],$year,$month,$day);
      }
    else
      {
	$prettyurl = $this->GetResourceType().sprintf("/day/%d/%04d-%02d-%02d",$pageid,$year,$month,$day);
      }
    $params['day'] = $day;
    $params['month'] = $month;
    $params['year'] = $year;
    $txt = '';
    if( $link === false || empty($title))
      {
	$txt = $this->CreateURL($id,'dayview',$pageid,$params,false,$prettyurl);
      }
    else
      {
	$txt = $this->CreateURL($id,'dayview',$pageid,$title,$params,'',false,false,'',false,$prettyurl);
      }
    return $txt;
  }


  /*---------------------------------------------------------
   GetResourceDetailURL
   ---------------------------------------------------------*/
  function GetResourceDetailURL($id,$pageid,$rsrcid,$title='',$parameters = array(),$link = false)
    {
      $prettyurl = $this->GetResourceType()."/$pageid/$rsrcid";
      if( !empty($title) )
	{
	  $prettyurl .= "/".munge_string_to_url($title);
	}

      $parameters['rsrcid'] = $rsrcid;
      $txt = '';
      if( $link === false || empty($title))
	{
	  $txt = $this->CreateURL($id,'detail',$pageid,$parameters,false,$prettyurl);
	}
      else
	{
	  $txt = $this->CreateLink($id,'detail',$pageid,$title,$parameters,
				   '',false,false,'',false,$prettyurl);
	}
      return $txt;
    }


  /*---------------------------------------------------------
   SendReservationDetailsEmail
   ---------------------------------------------------------*/
  function SendReservationDetailsEmail($resvn_id,$template,$logit,&$error)
  {
    $this->LazyLoadCommon();
    return availability_SendReservationDetailsEmail($this,$resvn_id,$template,$logit,$error);
  }


  /*---------------------------------------------------------
   GetResource
   deprecated.
   ---------------------------------------------------------*/
  function GetResource($rsrc_id)
  {
    return availability_utils::get_resource($rsrc_id);
  }


  /*---------------------------------------------------------
   GetResourceSummary
   ---------------------------------------------------------*/
  function GetResourceSummary(&$rsrc)
  {
    $this->LazyLoadCommon();
    return availability_GetResourceSummary($this,$rsrc);
  }


  /*---------------------------------------------------------
   is_taxable()
   ---------------------------------------------------------*/
  function is_taxable($resvn_id)
  {
    // todo: add preferences here.
    return TRUE;
  }


  /*---------------------------------------------------------
   is_shippable($resvn_id)
   ---------------------------------------------------------*/
  function is_shippable($resvn_id)
  {
    return FALSE;
  }


  /*---------------------------------------------------------
   GetReservationAttribute
   ---------------------------------------------------------*/
  function GetReservationAttribute($resvn_id,$attrib,$dflt = '')
  {
    $this->LazyLoadCommon();
    return availability_GetReservationAttribute($this,$resvn_id,$attrib,$dflt);
  }


  /*---------------------------------------------------------
   SetReservationAttribute
   ---------------------------------------------------------*/
  function SetReservationAttribute($resvn_id,$attrib,$value)
  {
    $this->LazyLoadCommon();
    return availability_SetReservationAttribute($this,$resvn_id,$attrib,$value);
  }


  /*---------------------------------------------------------
   GetAdminCCList()
   ---------------------------------------------------------*/
  function GetAdminCCList()
  {
    $this->LazyLoadCommon();
    return availability_GetAdminCCList($this);
  }


  /*---------------------------------------------------------
   SearchResult()
   ---------------------------------------------------------*/
  function SearchResult($returnid, $articleid, $attr = '')
  {
    $this->LazyLoadFrontend();
    return availability_SearchResult($this,$returnid, $articleid, $attr);
  }


  /*---------------------------------------------------------
   SearchReIndex()
   ---------------------------------------------------------*/
  function SearchReindex(&$searchmodule)
  {
    $this->LazyLoadAdmin();
    return availability_SearchReindex($this,$searchmodule);
  }


  /*---------------------------------------------------------
   DoAdvancedSearch()
   ---------------------------------------------------------*/
  function GetNumSlots($resources = '',$startdate = '',$enddate = '')
  {
    $this->LazyLoadCommon();
    return availability_CalcNumSlots($resources,$startdate,$enddate);
  }


  /*---------------------------------------------------------
   DoAdvancedSearch()
   ---------------------------------------------------------*/
  function DoAdvancedSearch($searchparms)
  {
    $this->LazyLoadSearch();
    return availability_AdvancedSearch($this,$searchparms);
  }


  /*---------------------------------------------------------
   get_product_info()
   ---------------------------------------------------------*/
  function get_product_info($resvn_id)
  {
    // this is just temporary...
    // fill this in with real reservation info
    // and map into a product.
    $res = array();
    $res['id'] = $resvn_id;
    $res['product_name'] = 'Reservation'; 
    return $res;
  }

} // class

?>
