<?php

if (!isset($gCms)) exit;

if (!$this->CheckPermission('Modify Site Preferences')) {
  echo $this->ShowErrors($this->Lang('needpermission', array('Modify Site Preferences')));
  return;
}

if (isset($params["examplesyntax"])) {
  $this->SetPreference("examplesyntax",$params["examplesyntax"]);
}

echo $this->StartTabHeaders();
echo $this->SetTabHeader("settings",$this->Lang("settingstab"));

echo $this->EndTabHeaders();
echo $this->StartTabContent();


echo $this->StartTab("settings");
$this->smarty->assign('startform', $this->CreateFormStart($id, 'savesettings', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());

$this->smarty->assign('showlinenumberstext', $this->Lang("showlinenumbers"));
$this->smarty->assign('showlinenumbersinput', $this->CreateInputCheckbox($id,"showlinenumbers",1,$this->GetPreference("showlinenumbers",1)));

$this->smarty->assign('cssadditionstext', $this->Lang("cssadditions"));
$this->smarty->assign('cssadditionsinput', $this->CreateInputText($id,"cssadditions",$this->GetPreference("cssadditions",$this->_defaultcssadditions),"60"));

/*$this->smarty->assign('textwrappingtext', $this->Lang("textwrapping"));
$this->smarty->assign('textwrappinginput', $this->CreateInputCheckbox($id,"textwrapping",1,$this->GetPreference("textwrapping",1)));
*/
/*$this->smarty->assign('automatchparenstext', $this->Lang("automatchparens"));
$this->smarty->assign('automatchparensinput', $this->CreateInputCheckbox($id,"automatchparens","1",$this->GetPreference("automatchparens","0")));
*/
$this->smarty->assign('tabhandlingtext', $this->Lang("tabhandling"));
$tabfunctions=array(
  $this->Lang("tabdefault")=>"default",
  $this->Lang("tabindent")=>"indent",
  $this->Lang("tabspaces")=>"classic",
  $this->Lang("tabshift")=>"shift"
);
$this->smarty->assign('tabhandlinginput', $this->CreateInputDropdown($id,"tabhandling",$tabfunctions,-1,$this->GetPreference("tabhandling","indent")));

$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('savesettings')));

echo $this->ProcessTemplate('settings.tpl');

echo $this->EndTab();
echo $this->EndTabContent();

$content="";
switch ($this->GetPreference("examplesyntax","html")) {
  case "html" : {
    $content="
<html>
  <head>
    <title>Testing html-syntax</title>
  </head>
  <body>
    And doing absolutely nothing else
  </body>
</html>
";
  break;
  }
  case "css" : {
    $content="
.testcss {
  font-weight:bold;
  height: 10px;
}
";
  break;
  }
  case "php" : {
    $content="
<?php
  function testPHP(\$someparam) {
    echo 'Do you think this looks nice?';
  }
?>
";
  break;
  }
  case "js" : {
    $content='
function myjsfuntion(params) {
  var msg = "This javascript is fantastic!"
  for (var i=0; i<9999; i++) {
    alert(msg);
    /*This must be the most annoying function ever!*/
  }
  return true
}
';
  break;
  }
}

echo $this->CreateFormStart($id,"defaultadmin");
echo $this->Lang("examplesyntax").": ";
$syntaxes=array($this->Lang("htmltest")=>"html",$this->Lang("csstest")=>"css",$this->Lang("phptest")=>"php",$this->Lang("jstest")=>"js");
echo $this->CreateInputDropdown($id,"examplesyntax",$syntaxes,-1,$this->GetPreference("examplesyntax","html"),"onchange='this.form.submit()'");
//echo $this->CreateInputSubmit($id,"examplesubmit",$this->Lang("change"));
echo "<br/>";
echo $this->CreateTextArea(false,$id,$content,"testarea1",'','','','','','','CodeMirror',$this->GetPreference("examplesyntax","html"));
echo $this->CreateFormEnd();





?>