<?php
#CMS - CMS Made Simple
#(c)2005-06 by Morten Poulsen (morten@poulsen.org)
#This project's homepage is: http://www.cmsmadesimple.org
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


class CodeMirror extends CMSModule {
	var $noeditors=0;
	var $headerinfosent=false;
  var $_htmlactive = false;
  var $_javascriptactive = false;
  var $_cssactive = false;
  var $_phpactive = false;
  var $_defaultcssadditions = ".CodeMirror {line-height: 1.3em; font-size:11px}";

	function GetName() {
		return 'CodeMirror';
	}

	function IsPluginModule() {
		return false;
	}

	function HasAdmin() {
		return true;
	}

	function GetHelp() {
		return $this->Lang("help");
	}

	function GetAuthor() {
		return 'Morten Poulsen';
	}

	function GetAuthorEmail() {
		return '&lt;morten@poulsen.org&gt;';
	}

	function GetChangeLog() {
		return $this->ProcessTemplate('changelog.tpl');
	}

	function GetVersion() {
		return '2.0.1';
	}
	
	function MinimumCMSVersion() {
		return "1.9";
	}

  function HasCapability($capability, $params=array()) {
    if ($capability=="wysiwyg") return true;
    if ($capability=="syntaxhighlighting") return true;
    return false;
  }

	function IsWYSIWYG() {
		return true;
	}

	function IsSyntaxHighlighter() {
		return true;
	}

	function VisibleToAdminUser() {
		return $this->CheckPermission('Modify Site Preferences');
	}

	function SyntaxPageFormSubmit() {
		return "for (var cntEditor = 0; cntEditor < numCodeMirrorAreas; cntEditor++) {\n"
		. "\t\tvar editor = eval('codemirroreditor' + cntEditor);\n"
    . "\t\tvar textarea = document.getElementById('codemirrorarea' + cntEditor);\n"
      //."alert(editor.getCode());"
		//. "\t\teditor.textarea.value = editor.getCode();\n"
      . "\t\ttextarea.value = editor.getValue();\n"
		. "\t}\n";
	}
	
	function WYSIWYGPageFormSubmit() {
		return $this->SyntaxPageFormSubmit();
	}

	function WYSIWYGTextArea($name='textarea',$columns='80',$rows='15',$encoding='',$content='',$stylesheet='',$addtext='') {
		$this->wysiwygactive=true;
		return $this->SyntaxTextarea($name,"html",$columns,$rows,$encoding,$content);
	}

	function SyntaxTextarea($name='textarea',$syntax="html",$columns='80',$rows='15',$encoding='',$content='',$stylesheet='',$addtext='') {
		$textarea="";
		$this->syntaxactive=true;	
		/*if ($this->GetPreference("useautocomplete","1")=="0") $class.=" autocomplete-off";
		if ($this->GetPreference("showlinenumbers","1")=="0") $class.=" linenumbers-off";
		*/
      /*if ($this->GetPreference("showtogglesyntax","1")=="1") {
     
			$textarea.="<br/><input type='checkbox' checked='1' onclick='codepress".$this->noeditors.".toggleEditor();' checked='checked' id='codepresscheck".$this->noeditors."'><label for='codepresscheck".$this->noeditors."'>".$this->Lang("togglesyntax")."</label>";
		}*/
    $smarty=$this->smarty;
    if ($this->GetPreference("showlinenumbers","1")=="1"){
      $smarty->assign('linenumbers', "true");
    } else {
      $smarty->assign('linenumbers', "false");
    }
    if ($this->GetPreference("textwrapping","1")=="1"){
      $smarty->assign('textwrapping', "true");
    } else {
      $smarty->assign('textwrapping', "false");
    }
    if ($this->GetPreference("automatchparens","0")=="1"){
      $smarty->assign('automatchparens', "true");
    } else {
      $smarty->assign('automatchparens', "false");
    }
    //lineNumbers: true,
    //$config=$this->GetConfig();
    $config=cmsms()->GetConfig();

    $smarty->assign('textareaid', "codemirrorarea".$this->noeditors);
    $smarty->assign('textareaname', $name);
    $smarty->assign('content', $content);
    $smarty->assign('id', $this->noeditors);
    //$parserfile=""; $cssfile="";
    /*$cmdir=$config["root_url"].'/modules/CodeMirror/codemirror';
    switch($syntax) {
      
      case "html" : 
        $parserfile='"parsexml.js"'; 
        $cssfile='"'.$cmdir.'/mode/xml/xml.css"';
        break;
      case "css" :
        $parserfile='"parsecss.js"';
        $cssfile='"'.$cmdir.'/css/css.css"';
        break;
      case "javascript" :
      case "js" :
        $parserfile='["tokenizejavascript.js", "parsejavascript.js"]';
        $cssfile='"'.$cmdir.'/css/jscolors.css"';
        break;
      case "php" :
        $parserfile='["parsexml.js", "parsecss.js", "tokenizejavascript.js", "parsejavascript.js", "parsehtmlmixed.js","../contrib/php/js/tokenizephp.js", "../contrib/php/js/parsephp.js",                     "../contrib/php/js/parsephphtmlmixed.js"]';
        $cssfile='["'.$cmdir.'/css/xmlcolors.css","'.$cmdir.'/css/jscolors.css","'.$cmdir.'/css/csscolors.css","'.$cmdir.'/contrib/php/css/phpcolors.css"]';
        break;
    }*/
    //$this->smarty->assign('parserfile', $parserfile);
    //$this->smarty->assign('cssfile', $cssfile);

    $smarty->assign('tabhandling', $this->GetPreference("tabhandling","indent"));
    
    $smarty->assign('root_url', $config["root_url"]);

    switch ($syntax) {
      case "html" : $smarty->assign('mode', "htmlmixed"); $this->_htmlactive=true; break;
      case "js":
      case "javascript" : $smarty->assign('mode', "javascript");$this->_javascriptactive=true;  break;
      case "css" : $smarty->assign('mode', "css"); $this->_cssactive=true; break;
      case "php" : $smarty->assign('mode', "php"); $this->_phpactive=true; break;
    }


    $textarea=$this->ProcessTemplate('codemirror2area.tpl');

		$this->noeditors++;

		return $textarea;
	}

	function WYSIWYGGenerateHeader($htmlresult='') {
		return $this->SyntaxGenerateHeader();
	}

	function SyntaxGenerateHeader($htmlresult='') {
		if ($this->headerinfosent) return "";
		if ($this->noeditors==0) return '';
		//$GLOBALS["config"]["root_path"].
    $config=cmsms()->GetConfig();

		$scriptpath=$config["root_url"]."/modules/CodeMirror/codemirror2";
		$header="";
		$header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/lib/codemirror.js"></script>';
    $header.='<link rel="stylesheet" type="text/css" href="'.$scriptpath.'/lib/codemirror.css"/>';
    
    if ($this->_htmlactive) {
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/htmlmixed/htmlmixed.js"></script>';
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/css/css.js"></script>';
      $header.='<link rel="stylesheet" type="text/css" href="'.$scriptpath.'/mode/css/css.css" />';
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/javascript/javascript.js"></script>';
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/xml/xml.js"></script>';
      $header.='<link rel="stylesheet" type="text/css" href="'.$scriptpath.'/mode/xml/xml.css" />';
    }
    if ($this->_javascriptactive) {
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/javascript/javascript.js"></script>
      <link rel="stylesheet" type="text/css" href="'.$scriptpath.'/mode/javascript/javascript.css" />
      ';
    }
    if ($this->_cssactive) {
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/css/css.js"></script>
      <link rel="stylesheet" type="text/css" href="'.$scriptpath.'/mode/css/css.css" />
      ';
    }
    if ($this->_phpactive) {

      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/css/css.js"></script>';
      $header.='<link rel="stylesheet" type="text/css" href="'.$scriptpath.'/mode/css/css.css" />';
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/javascript/javascript.js"></script>';
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/xml/xml.js"></script>';
      $header.='<link rel="stylesheet" type="text/css" href="'.$scriptpath.'/mode/xml/xml.css" />';
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/clike/clike.js"></script>';
      $header.='<link rel="stylesheet" type="text/css" href="'.$scriptpath.'/mode/clike/clike.css" />';
      $header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'/mode/php/php.js"></script>';
    }

    $header.='<script language="Javascript" type="text/javascript">var numCodeMirrorAreas='.$this->noeditors.'</script>';

    $header.='
<style type="text/css">
  '.$this->GetPreference("cssadditions",$this->_defaultcssadditions).'
</style>
    ';



		$this->headerinfosent=true;
		return $header;
	}
}

?>