{literal}
<script type="text/javascript">
//<![CDATA[
function selectAll(obj) {
	checkboxes = document.getElementsByClassName("logs");
	if (obj.value == 1) {
		check = true;
		obj.value = 0;
	}
	else {
		check = false;
		obj.value = 1;
	}
	for (i=0; i<checkboxes.length ; i++) {
		if (checkboxes[i].type == "checkbox")
			checkboxes[i].checked=check;
	}
}

function toggleActive(id) {
	document.getElementById(id).style.display = (document.getElementById(id).style.display == "block") ? "none" : "block";
	document.getElementById(id).style.visibility = (document.getElementById(id).style.visibility == "visible") ? "collapse" : "visible";
}
//]]>
</script>

{/literal}
<h3>{$heading}</h3>
{if isset($errormessage) && $errormessage!=''}
<div class="pageerrorcontainer">
	<div class="pageoverflow">
		<ul class="pageerror"><li>{$errormessage}</li></ul>
	</div>
</div>
{/if}
{if isset($message) && $message!=''}
<div class="pagemcontainer">
	<div class="pageoverflow">
		<p>{$message}</p>
	</div>
</div>
{/if}

<fieldset>
<legend>{$filter_text}:</legend>
<div class="pageoverflow">
	<div class="pageoptions">
		{$startFilterForm}
		<p>{$sortby_text}: {$sort_by} | {$sort_order} | {$limit_text}: {$limit} | {$errorsonly_text}: {$errors_only} | {$savefilter_text}: {$savefilter} | {$submit}</p>
		{$endForm}

	</div>
</div>
</fieldset>
<br />
{if $currentlogs_count>0}
{$startLogsForm}
<div class="pageoverflow">
	<div class="pageinput">
		<p>{$cancel}&nbsp;{$resend_all}{if isset($resend_new)}&nbsp;{$resend_new}{/if}{if isset($resend_errors)}&nbsp;{$resend_errors}{/if}&nbsp;{$resend_selected}</p>
	</div>
</div>
<div class="pageoverflow">
	<p class="pagetext">{$subject_text}:</p>
	<p class="pageinput">{$subject}</p>
</div>
<div class="pageoverflow">
	<p class="pagetext">{$sentby_text}:</p>
	<p class="pageinput">{$sentby}</p>
</div>
<div class="pageoverflow">
	<p class="pagetext">{$groups_text}:</p>
	<p class="pageinput">{$groups}</p>
</div>
<div class="pageoverflow">
	<p class="pagetext">{$totallogs_text}:</p>
	<p class="pageinput">{$totallogs_count}</p>
</div>
<div class="pageoverflow">
	<p class="pagetext">{$errorlogs_text}:</p>
	<p class="pageinput">{$errorlogs_count}</p>
</div>
{if $pages_count>0}
<br />
<table cellspacing="0" cellpadding="3">
	<tbody>
		<tr>
			<td>{$pages_text}:</td>
			<td>{$first}</td>
			<td>{$prev}</td>
			<td>{foreach from=$pages item=page} {$page->number} {/foreach}</td>
			<td>{$next}</td>
			<td>{$last}</td>
		</tr>
	</tbody>
</table>
{/if}
<br />
<table class="pagetable" cellspacing="0" cellpadding="3">
	<thead>
		<tr>
			<th class="pageicon">{$selectall}</th>
			<th>{$logid_text}</th>
			<th>{$send_date_text}</th>
			<th>{$username_text}{if ($username_is_email)} / {$email_text}{/if}</th>
			{if (!$username_is_email)}
			<th>{$email_text}</th>
			{/if}
			<th>{$status_text}</th>
			<th>{$recieved_text}</th>
			<th class="pageicon">{$resend_text}</th>
		</tr>
	</thead>
	<tbody>
	{foreach from=$logs item=log}
		<tr class="{$log->rowclass}" onmouseover="this.className='{$log->rowclass}hover';" onmouseout="this.className='{$log->rowclass}';">
			<td>{$log->selected}</td>
			<td>{$log->log_id}</td>
			<td>{$log->send_date}</td>
			<td>{$log->username}</td>
			{if (!$username_is_email)}
			<td>{foreach from=$log->emails item=email}{$email}<br />{/foreach}</td>
			{/if}
			<td>{$log->img}&nbsp;{$log->status}</td>
			<td>{$log->recieved}</td>
			<td>{$log->resend}</td>
		</tr>
	{/foreach}
	</tbody>
</table>
<br />
{if $pages_count>0}
<table cellspacing="0" cellpadding="3">
	<tbody>
		<tr>
			<td>{$pages_text}:</td>
			<td>{$first}</td>
			<td>{$prev}</td>
			<td>{foreach from=$pages item=page} {$page->number} {/foreach}</td>
			<td>{$next}</td>
			<td>{$last}</td>
		</tr>
	</tbody>
</table>
<br />
{/if}
<div class="pageoverflow">
	<div class="pageinput">
		<p>{$cancel}&nbsp;{$resend_all}{if isset($resend_new)}&nbsp;{$resend_new}{/if}{if isset($resend_errors)}&nbsp;{$resend_errors}{/if}&nbsp;{$resend_selected}</p>
	</div>
</div>
{$hidden}
{$endForm}
{else}
<p>{$nologs}</p>
{/if}

