<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.4
# File   : en_US.php (language file)
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
# See the GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

// general stuff
$lang['friendlyname'] = 'FrontendUsers Mailer Module';
$lang['postinstall'] = 'FrontendUsers Mailer Module installed.<br />Be sure to set "Use FEUMailers" permissions to use this module!';
$lang['postuninstall'] = 'FrontendUsers Mailer Module uninstalled.';
$lang['really_uninstall'] = 'Do you really want to uninstall FrontendUsers Mailer Module?';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['moddescription'] = 'This module provides a simple mailing function to send emails to several groups of the FrontendUsers Module.';
$lang['cannotcontinue'] = 'No archive mail found. Can not coninue or repeat this job.';
$lang['changelog'] = '<br />
<ul>
	<li>
		<p><strong>Version 0.9.4 (May 2011):</strong></p>
		<ul>
			<li><p>- compatibility bugfixes for CMSms 1.9.4.1</p></li>
		</ul>
	</li>
	<li>
		<p><strong>Version 0.9.3 (June 2010):</strong></p>
		<ul>
			<li><p>- first stable release</p></li>
			<li><p>- added "web bug" to track back if mail has been read (only works if mail is sent as html)</p></li>
		</ul>
	</li>
	<li>
		<p><strong>Version 0.9.2.BETA (May 2009):</strong></p>
		<ul>
			<li><p>several minor bugfixes</p></li>
			<li><p>moved all db querries into FEUMailer.module.php as separate functions</p></li>
		</ul>
	</li>
	<li>
		<p><strong>Version 0.9.1 (April 2009):</strong></p>
		<ul>
			<li><p>several minor bugfixes</p></li>
		</ul>
	</li>
	<li>
		<p><strong>Version 0.9 (March 2009):</strong></p>
		<ul>
			<li><p>improved compatiblity for CMSms 1.5.x</p></li>
			<li><p>added own module icon</p></li>
			<li><p>enlarged module icons</p></li>
			<li>
				<p>
					Added funtion to save log data of sent mails.<br />
					With that option you can resend mails to users that did not have entered a valid email address when sending a mail last time.
				</p>
			</li>
			<li><p>Saved messages displays amount of recipients, processed users and total users of the selected groups</p></li>
			<li><p>Added confirm messages before actually sending a mail.<br />(confirm message shows amount of total users, processed users, recipients and remaining users)</p></li>
			<li><p>Removed function to resend temporary mails to all users of selected groups</p></li>
			<li><p>Removed function to edit temporary mails<br />(jobs cannot be changed anymore but just continued)</p></li>
			<li><p>Several trivial bugfixes</p></li>
		</ul>
	</li>
	<li><p><strong>Version 0.8 (July 2008, initial release)</strong><p></li>
<ul>';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>This is a very simple "email module".<br />
It provides backend users ability to send emails to several groups of the FrontendUsers module.<br />
You can use smarty syntax in the message text to insert e.g. user properties, links etc. in the mail.<br />
Sent mails can be stored in the database.<br />
<br />
Sending mails are stored temporary in the database and during sending process <br />
continously updated with the currently processed users id. <br />
So if there is a server timeout the module can resend the emails continueing <br />
from the last user the mail was sent to.<br /><br />
To prevent a server timeout mails will be sent in "jobs" using an AJAX request.<br />
<h3>How Do I Use It</h3>
<p>This module does not support functions for the frontend.</p>
<p>After installation go to "Users &amp; Groups-&gt;FrontendUsers Mailer Module" in the backend.<br />
To send a new mail just select "Send a new mail".<br />
Select the groups of the FrontendUsers module you wish to send an email to.<br />
Enter a subject (optional).<br />
Enter a message text.<br />
Select "Submit" to send the mail.<br /><br />
The module now sends an email to all users of the specified groups using the <br />
CMS Mailer module.
</p>
<p><strong>Smarty syntax:</strong><br />
You can use general smarty stuff in the email.<br />
Additional smarty variables are:</p>
<ul>
<li><strong>{$username}: </strong>Prints out the username of the user the mail is sent to.</li>
<li><strong>{$userprops}: </strong>Is an array containing all userproperties of the user the mail is sent to.</li>
</ul>
<br />
Using a {foreach}-loop you will be able to access all userproperties.<br /><br />
Example:<br />
--------------------------------------------------------------------------------
<br /><br />
<pre>
Hello {$username},

Are these entrys still up to date?

{foreach from=$userprops item=prop}
{$prop.prompt}: {$prop.data}&lt;br /&gt;
{/foreach}

If not, so please update them.

Regards, your Admin.
</pre>
<br />
--------------------------------------------------------------------------------
<br />
<br />
{$prop.data} contains the data of that field.<br />
{$prop.prompt} contains the prompt of that field.<br />
<br /><br />
To access userproperties directly use dot syntax:<br />
<br />
Example:<br />
--------------------------------------------------------------------------------
<br /><br />
<pre>
Hello {$userprops.first_name.data},

i\'ve just spammed your inbox again ;P
</pre>
<br />
--------------------------------------------------------------------------------
<br /><br />
{$userprops.FIELDNAME.data} contains the data of that field.<br />
{$userprops.FIELDNAME.prompt} contains the prompt of that field.<br />
</p>
<h3>Settings</h3>
<p>In the adminpanel you can setup the following options:</p>
<ul>
	<li>
		<strong>Autosave:</strong>
		<ul>
			<li>
				Use this option to save sent messages in your message archive.
			</li>
		</ul>
	</li>
	<br >
	<li><strong>Save logs:</strong>
		<ul>
			<li>
				Use this option to save log data of each sent mail.<br /><br />
				<em>Notice: the amount of log data depends on the amount of your frontend users.<br />
				If you realize problems with large number of users, disable this option.<br /> 
				Disabling this option will also disable the ability to resend a saved mail to users <br />
				that did not have an email address when sending this mail last time.</em>
				<br /><br />
				Default is on.
			</li>
			<br />
			<li><strong>Save errorlogs only:</strong>
				<ul>
					<li>
						This will only save logs where a mail could not be sent.<br />
						This may happen when a user does not have entered an email address in his properties.<br />
						<br />
						Default is on.
					</li>
				</ul>
			</li>
		</ul>
	</li>
	<br />
	<li><strong>Automatically delete old mails:</strong>
		<ul>
			<li>
				This will automatically delete old mails.
				<br /><br />
				Default is on.<br />
				<br />
				Select the lifetime of archive or temporary mails with the dropdown input fields.<br /><br />
				Default is 3 months.
			</li>
		</ul>
	</li>
	<br />
	<li><strong>Default group(s):</strong>
		<ul>
			<li>
				This will be the preselected group(s) when sending a new mail.<br />
				<br />
				Default is none.
			</li>
		</ul>
	</li>
	<br />
	<li><strong>Send mail as HTML text:</strong>
		<ul>
			<li>
				If you select this option you will be able to use your installed WYSIWYG editor to write the mail.<br />
				<br />
				Default is off.
			</li>
		</ul>
	</li>
	<br />
	<li><strong>Max. number of emails per job:</strong>
		<ul>
			<li>
				To prevent a server timeout mails will be sent in "jobs" using an AJAX request.<br />
				Enter the amount of users that will be processed per job.<br />
				<br />
				Default is 50
			</li>
		</ul>
	</li>
	<br />
	<li><strong>AJAX request delay:</strong>
		<ul>
			<li>
				Since if you have a large amount of frontend users and a small amount of users per job<br />
				your browser will sent lots of identical requests to the server in a very short time.<br />
				Some security software probably will interpret this as an intrusion
				and break your requests or even block your IP address.<br />
				<br />
				To avoid this you can enter a delay (in miliseconds) the javascript will wait until sending a new request.<br />
				<br />
				Default is none.
			</li>
		</ul>
	</li>
</ul>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
	<li>The projects homepage is <a href="http://dev.cmsmadesimple.org/projects/feumailer/">http://dev.cmsmadesimple.org/projects/feumailer/</a></li>
	<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
</ul>
<br />
<p>Please report any kind of errors and feel free to report any ideas to improve this module.</p>
<h3>Known issues</h3>
<p>If username is used as emailaddress only this address will be used.</p>
<p>If username is <strong>not</strong> used as emailaddress the FeuMailer Module only searches for a user property of <strong>type "email"</strong>.</p>
<p>If the user has entered more than one emailaddress only the first found emailaddress will be used.</p>
<p>
	When using pictures or any other kind of media it will not be attached to the mail but just inserted with a link to that media.<br />
	This link will be inserted as a relative one (e.g. &lt;img src="/uploads/images/a_tiny_image.jpg" /&gt;).<br />
	For a proper link you need to adapt it to an absolute one (e.g. &lt;img src="http://www.yourDomain/uploads/images/a_tiny_image.jpg" /&gt;).
</p>
<p>
	Some Smarty tags, plugins or modules won\'t work properly if used in a mail<br />
	because they need some data of the server request in your browsers address bar.<br />
	This data does only exist when accessing the page via frontend.<br >
	Since the mail will be processed by the backend this data won\'t be accessible.<br />
	This cannot be changed unless you modify the plugins.
</p>
<h3>Copyright and License</h3>
<p>
	As per the GPL, this software is provided as-is.<br />
	This program is distributed in the hope that it will be useful,<br />
	but WITHOUT ANY WARRANTY; without even the implied warranty of<br />
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.<br />
	See the GNU General Public License for more details.<br />
	You should have received a copy of the GNU General Public License<br />
	along with this program; if not, write to the Free Software<br />
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA<br />
	Or read it online: http://www.gnu.org/licenses/licenses.html#GPL<br />
	Please read the text of the license for the full disclaimer.
</p>
<p>Copyright &copy; 2008, Georg Busch (NaN) <a href="mailto:georg.busch@gmx.net">&lt;georg.busch@gmx.net&gt;</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the module.</p>
';

// Error messages
$lang['error'] = 'Error!';
$lang['error_upgrade'] = "Sorry but there is no upgrade available. <br />You need to reinstall the module.";
$lang['error_permissions'] = 'Access Denied. Please check your permissions.';
$lang['error_feusers'] = 'No FrontendUsers module found. To use the FrontendUsers Mailer module you need to install the FrontendUsers module.';
$lang['error_cmsmailer'] = 'No CMS Mailer module found. To use the FrontendUsers Mailer module you need to install the CMS Mailer module.';
$lang['error_tmpmails'] = 'There are temporary emails in the database.<br />Temporary emails could not be sent to all users of the selected groups.<br />You can try to send the email to all users that did not recieve the mail using the "resend" button.<br />The module will send the mail again continueing from the last user that mail was sent to.';
$lang['error_groups'] = 'No FrontendUsers groups defined. Check the FrontendUsers Module for at least one usergroup.';
$lang['error_selectedgroups'] = 'Please select at least one usergroup.';
$lang['error_mailbody'] = 'Please enter a message text.';
$lang['error_request_status'] = "The AJAX request has been succesfully sent but there where errors. Request Status:";
$lang['error_xmlhttp_instance'] = "Cannot create XMLHttp instance!";
$lang['error_selectedarchivemails'] = 'No mails selected.<br />No mails deleted.<br />That\'s the deal.';
$lang['error_selectedtmpmails'] = 'No temporary mails selected.<br />No temporary mails deleted.<br />That\'s the deal.';
$lang['error_insufficientparams'] = 'Insufficient params.<br />Incorrect or missing value of param %s in modules/FEUMailer/action.%s.php.';
$lang['error_insufficientparams_ajax'] = 'Operation canceled. Insufficient params.<br />Incorrect or missing value of param %s in modules/FEUMailer/action.%s.php.';
$lang['error_nousersfound'] = 'No users found.';
$lang['error_ajax'] = "An error occured.\\nOperation canceled.\\nPlease try again.\\n\\nServer response:\\n\\n";

// db errors
$lang['error_db_deletemail'] = 'Mail(s) could not be deleted. The query could not be executed:<br />%s';
$lang['error_db_savemail'] = 'Mail could not be stored. The query could not be executed:<br />%s';
$lang['error_db_savemail_ajax'] = 'Mail could not be stored.';
$lang['error_db_get_tmpmail'] = 'Could not get temporary mail with id %s. The query could not be executed or returned an empty result.<br />Query:<br />%s';
$lang['error_db_get_tmpmail_ajax'] = 'Operation canceled. Could not get temporary mail with id %s.';
$lang['error_db_get_archivemail'] = 'Could not get archive mail. The query could not be executed or returned an empty result.<br />Query:<br />%s';
$lang['error_db_create_tmpmail'] = "Operation canceled. Could not create temp mail.<br />The query could not be executed:<br />%s";
$lang['error_db_autoclearlog'] = 'Could not delete log(s) of deleted mail(s). The query could not be executed:<br />%s';
$lang['error_db_update_tmpmail'] = 'Operation canceled. Could not update temporary mail. The query could not be executed:<br />%s';
$lang['error_db_update_tmpmail_ajax'] = 'Operation canceled. Could not update temporary mail.';

$lang['error_db_create_log'] = 'Could not create log entry(s).';
$lang['error_db_update_archive'] = 'Could not update archive mail. Tis may result in displaying incorrect number of recipients and/or processed users.';
$lang['error_db_delete_tmp'] = 'Could not delete temp mail. You need to delete temp mail manually.';
$lang['error_db_update_log'] = 'Could not update log entry(s). This may result in displaying incorrect send status.';

// module stuff
$lang['adminpanel'] = 'Adminpanel';
$lang['sendmail'] = 'Send mail...';
$lang['emailaddress'] = 'Emailaddress';
$lang['nomails'] = 'No sent mails in your mails archive.';
$lang['notempmails'] = 'No temporary mails found.';
$lang['archive'] = 'Archive mails';
$lang['newmail'] = 'Send a new mail';
$lang['temp'] = 'Temporary mails';
$lang['pref'] = 'Preferences';
$lang['prefs_updated'] = 'Preferences updated.';
$lang['users'] = 'Users';
$lang['request_delay'] = 'AJAX request delay';
$lang['groups'] = 'Usergroups';
$lang['subject'] = 'Subject';
$lang['date'] = 'Send date';
$lang['recipients'] = 'Recipients';
$lang['read'] = 'Read';
$lang['readmail'] = 'Read mail';
$lang['edit'] = 'Edit';
$lang['resend'] = 'Resend';
$lang['delete'] = 'Delete';
$lang['save_logs'] = 'Save logs';
$lang['save_errorlogs_only'] = 'Save errorlogs only';
$lang['logid'] = 'Log ID';
$lang['status'] = 'Status';
$lang['recieved'] = 'Recieved';
$lang['noemailaddressfound'] = 'No email address found';
$lang['invalidemailaddress'] = 'Invalid email address';
$lang['filter'] = 'Filter';
$lang['asc'] = 'ascending';
$lang['desc'] = 'descending';
$lang['sortby'] = 'Sort by';
$lang['sort'] = 'sort';
$lang['limit'] =  'Limit';
$lang['pages'] = 'Pages';
$lang['errorsonly'] = 'Show errors only';
$lang['savedefault'] = 'Save filter';
$lang['send_order'] = 'Send order';
$lang['sortorder'] = 'Sort order';
$lang['send_date'] = 'Send date';
$lang['username'] = 'Username';
$lang['nolimit'] = 'no limit';

$lang['autosave'] = 'Automatically save sent messages';
$lang['autoclear_archivemails'] = 'Automatically delete old mails';
$lang['autoclear_action'] = 'Delete mails that are older than';
$lang['seconds'] = 'seconds';
$lang['minutes'] = 'minutes';
$lang['hours'] = 'hours';
$lang['days'] = 'days';
$lang['weeks'] = 'weeks';
$lang['months'] = 'months';
$lang['years'] = 'years';
$lang['autoclear_tmpmails'] = 'include temporary mails';
$lang['default_groups'] = 'Default recipient groups';
$lang['is_html'] = 'Send mail as HTML text';
$lang['submit'] = 'Submit';
$lang['cancel'] = 'Cancel';
$lang['message'] = 'Message';
$lang['save'] = 'Save sent message';
$lang['maxmails'] = 'Max. number of emails per job';

$lang['nosubject'] = 'No subject';
$lang['logs'] = 'Logs';
$lang['tmpmaildeleted'] = 'Temporary mail(s) deletetd';
$lang['archivemaildeleted'] = 'Mail(s) deleted';

$lang['task_finished'] = 'This task is finished';
$lang['task_open'] = 'This task is not finished!';
$lang['mails_sent'] = 'All mails succesfully sent';
$lang['ok'] = 'Ok';
$lang['back'] = 'Back';
$lang['of'] = 'of';
$lang['wait'] = 'Please wait...';
$lang['sending'] = 'Sending mail';
$lang['deleteselected'] = 'Delete selected mails';
$lang['deleteselectedlog'] = 'Delete selected logs';

$lang['totallogs'] = 'Total entrys';
$lang['errorlogs'] = 'Errors';

$lang['log_deleted'] = 'Log entry(s) deleted.';
$lang['autoclear_logs'] = 'Automatically delete logs of mails that will be deleted';
$lang['view_logs'] = 'View logs';
$lang['view'] = 'Details';
$lang['nologs'] = 'No logs found';
$lang['processedusers'] = 'Processed users';
$lang['totalusers'] = 'Total users';
$lang['remaining'] = 'Remaining users';
$lang['sentby'] = 'Sent by';
$lang['resend_all'] = 'Resend to all users';
$lang['continue_archive'] = 'Resend to new users only';
$lang['continue_tmp'] = 'Continue from last processed user';
$lang['resend_errors'] = 'Resend errors only';
$lang['resend_user'] = 'Resend to this user';
$lang['resend_selected'] = 'Resend selected';
$lang['random_delay'] = 'Use random delay';

// confirm messages
$lang['groups_changed'] = 'You have changed the recipient groups.\\nDo you really you want to continue?';
$lang['deleteconfirm'] = 'Do you realy want to delete the selected mails?';
$lang['deletearchiveconfirm'] = 'Do you realy want to delete this mail?';
$lang['deletetempconfirm'] = 'Do you realy want to delete this temporary mail?';
$lang['deletelogconfirm'] = 'Do you realy want to delete the selected logs?';

$lang['submitconfirm'] = "Do you really want to send this mail to all users of the selected group(s)?";
$lang['resendselectedconfirm'] = 'Do you really want to send this mail AGAIN to the selected users?';
$lang['resendalltmpconfirm'] = "Do you really want to send this temporary mail AGAIN to all users of the selected group(s)?";
$lang['resendnewtmpconfirm'] = "Do you really want to send this temporary mail to all users of the selected group(s) coninueing from the last processed user?";
$lang['resenderrortmpconfirm'] = "Do you really want to send this temporary mail to all users of the selected group(s) who where already processed but did not have an email address last time?";
$lang['resendallarchiveconfirm'] = "Do you really want to send this mail AGAIN to all users of the selected group(s)?";
$lang['resendnewarchiveconfirm'] = "Do you really want to send this mail to all NEW users of the selected group(s)?\\n(coninueing from the last processed user)";
$lang['resenderrorarchiveconfirm'] = "Do you really want to send this mail to all users of the selected group(s) who where already processed but did not have an email address last time?";
$lang['resenduserconfirm_1'] = 'Do you really want to send this mail AGAIN to this user?\\nUsername / Email: %s';
$lang['resenduserconfirm_2'] = 'Do you really want to send this mail AGAIN to this user?\\nUsername: %s\\nEmail: %s';

$lang['submitconfirm_full'] = "Do you really want to send this mail to all users of the selected group(s)?\\n\\nGroups:\\n%s\\n\\nUsers:\\n%s";
$lang['resendalltmpconfirm_full'] = "Do you really want to send this temporary mail AGAIN to all users of the selected group(s)? \\n\\nGroups:\\n%s\\n\\nUsers:\\n%s";
$lang['resendnewtmpconfirm_full'] = "Do you really want to send this temporary mail to all users of the selected group(s) coninueing from the last processed user?\\n\\nGroups:\\n%s\\n\\nTotal users:\\n%s\\n\\nProcessed users: %s\\n\\nRecipients: %s\\n\\nRemaining users:\\n%s";
$lang['resenderrortmpconfirm_full'] = "Do you really want to send this temporary mail to all users of the selected group(s) who where already processed but did not have an email address last time?\\n\\nGroups:\\n%s\\n\\nTotal users:\\n%s\\n\\nProcessed users:\\n%s\\n\\nRecipients:\\n%s\\n\\nRemaining users:\\n%s";
$lang['resendallarchiveconfirm_full'] = "Do you really want to send this mail AGAIN to all users of the selected group(s)?\\n\\nGroups:\\n%s\\n\\nUsers:\\n%s";
$lang['resendnewarchiveconfirm_full'] = "Do you really want to send this mail to all NEW users of the selected group(s)?\\n(coninueing from the last processed user)\\n\\nGroups:\\n%s\\n\\nTotal users:\\n%s\\n\\nProcessed users:\\n%s\\n\\nRecipients:\\n%s\\n\\nRemaining users:\\n%s";
$lang['resenderrorarchiveconfirm_full'] = "Do you really want to send this mail to all users of the selected group(s) who where already processed but did have no or an invalid email address last time?\\n\\nGroups:\\n%s\\n\\nTotal users:\\n%s\\n\\nProcessed users:\\n%s\\n\\nRecipients:\\n%s\\n\\nRemaining users:\\n%s";


?>
