<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.4
# File   : action.savePrefs.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!is_object(cmsms())) exit;

if(isset($params['submit']) || isset($params['submit_prefs']))
{
	if(isset($params['autosave']))
	{
		$this->SetPreference("autosave", $params['autosave']);
	}
	if(isset($params['save_logs']))
	{
		$this->SetPreference("save_logs", $params['save_logs']);
		if(isset($params['save_errorlogs_only']))
		{
			$this->SetPreference("save_errorlogs_only", $params['save_errorlogs_only']);
		}
	}
	if(isset($params['autoclear_logs']))
	{
		$this->SetPreference("autoclear_logs", $params['autoclear_logs']);
	}
	if(isset($params['autoclear_archivemails']))
	{
		$this->SetPreference("autoclear_archivemails", $params['autoclear_archivemails']);
		if(isset($params['autoclear_value']) && $params['autoclear_value']!='')
		{
			$this->SetPreference("autoclear_value", intval(trim($params['autoclear_value'])));
		}
		if(isset($params['autoclear_time']) && $params['autoclear_time']!='')
		{
			$this->SetPreference("autoclear_time",trim($params['autoclear_time']));
		}
		if(isset($params['autoclear_tmpmails']))
		{
			$this->SetPreference("autoclear_tmpmails", $params['autoclear_tmpmails']);
		}
	}
	if(isset($params['is_html']))
	{
		$this->SetPreference("is_html", $params['is_html']);
	}
	if(isset($params['maxmails']))
	{
		$this->SetPreference("maxmails", intval(trim($params['maxmails'])));
	}
	if(isset($params['request_delay']))
	{
		$this->SetPreference("request_delay", intval(trim($params['request_delay'])));
	}
	if(isset($params['random_delay']))
	{
		$this->SetPreference("random_delay", $params['random_delay']);
	}
	if(isset($params['default_groups']))
	{
		$default_groups = '';
		if(is_array($params['default_groups']) && !empty($params['default_groups'])) 
		{
			$default_groups = array();
			foreach($params['default_groups'] as $def_group) 
			{
				$dg = explode(",",$def_group);
				if(isset($dg[1]))
				{
					$default_groups[$dg[0]] = $dg[0].",".$dg[1];
				}
			}
			$default_groups = implode(";",$default_groups);
		}
		$this->SetPreference("default_groups", $default_groups);
	}
}
if(isset($params['ajax']))
{
	echo '<div class="pagemcontainer"><p class="pagemessage">'.$this->lang('prefsupdated').'</p></div>';
	exit;
}
else
{
	$this->Redirect($id, 'defaultadmin', $returnid, array('message' => 'prefs_updated', 'submit' => true));
}
?>