<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.4
# File   : action.readMail.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!is_object(cmsms()))
	exit;

$config = cmsms()->GetConfig();

if(!$this->CheckPermission('Use FEUMailer')) {
	return $this->DisplayErrorPage($id,$returnid, $this->Lang('error_permissions'));
}

$new = '<img src="'.$config['root_url'].'/modules/FEUMailer/images/newmail.gif" alt="" title="'.$this->lang('newmail').'" class="systemicon" />';
$edit = cmsms()->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->lang('edit'),'','','systemicon');
$back = cmsms()->variables['admintheme']->DisplayImage('icons/system/back.gif', $this->lang('back'),'','','systemicon');
$delete = cmsms()->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->lang('delete'),'','','systemicon');
$resend_all = '<img src="'.$config['root_url'].'/modules/FEUMailer/images/resend_all.gif" alt="'.$this->lang('resend_all').'" title="'.$this->lang('resend_all').'" class="systemicon" />';
$resend_errors = '<img src="'.$config['root_url'].'/modules/FEUMailer/images/resend_errors.gif" alt="'.$this->lang('resend_errors').'" title="'.$this->lang('resend_errors').'" class="systemicon" />';
$errorlogs = cmsms()->variables['admintheme']->DisplayImage('icons/extra/yellow.gif', $this->lang('view_logs'),'','','systemicon');
$viewlogs = cmsms()->variables['admintheme']->DisplayImage('icons/system/info.gif', $this->lang('view_logs'),'','','systemicon');

if(isset($params['mail_type']) && !empty($params['mail_type'])) {
	$mail_type = trim($params['mail_type']);
} else {
	$this->Redirect($id, 'defaultadmin', $returnid);
}

$resend_new = '<img src="'.$config['root_url'].'/modules/FEUMailer/images/continue.gif" alt="'.$this->lang('continue_'.$mail_type).'" title="'.$this->lang('continue_'.$mail_type).'" class="systemicon" />';
#$resend_new_inactive = '<img src="'.$config['root_url'].'/modules/FEUMailer/images/resend_new_inactive.gif" alt="'.$this->lang('resend_new'.$mail_type).'" title="'.$this->lang('resend_new'.$mail_type).'" class="systemicon" />';
#$resend_errors_inactive = '<img src="'.$config['root_url'].'/modules/FEUMailer/images/resend_errors_inactive.gif" alt="'.$this->lang('resend_errors').'" title="'.$this->lang('resend_errors').'" class="systemicon" />';


if(isset($params['mail_id'])) {
	$mail_id = intval(trim($params['mail_id']));
} else {
	$this->Redirect($id, 'defaultadmin', $returnid);
}

$clear_log = false;
if(isset($params['clear_log']) && $params['clear_log']==true) {
	$clear_log = true;
}

$subject 			= '';
$mailbody 			= '';
$sentby 			= '';
$last_userid 		= 0;
$send_date 			= '';
$processed_users 	= 0;
$recipients 		= 0;
$errorcode 			= 0;
$total_users		= 0;
$groups 			= '';
$groups_confirm		= '';
$recipient_groups	= array();

// get mail data
$mail = $this->GetMail($mail_id,$mail_type);
if($mail!=false) {
	$sentby 			= $mail['username'];
	$send_date 			= $mail['send_date'];
	$last_userid 		= $mail['last_userid'];
	$mailbody  			= $mail['mailbody'];

	if(!empty($mail['subject'])) {
		$subject = $mail['subject'];
	} else {
		$subject = $this->lang('nosubject');
	}
	
	if($mail['recipients']==$mail['processed_users'])
		$errorcode 	= 0;
	else
		$errorcode 	= 1;
	
	$processed_users 	= $mail['processed_users'];
	$recipients 		= $mail['recipients'];
	
	if($mail['logs']>0)
		$logs 			= true;
	else
		$logs 			= false;

	$grps=explode(';',$mail['recipient_groups']);
	if(!empty($grps[0])) {
		foreach($grps as $grp) {
			if(!empty($grp)) {
				$g = explode(',',$grp);
				if(isset($g[1]))
					$recipient_groups[$g[0]] = $g[1];
			}
		}
	}
}

$total_users = count($this->GetUsers($recipient_groups));
$groups_confirm = implode("\\n",$recipient_groups);
$groups = implode("<br />",$recipient_groups);

// smarty stuff
$this->smarty->assign('groups_text',$this->lang('groups'));
$this->smarty->assign('groups_input',$groups);

$this->smarty->assign('totalusers_text',$this->lang('totalusers'));
$this->smarty->assign('totalusers_input',$total_users);

$this->smarty->assign('processed_text',$this->lang('processedusers'));
$this->smarty->assign('processed_input',$processed_users);

$this->smarty->assign('recipients_text',$this->lang('recipients'));
$this->smarty->assign('recipients_input',$recipients);

$remaining_new = $total_users - $processed_users;
if($remaining_new<0) $remaining_new = 0;

$remaining_errors = $total_users - $recipients;
if($remaining_errors<0) $remaining_errors = 0;

$this->smarty->assign('subject_text',$this->lang('subject'));
$this->smarty->assign('subject_input',$subject);

$this->smarty->assign('mailbody_text',$this->lang('message'));
$this->smarty->assign('mailbody_input',$mailbody);

$this->smarty->assign('back_link',$this->CreateLink($id,'defaultadmin','',
										$back,array('active_tab'=>$mail_type)));

if($mail_type!='tmp') {
	$this->smarty->assign('edit_link',$this->CreateLink($id,'editMail','',$edit,
													array('mail_type'=>$mail_type,
														'mail_id'=>$mail_id,
														'clear_log'=>$clear_log)));
}

// resend_all, resend_new, resend_errors
if($mail_type=='archive') {
	$this->smarty->assign('resend_all', $this->CreateLink($id,'prepareSendMail',$returnid,
											$resend_all,
											array('task'=>'all',
													'mail_type'=>$mail_type,
													'clear_log'=>$clear_log,
													'last_userid'=>0,
													'mail_id'=>$mail_id),
											$this->lang('resendall'.$mail_type.'confirm_full',
																$groups_confirm,
																$total_users)));
}

if($remaining_new>0) {
	$parms = array('task'=>'continue','mail_type'=>$mail_type,
									'clear_log'=>$clear_log,'mail_id'=>$mail_id);

	$this->smarty->assign('resend_new',$this->CreateLink($id,'prepareSendMail',
										$returnid,$resend_new,$parms,
										$this->lang('resendnew'.$mail_type.'confirm_full',
																$groups_confirm,
																$total_users,
																$processed_users,
																$recipients,
																$remaining_new)));
} else {
	#$this->smarty->assign('resend_new',$resend_new_inactive);
}

if($errorcode==1 && $logs==true) {
	if($remaining_errors>0 && $mail_type=='archive') {
	$this->smarty->assign('resend_error',$this->CreateLink($id,'prepareSendMail',$returnid,
										$resend_errors,
										array('task'=>'error',
												'mail_type'=>$mail_type,
												'clear_log'=>$clear_log,
												'mail_id'=>$mail_id),
										$this->lang('resenderror'.$mail_type.'confirm_full',
													$groups_confirm,
													$total_users,
													$processed_users,
													$recipients,
													$remaining_errors)));
	} else {
		#$this->smarty->assign('resend_error',$resend_errors_inactive);
	}

	$this->smarty->assign('view_log',$this->CreateLink($id,'viewLogs',$returnid,$errorlogs,
														array('mail_type'=>$mail_type,
															$mail_type.'_id'=>$mail_id,
															'clear_log'=>$clear_log)));
} else if($errorcode==0 && $logs==true) {
	$this->smarty->assign('view_log',$this->CreateLink($id,'viewLogs',$returnid,$viewlogs,
														array('mail_type'=>$mail_type,
															$mail_type.'_id'=>$mail_id,
															'clear_log'=>$clear_log)));
	#$this->smarty->assign('resend_error',$resend_errors_inactive);
}

$this->smarty->assign('heading',$this->lang('readmail'));
$this->smarty->assign('delete_link',$this->CreateLink($id,'deleteMail','',$delete,
													array('mail_type'=>$mail_type,
														'clear_log'=>$clear_log,
														'mail_id'=>$mail_id),
													$this->lang('deleteconfirm')));

$this->smarty->assign('new_link',$this->CreateLink($id,'newMail','',	$new));

$this->smarty->assign('new_link',$this->CreateLink($id,'newMail','',	$new));

// Display the populated template
echo $this->ProcessTemplate('readMail.tpl');
?>
