<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.4
# File   : action.newMail.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!is_object(cmsms()))
	exit;



if(isset($params['cancel'])) {
	$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab'=>'archive'));
}


$check_groups = array();
$selected_groups = array();
$rec_groups = array();

// preferences
$autosave = $this->GetPreference("autosave",true);
$default_groups = array();
$def_groups = explode(';',$this->GetPreference('default_groups',''));
if(!empty($def_groups[0])) {
	foreach($def_groups as $def_group) {
		$dg = explode(',',$def_group);
		if(isset($dg[1]))
			$default_groups[$dg[0]]=$dg[1];
	}
}

// get feusergroups
$groups = $this->GetGroups();
// if no groups -> display errormessage
if(empty($groups)) {
	$this->Redirect($id, 'defaultadmin', $returnid, 
							array('errormessage'=>$this->Lang('error_groups')));

}

foreach($groups as $k=>$v) {
	$grp_vars = explode(',',$v);
	if(isset($grp_vars[2]) && isset($default_groups[$grp_vars[0]])) {
		$selected_groups[$grp_vars[1]." (".$grp_vars[2]." ".$this->lang("users").")"] = implode(",",$grp_vars);
	}
}

$error = false;
$errormessage = '';

$subject = '';
if(isset($params['subject']) && !empty($params['subject'])) {
	$subject = trim($params['subject']);
}

$mailbody = '';
if(isset($params['mailbody'])) {
	$mailbody = trim($params['mailbody']);
}

if(isset($params['autosave']) && isset($params['submit_form']) && 
$params['submit_form']==true) {
	$autosave=true;
} else if(!isset($params['autosave']) && isset($params['submit_form']) && 
$params['submit_form']==true) {
	$autosave=false;
}

// get selected groups
if(isset($params['groups']) && !empty($params['groups'])
   && is_array($params['groups'])) {
	unset($selected_groups);
	unset($check_groups);
	unset($rec_groups);
	$selected_groups = array();
	$check_groups = array();
	$rec_groups = array();
	foreach($params['groups'] as $group) {
		if(!empty($group)) {
			$g = explode(',',trim($group));
			if(isset($g[2])) {
				$selected_groups[$g[1]." (".$g['2']." ".$this->lang("users").")"] = $g[0].",".$g[1].",".$g[2];
				$check_groups[$g[0]]=$g[1];
				$rec_groups[] = $g[0].','.$g[1];
			}
		}
	}
}


if(isset($params['submit_form']) && $params['submit_form']==true) {
	if(empty($selected_groups)) {
		$error = true;
		$errormessage .= $this->lang('error_selectedgroups').'<br />';
	} else {
		$users = count($this->GetUsers($check_groups));
		if($users==0) {
			$error = true;
			$errormessage .= $this->lang('error_nousersfound').'<br />';
		}
	}
	if(empty($mailbody)) {
		$error = true;
		$errormessage .= $this->lang('error_mailbody').'<br />';
	}

### do action ##################################################################

	if($error==false) {
		$parms = array();
		$recipient_groups 	= implode(";",$rec_groups);

		$ret = $this->createTempMail($recipient_groups,
										$subject,
										$mailbody,
										0,
										0,
										0,
										'all',
										'',
										$autosave);

		if(!$ret[0]) {
			return $this->DisplayErrorPage($id,$returnid,$ret[1]);
		} else {
			$parms['mail_id'] = $ret[1];
			$parms['mail_type'] = 'tmp';
			$this->DoAction('prepareSendMail',$id,$parms,$returnid);
			return;
		}
	}

################################################################################

}


// smarty stuff
$this->smarty->assign('startForm',
		$this->CreateFormStart($id, 'newMail', $returnid, 'post', '', false, 'myForm'));

$this->smarty->assign('hidden',$this->CreateInputHidden($id, 'submit_form', false, 'id="submit_form"'));

$this->smarty->assign('endForm',$this->CreateFormEnd());

$this->smarty->assign('id', $id);

$this->smarty->assign('nousers', $this->lang('error_nousersfound'));
$this->smarty->assign('nogroups', $this->lang('error_selectedgroups'));
$this->smarty->assign('nomessage', $this->lang('error_mailbody'));

$this->smarty->assign('confirmsubmit',	$this->lang('submitconfirm'));
$this->smarty->assign('submit',$this->lang('submit'));
$this->smarty->assign('groups',$this->lang('groups'));
$this->smarty->assign('heading',$this->lang('newmail'));
$this->smarty->assign('totalusers',$this->lang('totalusers'));

$this->smarty->assign('cancel',
		$this->CreateInputSubmit($id,'cancel',$this->lang('cancel')));

$this->smarty->assign('groups_text',$this->lang('groups'));
$smarty->assign('url', str_replace('&amp;', '&', 
	$this->CreateLink($id,'getUsers',$returnid,'',
		array('disable_theme'=>true,'ajax'=>true), '', true)));
																
$this->smarty->assign('groups_input',$this->CreateInputSelectList($id,
		'groups[]',$groups,$selected_groups,count($groups),'id="groups"',true));

$this->smarty->assign('error_ajax',$this->lang('error_ajax'));

// prefs
$this->smarty->assign('save_text',$this->lang('save'));
$this->smarty->assign('save_input',$this->CreateInputCheckbox($id,
											'autosave',1,($autosave==true?1:'')));

$this->smarty->assign('ishtml_text',$this->lang('is_html'));
$this->smarty->assign('ishtml_input',$this->CreateInputCheckbox($id,'is_html',1,
														($this->GetPreference('is_html',false)==true?1:'')));

$this->smarty->assign('subject_text',$this->lang('subject'));
$this->smarty->assign('subject_input',$this->CreateInputText($id,'subject',$subject,
																		64,128));

$this->smarty->assign('mailbody_text',$this->lang('message'));
$this->smarty->assign('mailbody_input',
$this->CreateTextArea(($this->GetPreference('is_html',false)==true?true:false),
						$id,
						$mailbody,
						'mailbody',
						'',
						'message'));

if($errormessage!='') {
	$this->smarty->assign('errormessage',$errormessage);
}

// Display the populated template
echo $this->ProcessTemplate('newMail.tpl');
?>
