<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.4
# File   : FEUMailer.module.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

class FEUMailer extends CMSModule {

	var $RRUtils;
	
	function FEUMailer()
	{
		parent::CMSModule();
	}
	
	function &RRUtils()
	{
		if(!$this->RRUtils)
		{
			$feu =& $this->GetModuleInstance('FrontEndUsers');
			$this->RRUtils = new RRUtils();
		}
		return $this->RRUtils;
	}
	
	function GetName() {
		return 'FEUMailer';
	}

	function GetFriendlyName() {
		return $this->Lang('friendlyname');
	}

	function GetVersion() {
		return '0.9.4';
	}

	function GetHelp() {
		return $this->Lang('help');
	}

	function GetAuthor() {
		return 'Georg Busch (NaN)';
	}

	function GetAuthorEmail() {
		return 'georg.busch@gmx.net';
	}

	function GetChangeLog() {
		return $this->Lang('changelog');
	}

	function IsPluginModule() {
		return false;
	}

	function HasAdmin() { 
		return true;
	}

	function GetAdminSection() {
		return 'usersgroups';
	}

	function GetAdminDescription() {
		return $this->Lang('moddescription');
	}

	function VisibleToAdminUser() {
		return $this->CheckPermission('Use FEUMailer');
	}

	function GetDependencies() {
		return array('FrontEndUsers' => '1.6','CMSMailer'=>'1.73.12');
	}

	function MinimumCMSVersion() {
		return "1.9.4.1";
	}

	function InstallPostMessage() {
		return $this->Lang('postinstall');
	}

	function UninstallPostMessage() {
		return $this->Lang('postuninstall');
	}

	function UninstallPreMessage() {
		return $this->Lang('really_uninstall');
	}

	function DoAction($action, $id, $params, $returnid = -1) {
		switch($action) {
			case 'clearLogs':
			case 'defaultadmin':
			case 'deleteMail':
			case 'editMail':
			case 'getUsers':
			case 'multiAction':
			case 'newMail':
			case 'prepareSendMail':
			case 'readMail':
			case 'savePrefs':
			case 'sendMail':
			case 'viewLogs':
				parent::DoAction($action,$id,$params,$returnid);break;
			case md5('trackBug'):
				$this->TrackBug($params[md5('log_id')]);break;
			default: break;
		}
	}

	function SetParameters() {
		$this->RestrictUnknownParams();
		
		$this->RegisterRoute('/'.md5('FEUMailer').'\/(?P<log_id>[0-9]+)\/(?P<junk>.*?)$/', array('action'=>md5('trackBug'),'showtemplate' => 'false'));
		
		$this->SetParameterType('active_tab',CLEAN_STRING);
		$this->SetParameterType('submit_log',CLEAN_STRING);
		$this->SetParameterType('errormessage',CLEAN_STRING);
		$this->SetParameterType('message',CLEAN_STRING);
		$this->SetParameterType('mail_type',CLEAN_STRING);
		$this->SetParameterType('cancel',CLEAN_STRING);
		$this->SetParameterType('submit',CLEAN_STRING);
		$this->SetParameterType('subject',CLEAN_STRING);
		$this->SetParameterType('mailbody',CLEAN_STRING);
		$this->SetParameterType('groups',CLEAN_STRING);
		$this->SetParameterType('task',CLEAN_STRING);
		$this->SetParameterType('username',CLEAN_STRING);
		$this->SetParameterType('submit_prefs',CLEAN_STRING);
		$this->SetParameterType('autoclear_time',CLEAN_STRING);
		$this->SetParameterType('default_groups',CLEAN_STRING);
		$this->SetParameterType('resend_all',CLEAN_STRING);
		$this->SetParameterType('resend_new',CLEAN_STRING);
		$this->SetParameterType('resend_errors',CLEAN_STRING);
		$this->SetParameterType('resend_selected',CLEAN_STRING);
		$this->SetParameterType('sort_by',CLEAN_STRING);
		$this->SetParameterType('sort_order',CLEAN_STRING);

		$this->SetParameterType('random_delay',CLEAN_INT);
		$this->SetParameterType('save_logs',CLEAN_INT);
		$this->SetParameterType('save_errorlogs_only',CLEAN_INT);
		$this->SetParameterType('autoclear_logs',CLEAN_INT);
		$this->SetParameterType('autoclear_archivemails',CLEAN_INT);
		$this->SetParameterType('autoclear_tmpmails',CLEAN_INT);
		$this->SetParameterType('is_html',CLEAN_INT);
		$this->SetParameterType('maxmails',CLEAN_INT);
		$this->SetParameterType('request_delay',CLEAN_INT);
		$this->SetParameterType('autoclear_value',CLEAN_INT);
		$this->SetParameterType('limit',CLEAN_INT);
		$this->SetParameterType('old_limit',CLEAN_INT);
		$this->SetParameterType('errors_only',CLEAN_INT);
		$this->SetParameterType('page',CLEAN_INT);
		$this->SetParameterType('userid',CLEAN_INT);
		$this->SetParameterType('errorcode',CLEAN_INT);
		$this->SetParameterType('mail_id',CLEAN_INT);
		$this->SetParameterType('archive_id',CLEAN_INT);
		$this->SetParameterType('tmp_id',CLEAN_INT);
		$this->SetParameterType('output',CLEAN_INT);
		$this->SetParameterType('clear_log',CLEAN_INT);
		$this->SetParameterType('autosave',CLEAN_INT);
		$this->SetParameterType('submit_form',CLEAN_INT);
		$this->SetParameterType('savefilter',CLEAN_INT);
		$this->SetParameterType(md5('log_id'),CLEAN_INT);
	}
	
/**
 * -----------------------------------------------------------------------------
 * Custom module functions
 * -----------------------------------------------------------------------------
 */
	
	/**
	 * function GetPrefs()
	 * not part of the module api
	 * gets all preferences of FEUmailer
	 *
	 * @return array ( $preference_name => $preference_value )
	 */
	function GetPrefs() 
	{
		$db =& $this->GetDb();
		$modulename = $this->GetName();
		$prefs = array();
		$query = "SELECT sitepref_value, sitepref_name 
					FROM ".cms_db_prefix()."siteprefs WHERE 
					sitepref_name LIKE '".$modulename."_mapi_pref%'";
		$dbresult = $db->Execute($query);
		while($dbresult && $row = $dbresult->FetchRow()) 
		{
			$prefname = str_replace($modulename."_mapi_pref_", "", 
				$row['sitepref_name']);
			$prefs[$prefname]=$row['sitepref_value'];
		}
		return $prefs;
	}
	
	
	/**
	 * function GetPref($prefname,$default='')
	 * not part of the module api
	 * gets a specific preference of FEUmailer
	 *
	 * @param string $prefname - The name of the preference to get
	 * @param string $default (optional) - The default value to return if nothing found
	 * @return string - The preference value
	 */
	function GetPref($prefname,$default='') 
	{
		if(empty($this->prefs))
			$this->prefs = $this->GetPrefs();
		if(isset($this->prefs[$prefname]))
			return $this->prefs[$prefname];
		else
			return $default;
	}
	
	/**
	 * function DisplayErrorPage($id, $returnid, $errormessage='')
	 * not part of the module api
	 * Displays an errormessage within a separate backend page
	 *
	 * @param string $id - The id given to the module on execution
	 * @param string $returnid - The id to eventually return to when the module is finished it's task
	 * @param string $errormessage (optional) - The errormessage to display
	 */
	function DisplayErrorPage($id, $returnid, $errormessage='') {
		$this->smarty->assign('error', $this->Lang('error'));
		if($errormessage != '') {
			$this->smarty->assign('errormessage', $errormessage);
		}
		$this->smarty->assign('ok_link',$this->CreateLink($id,'defaultadmin','',
			$this->lang('ok')));
		echo $this->ProcessTemplate('error.tpl');
	}
	
	
	/**
	 * function GetUsers($groups=array(),$uid=0,$limit=0,$operator='>=')
	 * not part of the module api
	 * gets all users of specified groups
	 *
	 * @param array $groups - An array of user groups the desired user should belong to ( $group_id => $group_name )
	 * @param integer $uid (optional) - An id of a user; function will get only those users where the user id is higher/lower/equal than $uid (depends on $operator)
	 * @param integer $limit (optional) - The maximum amount of users to get
	 * @param string $operator (optional) - Logical operators such as '>','<','=','>=','<=','!='
	 * @return array ( $userid => $username )
	 */
	function GetUsers($groups=array(),$uid=0,$limit=0,$operator='>=') {
		
		$db =& $this->GetDb();
		
		$feusers =& $this->GetModuleInstance('FrontEndUsers');
		if(!$feusers)
			return $this->DisplayErrorPage($id,$returnid,	$this->Lang('error_feusers'));
		
		$users = array();
		$where = array();
		$where2= array();
		$query = "SELECT FEU.id,FEU.username 
					FROM ".cms_db_prefix()."module_feusers_users FEU 
					LEFT JOIN ".cms_db_prefix()."module_feusers_belongs B
						ON B.userid = FEU.id";
		$where[] = "FEU.id". $operator . $uid;
		
		foreach($groups as $group_id=>$group_name) {
			$where2[] = " B.groupid = ".$group_id;
		}
		$q = '';
		if(count($where2)) {
			$q .= " AND (".implode(" OR ", $where2).") ";
		}
		$query .= " WHERE ".implode(" AND ",$where).$q;
		$query .= " GROUP BY FEU.id ORDER BY FEU.id ASC ".($limit>0?" LIMIT ". $limit:"");
		$dbresult = $db->Execute($query);
		while($dbresult && $row = $dbresult->FetchRow()) {
			$users[$row['id']]=$row['username'];
		}
		return $users;
	}
	
	
	/**
	 * function GetUsersErrors($mail_id=0, $uid=0, $limit=0,$operator='>=', $groups=array())
	 * not part of the module api
	 * gets all users of mail log where mail could not be sent to
	 *
	 * @param integer $mail_id - The id of the mail
	 * @param integer $uid (optional) - An id of a user; function will get only those users where the user id is higher/lower/equal than $uid (depends on $operator)
	 * @param integer $limit (optional) - The maximum amount of users to get
	 * @param string $operator (optional) - Logical operators such as '>','<','=','>=','<=','!='
	 * @param array $groups (optional) - An array of user groups the desired user should belong to ( $group_id => $group_name )
	 * @return array ( $userid => $username )
	 */
	function GetUsersErrors($mail_id=0, $uid=0, $limit=0,$operator='>=', $groups=array()) {
		
		$feusers =& $this->GetModuleInstance('FrontEndUsers');
		if(!$feusers)
			return $this->DisplayErrorPage($id,$returnid,	$this->Lang('error_feusers'));
		
		$db =& $this->GetDb();
		
		$users = array();
		$where = array();
		$where2= array();
		$query = "SELECT FEU.id, FEU.username 
					FROM ".cms_db_prefix()."module_feusers_users FEU 
					LEFT OUTER JOIN ".cms_db_prefix()."module_feumailer_logs L
						ON FEU.id = L.recipient_id
					LEFT OUTER JOIN ".cms_db_prefix()."module_feusers_belongs B 
						ON FEU.id = B.userid";
		$where[] = "L.errorcode>0 
					AND L.archive_id=". $mail_id ."
					AND FEU.id".$operator. $uid;
		
		foreach($groups as $group_id=>$group_name) {
			$where2[] = " B.groupid = ".$group_id;
		}
		$q = '';
		if(count($where2)) {
			$q .= " AND (".implode(" OR ",$where2).")";
		}
		$query .= " WHERE ".implode(" AND ",$where).$q;
		$query .= " GROUP BY FEU.id ORDER BY FEU.id ASC ".($limit>0?" LIMIT ". $limit:"");
		$dbresult = $db->Execute($query);
		while($dbresult && $row = $dbresult->FetchRow()) {
			$users[$row['id']]=$row['username'];
		}
		return $users;
	}
	
	
	/**
	 * function GetAdditionalGroups($users=array())
	 * not part of the module api
	 * gets all groups one or more users belongs to
	 *
	 * @param array $users - An array of users ( $userid => username )
	 * @return array - ( $group_id => $groupname )
	 */
	function GetAdditionalGroups($users=array()) {
		
		$feusers =& $this->GetModuleInstance('FrontEndUsers');
		if(!$feusers)
			return $this->DisplayErrorPage($id,$returnid,	$this->Lang('error_feusers'));
		
		$db =& $this->GetDb();
		
		$groups = array();
		$query = "SELECT G.id,G.groupname 
					FROM ".cms_db_prefix()."module_feusers_groups G
					LEFT JOIN ".cms_db_prefix()."module_feusers_belongs B
						ON B.groupid = G.id";
		$where=array();
		foreach($users as $userid=>$username) {
			$where[] = " B.userid = ".$userid;
		}
		if(count($where))
			$query .= " WHERE (".implode(" OR ",$where).") ";
		
		$query .= " ORDER BY G.id ASC";
		$dbresult = $db->Execute($query);
		while($dbresult && $row = $dbresult->FetchRow()) {
			$groups[$row['id']]=$row['groupname'];
		}
		return $groups;
	}
	
	
	/**
	 * function CreateTempMail($recipient_groups='',$subject='',$mailbody='',$last_userid=0,$processed_users=0,$recipients=0,$task='all',$archive_id='',$autosave=-1)
	 * not part of the module api
	 * stores mail data temporary in the db
	 *
	 * @param string $recipient_groups (optional) - A string of groups to send a mai to ( $group_id,$groupname; ... )
	 * @param string $subject (optional) - The mail subject
	 * @param string $mailbody (optional) - The message text
	 * @param integer $last_userid (optional) - The ID of the last user the mail was sent to
	 * @param integer $processed_users (optional) - Number of processed users in general
	 * @param integer $recipients (optional) - Number of recipients (users that have a valid email address)
	 * @param string $task (optional) - "all" = send mails to all users of the selected groups; "user" = only to a specified user; "selected" = only to a bunch of selected users; "error" = only to users who had no valid email address
	 * @param integer $archive_id (optional) - The ID of the archive mail (if this mail has been sent before)
	 * @param boolean $autosave (optional) - true|false save message after mail was sent or not
	 * @return array - ( true|false, $tmp_mail_id|errormessage )
	 */
	function CreateTempMail($recipient_groups='',$subject='',$mailbody='',$last_userid=0,$processed_users=0,$recipients=0,$task='all',$archive_id='',$autosave=-1) {
		
		$db =& $this->GetDb();
		
		if(empty($recipient_groups))
			$recipient_groups = $this->GetPreference("default_groups");
		if(empty($recipient_groups)|| empty($mailbody))
			return array(FALSE,$this->lang('error_insufficientparams',
				'recipient_groups / mailbody','createTempMail'));
		
		$parms = array();
		$parms[] = $db->GenID(cms_db_prefix()."module_feumailer_tmp_seq");
		$parms[] = get_userid();
		$parms[] = $recipient_groups;
		$parms[] = $subject;
		$parms[] = $mailbody;
		$parms[] = $last_userid;
		$parms[] = $processed_users;
		$parms[] = $recipients;
		$parms[] = $task;
		$parms[] = $archive_id;
		$parms[] = ($autosave!=-1?$autosave:$this->GetPreference("autosave",true));
		$query = "INSERT INTO ".cms_db_prefix()."module_feumailer_tmp 
						(id,
						sentby_id,
						recipient_groups,
						send_date,
						subject,
						mailbody,
						last_userid,
						processed_users,
						recipients,
						task,
						archive_id,
						save_message)
					VALUES (?,?,?,".$db->DBTimeStamp(time()).",?,?,?,?,?,?,?,?)";
		$dbresult = $db->Execute($query,$parms);
		if(!$dbresult)
			return array(FALSE,$this->Lang('error_db_create_tmpmail',$query));
		else
			return array(TRUE,$parms[0]);
	}
	
	
	/**
	 * function CreateArchiveMail($recipient_groups='',$subject='',$mailbody='',$last_userid=0,$processed_users=0,$recipients=0)
	 * not part of the module api
	 * stores mail data temporary in the db
	 *
	 * @param string $recipient_groups (optional) - A string of groups to send a mai to ( $group_id,$groupname; ... )
	 * @param string $subject (optional) - The mail subject
	 * @param string $mailbody (optional) - The message text
	 * @param integer $last_userid (optional) - The ID of the last user the mail was sent to
	 * @param integer $processed_users (optional) - Number of processed users in general
	 * @param integer $recipients (optional) - Number of recipients (users that have a valid email address)
	 * @return integer|false - The mail ID or false if fail
	 */
	function CreateArchiveMail($recipient_groups='',$subject='',$mailbody='',$last_userid=0,$processed_users=0,$recipients=0) {
		
		$db =& $this->GetDb();
		
		if(empty($recipient_groups))
			$recipient_groups = $this->GetPreference("default_groups");
		if(empty($recipient_groups)|| empty($mailbody)) {
			return false;
		}
		
		$parms = array();
		$parms[] = $db->GenID(cms_db_prefix()."module_feumailer_archive_seq");
		$parms[] = get_userid();
		$parms[] = $recipient_groups;
		$parms[] = $subject;
		$parms[] = $mailbody;
		$parms[] = $last_userid;
		$parms[] = $processed_users;
		$parms[] = $recipients;
		$query = "INSERT INTO ".cms_db_prefix()."module_feumailer_archive 
						(id,
						sentby_id,
						recipient_groups,
						send_date,
						subject,
						mailbody,
						last_userid,
						processed_users,
						recipients)
					VALUES (?,?,?,".$db->DBTimeStamp(time()).",?,?,?,?,?)";
		$dbresult = $db->Execute($query,$parms);
		if(!$dbresult) {
			return false;
		}
			
		else {
			return $parms[0];
		}
	}
	
	
	/**
	 * function GetGroups()
	 * not part of the module api
	 * gets all frontend user groups
	 *
	 * @return array - ($groupname . $usercount => $group_id . $groupname . $usercount )
	 */
	function GetGroups() {
		
		$feusers =& $this->GetModuleInstance('FrontEndUsers');
		if(!$feusers)
			return $this->DisplayErrorPage($id,$returnid,	$this->Lang('error_feusers'));
		
		$default_groups = array();
		$def_groups = explode(';',$this->GetPreference('default_groups',''));
		if(!empty($def_groups[0])) {
			foreach($def_groups as $def_group) {
				$dg = explode(',',$def_group);
				if(isset($dg[1]))
					$default_groups[$dg[0]]=$dg[1];
			}
		}
		
		$db =& $this->GetDb();
		$groups=array();
		$query = "SELECT COUNT(U.id) AS usercount, G.id AS group_id, G.groupname
					FROM ".cms_db_prefix()."module_feusers_users U 
					LEFT JOIN ".cms_db_prefix()."module_feusers_belongs B
					ON B.userid = U.id
					LEFT JOIN ".cms_db_prefix()."module_feusers_groups G 
					ON G.id = B.groupid
					GROUP BY G.id 
					ORDER BY G.id ASC";
		$dbresult = $db->Execute($query);
		while($dbresult && $row = $dbresult->FetchRow()) {
			$groups[$row['groupname']." (".$row['usercount']." ".$this->lang("users").")"]=$row['group_id'].','.$row['groupname'].','.$row['usercount'];
		}
		return $groups;
	}
	
	
	/**
	 * function GetArchiveMails()
	 * not part of the module api
	 * gets all archive mails
	 *
	 * @return array - ( $mail_id => array () )
	 */
	function GetArchiveMails() {
		
		$db =& $this->GetDb();
		
		$archive_mails = array();
		$query = "SELECT COUNT(L.id) AS logs, A.*, L.tmp_id, U.username 
			FROM ".cms_db_prefix()."module_feumailer_archive A 
			LEFT OUTER JOIN ".cms_db_prefix()."module_feumailer_logs L
			ON L.archive_id = A.id 
			LEFT OUTER JOIN ".cms_db_prefix()."users U
			ON U.user_id = A.sentby_id 
			GROUP BY A.id
			ORDER BY A.send_date DESC";
		$dbresult = $db->Execute($query);
		while($dbresult && $row = $dbresult->FetchRow()) {
				$archive_mails[$row['id']]['id'] 				= $row['id'];
				$archive_mails[$row['id']]['sentby'] 			= $row['username'];
				$archive_mails[$row['id']]['recipient_groups'] = $row['recipient_groups'];
				$archive_mails[$row['id']]['send_date'] 		= $row['send_date'];
				$archive_mails[$row['id']]['subject'] 			= $row['subject'];
				$archive_mails[$row['id']]['last_userid'] 	= $row['last_userid'];
				$archive_mails[$row['id']]['tmp_id'] 			= $row['tmp_id'];
				
				if($row['recipients']==$row['processed_users'])
					$archive_mails[$row['id']]['errorcode'] 	= 0;
				else
					$archive_mails[$row['id']]['errorcode'] 	= 1;
				
				$archive_mails[$row['id']]['processed_users'] = $row['processed_users'];
				$archive_mails[$row['id']]['recipients'] 		= $row['recipients'];
				
				if($row['logs']>0)
					$archive_mails[$row['id']]['logs'] 		= true;
				else
					$archive_mails[$row['id']]['logs'] 		= false;
		}
		return $archive_mails;
	}
	
	
	/**
	 * function GetTempMails()
	 * not part of the module api
	 * gets all temporary mails
	 *
	 * @return array - ( $mail_id => array () )
	 */
	function GetTempMails() {
		
		$db =& $this->GetDb();
		
		$tmp_mails=array();
		$query = "SELECT COUNT(L.id) AS logs, T.*, L.archive_id AS log_archive_id, U.username 
					FROM ".cms_db_prefix()."module_feumailer_tmp T 
					LEFT OUTER JOIN ".cms_db_prefix()."module_feumailer_logs L
					ON L.tmp_id = T.id 
					LEFT OUTER JOIN ".cms_db_prefix()."users U
					ON U.user_id = T.sentby_id 
					GROUP BY T.id 
					ORDER BY T.send_date DESC";
		
		$dbresult = $db->Execute($query);
		while($dbresult && $row = $dbresult->FetchRow()) {
			$tmp_mails[$row['id']]['id'] 				= $row['id'];
			$tmp_mails[$row['id']]['sentby'] 			= $row['username'];
			$tmp_mails[$row['id']]['recipient_groups']= $row['recipient_groups'];
			$tmp_mails[$row['id']]['send_date'] 		= $row['send_date'];
			$tmp_mails[$row['id']]['subject'] 			= $row['subject'];
			$tmp_mails[$row['id']]['last_userid'] 		= $row['last_userid'];
			$tmp_mails[$row['id']]['archive_id'] 		= $row['log_archive_id'];
			$tmp_mails[$row['id']]['a_id'] 			= $row['archive_id'];
			$tmp_mails[$row['id']]['task'] 			= $row['task'];
			$tmp_mails[$row['id']]['autosave'] 		= $row['save_message'];
			
			if($row['recipients']==$row['processed_users'])
				$tmp_mails[$row['id']]['errorcode'] 	= 0;
			else
				$tmp_mails[$row['id']]['errorcode'] 	= 1;
			
			$tmp_mails[$row['id']]['processed_users'] = $row['processed_users'];
			$tmp_mails[$row['id']]['recipients'] 		= $row['recipients'];
			
			if($row['logs']>0)
				$tmp_mails[$row['id']]['logs'] 		= true;
			else
				$tmp_mails[$row['id']]['logs'] 		= false;
		}
		return $tmp_mails;
		
	}
	
	
	/**
	 * function GetGroups($mail_id,$mail_type)
	 * not part of the module api
	 * gets all data of one speicifed mail
	 *
	 * @param integer $mail_id - The ID of the mail
	 * @param string $mail_type (optional) - "tmp" or "archive" (default is "archive")
	 * @return array|false
	 */
	function GetMail($mail_id,$mail_type="archive") {
		
		$db =& $this->GetDb();
		
		$query = "SELECT COUNT(L.id) AS logs, M.*, L.".$mail_type."_id, U.username 
					FROM ".cms_db_prefix()."module_feumailer_".$mail_type." M 
					LEFT OUTER JOIN ".cms_db_prefix()."module_feumailer_logs L
					ON L.".$mail_type."_id = M.id 
					LEFT OUTER JOIN ".cms_db_prefix()."users U
					ON U.user_id = M.sentby_id 
					WHERE M.id=".$mail_id."
					GROUP BY M.id";
		$dbresult = $db->Execute($query);
		if($dbresult && $row = $dbresult->FetchRow())
			return $row;
		else
			return false;
	}
	
	
	/**
	 * function CreateLog($params)
	 * not part of the module api
	 * create a log entry
	 *
	 * @param array $params
	 * @return integer|false - The log ID or false if fail
	 */
	function CreateLog($params) {
		
		$db =& $this->GetDb();
		
		if($params[0]=='')
			$params[0] = $db->GenID(cms_db_prefix()."module_feumailer_logs_seq");
		
		$query = "INSERT INTO ".cms_db_prefix()."module_feumailer_logs 
						(id,
						archive_id,
						tmp_id,
						sentby_id,
						recipient_id,
						recipient_groups,
						send_date,
						errorcode,
						subject,
						tmp_errorcode,
						recieved)
					VALUES (?,?,?,?,?,?,".$db->DBTimeStamp(time()).",?,?,?,?)";
		$dbresult = $db->Execute($query, $params);
		if(!$dbresult) {
			return false;
		}
		return $params[0];
	 }
	
	
	/**
	 * function UpdateLog($params)
	 * not part of the module api
	 * create a log entry
	 *
	 * @param array $params
	 * @return boolean
	 */
	 /* Not used yet
	function UpdateLog($params) {
		
		$db =& $this->GetDb();
		
		$query = "UPDATE ".cms_db_prefix()."module_feumailer_logs 
					SET send_date=". $db->DBTimeStamp(time()) .", tmp_errorcode=?, sentby_id=? 
					WHERE archive_id=? AND recipient_id=?";
		$dbresult = $db->Execute($query,$params);
		if(!$dbresult) {
			return false;
		}
		return true;
	}
	*/
	
	
	/**
	 * function GetLogs()
	 * not part of the module api
	 * gets all logs
	 *
	 * @return array
	 */
	function GetLogs() {
		
		$db =& $this->GetDb();
		
		$query = "SELECT MAX(L.tmp_errorcode) AS log_error, L.*, U.username FROM ".cms_db_prefix()."module_feumailer_logs L 
					LEFT OUTER JOIN ".cms_db_prefix()."users U 
					ON U.user_id=L.sentby_id 
					GROUP BY L.tmp_id 
					ORDER BY L.send_date DESC";
		$dbresult = $db->Execute($query);
		$result = array();
		while($dbresult && $row = $dbresult->FetchRow()) {
			
			$result[] = $row;
			
		}
		return $result;
	}
	
	
	/**
	 * function GetLogID($mail_id, $userid)
	 * not part of the module api
	 * gets the ID of a log entry
	 *
	 * @param integer $mail_id
	 * @param integer $userid
	 * @return integer
	 */
	function GetLogID($mail_id, $userid) {
		
		$db =& $this->GetDb();
		
		$query = "SELECT id FROM ".cms_db_prefix()."module_feumailer_logs 
			WHERE archive_id=? AND recipient_id=?";
		$dbresult = $db->Execute($query, array($mail_id, $userid));
		if($dbresult && $row = $dbresult->FetchRow())
			return $row['id'];
		
		return false;
		
	}
	
	
	/**
	 * function TrackBug($log_id)
	 * not part of the module api
	 * check if a mail has been read
	 *
	 * @param integer $log_id
	 * @return file
	 */
	function TrackBug($log_id) {
		
		$db =& $this->GetDb();
		
		$query = "UPDATE ".cms_db_prefix()."module_feumailer_logs 
					SET recieved = ? WHERE id=?";
		$dbresult = $db->Execute($query,array(true,$log_id));
		
		$img_file = dirname(__FILE__). DIRECTORY_SEPARATOR .'images'. DIRECTORY_SEPARATOR .'trackBug.gif';

		if(file_exists($img_file) && is_readable($img_file)) {
			
			ob_end_clean();
			ob_start();
			
			header("Content-Type: image/gif");
			header('Content-Disposition: inline; filename=logo.gif');
			header("Cache-Control: no-store, no-cache, must-revalidate");
			header("Cache-Control: post-check=0, pre-check=0", false);
			header("Pragma: no-cache");
			readfile($img_file);
			
			ob_end_flush();
		}
		
		exit;
	}
	
	
	function DeleteMail($mail_type,$mail_id) {
		
		$db =& $this->GetDb();
		
		$query = "DELETE FROM ".cms_db_prefix()."module_feumailer_".$mail_type." 
					WHERE id=".$mail_id." LIMIT 1";
		$dbresult = $db->Execute($query);
		return $dbresult;
	}
	
	
	function DeleteLog($mail_type, $mail_id) {
		
		$db =& $this->GetDb();

		$query = "DELETE FROM ".cms_db_prefix()."module_feumailer_logs 
				WHERE ".$mail_type."_id=".$mail_id;
		$dbresult = $db->Execute($query);
		return $dbresult;
	}
	
	
	/**
	 * function IsValidEmailAddress($email)
	 * not part of the module api
	 * checks if an email address is valid or not
	 *
	 * @param string $email - the email address to check
	 * @return boolean
	 */
	function IsValidEmailAddress( $email ) {
		if( eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z0-9]{2,4})$", $email ) ) 
			return true;
		else
			return false;
	}

}
?>
