<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSmartImage (c) 2011 by Robert Campbell (calguy1000@cmsmadesimple.org)
#  
#  An addon module for CMS Made Simple to allow creating image tags in a smart
#  way to optimize performance.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) return;

$config = cmsms()->GetConfig();
$want_transform = 0;
$do_transform = 0;
$have_transform = 0;
$dest_fname = '';
$dest_url = '';
$img = '';
$srcfile = '';
$rel = 0;
$outp = array();  // output params
$outp['id'] = '';
$outp['name'] = '';
$outp['class'] = '';
$outp['src'] = '';
$outp['width'] = '';
$outp['height'] = '';
$outp['alt'] = '';
$outp['style'] = '';
$opp = array();  // operation params
$opp['overwrite'] = 0;
$opp['nocache'] = 0;
$opp['noembed'] = 0;
$opp['noauto'] = 0;
$opp['noautoscale'] = 0;
$opp['notag'] = 0;
$opp['src'] = '';
$opp['quality'] = 75;
$opp['filters'] = array();

$error = '';
foreach( $params as $key => $value )
{
  if( startswith($key,'filter_') )
    {
      // handle filter argument.
      $filter = ucwords(substr($key,strlen('filter_')));
      $args = explode(',',$value);
      $classname = 'CGImage_'.$filter.'_Filter';
      if( !class_exists($classname) )
	{
	  $error = $this->Lang('error_unknownfilter',$filter);
	  break;
	}

      // add it to the ops.
      $opp['filters'][] = array($classname,$args);

      // done.
      continue;
    }

  switch( $key )
    {
    case 'id':
    case 'class':
    case 'name':
    case 'alt':
    case 'style':
      $outp[$key] = trim($params[$key]);
      break;
    case 'width':
    case 'height':
      $outp[$key] = (int)$params[$key];
      break;

    case 'src':
      $opp[$key] = trim($params[$key]);
      break;

    case 'quality':
      $opp['quality'] = (int)$value;
      $opp['quality'] = min(100,max(0,$opp['quality']));
      break;

    case 'overwrite':
    case 'notag':
    case 'nocache':
    case 'noembed':
      $opp[$key] = cge_utils::to_bool($value);
      break;
    }
}
if( !$error && !$opp['src'] )
  {
    $error = $this->Lang('error_missingparam','src');
  }


//
// find the source image ... the actual filename
//
if( file_exists($opp['src']) )
  {
    // user specified the complete path to the file.
    $srcfile = $opp['src'];
    if( startswith($opp['src'],'/') ) $rel = 1;
  }    
if( !$srcfile && startswith($opp['src'],$config['uploads_url']) )
  {
    $tmp = str_replace($config['uploads_url'],$config['uploads_path'],$opp['src']);
    if( file_exists($tmp) ) $srcfile = $tmp;
  }
if( !$srcfile && startswith($opp['src'],$config['root_url']) )
  {
    $tmp = str_replace($config['root_url'],$config['root_path'],$opp['src']);
    if( file_exists($tmp) ) $srcfile = $tmp;
  }
if( !$srcfile && startswith($opp['src'],'/') )
  {
    $tmp = $config['root_path'].$opp['src'];
    if( file_exists($tmp) ) $srcfile = $tmp;
  }
if( !$srcfile && isset($config['ssl_url']) && startswith($opp['src'],$config['ssl_url']) )
  {
    $tmp = str_replace($config['ssl_url'],$config['root_path'],$opp['src']);
    if( file_exists($tmp) ) $srcfile = $tmp;
  }

if( !$srcfile )
  {
    $error = $this->Lang('error_srcnotfound',$opp['src']);
  }

// now do some intelligence, and see if the width, and height parameters passed in
// match the image size... if not, add a filter.
if( !$error && ($outp['width'] > 0 || $outp['height'] > 0) && $opp['noautoscale'] == 0 )
{
  $tmp = getimagesize($srcfile);
  if( is_array($tmp) )
    {
      if( $outp['width'] != $tmp[0] || $outp['height'] != $tmp[1] )
	{
	  // we wanna display the file at a different dimenion.
	  $args = '';
	  $filter = '';
	  if( $outp['width'] && $outp['height'] )
	    {
	      // gonna do a crop to fit
	      $filter = 'CGImage_Croptofit_Filter';
	      $args = array((int)$outp['width'],(int)$outp['height']);
	    }
	  else if( $outp['width'] )
	    {
	      // gonna do a resize
	      $filter = 'CGImage_Resize_Filter';
	      $args = array('w',(int)$outp['width']);
	    }
	  else if ( $outp['height'] )
	    {
	      // gonna do a resize
	      $filter = 'CGImage_Resize_Filter';
	      $args = array('w',(int)$outp['width']);
	    }
	  if( is_array($args) && $filter != '' )
	    {
	      $found = 0;
	      for( $i = 0; $i < count($opp['filters']); $i++ )
		{
		  if( $opp['filters'][$i][0] == 'CGImage_Resize_Filter' )
		    {
		      $found = 1;
		      break;
		    }
		}
	      if( !$found )
		{
		  $opp['filters'][] = array($filter,$args);
		}
	    }
	}
    }
}

if( !$error && count(array_keys($opp['filters'])) )
  {
    //
    // we're doing some kind of magic to the image.
    //
    $want_transform = 1;
  }

if( !$error && $srcfile && $want_transform )
  {
    // calculate our destination name and url.
    $tmp = basename($srcfile);
    $ext = strrchr($srcfile,'.');
    $t2 = md5(serialize($opp));
    $destname = substr($tmp,0,strlen($tmp)-strlen($ext)).'-'.$t2.$ext;
    
    $destdir = $config['uploads_path'].'/_'.$this->GetName();
    if( !is_dir($destdir) ) @mkdir($destdir);
    if( !is_dir($destdir) )
      {
	$error = $this->Lang('error_mkdir',$destdir);
      }
    else
      {
	// see if it exists
	$dest_fname = $destdir.'/'.$destname;
	$dest_url = $this->get_cached_image_url($destname);
	if( !file_exists($dest_fname) || $opp['overwrite']  )
	  {
	    $do_transform = 1;
	  }
      }
  }
else if( !$error && $srcfile )
  {
    // no transofmration... just use the src image
    $dest_fname = $srcfile;
    $dest_url = $opp['src'];
  }

if( !$error && $do_transform )
  {
    try
      {
	// load the image.
	$img = new CGImageBase($srcfile);

	// process filters
	$i = 0;
	while( !$error && $i < count($opp['filters']) )
	  {
	    $filter = $opp['filters'][$i][0];
	    $filter_obj = new $filter($opp['filters'][$i][1]);
	    $img = $filter_obj->transform($img);
	    $i++;
	  }

	// and write the thing.
	if( !$error && is_object($img) )
	  {
	    $img->save($dest_fname,$opp['quality']);
	  }
      }
    catch( Exception $e )
      {
	$error = $e->getMessage();
      }
  } // if


// if we have an error, display it... we're done.
if( $error != '')
  {
    $smarty->trigger_error($error);
    return;
  }

// at this point, we're ready to handle building the tag.
if( $opp['nocache'] )
  {
    $dest_url .= '?x='.time();
  }

// build the output.
$output = '';
global $CMS_STYLESHEET;
if( $opp['notag'] || isset($CMS_STYLESHEET) )
  {
    if( !$opp['noembed'] && $this->can_embed($dest_fname) )
      {
	$type = cge_utils::get_mime_type($dest_fname);
	if( $type && $type != 'unknown' ) 
	  {
	    $tmp = base64_encode(file_get_contents($dest_fname));
	    $output = 'data:'.$type.';base64,'.$tmp;
	  }
      }

    if( !$output )
      {
	$output = $dest_url;
      }
  }
else
  {
    //
    // gotta build a tag.
    //
    // get the src first.
    if( !$opp['noembed'] && $this->can_embed($dest_fname) )
      {
	$type = cge_utils::get_mime_type($dest_fname);
	if( $type && $type != 'unknown' ) 
	  {
	    $tmp = base64_encode(file_get_contents($dest_fname));
	    $outp['src'] = 'data:'.$type.';base64,'.$tmp;
	  }
      }

    if( !isset($outp['src']) || !$outp['src'] )
      {
	// fallback to the destination url.
	$outp['src'] = $dest_url;
      }

    if( !$outp['width'] && !$outp['height'] && !$opp['noauto'] )
      {
	$details = getimagesize($dest_fname);
	if( is_array($details) )
	  {
	    $outp['width'] = (int)$details[0];
	    $outp['height'] = (int)$details[1];
	  }
      }

    // now we can build the tag.
    if( !$outp['alt'] )
      {
	$outp['alt'] = basename($dest_fname);
      }

    $output = '<img';
    foreach( $outp as $key => $value )
      {
	if( !$value ) continue;
	$output .= ' '.$key.'="'.$value.'"';
      }
    $output .= '/>';
  }

echo $output;
#
# EOF
#
?>
