<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGMyOrders (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module to allow for customers to see and intereact with past
#  invoices.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialize
//
$orders_mod = cms_utils::get_module('Orders');
$the_template = $orders_mod->GetPreference('dflt_invoice_template');

//
// get parameters
//
if( !isset($params['order']) ) return;
$order_id = (int)$params['order'];
$order_obj = orders_ops::load_by_id($order_id);
if( !is_object($order_obj) )
  {
    $this->Audit($order_id,$this->GetName(),'Attempt to view invoice for invalid order');
    return;
  }
// hwere we should do some security checks...

// get the view count.... and make sure we're not overgoing the limit.
$assocdata = new AssocData($db,$this->GetName());
$viewlist = $assocdata->Get('viewdata');
if( $viewlist) $viewlist = unserialize($viewlist); else $viewlist = array();
$nviews = (isset($viewlist[$order_id]))?$viewlist[$order_id]:0;
$nviews++;
$maxviews = (int)$this->GetPreference('max_invoice_views',0);
if( $maxviews != 0 && $nviews > $maxviews )
  {
    // too many views...
    $this->Audit($order_id,$this->GetName(),'Attempt to view an invoice too many times: '.$nviews);
    return;
  }
$viewlist[$order_id] = $nviews;
$assocdata->Set('viewdata',serialize($viewlist));
  
$smarty->assign('ordernumber',$order_obj->get_invoice());
$smarty->assign('currencysymbol',cg_ecomm::get_currency_symbol());
$smarty->assign('weightunits',cg_ecomm::get_weight_units());
$smarty->assign('order',$order_obj->to_array());
$smarty->assign('order_obj',$order_obj);
$smarty->assign('Orders',$orders_mod);

echo $orders_mod->ProcessTemplateFromDatabase('invoice_'.$the_template);
#
# EOF
#
?>