<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGMyOrders (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module to allow for customers to see and intereact with past
#  invoices.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

$cgextensions = cms_join_path($gCms->config['root_path'],'modules',
	'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
	echo '<h1><font color="red">ERROR: The CGExtensions module could not be found. Please install it.</font></h1>';
	return;
}
require_once($cgextensions);


class CGMyOrders extends CGExtensions
{
  /**
   * Returns the module name.
   *
   * @abstract
   * @internal
   * @return string
   */
  public function GetName()
  {
    return get_class();
  }

  
  /**
   * Returns a human readable module name.
   *
   * @abstract
   * @return string
   */
  public function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }


  /**
   * Return a version string.
   *
   * @abstract
   * @return string
   */
  public function GetVersion()
  {
    return '1.0';
  }


  /**
   * Returns module help.
   *
   * @abstract
   * @return string
   */
  public function GetHelp()
  {
    return $this->Lang('help');
  }


  /**
   * Return the authors name.
   * 
   * @abstract
   * @return string
   */
  public function GetAuthor()
  {
    return 'Robert Campbell';
  }


  /**
   * Return the authors email address.
   * 
   * @abstract
   * @return string
   */
  public function GetAuthorEmail()
  {
    return 'calguy1000@cmsmadesimple.org';
  }


  /**
   * Returns the module change history.
   * 
   * @abstract
   * @return string
   */
  public function GetChangeLog()
  {
    return file_get_contents(dirname(__FILE__).'/changelog.inc');
  }


  /**
   * Test wether this function is a plugin module.
   *
   * To work with order processing modules, it is advised that this method return true.
   * 
   * @abstract
   * @return boolean
   */
  public function IsPluginModule()
  {
    return true;
  }


  /**
   * Does this module have an admin interface?
   *
   * @abstract
   * @return boolean
   */
  public function HasAdmin()
  {
    return true;
  }


  /**
   * If the module has an admin interface, this method returns the key name of the
   * top level admin menu that the modules menu item should be placed in.
   *
   * @see CmsModule::GetAdminSection()
   * @abstract
   * @return string
   */
  public function GetAdminSection()
  {
    return 'ecommerce';
  }


  /**
   * Returns a description of this module suitable for administrators.
   *
   * @see CmsModule::GetAdminDescription()
   * @abstract
   * @return string
   */
  public function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /**
   * If the module has an admin interface, this 
   *
   * @see CmsModule::GetVisibleToAdminUser()
   * @abstract
   * @return string
   */
  public function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Site Preferences') || $this->CheckPermission('Modify Templates');
  }


  /**
   * Returns an array of strings indicating which modules (and versions of those modules)
   * that this module depends upon.
   *
   * @see CmsModule::GetDependencies()
   * @abstract
   * @return array
   */
  public function GetDependencies()
  {
    return array('CGExtensions'=>'1.25.1',
		 'CGEcommerceBase'=>'1.2.4',
		 'Orders'=>'1.12.4');
  }


  /**
   * Returns a version string stating the minimum CMS Version that this module is 
   * compatible with
   *
   * @see CmsModule::MinimumCMSVersion()
   * @abstract
   * @return string
   */
  public function MinimumCMSVersion()
  {
    return "1.9.2";
  }


  /**
   * Returns a message that should be displayed after the installation of the module.
   *
   * @see CmsModule::InstallPostMessage()
   * @abstract
   * @return string
   */
  public function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /**
   * Returns a message that should be displayed after the un-installation of the module.
   *
   * @see CmsModule::UninstallPostMessage()
   * @abstract
   * @return string
   */
  public function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /**
   * Returns a message that should be displayed before the un-installation of the module.
   *
   * @see CmsModule::UninstallPreMessage()
   * @abstract
   * @return string
   */
  public function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }

	
  /**
   * @see CmsModule::SetParameters()
   * @abstract
   * @return void
   */
  public function SetParameters()
  {
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();
    
    $this->CreateParameter('action','',$this->Lang('param_action'));
    $this->CreateParameter('useridtemplate','',$this->Lang('param_useridtemplate'));
    $this->CreateParameter('orderlisttemplate','',$this->Lang('param_orderlisttemplate'));
    $this->CreateParameter('invoicetemplate','',$this->Lang('param_invoicetemplate'));
    $this->CreateParameter('order','',$this->Lang('param_order'));
    $this->CreateParameter('email','',$this->Lang('param_email'));

    $this->SetParameterType('useridtemplate',CLEAN_STRING);
    $this->SetParameterType('orderlisttemplate',CLEAN_STRING);
    $this->SetParameterType('invoicetemplate',CLEAN_STRING);

    $this->SetParameterType('order',CLEAN_INT);
    $this->SetParameterType('email',CLEAN_STRING);
    $this->SetParameterType('userid_submit',CLEAN_STRING);
  }

} // class
