<?php
global $gCms;
$config = $gCms->getConfig();
require_once(cms_join_path($config['root_path'], 'lib', 'classes', 'module_support', 'modtemplates.inc.php'));

class {{$module->getModuleName()}}ObjectBase {


	// NEW WAY 
	protected $id;
	protected $user_id;
	protected $created_at;
	protected $created_by;
	protected $updated_at;
	protected $updated_by;
	protected $vars = array();
	protected $is_modified = false;
	
	const MODULE_NAME = '{{$module->getModuleName()}}';
	const DB_NAME = 'module_{{$table_name}}';
	const DB_ITEM = '{{$table_name}}';
	const UPLOADS_RELATIVE_URL = '/uploads/Modules/{{$module->getModuleName()}}';
	
	protected static $fields = array(
		'title',
		'parent_id',
		'parent_item',
		'order_by',
		'published',
	{{foreach from=$extra_fields item=field}}
		'{{$field.name}}',
	{{/foreach}}
		'full_text_search'
	);
	
	public function __set($var, $val)
	{
			$this->is_modified = true;
      $this->vars[$var] = $val;
  }

  public function __get($var)
	{
		try
		{
			if(method_exists($this, $var))
			{
				return $this->$var();
			}
	    elseif (array_key_exists($var, $this->vars))
			{
	    	return $this->vars[$var];
	    } 
			else 
			{
	    	//throw new Exception("Property $var does not exist");
	    }
		}
		catch(Exception $e)
		{
			echo 'Error: ',  $e->getMessage(), "\n";
		}
  }

		public function set($name, $value) {
			if ($this->$name != $value) {
				$this->__set($name, $value);
			}
		}

		public function get($name) 
		{
			// DEPRECATED
			return $this->__get($name);
		}

	public function __toString()
	{
		return (string)$this->title;
	}

	public function getId() {
		return $this->id;
	}
	
	public function setId($value) {
		$this->is_modified = true;
		$this->id = $value;
	}
	
	public function getUserId() {
		return $this->user_id;
	}
	
	public function setUserId($value) {
		$this->is_modified = true;
		$this->user_id = $value;
	}

	public function getUser()
	{
		return CMSUser::retrieveByPk($this->user_id);
	}

	public function full_text_search()
	{
		$text = $this->title;
		{{foreach from=$extra_fields item=field}}
		{{if $field.type == 'textarea' || $field.type == 'text' || $field.type == 'textarea_plain'}}
		$text .= ' ' . $this->{{$field.name}};
		{{/if}}{{/foreach}}
		return $text;
	}


	// OLD WAY
	

	public function getParentId() {
		return $this->parent_id;
	}

	public function getTitle() {
		return $this->title;
	}

	public function getCreatedAt() {
		return $this->created_at;
	}

	public function getCreatedBy() {
		return $this->created_by;
	}

	public function getUpdatedAt() {
		return $this->updated_at;
	}

	public function getUpdatedBy() {
		return $this->updated_by;
	}

	public function getOrderBy() {
		return $this->order_by;
	}

	public function getParentItem() {
		return $this->parent_item;
	}

	public function getPublished() {
		return $this->published;
	}

	public function getCoreSlug()
	{
		return $this->title;
	}
	
	public function getFullTextSearch()
	{
		return $this->full_text_search();
	}
	
	public function setParentId($value) {
		$this->__set('parent_id', $value);
	}

	public function setTitle($value) {
		$this->__set('title', $value);
	}

	public function setCreatedAt($value) {
		$this->created_at = $value;
	}

	public function setCreatedBy($value) {
		$this->created_by = $value;
	}

	public function setUpdatedAt($value) {
		$this->updated_at = $value;
	}

	public function setUpdatedBy($value) {
		$this->updated_by = $value;
	}

	public function setOrderBy($value) {
		$this->__set('order_by', $value);
	}

	public function setParentItem($value) {
		$this->__set('parent_item', $value);
	}

	public function setPublished($value) {
		$this->__set('published', $value);
	}
	
	public function setFullTextSearch($value)
	{
		$this->__set('full_text_search', $value);
	}


	{{foreach from=$extra_fields item=field}}

	public function get{{$field.camelcase}}($parse = {{if $field.type == 'textarea'}}true{{else}}false{{/if}}) {
	    if ($parse) {
	        return cms_module_ProcessTemplateFromData(new stdClass(), $this->{{$field.name}});
	    }
	    return $this->{{$field.name}};
	}
	
	public function set{{$field.camelcase}}($value) {
		{{if $field.type == 'date'}}
		if (is_array($value)) {
			if (array_key_exists('year'))
			{				
				$value = $value['year'] . '-' . $value['month'] . '-' . $value['day'];
			}
			else
			{
				$value = $value['0'] . '-' . $value['1'] . '-' . $value['2'];
			}
		}
		$value = str_replace('|','-',str_replace('/','-',$value));
		{{/if}}
		$this->__set('{{$field.name}}', $value);
	}
	
	{{if $field.form_type == 'module'}}
	{{if isset($field.foptions.multiple)}}
	public function get{{$field.camelcase}}Items()
	{
		$c = new MCFCriteria();
		$c->add('id', explode('|||', $this->{{$field.name}}), MCFCriteria::IN);
		return {{$field.foptions.module_name}}Object::doSelect($c);
	}
	{{else}}
	public function get{{$field.camelcase}}Object()
	{
		return {{$field.foptions.module_name}}Object::getById($this->{{$field.name}});
	}
	{{/if}}
	{{/if}}
	
	{{if $field.form_type == 'select'}}
	{{if isset($field.foptions.multiple)}}
	public function get{{$field.camelcase}}Values()
	{
		$values = explode('|||', $this->{{$field.name}});
		$labels = {{$field.select_options}};
		$items = array();
		foreach($values as $value)
		{
			if(isset($labels[$value]))	$items[$value] = $labels[$value];
		}
		return $items;
	}
	{{else}}
			public function get{{$field.camelcase}}Value()
			{
				$values = {{$field.select_options}};
				if(isset($values[$this->{{$field.name}}]))	return $values[$this->{{$field.name}}];
				return null;
			}
	{{/if}}
	{{/if}}
		
	{{if $field.form_type == 'group'}}
	{{if isset($field.foptions.multiple)}}
	public function get{{$field.camelcase}}Values()
	{
		$values = explode('|||', $this->{{$field.name}});
		$items = array();
		foreach($values as $value)
		{
			$items[$value] = (string)CMSGroup::retrieveByPk($value);
		}
		return $items;
	}
	{{else}}
			public function get{{$field.camelcase}}Value()
			{
				return (string)CMSGroup::retrieveByPk($this->{{$field.name}});
			}
	{{/if}}
	{{/if}}	
	
	{{if $field.form_type == 'user'}}
	{{if isset($field.foptions.multiple)}}
	public function get{{$field.camelcase}}Values()
	{
		$values = explode('|||', $this->{{$field.name}});
		$items = array();
		foreach($values as $value)
		{
			$items[$value] = (string)CMSUser::getUserNameById($value);
		}
		return $items;
	}
	{{else}}
			public function get{{$field.camelcase}}Value()
			{
				return (string)CMSUser::getUserNameById($this->{{$field.name}});
			}
	{{/if}}
	{{/if}}
	
	{{if $field.form_type == 'file'}}
	public function get{{$field.camelcase}}Size($readable = true)
	{
		$file = self::getFilesPath() .DIRECTORY_SEPARATOR . $this->{{$field.name}};				
	 	return MX_Document::getFileSize($file, $readable);
	}
	
	public function get{{$field.camelcase}}Icon($icon_type = 'small')
	{
		$file = self::getFilesPath() .DIRECTORY_SEPARATOR . $this->{{$field.name}};				
		return MX_Document::getFileIcon($file, $icon_type);
	}
	
	public function get{{$field.camelcase}}Ext()
	{
		// list($ext, $divers) = array_reverse(explode('.',$this->{{$field.name}}));	
		// return $ext;
		return end(explode('.',$this->{{$field.name}}));
	}
	
	public function get{{$field.camelcase}}Url($id)
	{
		// list($ext, $divers) = array_reverse(explode('.',$this->{{$field.name}}));	
		// return $ext;
		$prettyurl = '{{$module->getModuleName()|lower}}/download/'.$this->getId().'/{{$field.name}}/'.self::retrieveFilename($this->get{{$field.camelcase}}());
		global $gCms;
		return $gCms->modules['{{$module->getModuleName()}}']['object']->CreateLink($id,'download','','',array('item_id' => $this->getId(), 'field' => '{{$field.name}}'),'',true,false,'',false,$prettyurl);
//		return;
	}
	
	{{if ($field.type == 'image') && $field.image_width && $field.image_height}}
	public function get{{$field.camelcase}}OriginalPicture()
	{
		return str_replace('{{$field.image_width}}_{{$field.image_height}}_', '', $this->get{{$field.camelcase}}());
	}	
	public function get{{$field.camelcase}}OriginalPictureUrl()
	{
		// TODO: Return something
		//return str_replace('{{$field.image_width}}_{{$field.image_height}}_', '', $this->get{{$field.camelcase}}());
	}
	
	protected function createResizedImageFor{{$field.camelcase}}($filename)
	{
		$destination = self::getFilesFullPath() . DIRECTORY_SEPARATOR . $filename;
		
		list($image_width, $image_height, $image_type) = getimagesize($destination);
		switch ($image_type) 
		{
			case IMAGETYPE_GIF:
				$img = imagecreatefromgif($destination);
				break;
			case IMAGETYPE_JPEG:
				$img = imagecreatefromjpeg($destination);
				break;
			case IMAGETYPE_PNG:
				$img = imagecreatefrompng($destination);
				break;
		}
			
		$factor = max($image_width / {{$field.image_width}}, $image_height / {{$field.image_height}});
		$new_width = min(round($image_width / $factor), $image_width);
		$new_height = min(round($image_height / $factor), $image_height);
		$new_img = imagecreatetruecolor($new_width, $new_height);
		imagecopyresampled($new_img, $img, 0, 0, 0, 0, $new_width, $new_height, $image_width, $image_height);
		switch ($image_type) {
			case IMAGETYPE_GIF:
				imagegif($new_img, self::getFilesFullPath() . DIRECTORY_SEPARATOR . '{{$field.image_width}}_{{$field.image_height}}_' . $filename);
				break;
			case IMAGETYPE_JPEG:
				imagejpeg($new_img, self::getFilesFullPath() . DIRECTORY_SEPARATOR . '{{$field.image_width}}_{{$field.image_height}}_' . $filename);
				break;
			case IMAGETYPE_PNG:
				imagepng($new_img, self::getFilesFullPath() . DIRECTORY_SEPARATOR . '{{$field.image_width}}_{{$field.image_height}}_' . $filename);
				break;
		}
		return self::UPLOADS_RELATIVE_URL . '/' . '{{$field.image_width}}_{{$field.image_height}}_' . $filename;
	}
	{{/if}}
	
	public function upload{{$field.camelcase}}($id)
	{
		if (isset($_FILES[$id.'{{$field.name}}']) && ($_FILES[$id.'{{$field.name}}']['size'] > 0)) 
		{
			$filename = self::checkFilename($_FILES[$id.'{{$field.name}}']);
			
			if (move_uploaded_file($_FILES[$id.'{{$field.name}}']['tmp_name'], self::getFilesFullPath() . DIRECTORY_SEPARATOR . $filename)) {
				$file = self::UPLOADS_RELATIVE_URL . DIRECTORY_SEPARATOR . $filename;
				
				{{if ($field.type == 'image') && $field.image_width && $field.image_height}}
				$file = $this->createResizedImageFor{{$field.camelcase}}($filename);
				{{/if}}
			}		
		
			$this->delete{{$field.camelcase}}();
			$this->set{{$field.camelcase}}($file);
		}
	}
	
	public function download{{$field.camelcase}}()
	{
		$file = self::getFilesPath() . str_replace('/', DIRECTORY_SEPARATOR, $this->get{{$field.camelcase}}());
		if(is_file($file))
		{
			//$pathinfo = pathinfo($file);			
			header("Content-Length: ".filesize($file));
			header('Content-type: ' . self::getMimeType($file));
			header('Content-Disposition: inline; filename="' . self::retrieveFilename($this->get{{$field.camelcase}}()) . '"');
			echo file_get_contents($file);
		}
		else
		{			
			header("HTTP/1.0 404 Not Found");
		}
		exit;
	}

	public function delete{{$field.camelcase}}()
	{
		if($this->get{{$field.camelcase}}() != '')
		{
			debug_display('Deleting file {{$field.camelcase}} - '.self::getFilesPath() . DIRECTORY_SEPARATOR . $this->get{{$field.camelcase}}());
		
			if (is_file(self::getFilesPath() . DIRECTORY_SEPARATOR . $this->get{{$field.camelcase}}()))
			{
				$result = unlink(self::getFilesPath() . DIRECTORY_SEPARATOR . $this->get{{$field.camelcase}}());
				debug_display('Delete ' . self::getFilesPath() . DIRECTORY_SEPARATOR . $this->get{{$field.camelcase}}() . ' Result: ' . $result);
			}	
			{{if ($field.type == 'image') && $field.image_width && $field.image_height}}
			if (is_file(self::getFilesPath()  . DIRECTORY_SEPARATOR .  $this->get{{$field.camelcase}}OriginalPicture()))
			{
				$result = unlink(self::getFilesPath()  . DIRECTORY_SEPARATOR .  $this->get{{$field.camelcase}}OriginalPicture()); // Deleting the original picture as well
				debug_display('Delete ' . self::getFilesPath()  . DIRECTORY_SEPARATOR .  $this->get{{$field.camelcase}}OriginalPicture() . ' Result: ' . $result);
			}	
			{{/if}}
			$this->set{{$field.camelcase}}('');			
		}
	}
	
	{{/if}}

	{{/foreach}}

	protected static function getFilesPath()
	{
		{{if $files_path != ''}}
		$path = '{{$files_path}}';
		{{else}}
		global $gCms;
		$config = $gCms->GetConfig();
		$path = $config['root_path'];
		{{/if}}
		if (!is_dir($path . self::getUploadsRelativePath()))
		{
			mkdir($path . self::getUploadsRelativePath(),0777,true);
		}
		return $path;
	}
	
	protected static function getFilesFullPath()
	{
		return self::getFilesPath() . self::getUploadsRelativePath();
	}
	
	protected static function getUploadsRelativePath()
	{
		return str_replace('/', DIRECTORY_SEPARATOR, self::UPLOADS_RELATIVE_URL);
	}
	
	protected static function retrieveFilename($filename)
	{
		$clean = str_replace(self::UPLOADS_RELATIVE_URL, '', $filename);
		$clean = str_replace('/', '', $clean);
		return $clean;
	}
	
	public static function cleanFilename($filename)
  {
      $result = strtolower($filename);
			// Remove accents
      $result = strtr($result,  "�����������������������������������������������������",  "aaaaaaaaaaaaooooooooooooeeeeeeeecciiiiiiiiuuuuuuuuynn");

			// Soft way
			$result = str_replace("#", "No.", $result); 
			$result = str_replace("$", "Dollar", $result); 
			$result = str_replace("%", "Percent", $result); 
			$result = str_replace("^", " ", $result); 
			$result = str_replace("&", "and", $result); 
			$result = str_replace("*", " ", $result); 
			$result = str_replace("?", " ", $result);
			$result = str_replace(",", " ", $result);
			
      // strip all non word chars
      //$result = preg_replace('/\W/', ' ', $result); // HARD WAY...

      // replace all white space sections with a dash
      $result = preg_replace('/\ +/', '-', $result);
      // trim dashes
      $result = preg_replace('/\-$/', '', $result);
      $result = preg_replace('/^\-/', '', $result);
      return $result;
  }

	protected function checkFilename($file)
	{
		$pathinfo = pathinfo($file['name']);
		$filename = self::cleanFilename($pathinfo['filename']);
		$final_filename = self::cleanFilename($pathinfo['filename']);
		$i = 2;
		while (file_exists(self::getFilesFullPath() . DIRECTORY_SEPARATOR . $final_filename . '.' . $pathinfo['extension'])) {
			$final_filename = $filename.'-'.$i;
			++$i;
		}
		return $final_filename . '.' . $pathinfo['extension'];
	}

	//function

		public function downloadFile($field) {
			switch($field)
			{
			{{foreach from=$extra_fields item=field}}
			{{if $field.form_type == 'file'}}
			case '{{$field.name}}':
				return $this->download{{$field.camelcase}}($id);
				break;
			{{/if}}
			{{/foreach}}
			default:
				return false;
			}
		}

	public function uploadFiles($id) {
		{{foreach from=$extra_fields item=field}}
			{{if $field.form_type == 'file'}}
				$this->upload{{$field.camelcase}}($id);
			{{/if}}
		{{/foreach}}
		
		{{*}}
		global $gCms;
		$config = $gCms->GetConfig();
		$upload_path = self::UPLOADS_RELATIVE_URL . '/'; //'/uploads/Modules/{{$module->getModuleName()}}/';
		$upload_full_path = $config['root_path'].$upload_path;
		
		if (!is_dir($upload_full_path))
		{
			mkdir($upload_full_path,0777,true);
		}
		
		{{foreach from=$extra_fields item=field}}
			{{if $field.form_type == 'file'}}
			if (isset($_POST[$id.'{{$field.name}}_delete'])) {
				$this->set{{$field.camelcase}}('');
			} elseif (isset($_FILES[$id.'{{$field.name}}']) && ($_FILES[$id.'{{$field.name}}']['size'] > 0)) {
				$pathinfo = pathinfo($_FILES[$id.'{{$field.name}}']['name']);
				$filename = $pathinfo['basename'];
				$i = 2;
				while (file_exists($upload_full_path.$filename)) {
					$filename = $pathinfo['filename'].'-'.$i.'.'.$pathinfo['extension'];
					++$i;
				}
				$destination = $upload_full_path.$filename;
				if (move_uploaded_file($_FILES[$id.'{{$field.name}}']['tmp_name'], $destination)) {
					$this->set{{$field.camelcase}}($upload_path.$filename);
					{{if ($field.type == 'image') && $field.image_width && $field.image_height}}
					list($image_width, $image_height, $image_type) = getimagesize($destination);
					switch ($image_type) {
						case IMAGETYPE_GIF:
							$img = imagecreatefromgif($destination);
							break;
						case IMAGETYPE_JPEG:
							$img = imagecreatefromjpeg($destination);
							break;
						case IMAGETYPE_PNG:
							$img = imagecreatefrompng($destination);
							break;
					}
					$factor = max($image_width / {{$field.image_width}}, $image_height / {{$field.image_height}});
					$new_width = min(round($image_width / $factor), $image_width);
					$new_height = min(round($image_height / $factor), $image_height);
					$new_img = imagecreatetruecolor($new_width, $new_height);
					imagecopyresampled($new_img, $img, 0, 0, 0, 0, $new_width, $new_height, $image_width, $image_height);
					switch ($image_type) {
						case IMAGETYPE_GIF:
							imagegif($new_img, $upload_full_path.'{{$field.image_width}}_{{$field.image_height}}_'.basename($_FILES[$id.'{{$field.name}}']['name']));
							break;
						case IMAGETYPE_JPEG:
							imagejpeg($new_img, $upload_full_path.'{{$field.image_width}}_{{$field.image_height}}_'.basename($_FILES[$id.'{{$field.name}}']['name']));
							break;
						case IMAGETYPE_PNG:
							imagepng($new_img, $upload_full_path.'{{$field.image_width}}_{{$field.image_height}}_'.basename($_FILES[$id.'{{$field.name}}']['name']));
							break;
					}
					$this->set{{$field.camelcase}}($upload_path.'{{$field.image_width}}_{{$field.image_height}}_'.basename($_FILES[$id.'{{$field.name}}']['name']));
					{{/if}}
				}
			}
			{{/if}}
		{{/foreach*}}
	}
	
	protected static function getMimeType($filename) {
		$extension = strtolower(end(explode('.',$filename)));
		$mime_types = array(
			'txt' => 'text/plain',
			'htm' => 'text/html',
			'html' => 'text/html',
			'php' => 'text/html',
			'css' => 'text/css',
			'js' => 'application/javascript',
			'json' => 'application/json',
			'xml' => 'application/xml',
			'swf' => 'application/x-shockwave-flash',
			'flv' => 'video/x-flv',
			// images
			'png' => 'image/png',
			'jpe' => 'image/jpeg',
			'jpeg' => 'image/jpeg',
			'jpg' => 'image/jpeg',
			'gif' => 'image/gif',
			'bmp' => 'image/bmp',
			'ico' => 'image/vnd.microsoft.icon',
			'tiff' => 'image/tiff',
			'tif' => 'image/tiff',
			'svg' => 'image/svg+xml',
			'svgz' => 'image/svg+xml',
			// archives
			'zip' => 'application/zip',
			'rar' => 'application/x-rar-compressed',
			'exe' => 'application/x-msdownload',
			'msi' => 'application/x-msdownload',
			'cab' => 'application/vnd.ms-cab-compressed',
			// audio/video
			'mp3' => 'audio/mpeg',
			'qt' => 'video/quicktime',
			'mov' => 'video/quicktime',
			// adobe
			'pdf' => 'application/pdf',
			'psd' => 'image/vnd.adobe.photoshop',
			'ai' => 'application/postscript',
			'eps' => 'application/postscript',
			'ps' => 'application/postscript',
			// ms office
			'doc' => 'application/msword',
			'rtf' => 'application/rtf',
			'xls' => 'application/vnd.ms-excel',
			'ppt' => 'application/vnd.ms-powerpoint',
			// open office
			'odt' => 'application/vnd.oasis.opendocument.text',
			'ods' => 'application/vnd.oasis.opendocument.spreadsheet'
		);
		if (isset($mime_types[$extension])) {
			return $mime_types[$extension];
		}
		return 'application/octet-stream';
	}
	
	public function getSearchString() {
		$fields[] = $this->getTitle();
		{{foreach from=$extra_fields item=field}}
			{{if $field.column_type == 'C(255)' || $field.column_type == 'X'}}
			$fields[] = $this->get{{$field.camelcase}}();
			{{/if}}
		{{/foreach}}
		return implode(' ', $fields);
	}

	public function getParent() {
	    if ($this->parent_id) {
	        return self::getById($this->parent_id);
	    }
		return false;
	}

	{{if isset($parent_module) && $parent_module ne ''}}
	public function getParentModule()
	{
		if ($this->parent_item)
		{
			return {{$parent_module->getModuleName()}}Object::getById($this->parent_item);
		}
	}
	
	public function getParentModuleList(MCFCriteria $c)
	{
		$items = self::doSelect($c);
		$list = array();
		foreach($items as $item)
		{
			$list[$item->getParentModule()->__toString()][$item->getId()] = $item;
		}
		return $list;
	}
	{{/if}}

	public function getPossibleParents() {
		$objects = self::doSelect(new MCFCriteria());
		$possible_objects = array(0 => '');
		foreach ($objects as $object) {
			if (($object->getId() != $this->getId()) && !$object->isDescendantOf($this->getId())) {
				$possible_objects[$object->getId()] = $object->getTitle();
			}
		}

		return $possible_objects;
	}
	public function getPossibleParentsHierarchy($separator = ' - ')
	{
		$c = new MCFCriteria();
		$c->add('parent_id', '', MCFCriteria::ISEMPTY);
		$roots = self::doSelect($c);
		$array = array();
		
		foreach($roots as $root)
		{
			$array[$root->getId()] = $root->getTitle();
			$array = $array + self::getChildrenHierarchy($root->getId(), $separator, 1, $this->getId());
		}
		
		return $array;
	}
	
	public static function getChildrenHierarchy($id,$separator = ' - ', $level = 1, $without_childrens_of = null)
	{
		$array = array();
		$direct_childrens = self::getChildrensOf($id);
		foreach($direct_childrens as $children)
		{
			if ($children->getId() != $without_childrens_of)
			{
				$sep = '';
				for($i = 0; $i < $level; $i++){$sep .= $separator;}
				$array[$children->getId()] = $separator . $children->getTitle();
				$array = $array + self::getChildrenHierarchy($children->getId(), $separator, $level+1,$without_childrens_of); 
			}
		} 
		return $array;
	}
	
	public static function getChildrensOf($id)
	{
		$c = new MCFCriteria();
		$c->add('parent_id', $id, MCFCriteria::EQUAL);
		return self::doSelect($c);		
	}

	public function isDescendantOf($id) {
		$item = $this;
		while ($item = $item->getParent()) {
			if ($item->getId() == $id) {
				return true;
			}
		}
		return false;
	}

	public static function doCount(MCFCriteria $crit) {
		$c = clone $crit;
		global $gCms;
		$db = $gCms->GetDb();
		$c->addSelectColumn('COUNT(*) AS nbitems');
		$query = $c->buildQuery(cms_db_prefix().self::DB_NAME);
		$result = $db->execute($query, $c->values);
		$row = $result->FetchRow();
		return $row['nbitems'];
	}

	public static function doSelect(MCFCriteria $crit) {
		$c = clone $crit;
		global $gCms;
		$db = $gCms->GetDb();
		$query = $c->buildQuery(cms_db_prefix().self::DB_NAME);
		$result = $db->execute($query, $c->values);
		$objects = array();
		while ($result && $row = $result->FetchRow()) {
			$object = new {{$module->getModuleName()}}Object();
			$object->populateFromArray($row);
			$object->is_modified = false;
			$objects[$object->getId()] = $object;
		}
		return $objects;
	}

    public static function doSelectOne(MCFCriteria $crit) {
        $c = clone $crit;
        $c->setLimit(1);
        $objects = self::doSelect($c);
        return (count($objects) > 0) ? array_shift($objects) : false;
    }

	public static function getById($id) {
	    $c = new MCFCriteria();
	    $c->add('id', $id);
	    return self::doSelectOne($c);
	}

	public static function getTitles() {
		global $gCms;
		$db = $gCms->GetDb();
		$c = new MCFCriteria();
		$c->addAscendingOrderByColumn($gCms->modules[self::MODULE_NAME]['object']->getPreference('order_by', 'order_by'));
		$query = $c->buildQuery(cms_db_prefix().self::DB_NAME);
		$result = $db->execute($query, $c->values);
		$objects = array();
		while ($result && $row = $result->FetchRow()) {
			$objects[$row['id']] = $row['title'];
		}
		//asort($objects);
		return $objects;
	}

	public static function query($sql, $values = array()) {
		global $gCms;
		$db = $gCms->GetDb();
		return $db->execute($sql, $values);
	}
	
	public function populateFromArray(array $params) {
		if (isset($params['id'])) {
			$this->setId($params['id']);
		}		
		if (isset($params['user_id'])) {
			$this->setUserId($params['user_id']);
		}
		if (isset($params['parent_id'])) {
			$this->parent_id = $params['parent_id'];
		}
		if (isset($params['title'])) {
			$this->setTitle($params['title']);
		}
		if (isset($params['created_at'])) {
			$this->setCreatedAt($params['created_at']);
		}
		if (isset($params['created_by'])) {
			$this->setCreatedBy($params['created_by']);
		}
		if (isset($params['updated_at'])) {
			$this->setUpdatedAt($params['updated_at']);
		}
		if (isset($params['updated_by'])) {
			$this->setUpdatedBy($params['updated_by']);
		}
		if (isset($params['order_by'])) {
			$this->setOrderBy($params['order_by']);
		}
		if (isset($params['parent_item'])) {
			$this->setParentItem($params['parent_item']);
		}
		if (isset($params['published'])) {
			$this->setPublished($params['published']);
		}
		if (isset($params['full_text_search']))
		{
			$this->setFullTextSearch($params['full_text_search']);
		}
		{{foreach from=$extra_fields item=field}}
		if (isset($params['{{$field.name}}'])) {
			$this->set{{$field.camelcase}}($params['{{$field.name}}']);
		}
		{{/foreach}}
	}

	public function isNew() {
		return $this->getId() ? false : true;
	}

	public function populate($row)
	{
		if (isset($row[self::DB_ITEM.'__id']))
		{
			$this->setId($row[self::DB_ITEM.'__id']);
		}		
		
		if (isset($params['user_id'])) {
				$this->user_id = $row[self::DB_ITEM.'__user_id']; //$params['created_at'];
		}		
		if (isset($params['created_at'])) {
				$this->created_at = $row[self::DB_ITEM.'__created_at']; //$params['created_at'];
			}
		if (isset($params['created_by'])) {
			$this->created_by = $row[self::DB_ITEM.'__created_by']; //$params['created_by'];
		}
		if (isset($params['updated_at'])) {
			$this->updated_at = $row[self::DB_ITEM.'__updated_at']; //$params['updated_at'];
		}
		if (isset($params['updated_by'])) {
			$this->updated_by = $row[self::DB_ITEM.'__updated_by']; //$params['updated_by'];
		}
		
		foreach (self::$fields as $field)
		{
			if (isset($row[self::DB_ITEM.'__'.$field]))
			{
				$this->$field = $row[self::DB_ITEM.'__'.$field];
			}
		}
	}

	public static function generateSelectList()
	{
		$fields = array_merge(array('id','user_id','created_at','created_by','updated_at','updated_by'), self::$fields);
		$list = array();
		foreach ($fields as $field)
		{
			$list[] = self::DB_ITEM . '.'.$field.' as '. self::getRowName($field);
		}
		return implode(' , ',$list);
	}

  public static function getRowName($name)
	{
		return self::DB_ITEM . '__' . $name;
	}


	public function save($params = array()) {
		global $gCms;
		if ($this->getId()) {
		    if ($this->is_modified) {
		        $this->update($params);
		    }
		} else {
			$this->insert($params);
		}
		$gCms->modules['{{$module->getModuleName()}}']['object']->index($this);
		//	debug_display($entry); // TO IMPLEMENT: Show datas for debug
		return true;
	}

	public function delete() {
		global $gCms;
		if ($this->getId()) {
			$query = 'DELETE FROM '.cms_db_prefix().self::DB_NAME .' WHERE id = ?';
			$this->query($query, array($this->id));
			
			MX_RelationLink::cleanRelatedItems('{{$module->getModuleName()}}', $this->getId());
		}
		// DELETE ALL RELATED DOCUMENTS		
		{{foreach from=$extra_fields item=field}}
			{{if $field.form_type == 'file'}}
				$this->delete{{$field.camelcase}}();
			{{/if}}
		{{/foreach}}
		$gCms->modules['{{$module->getModuleName()}}']['object']->deindex($this);
		return true;
	}

	protected function insert($params = array()) {
		global $gCms;
		$db = $gCms->GetDb();
		$this->setId($db->GenID(cms_db_prefix(). self::DB_NAME . '_seq'));
		$query = 'SELECT MAX(order_by) + 1 AS order_by FROM '.cms_db_prefix().self::DB_NAME;
		$values = array();
		if ($this->parent_item) {
			$query .= ' WHERE parent_item = ?';
			$values[] = $this->parent_item;
		}
		$result = $db->execute($query, $values);
		$row = $result->FetchRow();
		$order_by = $row['order_by'] ? $row['order_by'] : 1;
		if(isset($params['frontend']))
		{
			$userid = null;
		}
		else
		{
			$userid = get_userid();
		}		
		$query = 'INSERT INTO '.cms_db_prefix().self::DB_NAME . '
			SET id = ?,
				user_id = ?,
			  parent_id = ?,
				title = ?,
				{{foreach from=$extra_fields item=field}}
				{{$field.name}} = ?,
				{{/foreach}}
				created_by = ?,
				created_at = NOW(),
				updated_by = ?,
				updated_at = NOW(),
				order_by = ?,
				parent_item = ?,
				published = ?,
				full_text_search = ?';
		$db->Execute($query, array(
		    $this->id,
				$this->user_id,
			$this->parent_id,
			$this->title,
			{{foreach from=$extra_fields item=field}}
			$this->{{$field.name}},
			{{/foreach}}
			$userid,
			$userid,
			$order_by,
			$this->parent_item,
			$this->published,
			$this->full_text_search()
		));
		$gCms->modules['{{$module->getModuleName()}}']['object']->SendEvent('ContentEditPost', array());
		return true;
	}

	protected function update($params = array()) {
		global $gCms;
		$db = $gCms->GetDb();
		if(isset($params['frontend']))
		{
			$userid = null;
		}
		else
		{
			$userid = get_userid();
		}
		$query = 'UPDATE '.cms_db_prefix().self::DB_NAME. '
			SET 
				user_id = ?,
				parent_id = ?,
				title = ?,
				{{foreach from=$extra_fields item=field}}
				{{$field.name}} = ?,
				{{/foreach}}
				updated_by = ?,
				updated_at = NOW(),
				order_by = ?,
				parent_item = ?,
				published = ?,
				full_text_search = ?
			WHERE id = ?';
		$db->Execute($query, array(
			$this->user_id,
			$this->parent_id,
			$this->title,
			{{foreach from=$extra_fields item=field}}
			$this->{{$field.name}},
			{{/foreach}}
			$userid,
			$this->order_by,
			$this->parent_item,
			$this->published,
			$this->full_text_search(),
			$this->id
		));
		$gCms->modules['{{$module->getModuleName()}}']['object']->SendEvent('ContentEditPost',array());
		return true;
	}
	
	public static function updateObjects()
	{
		$c = new MCFCriteria();
		$objects = self::doSelect($c);
		foreach($objects as $object)
		{
			$object->is_modified = true;
			$object->save();
		}
	}
	
	public function forceUpdateObject($magic)
	{
		if ($magic = 'magic')
		{
			$this->is_modified = true;
			$this->save();
		}
	}
	
	
	// FILTERS
	
	public static function buildFiltersWidgets(CMSForm &$form, $filters)
	{
		{{foreach from=$extra_fields item=field}}
			{{if $field.filter == true}}
				{{if $field.type == 'text' || $field.type == 'textarea' || $field.type == 'textarea_plain'}}
					$form->setWidget('moduleFilters[{{$field.name}}]', 'text', array('size' => '12', 'label' => '{{$field.friendlyname}}',
					 'value' => isset($filters['{{$field.name}}'])?$filters['{{$field.name}}']:null
					));
				{{elseif $field.type == 'module'}}
					if(class_exists('{{$field.foptions.module_name}}Object'))
					{
						$items = {{$field.foptions.module_name}}Object::getTitles();
					}
					else
					{
						$items = array();
					}
					$form->setWidget('moduleFilters[{{$field.name}}]', 'select', array(
						'values' => 
								array(0 => '&laquo; {{$field.friendlyname}} &raquo;') +
								$items
							,
							'label' => '',
							'value' => isset($filters['{{$field.name}}'])?$filters['{{$field.name}}']:null
						));
				{{elseif $field.form_type == 'select'}}
					$form->setWidget('moduleFilters[{{$field.name}}]', 'select', array(
						'values' => 
								array(0 => '&laquo; {{$field.friendlyname}} &raquo;') +
								{{$field.select_options}}
							,
							'label' => '',
							'value' => isset($filters['{{$field.name}}'])?$filters['{{$field.name}}']:null
						));
				{{elseif $field.type == 'user'}}
					if(class_exists('CMSUser'))
					{
						$users = CMSUser::getUserList();
					}
					else
					{
						$users = array();
					}
				
					$form->setWidget('moduleFilters[{{$field.name}}]', 'select', array(
						'values' => 
								array(0 => '&laquo; {{$field.friendlyname}} &raquo;') +
								$users
							,
							'label' => '',
							'value' => isset($filters['{{$field.name}}'])?$filters['{{$field.name}}']:null
						));
				{{/if}}

			{{/if}}
		{{/foreach}}
	}
	
	public static function buildFiltersCriteria(MCFCriteria &$c, $filters)
	{
		{{foreach from=$extra_fields item=field}}
			{{if $field.filter == true}}
				{{if $field.type == 'text' || $field.type == 'textarea' || $field.type == 'textarea_plain'}}
					if (isset($filters['{{$field.name}}']))
					{
							$c->add('{{$field.name}}', '%'.$filters['{{$field.name}}'].'%', MCFCriteria::LIKE);
					}
				{{elseif $field.type == 'module' || $field.type == 'user' || $field.form_type == 'select'}}
					if (isset($filters['{{$field.name}}']))
					{
						{{if isset($field.foptions.multiple)}}						
							$c->add('{{$field.name}}', $filters['{{$field.name}}'], MCFCriteria::MULTILIKE);
						{{else}}						
							$c->add('{{$field.name}}', $filters['{{$field.name}}'], MCFCriteria::EQUAL);
						{{/if}}
					}
				{{/if}}
			{{/if}}
		{{/foreach}}
	}
	
	public static function getFEFilter($form, $filter, $options = array())
	{
		global $gCms;
		switch($filter)
		{
		{{foreach from=$filters item=filter}}
		case '{{$filter.name}}':	
			{{if $filter.field == 'title'}}
				$form->setWidget('title','text', $options);
			{{else}}
				{{foreach from=$extra_fields item=field}}
					{{if $filter.field == $field.name}}
						if (!isset($options['label'])) $options['label'] = '{{$field.label}}';
						{{if $field.type == 'text' or $field.type == 'textarea' or $field.type == 'textarea_plain'}}
							$form->setWidget('{{$filter.name}}', 'text', $options);
						{{elseif $field.form_type == 'select'}}
							if (!isset($options['include_custom'])) $options['include_custom'] = '&laquo; ' . $gCms->modules[self::MODULE_NAME]['object']->lang('select_one') . ' &raquo;';
							{{if isset($field.foptions.selector)}}
							$c = new MCFCriteria();
							$c->add('published', 1);
							$options['values'] = {{$field.foptions.module_name}}Object::{{$field.foptions.selector}}($c);
							{{else}}
							$options['values'] = {{$field.select_options}};
							{{/if}}
							$form->setWidget('{{$filter.name}}', 'select', $options);
						{{elseif $field.type == 'module'}}
							if (!isset($options['include_custom'])) $options['include_custom'] = '&laquo; ' . $gCms->modules[self::MODULE_NAME]['object']->lang('select_one') . ' &raquo;';
							if(class_exists('{{$field.foptions.module_name}}Object'))
							{
								$options['values'] = {{$field.foptions.module_name}}Object::getTitles();
							}
							else
							{
								$options['values'] = array();
							}						
							$form->setWidget('{{$filter.name}}', 'select', $options);
						{{/if}}
					{{/if}}
				{{/foreach}}
			{{/if}}
		break;
		{{/foreach}}
			default:
				break;
		}
	}

	// Executed in the edit action when everything went fine (Executed after item save though)
	public function postActions()
	{
		
	}
	
	// Allow you to restrict the frontend list and details with required filters
	public static function globalFrontendFilters(MCFCriteria &$c)
	{
		
	}

	// FRONTEND FORMS : CHECK PERMISSIONS
	
	public static function checkPermissions($params = array())
	{
		return true; // Can be overide in the custom logic
	}
	
	public function isUserItem()
	{
		$user = CMSUsers::getUser();
		if (is_object($user))
		{
			if ($user->getId() == $item->geUserId())
			{
				return true;
			}
		}
		return false;
	}
	
	// Executed in the user_form action when everything went fine
	public function userPostActions($id, $returnid)
	{
		$this->postActions();
	}
}

?>
