<?php

if (!isset($gCms)) exit;

if (!$this->CheckAccess('Manage {{$module->getModuleName()}}')) {
	return $this->DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
}

$view = new MCFListView('{{$module->getModuleName()}}', $params);

$modulextender = $gCms->modules['ModuleXtender']['object'];

if (isset($params['item_id']) && !empty($params['item_id'])) {
	$item = {{$module->getModuleName()}}Object::getById($params['item_id']);
} else {
	$item = new {{$module->getModuleName()}}Object();
	$item->setParentItem(isset($params['parent_item']) ? $params['parent_item'] : 0);
}

if (isset($params['cancel'])) {
	{{if $parent_module}}
	$parent = new {{$parent_module->getModuleName()}}();
	$parent->Redirect($id, 'edit', $returnid, array('view' => $view->getView(), 'item_id' => $item->getParentItem()));
	{{else}}
	$this->Redirect($id, 'defaultadmin', $returnid, array('view' => $view->getView()));
	{{/if}}
	exit;
}

$form = new CMSForm('{{$module->getModuleName()}}', $id,'edit',$returnid);
$form->setButtons(array('submit','apply','cancel'));
$form->setMultipartForm();
$form->setLabel('submit', $this->Lang('save'));
$form->setLabel('apply', $this->Lang('save_continue'));
$form->setLabel('cancel', $this->Lang('cancel'));

$form->setWidget('view','hidden', $view->getView());
$form->setWidget('item_id', 'hidden', array('object' => &$item, 'field_name' => 'id'));
$form->setWidget('parent_item', 'hidden', array('object' => &$item));
$form->setWidget('title', 'text', array('label' => 'Title','object' => &$item, 'size' => 50));

if ($this->getPreference('show_parent', '0') == 1)
{
	$form->setWidget('parent_id', 'select', array(
		'object' => &$item, 
		'values' => array_merge(array(0 => ''), $item->getPossibleParentsHierarchy())
		));
}
// Custom part
$config =& $this->getConfig();


{{$module->getModuleName()}}Views::createForm($this,&$form,&$item);

{{foreach from=$extra_fields item=field}}
{{*
	// MASTER ! TO REPLICATE TO USER FORM IF ANY CHANGE !! (Yeah I know, bad behavior...)
	// REPLATED BY CALL "createForm"
*}}
{{*
{{if $field.form_type == 'select'}}
$form->setWidget('{{$field.name}}', 'select', array(
	{{if isset($field.foptions.multiple) || isset($field.foptions.expanded)}}
	'values' => {{$field.select_options}},
	{{else}}
	'values' => array('' => '&laquo; ' . $this->lang('select_one') . ' &raquo;') + {{$field.select_options}},
	{{/if}} 
	'label' => '{{$field.label}}', 
	'get_method' => 'get{{$field.camelcase}}', 
	'object' => &$item
	{{if isset($field.foptions.multiple)}}, 'multiple' => true{{/if}}
	{{if isset($field.foptions.size)}}, 'size' => {{$field.foptions.size}}{{/if}}
	{{if isset($field.foptions.expanded)}}, 'expanded' => true{{/if}}
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
));
{{elseif $field.form_type == 'textarea'}}
$form->setWidget('{{$field.name}}', 'textarea', array(
	'label' => '{{$field.label}}', 
	'object' => &$item,
	'show_wysiwyg' => true
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
	));
{{elseif $field.form_type == 'textarea_plain'}}
$form->setWidget('{{$field.name}}', 'textarea', array(
	'label' => '{{$field.label}}', 
	'object' => &$item
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
	));
{{elseif $field.form_type == 'file'}}
$form->setWidget('{{$field.name}}', 'file', array(
	'label' => '{{$field.label}}', 
	'object' => &$item,
	'base_url' => $config['root_url'],
	'delete_checkbox' => '{{$field.name}}_delete'
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
));
{{elseif $field.type == 'date'}}
$form->setWidget('{{$field.name}}', 'date', array(
	'label' => '{{$field.label}}', 
	'object' => &$item, 'european_date' => true, 
	'set_method' => 'set{{$field.camelcase}}',
	'default_value' => array(date('Y'),date('m'),date('d')),
	{{if isset($field.date_options.start_year)}} 'start_year' => {{$field.date_options.start_year}},{{/if}}
	{{if isset($field.date_options.number_years)}} 'number_years' => {{$field.date_options.number_years}},{{/if}}
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
));
{{elseif $field.type == 'time'}}
$form->setWidget('{{$field.name}}', 'time', array(
	'label' => '{{$field.label}}', 
	'object' => &$item,
	'set_method' => 'set{{$field.camelcase}}',
	'default_value' => array(date('H'),date('i'),date('s')),
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
));
{{elseif $field.form_type == 'module'}}
if (class_exists('{{$field.foptions.module_name}}Object'))
{	
	$c = new MCFCriteria();
	$c->add('published', 1);
	{{if isset($field.foptions.selector)}}
	$mod_items = {{$field.foptions.module_name}}Object::{{$field.foptions.selector}}($c);
	{{else}}
	$mod_items = {{$field.foptions.module_name}}Object::doSelect($c);
	{{/if}}
	$list = array();
$form->setWidget('{{$field.name}}', 'select', array(
	{{if isset($field.foptions.multiple) || isset($field.foptions.expanded)}}
	'values' =>	$mod_items, 
	{{else}}
	'values' =>	array('' => '&laquo; ' . $this->lang('select_one') . ' &raquo;') + $mod_items, 
	{{/if}}
	'label' => '{{$field.label}}', 
	'get_method' => 'get{{$field.camelcase}}', 
	'object' => &$item
{{if isset($field.foptions.multiple)}}, 'multiple' => true{{/if}}
{{if isset($field.foptions.size)}}, 'size' => {{$field.foptions.size}}{{/if}}
{{if isset($field.foptions.expanded)}}, 'expanded' => true{{/if}}
{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
));
}
{{elseif $field.form_type == 'page'}}
$form->setWidget('{{$field.name}}', 'pages', array(
	'label' => '{{$field.label}}' 
	,'object' => &$item
	{{if isset($field.foptions.start_page)}}, 'start_page' => '{{$field.foptions.start_page}}'{{/if}}
	{{if isset($field.foptions.childrenof)}}, 'childrenof' => '{{$field.foptions.childrenof}}'{{/if}}
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
	));
{{elseif $field.form_type == 'static'}}
$form->setWidget('{{$field.name}}', 'static', array(
	'label' => '{{$field.label}}', 
	'object' => &$item
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
	));
{{elseif $field.form_type == 'none'}}
{{elseif $field.form_type == 'user'}}
${{$field.name}}_list = CMSUser::getUserList();
$form->setWidget('{{$field.name}}', 'select', array(
	{{if isset($field.foptions.multiple) || isset($field.foptions.expanded)}}
	'values' => {{$field.select_options}},
	{{else}}
	'values' => array('' => '&laquo; ' . $this->lang('select_one') . ' &raquo;') + ${{$field.name}}_list,
	{{/if}} 
	'label' => '{{$field.label}}', 
//	'get_method' => 'get{{$field.camelcase}}', 
	'object' => &$item
	{{if isset($field.foptions.multiple)}}, 'multiple' => true{{/if}}
	{{if isset($field.foptions.size)}}, 'size' => {{$field.foptions.size}}{{/if}}
	{{if isset($field.foptions.expanded)}}, 'expanded' => true{{/if}}
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
));
{{elseif $field.form_type == 'group'}}
${{$field.name}}_list = CMSGroup::getGroupList();
$form->setWidget('{{$field.name}}', 'select', array(
	{{if isset($field.foptions.multiple) || isset($field.foptions.expanded)}}
	'values' => {{$field.select_options}},
	{{else}}
	'values' => array('' => '&laquo; ' . $this->lang('select_one') . ' &raquo;') + ${{$field.name}}_list,
	{{/if}} 
	'label' => '{{$field.label}}', 
//	'get_method' => 'get{{$field.camelcase}}', 
	'object' => &$item
	{{if isset($field.foptions.multiple)}}, 'multiple' => true{{/if}}
	{{if isset($field.foptions.size)}}, 'size' => {{$field.foptions.size}}{{/if}}
	{{if isset($field.foptions.expanded)}}, 'expanded' => true{{/if}}
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
));
{{else}}
$form->setWidget('{{$field.name}}', 'text', array(
	'label' => '{{$field.label}}', 
	'object' => &$item, 
	'size' => 50
	{{if isset($field.foptions.tips)}}, 'tips' => '{{$field.foptions.tips}}'{{/if}}
	));
{{/if}}
*}}
{{*
	// END OF MASTER/SLAVE
*}}
{{/foreach}}



{{if isset($is_user_module)}}
if (class_exists('CMSUser'))
{	
	$form->setWidget('user_id', 'select', array(
		'values' =>	array('' => '&laquo; ' . $this->lang('select_one') . ' &raquo;') + CMSUser::getUserList(),  
		'get_method' => 'getUserId', 
		'object' => &$item
	));
}
{{/if}}

if(!is_null($item->getCreatedBy())) $form->setWidget('created_by', 'static', array('label' => 'Created by',	'value' => $gCms->GetUserOperations()->LoadUserByID($item->getCreatedBy())->username . ' on ' . $item->getCreatedAt()));
if(!is_null($item->getUpdatedBy())) $form->setWidget('updated_by', 'static', array('label' => 'Last updated by',	'value' => $gCms->GetUserOperations()->LoadUserByID($item->getUpdatedBy())->username . ' on ' . $item->getUpdatedAt()));
$form->setWidget('published', 'checkbox', array('label' => 'Published', 'object' => &$item));
$this->smarty->assign('form', $form);

// SUB MODULES SECTION
$c = new MCFCriteria();
$c->add('parent_module', {{$module->getId()}}, MCFCriteria::EQUAL);
$child_modules = MCFModule::doSelect($c);
$submodules = array();
foreach ($child_modules as $child) {
	if (isset($gCms->modules[$child->GetModuleName()]))
	{
		$submodules[$child->getId()] = array('name' => $child->GetModuleFriendlyName(), 'items' => array());
		if (!$item->isNew()) {
			$c = new MCFCriteria();
			$c->add('parent_item', $item->getId());
			$c->addAscendingOrderByColumn('order_by');
			$classname = $child->GetModuleName();
			$mod = new $classname();
			$items = call_user_func(array($child->GetModuleName() . 'Object', 'doSelect'), $c);
			$submodules[$child->getId()]['template'] = call_user_func(array($child->GetModuleName() . 'Views', 'adminItems'), $gCms,$mod,$id,$returnid,$view,$items,$item->getId());
			$submodules[$child->getId()]['add_item_link'] = $mod->CreateLink($id, 'edit', $returnid, $mod->Lang('add_item_for', $child->GetModuleFriendlyName()), array('parent_item' => $item->getId()));
			$submodules[$child->getId()]['add_item_icon'] = $mod->CreateLink($id, 'edit', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $mod->Lang('add_item_for', $child->GetModuleFriendlyName()), '', '', 'systemicon'));
		}
	}
}

$this->smarty->assign('submodules', $submodules);

// MODULE XTENDER SECTION

if ($modulextender->isXtendedModule($this->getName())) {  
	$this->smarty->assign('xtended_form', $modulextender->XtendModuleForm('{{$module->getModuleName()}}', $item->getId(), $id));
} else {
	$this->smarty->assign('xtended_form', '');
}

// FORM PROCESSING

if ($form->isPosted()) {
	$form->process();
	if ($form->NoError())
	{
		$item->uploadFiles($id);
		$item->save();
		if ($modulextender->isXtendedModule($this->getName())) {
			$modulextender->getFormInput($this->getName(), $item->getId(), $params);
		}
		$item->postActions(); // Use to allow people to tweak things.
		if (isset($params['submit'])) {
			{{if $parent_module}}
			$parent = new {{$parent_module->getModuleName()}}();
			$parent->Redirect($id, 'edit', $returnid, array('view' => $view->getView(), 'item_id' => $item->getParentItem()));
			{{else}}
			$this->Redirect($id, 'defaultadmin', $returnid, array('view' => $view->getView()));
			{{/if}}
			exit;
		} else {
			$this->Redirect($id, 'edit', $returnid, array('view' => $view->getView(), 'item_id' => $item->getId()));
			exit;
		}
	}
}

echo $this->ProcessTemplate('edit.tpl');
