<?php

$GLOBALS['ADODB_QUOTE_FIELDNAMES'] = true;

require dirname(__FILE__) . '/classes/{{$module->getModuleName()}}ObjectBase.class.php';
require dirname(__FILE__) . '/classes/{{$module->getModuleName()}}Object.class.php';
require dirname(__FILE__) . '/classes/{{$module->getModuleName()}}Views.class.php';

class {{$module->getModuleName()}} extends CMSModule {

	public static $frontend_templates = array(
		'default' 		=> 'default',
		'detail' 			=> 'detail', 
		'search' 			=> 'search',
		'calendar' 		=> 'calendar',
		'tagcloud' 		=> 'tagcloud', // TODO
		'rss' 				=> 'rss',
		'paginated' 	=> 'paginated',
		'user_form' 	=> 'user_form',
		'user_form_succes' 	=> 'user_form_succes',
		);

    public function DoAction($name, $id, $params, $returnid = '') {
        $methods = get_class_methods($this);
        foreach ($methods as $method) {
            if (strpos($method, 'modifier') === 0) {
                $modifier =substr($method, 8);
                $modifier{0} = strtolower($modifier{0});
                $this->smarty->register_modifier($modifier, array($this, $method));
            }
        }
        parent::DoAction($name, $id, $params, $returnid);
    }

	public function GetName() {		return '{{$module->getModuleName()}}';	}
	public function GetFriendlyName() {		return '{{$module->getModuleFriendlyName()}}';	}
	public function GetVersion() {		return '{{$module->getModuleVersion()}}';	}
	public	function GetHelp() {		return $this->Lang('help');	}
	public	function GetAuthor() {		return 'Auto-generated by M&C Factory';	}
	public	function GetAuthorEmail() {		return 'jcc@morris-chapman.com';	}
	public	function GetChangeLog() {		return $this->Lang('changelog');	}
	public	function IsPluginModule() {		return true;	}
	public	function HasAdmin() {		return {{$has_admin}};	}
	{{* public	function GetAdminSection() {		return 'content';	} *}}
	public	function GetAdminSection() {		return '{{$admin_section}}';	}
	public	function GetAdminDescription() {		return $this->Lang('admindescription');	}
	public	function VisibleToAdminUser() {		return true;	}
	public	function GetDependencies() {		return array('MCFactory' => '{{$mcfactoryversion}}');	}
	public	function CheckAccess($permission = 'Manage {{$module->getModuleName()}}') {		return $this->CheckPermission($permission);	}
	public	function DisplayErrorPage($id, &$params, $return_id, $message='') {
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);
		echo $this->ProcessTemplate('error.tpl');
	}

	function MinimumCMSVersion() {		return '1.4';	}
	function InstallPostMessage() {		return $this->Lang('postinstall');	}
	function UninstallPostMessage() {		return $this->Lang('postuninstall');	}
	function UninstallPreMessage() {		return $this->Lang('really_uninstall');	}
	public function Install() {
		global $gCms;
		$config = $gCms->GetConfig();
		$db = $this->cms->db;
		$dict = NewDataDictionary($db);
        $fields = 'id I KEY,
		  user_id I,
			parent_id I,
			title C(255),
			{{foreach from=$extra_fields item=field}}
			{{$field.name}} {{$field.column_type}},
			{{/foreach}}
			created_at D,
			created_by I,
			updated_at D,
			updated_by I,
			order_by I,
			published I,
			parent_item I,
			full_text_search XL';
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_{{$table_name}}', $fields);
		$dict->ExecuteSQLArray($sqlarray);
		$db->CreateSequence(cms_db_prefix().'module_{{$table_name}}_seq');
		
		//$this->SetTemplate('display_list', $this->GetTemplateFromFile('template.list'));
		//$this->SetTemplate('display_paginated', $this->GetTemplateFromFile('template.paginated'));
		//$this->SetTemplate('display_details', $this->GetTemplateFromFile('template.details'));
		//$this->SetTemplate('display_search', $this->GetTemplateFromFile('template.search'));
		//$this->SetTemplate('display_calendar', $this->GetTemplateFromFile('template.calendar'));
		
		//@mkdir($config['root_path'].'/uploads/{{$module->getModuleName()}}');
		$this->CreateEvent('ContentEditPost');
		$gCms->modules['MCFactory']['object']->AddEventHandler($this->getName(), 'ContentEditPost', false);
		$this->CreatePermission('Manage {{$module->getModuleName()}}', 'Manage {{$module->getModuleName()}}');	
		$this->CreatePermission('Admin {{$module->getModuleName()}}', 'Admin {{$module->getModuleName()}}');	
		$this->SetPreference('index_content', 'true');
		$this->SetPreference('twitter_template', '{$title} - {$url}');
		$this->SetPreference('mcfactory_version', '{{$mcfactory_version}}');
	}

	public function Upgrade()
	{
		$db = $this->GetDb();
		$dict = NewDataDictionary($db);
		
		$oldversion = $this->GetPreference('mcfactory_version', '2.5.0');
		
		switch(true) {
			case version_compare($oldversion, '2.9.0', '<'):
				$this->GetPreference('index_content',$this->GetPreference('index_content', 'true'));
			case version_compare($oldversion, '2.9.9', '<'):
				$this->AddDefaultTemplate('default', 'display_list');
				$this->AddDefaultTemplate('detail', 'display_details');
				$this->AddDefaultTemplate('paginated', 'display_paginated');
				$this->AddDefaultTemplate('search', 'display_search');
				$this->AddDefaultTemplate('calendar', 'display_calendar');
			case version_compare($oldversion, '2.9.16', '<'):
					$sqlarray = $dict->AddColumnSQL(cms_db_prefix() . 'module_{{$table_name}}', 'user_id I');
					$dict->ExecuteSQLArray($sqlarray);
		}
		
		$this->SetPreference('mcfactory_version', '{{$mcfactory_version}}');
	}

	public function Uninstall() {
		global $gCms;
		$db = $this->cms->db;
		$dict = NewDataDictionary($db);
		$sql = $dict->DropTableSQL(cms_db_prefix().'module_{{$table_name}}');
		$dict->ExecuteSQLArray($sql);
		$db->DropSequence(cms_db_prefix().'module_{{$table_name}}_seq');
		$gCms->modules['MCFactory']['object']->RemoveEventHandler($this->getName(), 'ContentEditPost');
		$this->RemoveEvent('ContentEditPost');
		$this->RemovePreference();
	}

	function XtendedModule () {
		return true;
	}

	function GetHeaderHTML() {
		$html  = '<script type="text/javascript" src="'.$this->config['root_url'].'/modules/MCFactory/js/jquery-1.3.2.min.js"></script>';
		$html .= '<script type="text/javascript">jQuery.noConflict();</script>';
		return $html;
	}

	function setParameters() {	
		global $gCms;
    $this->RegisterModulePlugin();
		$this->RegisterRoute('/{{$module->getModuleName()|lower}}\/(?P<item_id>[0-9]+)\/(?P<returnid>[0-9]+)(\/.*?)?$/', array('action' => 'detail'));
		$this->RegisterRoute('/{{$module->getModuleName()|lower}}\/rss\/(?P<maction>[a-zA-Z0-9_-]+)(\/.*?)?$/', array('action' => 'rss', 'showtemplate' => 'false','returnid' => $gCms->GetContentOperations()->GetDefaultPageID()));
			$this->RegisterRoute('/{{$module->getModuleName()|lower}}\/download\/(?P<item_id>[0-9]+)\/(?P<field>[a-zA-Z0-9_-]+)(\/.*?)?$/', 
			array(
			'action' => 'download', 
			'showtemplate' => 'false',
			'returnid' => $gCms->GetContentOperations()->GetDefaultPageID()
			));
	}

	function createLink($id, $action, $returnid='', $contents='', $params=array(), $warn_message='', $onlyhref=false, $inline=false, $addttext='', $targetcontentonly=false, $prettyurl='') {
		if ($targetcontentonly || ($returnid != '' && !$inline)) {
			$id = 'cntnt01';
		}
		if (!$returnid) {
			if (isset($GLOBALS['gCms']->variables['content_id']))
			{			
				$returnid = $GLOBALS['gCms']->variables['content_id'];	
			}
			else
			{
				$returnid = '';
			}
		}
		if (empty($prettyurl)) {
			if ($action == 'detail') {
				$item_id = $params['item_id'];
				$prettyurl = '{{$module->getModuleName()|lower}}/' . $item_id . '/' . $returnid . '/';
				if (!empty($params['title'])) {
					$title = $params['title'];
					$prettyurl .= munge_string_to_url($title) . '/';
				}
				
				$query = array();
				foreach ($params as $name => $value) {
					if (!in_array($name, array(
						'module', 'action', 'item_id', 'title',
						'orderby','limit'
						))) {
						$query[$id . $name] = $value;
					}
				}
				if (count($query)) {
					$prettyurl .= '?' . http_build_query($query);
				}
			}
		}
		return parent::createLink($id, $action, $returnid, $contents, $params, $warn_message, $onlyhref, $inline, $addttext, $targetcontentonly, $prettyurl);
	}

	function SearchReindex($module) {
		$c = new MCFCriteria();
		$c->add('published', 1);
		$items = {{$module->getModuleName()}}Object::doSelect($c);
		foreach ($items as $item) {
			$this->index($item);
		}
	}
	
	function SearchDeindex($module) {
		$c = new MCFCriteria();
		$c->add('published', 1);
		$items = {{$module->getModuleName()}}Object::doSelect($c);
		foreach ($items as $item) {
			$this->deindex($item);
		}
	}

	function index($item) {
		if ($this->getPreference('index_content') == 'true')
		{
			$search = $this->GetModuleInstance('Search');
			if ($search) {
				$search->AddWords(
					'{{$module->getModuleName()}}',
					$item->getId(),
					'{{$module->getModuleName()|lower}}_item',
					$item->getSearchString()
				);
			}
		}
	}

	function deindex($item) {
		$search = $this->GetModuleInstance('Search');
		if ($search) {
			$search->DeleteWords('{{$module->getModuleName()}}', $item->getId(), '{{$module->getModuleName()|lower}}_item');
		}
	}

	function SearchResult($returnid, $id, $attr = '') {
		$result = array();
		if ($attr == '{{$module->getModuleName()|lower}}_item') {
			$c = new MCFCriteria();
			$c->add('id', $id);
			$c->add('published', 1);
			$item = {{$module->getModuleName()}}Object::doSelectOne($c);
			if ($item) {
				$result[0] = $this->GetFriendlyName();
				$result[1] = $item->getTitle();
				$result[2] = $this->CreateLink('cntnt01', 'detail', $returnid, '', array('item_id' => $id, 'title' => $item->getTitle()), '', true);
			}
		}
		return $result;
	}
	
	/**
	 * NTList: Notification Tool function: Return the list of items uploaded since a certain date 
	 */

	function NTList($date, $template = null, $params = array())
	{
		global $gCms;
		$returnid = $this->getPreference('default_page', '');
		$c = new MCFCriteria();
		$c->add('published', '1');
		if(isset($params['created_at']))
		{
			$c->add('created_at', $date, MCFCriteria::GREATER_EQUAL);	
		}
		else
		{
			$c->add('updated_at', $date, MCFCriteria::GREATER_EQUAL);
		}		
		$this->buildFrontendFilters($c, $params);
		$c->addAscendingOrderByColumn('updated_at');
		$items = {{$module->getModuleName()}}Object::doSelect($c);

		if (empty($items))
		{
			return null;
		}
		
		if (!is_null($template))
		{
			$params['template'] = $template;
		}

		$detailpage = $returnid;

		if (isset($params['detailpage'])) {
		    $manager = $gCms->GetHierarchyManager();
		    $node = $manager->sureGetNodeByAlias($params['detailpage']);
		    if ($node) {
		        $content = $node->GetContent();
		        if ($content)
		        {
		            $detailpage = $content->Id();
		        }
		    } else {
		        $node = $manager->sureGetNodeById($params['detailpage']);
		        if ($node) {
		            $detailpage = $params['detailpage'];
		        }
		    }
		    $params['origid'] = $returnid;
		}

		foreach ($items as &$item) {
			$params['item_id'] = $item->getId();
			$params['title'] = $item->getTitle();
			$newparams = $params;
			unset($newparams['showtemplate']);
			$item->detail_link = $this->createLink($id, 'detail', $detailpage, $contents='', $newparams, '', true);
			$xtended_felist = MX_XtendedModule::getRelatedItems($this->getName(), $item->getId());
		}
		unset($item);

    $this->smarty->assign('items', $items);		
    $this->smarty->assign('{{$module->getModuleName()}}', $items);
    $this->smarty->assign('{{$module->getModuleName()|lower}}', $items);
    $paramsobj = new stdClass();
    $paramsobj->params = $params;
    $this->smarty->assign('mcfactory', $paramsobj);
		return $this->ProcessTemplateFor('default', $params);
	}
	
	public function updateItem($item_id)
	{
		$c = new MCFCriteria();
		$c->add('id', $item_id);
		$item = {{$module->getModuleName()}}Object::doSelectOne($c);
		
		if ($item !== false)
		{
			$item->forceUpdateObject('magic');	
		}
	}

	public function getAdminList($id,$returnid,$gCms)
	{
		
		// if (!$this->CheckAccess('Manage MC Factory')) {
		// 			return $this->DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
		// 		}
		
		//return {{$module->getModuleName()}}Views::adminItems($this,$id,$returnid,$gCms);
	}
	
	public static function ExportDatas()
	{
		$datas = array();
		$c = new MCFCriteria();
		$items = {{$module->getModuleName()}}Object::doSelect($c);

		$datas[0] = array(
			'id',
			'title',
			{{foreach from=$extra_fields item=field}}
			'{{$field.friendlyname}}',
			{{/foreach}}
			'created_at',
			'created_by',
			'updated_at',
			'updated_by',
			'order_by',
			'published',
			'parent_item',
			'parent_id'
			);
			
		foreach($items as $item)
		{
			$datas[] = array(
				'id' => $item->getId(),
				'title' => $item->getTitle(),
				{{foreach from=$extra_fields item=field}}
				'{{$field.friendlyname}}' => $item->get{{$field.camelcase}}(),
				{{/foreach}}
				'created_at' => $item->getCreatedAt(),
				'created_by' => $item->getCreatedBy(),
				'updated_at' => $item->getUpdatedAt(),
				'updated_by' => $item->getUpdatedBy(),
				'order_by' => $item->getOrderBy(),
				'published' => $item->getPublished(),
				'parent_item' => $item->getParentItem(),
				'parent_id' => $item->getParentId()
			);
		}
			
		return $datas;
	}
	
	// TEMPLATES
	
	public function GetDefaultTemplates()
	{
		$array = unserialize($this->GetPreference('default_templates'));
		if (is_array($array))
		{
			return $array;
		}
		return array();
	} 
	
	public function SetDefaultTemplates($list = array())
	{
		return $this->SetPreference('default_templates', serialize($list));
	}
	
	public function AddDefaultTemplate($action, $template)
	{
		$list = $this->GetDefaultTemplates();
		$list[$action] = $template;
		$this->SetDefaultTemplates($list);
	}
	
	public function GetDefaultTemplate($action)
	{
			$list = $this->GetDefaultTemplates();
			if (!is_array($list)) $list = array();
			if (array_key_exists($action, $list)) // TODO: Possible problem with list
			{
				return $list[$action];
			}
			else
			{
				return false;
			}
	}
	
	public function isDefaultTemplate($template)
	{		
		$list = $this->GetDefaultTemplates();
		$action = array_search($template, $list);
		if($action !== false)
		{
			return $action;
		}
		return false;
	}	
	
	public function removeDefaultTemplate($template)
	{		
		$list = $this->GetDefaultTemplates();
		$action = array_search($template, $list);
		if($action !== false)
		{
			unset($list[$action]);
			$this->SetDefaultTemplates($list);
		}
		return false;
	}
	
	public function ProcessTemplateFor($action, $params = array())
	{
		if (isset($params['template']) && $this->GetTemplate($params['template'])) {
			return $this->ProcessTemplateFromDatabase($params['template']);
		}
		elseif (($template = $this->GetDefaultTemplate($action))	&&	($this->GetTemplate($template) !== false))
		{
			return $this->ProcessTemplateFromDatabase($template);
		}
		else
		{
			return $this->ProcessTemplate('frontend.'.$action.'.tpl');
		}
	}
	
	public function ParamsForLink($params,$include = array(),$exclude = array())
	{
		$new_params = array();
		
		foreach($params as $key => $value)
		{
			if (!in_array($key, $exclude))
			{
				$new_params[$key] = $value;
			}
		}
		
		foreach($include as $key => $value)
		{
			if (!in_array($key, $exclude))
			{
				$new_params[$key] = $value;
			}
		}
		
		// Now we'll treath the complex array problem
		
		$query = http_build_query($new_params);
		$entries = explode('&', $query);
		$output = array();
		foreach($entries as $entry)
		{
			$data = explode('=', $entry);
			$output[$data[0]] = urldecode($data[1]);
		}	
		
		return $output;
	}
	
	public function buildFiltersCriteria(MCFCriteria &$c, $filters)
	{
		{{$module->getModuleName()}}Object::buildFiltersCriteria($c, $filters);
	}
	
	public function buildFrontendFilters(MCFCriteria &$c, $params)
	{
		global $gCms;
		// Module Xtender filters
		if (isset($params['currentpage'])) {
			$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', $gCms->variables['content_id'], 'pages'), MCFCriteria::IN);
		}
		if (isset($params['pages'])) {
			$glue = isset($params['all_pages']) ? 'AND' : 'OR';
			$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', explode(',', $params['pages']), 'pages', $glue), MCFCriteria::IN);
		}
		if (isset($params['options'])) {
			$glue = isset($params['all_options']) ? 'AND' : 'OR';
			$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', explode(',', $params['options']), 'options', $glue), MCFCriteria::IN);
		}
		
		// Search filters
		
		if (isset($params['mxfilters_options']) && is_array($params['mxfilters_options'])) {
			$options = array();
			foreach ($params['mxfilters_options'] as $option) {
				if ($option) {
					$options[] = $option;
				}
			}
			if (count($options)) {
				$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', $options, 'options', 'AND'), MCFCriteria::IN);
			}
		}

		if (isset($params['mxfilters_pages']) && is_array($params['mxfilters_pages'])) {
			$pages = array();
			foreach ($params['mxfilters_pages'] as $page) {
				if ($page) {
					$pages[] = $page;
				}
			}
			if (count($pages)) {
				$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', $pages, 'pages', 'AND'), MCFCriteria::IN);
			}
		}
		
		if (isset($params['filter_title'])) {
			$filter_title = trim(html_entity_decode($params['filter_title']));
			$filter_title = str_replace(array('%', '?'), ' ', $filter_title);
			if (!empty($filter_title)) {
				preg_match_all('/(?:"([^"]+)")|(\w+)/', $filter_title, $matches);
				$clauses = array();
				foreach ($matches[0] as $key => $value) {
					$clauses[$key] = $matches[1][$key] ? $matches[1][$key] : $matches[2][$key];
				}
				foreach ($clauses as $clause) {
					$c->add('title', '%' . $clause . '%', MCFCriteria::LIKE);
				}
			}
		}

		if (isset($params['filter_all'])) {
			$filter_all = trim(html_entity_decode($params['filter_all']));
			$filter_all = str_replace(array('%', '?'), ' ', $filter_all);
			if (!empty($filter_all)) {
				preg_match_all('/(?:"([^"]+)")|(\w+)/', $filter_all, $matches);
				$clauses = array();
				foreach ($matches[0] as $key => $value) {
					$clauses[$key] = $matches[1][$key] ? $matches[1][$key] : $matches[2][$key];
				}
				foreach ($clauses as $clause) {
					$c->add('full_text_search', '%' . $clause . '%', MCFCriteria::LIKE);
				}
			}
		}
		
		// Module Filters
		
		{{foreach from=$filters item=filter}}
		if (isset($params['{{$filter.name}}']) && $params['{{$filter.name}}'] != '') {
			{{if in_array($filter.type, array('less', 'less_equal', 'greater', 'greater_equal'))}}
			$c->add('CAST({{$filter.field}} AS UNSIGNED)', $params['{{$filter.name}}'], MCFCriteria::{{$filter.criteria}});
			{{elseif  in_array($filter.type, array('like_wild'))}}
			$c->add('{{$filter.field}}', '%' . $params['{{$filter.name}}'] . '%', MCFCriteria::{{$filter.criteria}});
			{{else}}
			$c->add('{{$filter.field}}', $params['{{$filter.name}}'], MCFCriteria::{{$filter.criteria}});
			{{/if}}
		}
		{{/foreach}}
		
		// End buildFrontendFilters
	}
}

?>
