<?php
if (!isset($gCms)) exit;

if (!$this->CheckAccess()) {
	return $this->DisplayErrorPage();
}

/*
	Module Edition
*/

// Tabs

$tabs = array (
	'main' => false,
//	'fields' => false,
	'actions' => false,
	'logic' => false,
	'options' => false
);

if (isset($params['active_tab']))
{
	$tabs[$params['active_tab']] = true;
}

$this->smarty->assign('tab_headers',$this->StartTabHeaders().

	$this->SetTabHeader('main',$this->Lang('main'), $tabs['main']).
//	$this->SetTabHeader('fields',$this->Lang('fields'), $tabs['fields']).
	$this->SetTabHeader('actions',$this->Lang('actions'), $tabs['actions']).
	$this->SetTabHeader('logic',$this->Lang('logic'), $tabs['logic']).
	$this->SetTabHeader('options',$this->Lang('options'), $tabs['options']).
	
$this->EndTabHeaders().$this->StartTabContent());

$this->smarty->assign('start_main_tab',$this->StartTab('main'));
//$this->smarty->assign('start_fields_tab',$this->StartTab('fields'));
$this->smarty->assign('start_actions_tab',$this->StartTab('actions'));
$this->smarty->assign('start_logic_tab',$this->StartTab('logic'));
$this->smarty->assign('start_options_tab',$this->StartTab('options'));

$this->smarty->assign('end_tab',$this->EndTab());
$this->smarty->assign('tab_footers',$this->EndTabContent());

// Logic

if (isset($params['cancel'])) {
	$this->Redirect($id, 'defaultadmin', $returnid);
	exit;
}

if (isset($params['module_id']) && !empty($params['module_id'])) {
	$module = MCFModule::retrieveByPk($params['module_id']);
} else {
	$module = new MCFModule();
	$module->setParentModule(0);
}


if (isset($params['move_up']) && is_array($params['move_up']))
{
	foreach($params['move_up'] as $key => $value)
	{	
		$module->orderExtraFields($key, 'up');	
		$module->save();
	}
}

if (isset($params['move_down']) && is_array($params['move_down']))
{
	foreach($params['move_down'] as $key => $value)
	{	
		$module->orderExtraFields($key, 'down');	
		$module->save();
	}
}

if (isset($params['publish']) || isset($params['save']) ) {
	$module->populateFromArray($params);
	if (!isset($params['show_module']))
		{
			//var_dump($params);
			$module->setShowModule(0);
		}	
		if (!isset($params['is_user_module']))
		{
			//var_dump($params);
			$module->setIsUserModule(0);
		}
	$module->save();
	if (isset($params['publish']))
	{
		$module->publish();
		$this->Redirect($id, 'defaultadmin', $returnid);
		exit;	
	}
}

$c = new MCFCriteria();
$c->add('parent_module', 0);
if (isset($params['module_id']) && !empty($params['module_id'])) {
	$c->add('id', $module->getId(), MCFCriteria::NOT_EQUAL);
}
$modules = MCFModule::doSelect($c);
$modules_select = array('' => 0);
foreach ($modules as $mod) {
	$modules_select[$mod->getModuleFriendlyName()] = $mod->getId();
}

$field_types = $module->getFieldTypes();
$field_types_with_options = array();
foreach ($field_types as $field_type) {
	if ($field_type['options']) {
		$field_types_with_options[] = $field_type['type'];
	}
}

$filter_types = $module->getFilterTypes();

$this->smarty->assign('module_id', $id);
$this->smarty->assign('form_start', $this->CreateFormStart($id, 'edit', $returnid, 'post'));
$this->smarty->assign('input_module_id', $this->CreateInputHidden($id, 'module_id', $module->getId()));
$this->smarty->assign('input_module_parent', $this->CreateInputDropdown($id, 'parent_module', $modules_select, -1, $module->getParentModule()));

$this->smarty->assign('input_admin_section', $this->CreateInputDropdown(
	$id,
	'admin_section',
	array(
		'Content' => 'content',
		'Layout' => 'layout',
		'Users & Groups' => 'usersgroups',
		'Extentions' => 'extensions',
		'Site Admin' => 'siteadmin'
	),
	'-1',
	$module->getAdminSection()
	));


$this->smarty->assign('input_module_friendlyname', $this->CreateInputText($id, 'module_friendlyname', $module->getModuleFriendlyname(), 50));
$this->smarty->assign('created_by', $gCms->GetUserOperations()->LoadUserByID($module->getCreatedBy())->username);
$this->smarty->assign('created_at', $module->getCreatedAt());
$this->smarty->assign('updated_by', $gCms->GetUserOperations()->LoadUserByID($module->getUpdatedBy())->username);
$this->smarty->assign('updated_at', $module->getUpdatedAt());
$this->smarty->assign('extra_fields', $module->getExtraFields());
$this->smarty->assign('filters', $module->getFilters());
$this->smarty->assign('module_logic', $this->CreateTextArea(true, $id, $module->getModuleLogic(), 'module_logic', 'pagebigtextarea', '','', '', 90, 15, 'EditArea'));
$this->smarty->assign('input_show_module', $this->CreateInputCheckbox($id, 'show_module', '1', is_null($module->getShowModule())?1:$module->getShowModule()));
$this->smarty->assign('input_is_user_module', $this->CreateInputCheckbox($id, 'is_user_module', '1', $module->getIsUserModule()));

$this->smarty->assign('input_is_protected', $this->CreateInputCheckbox($id, 'is_protected', '1', $module->getIsProtected()));
$this->smarty->assign('input_files_path', $this->CreateInputText($id, 'files_path', $module->getFilesPath(), 50));

$this->smarty->assign('publish_button', $this->CreateInputSubmit($id, 'publish', 'Publish')); 
$this->smarty->assign('save_button', $this->CreateInputSubmit($id, 'save', 'Save')); 
$this->smarty->assign('cancel_button', $this->CreateInputSubmit($id, 'cancel', 'Cancel'));
$this->smarty->assign('field_types', $field_types);
$this->smarty->assign('field_types_with_options', $field_types_with_options);
$this->smarty->assign('filter_types', $filter_types);

$this->smarty->assign('move_up', $this->getImage('arrow_up.png'));
$this->smarty->assign('move_down', $this->getImage('arrow_down.png'));

$this->smarty->assign('remove_icon',$gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'), '', '', 'systemicon'));
//$this->smarty->assign('up_icon',$gCms->variables['admintheme']->DisplayImage('icons/system/up.gif','', '', '', 'systemicon'));
//$this->smarty->assign('down_icon',$gCms->variables['admintheme']->DisplayImage('icons/system/down.gif', $this->Lang('move_down'), '', '', 'systemicon'));

// Actions
$this->smarty->assign('add_action_url', $this->CreateLink($id, 'manage_action', $returnid, '', array('module_id' => $params['module_id']),'',true,false));
$actions = MCFModuleAction::doSelect(array('where' => array('module_id' =>  $params['module_id'])));
foreach($actions as $action)
{
 $action->edit_url = $this->CreateLink($id, 'manage_action', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'), '', '', 'systemicon'), array('module_action_id' => $action->getId()));

 $action->delete_url = $this->CreateLink($id, 'delete_action', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'), '', '', 'systemicon'), array('module_action_id' => $action->getId()));

	if ($action->is_public == 1)
	{
		$action->is_public_icon = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', '', '', '', 'systemicon');
	}
	else
	{
		$action->is_public_icon = $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif', '', '', '', 'systemicon');
	}
}
$this->smarty->assign('actions', $actions);

// Templates: Restore

$this->smarty->assign('templates_restore_url', $this->CreateLink($id, 'templates_restore', $returnid, '', array('module_id' => $params['module_id']),'',true,false));

echo $this->ProcessTemplate('edit.tpl');

?>
