<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: AuthNetAim (c) 2009 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide the ability to process
#  Payments made using the E-commerce suite through the AuthNet payment
#  gateway.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

$billing = $this->_data['billing_address'];
$shipping = $this->_data['shipping_address'];
if( !is_object($billing) || !is_object($shipping) )
  {
    $this->SetError($this->Lang('error_missing_data'));
    $this->FinishTransaction();
    return;
  }

if( !isset($this->_data['order_obj']) )
  {
    $this->SetError($this->Lang('error_missing_data'));
    $this->FinishTransaction();
    return;
  }
$order = $this->_data['order_obj'];

// woot, we're building a subscription... gotta build the xml data.
// see this reference:  http://www.authorize.net/support/ARB_guide.pdf
$writer = new XMLWriter();
$writer->openMemory();
$writer->startDocument('1.0', 'utf-8');
// the xml root.
$writer->startElement('ARBCreateSubscriptionRequest');
$writer->writeAttribute('xmlns','AnetApi/xml/v1/schema/AnetApiSchema.xsd');

// do authentication portion.
$writer->startElement('merchantAuthentication');
$writer->writeElement('name',$this->GetPreference('loginid')); 
$writer->writeElement('transactionKey',$this->GetPreference('transactionkey'));
$writer->endElement();
// write the refid element
$writer->writeElement('refId',$this->_data['invoice']);
// start the subscription.
$writer->startElement('subscription');
$item = $this->order_contains_subscription();
$writer->writeElement('name',$item->get_description());
$writer->startElement('paymentSchedule');
$writer->startElement('interval');
switch( $item->get_subscr_payperiod() )
  {
  case cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_MONTHLY:
    $writer->writeElement('length',1);
    $writer->writeElement('unit','months');
    break;
  case cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_QUARTERLY:
    $writer->writeElement('length',3);
    $writer->writeElement('unit','months');
    break;
  case cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_SEMIANUALLY:
    $writer->writeElement('length',6);
    $writer->writeElement('unit','months');
    break;
  case cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_YEARLY:
  default:
    $writer->writeElement('length',12);
    $writer->writeElement('unit','months');
    break;
  }
$writer->endElement(); // interval
$writer->writeElement('startDate',strftime('%Y-%m-%d'));
$writer->writeElement('totalOccurrences',9999);
$writer->endElement(); // paymentschedule
$writer->writeElement('amount',number_format($order->get_total(),2,'.',''));

$writer->startElement('payment');
$writer->startElement('creditCard');
$writer->writeElement('cardNumber',$this->_data['ccinfo']['x_card_num']);
$writer->writeElement('expirationDate',strftime('%Y-%m',$this->_data['raw_ccinfo'][1]));
$writer->writeElement('cardCode',$this->_data['raw_ccinfo'][2]);
$writer->endElement(); // creditCard
$writer->endElement(); // payment

$writer->startElement('order');
$writer->writeElement('invoiceNumber',$this->_data['invoice']);
$writer->endElement(); // order;

$writer->startElement('customer');
$writer->writeElement('email',$billing->get_email());
$writer->writeElement('phoneNumber',$billing->get_phone());
$writer->endElement(); // customer

$writer->startElement('billTo');
$writer->writeElement('firstName',$billing->get_firstname());
$writer->writeElement('lastName',$billing->get_lastname());
$writer->writeElement('company',$billing->get_company());
$writer->writeElement('address',$billing->get_address1());
$writer->writeElement('city',$billing->get_city());
$writer->writeElement('state',$billing->get_state());
$writer->writeElement('zip',$billing->get_postal());
$writer->writeElement('country',$billing->get_country());
$writer->endElement(); // billTo

$writer->startElement('shipTo');
$writer->writeElement('firstName',$shipping->get_firstname());
$writer->writeElement('lastName',$shipping->get_lastname());
$writer->writeElement('company',$shipping->get_company());
$writer->writeElement('address',$shipping->get_address1());
$writer->writeElement('city',$shipping->get_city());
$writer->writeElement('state',$shipping->get_state());
$writer->writeElement('zip',$shipping->get_postal());
$writer->writeElement('country',$shipping->get_country());
$writer->endElement(); // shipTo

$writer->endElement(); // subscription

$writer->endElement(); // ARBCreateSubscriptionRequest
$data = $writer->outputMemory(true);

// we have the data to post... so lets do it.
$post_url = $this->GetPreference('arb_url',AUTHNETARB_PRODUCTION_URL);
if( $this->GetPreference('usetesturl') )
  {
    $post_url = $this->GetPreference('test_arb_url',AUTHNETARB_TEST_URL);
  }

$http = cge_http::get_http();
$http->addRequestHeader('Content-Type: text/xml');
$http->setMethod('POST');
$http->setParams($data);
$result = $http->execute($post_url);

// Here we adjust headers for non cachable pages
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

$xml = new SimpleXMLElement($result,LIBXML_NOWARNING);
if( isset($xml->messages) && isset($xml->messages->resultCode) )
  {
    if( $xml->messages->resultCode == 'Error' )
      {
	$code = '';
	if( isset($xml->messages->message->code) )
	  $code = $xml->messages->message->code;
	$this->Audit('',$this->GetName(),'ARB POST Failed for invoice '.$this->_data['invoice'].' With code '.$code);
	$this->SetError($this->Lang('error_transaction_error',$code,$xml->messages->message->text));
	$this->FinishTransaction();
	return;
      }
    else if( $xml->messages->resultCode == 'Ok' && isset($xml->subscriptionId) )
      {
	$sid = (string)$xml->subscriptionId;
	$this->Audit('',$this->GetName(),'ARB POST Succeeded for invoice '.$this->_data['invoice'].' With subscription id '.$sid);
	$this->SetTransactionData('Subscription ID',$sid);
	$this->SetTransactionStatus(PAYMENT_STATUS_PENDING);
	$this->FinishTransaction();
	return;
      }
  }

// should not get here.
$this->Audit('',$this->GetName(),'Unknown ARB POST ERROR');
echo $this->Lang('unknown_arb_post_error').'<br/>';
debug_display($xml);
return;

#
# EOF
#
?>