<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: AuthNetSim (c) 2009 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide the ability to process
#  Payments made using the E-commerce suite through the AuthNet payment
#  gateway.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( strtoupper($_SERVER['REQUEST_METHOD']) != 'POST' ) exit;

$reqd_vars = array('x_response_code','x_trans_id','x_subscription_id','x_amount','x_invoice_num');
$data = array();
foreach( $reqd_vars as $one )
{
  if( !isset($_POST[$one]) )
    {
      // there's a variable missing
      $this->Audit('',$this->GetName(),'silent_post - missing POST variable '.$one);
      exit;
    }
  $data[$one] = $_POST[$one];
}

// build a transaction.
$trans = new cgpgb_async_transaction('',$data['x_amount'],$this->GetName());
switch( $data['x_response_code'] )
  {
  case 1:
    // good
    $this->Audit('',$this->GetName(),sprintf('Received a payment (id: %s amount: %s) for order %s, subscription %s',
					     $data['x_trans_id'],$data['x_amount'],$data['x_invoice_num'],$data['x_subscription_id']));
    $trans->set_status(PAYMENT_STATUS_APPROVED);
    break;

  case 2:
    // declined
    $this->Audit('',$this->GetName(),sprintf('Payment declined(id: %s amount: %s) for order %s, subscription %s',
					     $data['x_trans_id'],$data['x_amount'],$data['x_invoice_num'],$data['x_subscription_id']));
    $trans->set_status(PAYMENT_STATUS_DECLINED);
    break;

  case 3:
  default:
    // error of some sort.
    $this->Audit('',$this->GetName(),sprintf('Error received for order %s - ',$data['x_invoice_num']).$_POST['x_respons_reason_text']);
    $trans->set_status(PAYMENT_STATUS_ERROR);
    break;
  }
$trans->set_invoice($data['x_invoice_num']);
$trans->set_other_val('Subscription ID',$data['x_subscription_id']);
$trans->set_id($data['x_trans_id']);
$this->send_transaction_notification($trans);


#
# EOF
#?>